﻿---
title: Snyk Integration
description: % This integration is for ingesting data from the Snyk API. The integration allows collection of audit logging information and vulnerability issues via...
url: https://www.elastic.co/docs/reference/integrations/snyk
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Snyk Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.2.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                    |

%
This integration is for ingesting data from the [Snyk](https://snyk.io/) API. The integration allows collection of audit logging information and vulnerability issues via the Snyk [REST API](https://apidocs.snyk.io/?version=2024-04-29#overview).

## Agentless Enabled Integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

## REST API

- `issues`: Collects all found issues for the related organizations and projects.
- `audit_logs`: Collects audit logging from Snyk, this can be actions like users, permissions, groups, api access and more.

To configure access to the Snyk REST Audit Log API you will have to obtain an API access token from [your Snyk account dashboard](https://app.snyk.io/account) as described in the [Snyk Documentation](https://docs.snyk.io/snyk-api/authentication-for-api).

## Audit Logs

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-05-15T16:34:14.144Z",
      "agent": {
          "ephemeral_id": "6b4b2646-d403-4342-9261-edee5f31db21",
          "id": "24936262-0cda-4934-aea3-82bed4844c98",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "snyk.audit_logs",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "24936262-0cda-4934-aea3-82bed4844c98",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "action": "org.project.issue.create",
          "agent_id_status": "verified",
          "dataset": "snyk.audit_logs",
          "ingested": "2024-05-23T23:38:58Z",
          "original": "{\"content\":{\"action\":\"Returned from analysis\"},\"created\":\"2024-05-15T16:34:14.144Z\",\"event\":\"org.project.issue.create\",\"org_id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"project_id\":\"d2bf0629-84a7-4b0b-b435-f49a87f0720c\"}",
          "type": [
              "creation"
          ]
      },
      "input": {
          "type": "cel"
      },
      "organization": {
          "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4"
      },
      "snyk": {
          "audit_logs": {
              "content": {
                  "action": "Returned from analysis"
              },
              "org_id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
              "project_id": "d2bf0629-84a7-4b0b-b435-f49a87f0720c"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "snyk-audit-logs"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                      | Description                                                        | Type             |
  |----------------------------|--------------------------------------------------------------------|------------------|
  | @timestamp                 | Event timestamp.                                                   | date             |
  | data_stream.dataset        | Data stream dataset name.                                          | constant_keyword |
  | data_stream.namespace      | Data stream namespace.                                             | constant_keyword |
  | data_stream.type           | Data stream type.                                                  | constant_keyword |
  | event.dataset              | Event dataset                                                      | constant_keyword |
  | event.module               | Event module                                                       | constant_keyword |
  | host.containerized         | If the host is a container.                                        | boolean          |
  | host.os.build              | OS build information.                                              | keyword          |
  | host.os.codename           | OS codename, if any.                                               | keyword          |
  | input.type                 | Type of Filebeat input.                                            | keyword          |
  | log.flags                  | Flags for the log file.                                            | keyword          |
  | log.offset                 | Offset of the entry in the log file.                               | long             |
  | snyk.audit_logs.content    | Overview of the content that was changed, both old and new values. | flattened        |
  | snyk.audit_logs.org_id     | ID of the related Organization related to the event.               | keyword          |
  | snyk.audit_logs.project_id | ID of the project related to the event.                            | keyword          |
  | snyk.audit_logs.user_id    | ID of the user related to the event.                               | keyword          |
  | snyk.projects              | Array with all related projects objects.                           | flattened        |
  | snyk.related.projects      | Array of all the related project ID's.                             | keyword          |
</dropdown>


## Issues

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-05-15T18:49:24.958Z",
      "agent": {
          "ephemeral_id": "e960d9c1-a9b4-46fe-874a-f631574b22c4",
          "id": "f1ccac17-bee9-4ba8-99e4-9f6f3ddeeecc",
          "name": "elastic-agent-93033",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "snyk.issues",
          "namespace": "82149",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "f1ccac17-bee9-4ba8-99e4-9f6f3ddeeecc",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "snyk.issues",
          "ingested": "2025-09-17T16:16:33Z",
          "kind": [
              "alert"
          ],
          "original": "{\"attributes\":{\"coordinates\":[{\"is_fixable_manually\":false,\"is_fixable_snyk\":false,\"is_fixable_upstream\":false,\"is_patchable\":false,\"is_pinnable\":false,\"is_upgradeable\":false,\"reachability\":\"no-info\",\"representations\":[{\"dependency\":{\"package_name\":\"git/git-man\",\"package_version\":\"1:2.30.2-1\"}}]},{\"is_fixable_manually\":false,\"is_fixable_snyk\":false,\"is_fixable_upstream\":false,\"is_patchable\":false,\"is_pinnable\":false,\"is_upgradeable\":false,\"reachability\":\"no-info\",\"representations\":[{\"dependency\":{\"package_name\":\"git\",\"package_version\":\"1:2.30.2-1\"}}]}],\"created_at\":\"2024-05-15T18:49:24.958Z\",\"effective_severity_level\":\"low\",\"ignored\":false,\"key\":\"SNYK-DEBIAN11-GIT-6846207\",\"problems\":[{\"id\":\"SNYK-DEBIAN11-GIT-6846207\",\"source\":\"SNYK\",\"type\":\"vulnerability\",\"updated_at\":\"2024-05-15T18:49:26.454629Z\"},{\"id\":\"CVE-2024-32020\",\"source\":\"NVD\",\"type\":\"vulnerability\",\"updated_at\":\"2024-05-15T18:49:26.454631Z\",\"url\":\"https://nvd.nist.gov/vuln/detail/CVE-2024-32020\"}],\"risk\":{\"factors\":[],\"score\":{\"model\":\"v1\",\"value\":221}},\"status\":\"open\",\"title\":\"CVE-2024-32020\",\"type\":\"package_vulnerability\",\"updated_at\":\"2024-05-15T18:49:24.958Z\"},\"id\":\"bdb0b182-440e-483f-8f42-d4f5477e8349\",\"relationships\":{\"organization\":{\"data\":{\"id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"type\":\"organization\"},\"links\":{\"related\":\"/orgs/0de7b2d6-c1da-46aa-887e-1886f96770d4\"}},\"scan_item\":{\"data\":{\"attributes\":{\"build_args\":{\"root_workspace\":\"text\"},\"business_criticality\":[\"medium\"],\"created\":\"2021-05-29T09:50:54.014Z\",\"environment\":[\"external\",\"hosted\"],\"lifecycle\":[\"production\"],\"name\":\"snyk/goof\",\"origin\":\"github\",\"read_only\":true,\"settings\":{\"auto_dependency_upgrade\":{\"ignored_dependencies\":[\"typescript\"],\"is_enabled\":true,\"is_inherited\":true,\"is_major_upgrade_enabled\":true,\"limit\":10,\"minimum_age\":365},\"auto_remediation_prs\":{\"is_backlog_prs_enabled\":true,\"is_fresh_prs_enabled\":true,\"is_patch_remediation_enabled\":true},\"manual_remediation_prs\":{\"is_patch_remediation_enabled\":true},\"pull_request_assignment\":{\"assignees\":[\"my-github-username\"],\"is_enabled\":true,\"type\":\"auto\"},\"pull_requests\":{\"fail_only_for_issues_with_fix\":true,\"is_enabled\":true,\"policy\":\"all\",\"severity_threshold\":\"high\"},\"recurring_tests\":{\"frequency\":\"daily\"}},\"status\":\"active\",\"tags\":[{\"key\":\"tag-key\",\"value\":\"tag-value\"}],\"target_file\":\"package.json\",\"target_reference\":\"main\",\"target_runtime\":\"text\",\"type\":\"maven\"},\"id\":\"123e4567-e89b-12d3-a456-426614174000\",\"meta\":{\"cli_monitored_at\":\"2021-05-29T09:50:54.014Z\",\"latest_dependency_total\":{\"total\":1,\"updated_at\":\"2025-08-02T06:48:28.132Z\"},\"latest_issue_counts\":{\"critical\":1,\"high\":1,\"low\":1,\"medium\":1,\"updated_at\":\"2025-08-02T06:48:28.132Z\"}},\"relationships\":{\"importer\":{\"data\":{\"id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"type\":\"resource\"},\"links\":{\"related\":{\"href\":\"https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4\"}}},\"organization\":{\"data\":{\"id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"type\":\"resource\"},\"links\":{\"related\":{\"href\":\"https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4\"}}},\"owner\":{\"data\":{\"id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"type\":\"resource\"},\"links\":{\"related\":{\"href\":\"https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4\"}}},\"target\":{\"data\":{\"id\":\"0de7b2d6-c1da-46aa-887e-1886f96770d4\",\"type\":\"resource\"},\"links\":{\"related\":{\"href\":\"https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4\"}}}},\"type\":\"project\"},\"links\":{\"related\":\"/orgs/0de7b2d6-c1da-46aa-887e-1886f96770d4/projects/123e4567-e89b-12d3-a456-426614174000\"}}},\"type\":\"issue\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "organization": {
          "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4"
      },
      "snyk": {
          "issues": {
              "attributes": {
                  "coordinates": [
                      {
                          "is_fixable_manually": false,
                          "is_fixable_snyk": false,
                          "is_fixable_upstream": false,
                          "is_patchable": false,
                          "is_pinnable": false,
                          "is_upgradeable": false,
                          "reachability": "no-info",
                          "representations": [
                              {
                                  "dependency": {
                                      "package_name": "git/git-man",
                                      "package_version": "1:2.30.2-1"
                                  }
                              }
                          ]
                      },
                      {
                          "is_fixable_manually": false,
                          "is_fixable_snyk": false,
                          "is_fixable_upstream": false,
                          "is_patchable": false,
                          "is_pinnable": false,
                          "is_upgradeable": false,
                          "reachability": "no-info",
                          "representations": [
                              {
                                  "dependency": {
                                      "package_name": "git",
                                      "package_version": "1:2.30.2-1"
                                  }
                              }
                          ]
                      }
                  ],
                  "created_at": "2024-05-15T18:49:24.958Z",
                  "effective_severity_level": "low",
                  "ignored": false,
                  "key": "SNYK-DEBIAN11-GIT-6846207",
                  "problems": [
                      {
                          "id": "SNYK-DEBIAN11-GIT-6846207",
                          "source": "SNYK",
                          "type": "vulnerability",
                          "updated_at": "2024-05-15T18:49:26.454629Z"
                      },
                      {
                          "id": "CVE-2024-32020",
                          "source": "NVD",
                          "type": "vulnerability",
                          "updated_at": "2024-05-15T18:49:26.454631Z",
                          "url": "https://nvd.nist.gov/vuln/detail/CVE-2024-32020"
                      }
                  ],
                  "risk": {
                      "score": {
                          "model": "v1",
                          "value": 221
                      }
                  },
                  "status": "open",
                  "title": "CVE-2024-32020",
                  "type": "package_vulnerability",
                  "updated_at": "2024-05-15T18:49:24.958Z"
              },
              "id": "bdb0b182-440e-483f-8f42-d4f5477e8349",
              "relationships": {
                  "organization": {
                      "data": {
                          "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
                          "type": "organization"
                      },
                      "links": {
                          "related": "/orgs/0de7b2d6-c1da-46aa-887e-1886f96770d4"
                      }
                  },
                  "scan_item": {
                      "data": {
                          "attributes": {
                              "build_args": {
                                  "root_workspace": "text"
                              },
                              "business_criticality": [
                                  "medium"
                              ],
                              "created": "2021-05-29T09:50:54.014Z",
                              "environment": [
                                  "external",
                                  "hosted"
                              ],
                              "lifecycle": [
                                  "production"
                              ],
                              "name": "snyk/goof",
                              "origin": "github",
                              "read_only": true,
                              "settings": {
                                  "auto_dependency_upgrade": {
                                      "ignored_dependencies": [
                                          "typescript"
                                      ],
                                      "is_enabled": true,
                                      "is_inherited": true,
                                      "is_major_upgrade_enabled": true,
                                      "limit": 10,
                                      "minimum_age": 365
                                  },
                                  "auto_remediation_prs": {
                                      "is_backlog_prs_enabled": true,
                                      "is_fresh_prs_enabled": true,
                                      "is_patch_remediation_enabled": true
                                  },
                                  "manual_remediation_prs": {
                                      "is_patch_remediation_enabled": true
                                  },
                                  "pull_request_assignment": {
                                      "assignees": [
                                          "my-github-username"
                                      ],
                                      "is_enabled": true,
                                      "type": "auto"
                                  },
                                  "pull_requests": {
                                      "fail_only_for_issues_with_fix": true,
                                      "is_enabled": true,
                                      "policy": "all",
                                      "severity_threshold": "high"
                                  },
                                  "recurring_tests": {
                                      "frequency": "daily"
                                  }
                              },
                              "status": "active",
                              "tags": [
                                  "tag-key:tag-value"
                              ],
                              "target_file": "package.json",
                              "target_reference": "main",
                              "target_runtime": "text",
                              "type": "maven"
                          },
                          "id": "123e4567-e89b-12d3-a456-426614174000",
                          "meta": {
                              "cli_monitored_at": "2021-05-29T09:50:54.014Z",
                              "latest_dependency_total": {
                                  "total": 1,
                                  "updated_at": "2025-08-02T06:48:28.132Z"
                              },
                              "latest_issue_counts": {
                                  "critical": 1,
                                  "high": 1,
                                  "low": 1,
                                  "medium": 1,
                                  "updated_at": "2025-08-02T06:48:28.132Z"
                              }
                          },
                          "relationships": {
                              "importer": {
                                  "data": {
                                      "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
                                      "type": "resource"
                                  },
                                  "links": {
                                      "related": {
                                          "href": "https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4"
                                      }
                                  }
                              },
                              "organization": {
                                  "data": {
                                      "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
                                      "type": "resource"
                                  },
                                  "links": {
                                      "related": {
                                          "href": "https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4"
                                      }
                                  }
                              },
                              "owner": {
                                  "data": {
                                      "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
                                      "type": "resource"
                                  },
                                  "links": {
                                      "related": {
                                          "href": "https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4"
                                      }
                                  }
                              },
                              "target": {
                                  "data": {
                                      "id": "0de7b2d6-c1da-46aa-887e-1886f96770d4",
                                      "type": "resource"
                                  },
                                  "links": {
                                      "related": {
                                          "href": "https://example.com/api/resource/0de7b2d6-c1da-46aa-887e-1886f96770d4"
                                      }
                                  }
                              }
                          },
                          "type": "project"
                      },
                      "links": {
                          "related": "/orgs/0de7b2d6-c1da-46aa-887e-1886f96770d4/projects/123e4567-e89b-12d3-a456-426614174000"
                      }
                  }
              }
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "snyk-issues"
      ],
      "vulnerability": {
          "enumeration": [
              "SNYK",
              "NVD"
          ],
          "id": [
              "SNYK-DEBIAN11-GIT-6846207",
              "CVE-2024-32020"
          ],
          "reference": [
              "https://nvd.nist.gov/vuln/detail/CVE-2024-32020"
          ],
          "scanner": {
              "vendor": "Snyk"
          },
          "severity": "low"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                                            | Description                                                                                                                                                                     | Type             |
  |------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                                       | Event timestamp.                                                                                                                                                                | date             |
  | data_stream.dataset                                                                                              | Data stream dataset name.                                                                                                                                                       | constant_keyword |
  | data_stream.namespace                                                                                            | Data stream namespace.                                                                                                                                                          | constant_keyword |
  | data_stream.type                                                                                                 | Data stream type.                                                                                                                                                               | constant_keyword |
  | event.dataset                                                                                                    | Event dataset                                                                                                                                                                   | constant_keyword |
  | event.module                                                                                                     | Event module                                                                                                                                                                    | constant_keyword |
  | host.containerized                                                                                               | If the host is a container.                                                                                                                                                     | boolean          |
  | host.os.build                                                                                                    | OS build information.                                                                                                                                                           | keyword          |
  | host.os.codename                                                                                                 | OS codename, if any.                                                                                                                                                            | keyword          |
  | input.type                                                                                                       | Type of Filebeat input.                                                                                                                                                         | keyword          |
  | labels.is_transform_source                                                                                       | Distinguishes between documents that are a source for a transform and documents that are an output of a transform, to facilitate easier filtering.                              | constant_keyword |
  | log.flags                                                                                                        | Flags for the log file.                                                                                                                                                         | keyword          |
  | log.offset                                                                                                       | Offset of the entry in the log file.                                                                                                                                            | long             |
  | snyk.issues.attributes.classes.id                                                                                |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.classes.source                                                                            |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.classes.type                                                                              |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.coordinates.cloud_resource                                                                | A resource location to some service, like a cloud resource.                                                                                                                     | flattened        |
  | snyk.issues.attributes.coordinates.is_fixable_manually                                                           |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.is_fixable_snyk                                                               |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.is_fixable_upstream                                                           |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.is_patchable                                                                  |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.is_pinnable                                                                   |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.is_upgradeable                                                                |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.coordinates.reachability                                                                  |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.coordinates.representations.dependency.package_name                                       |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.coordinates.representations.dependency.package_version                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.coordinates.resourcePath                                                                  |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.created_at                                                                                |                                                                                                                                                                                 | date             |
  | snyk.issues.attributes.effective_severity_level                                                                  | The type from enumeration of the issue’s severity level: info, low, medium, high or critical. This is usually set from the issue’s producer, but can be overridden by policies. | keyword          |
  | snyk.issues.attributes.exploit_details.maturity_levels.format                                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.exploit_details.maturity_levels.level                                                     |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.exploit_details.sources                                                                   |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.ignored                                                                                   |                                                                                                                                                                                 | boolean          |
  | snyk.issues.attributes.key                                                                                       |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.problems.disclosed_at                                                                     | When this problem was disclosed to the public.                                                                                                                                  | date             |
  | snyk.issues.attributes.problems.discovered_at                                                                    | When this problem was first discovered.                                                                                                                                         | date             |
  | snyk.issues.attributes.problems.id                                                                               |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.problems.source                                                                           |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.problems.type                                                                             | The problem type: rule or vulnerability.                                                                                                                                        | keyword          |
  | snyk.issues.attributes.problems.updated_at                                                                       | When this problem was last updated.                                                                                                                                             | date             |
  | snyk.issues.attributes.problems.url                                                                              |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.risk.score.model                                                                          | Risk scoring model used to calculate the score value.                                                                                                                           | keyword          |
  | snyk.issues.attributes.risk.score.updated_at                                                                     |                                                                                                                                                                                 | date             |
  | snyk.issues.attributes.risk.score.value                                                                          | Risk score value, which may be used for overall prioritization.                                                                                                                 | long             |
  | snyk.issues.attributes.severities.level                                                                          |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.severities.modification_time                                                              |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.severities.score                                                                          |                                                                                                                                                                                 | double           |
  | snyk.issues.attributes.severities.source                                                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.severities.vector                                                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.severities.version                                                                        |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.status                                                                                    | An issue's status: open or resolved.                                                                                                                                            | keyword          |
  | snyk.issues.attributes.title                                                                                     |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.type                                                                                      |                                                                                                                                                                                 | keyword          |
  | snyk.issues.attributes.updated_at                                                                                |                                                                                                                                                                                 | date             |
  | snyk.issues.id                                                                                                   | The issue reference ID.                                                                                                                                                         | keyword          |
  | snyk.issues.relationships.organization.data.id                                                                   |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.organization.data.type                                                                 |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.organization.links.related                                                             |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.build_args.root_workspace                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.business_criticality                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.created                                                      |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.environment                                                  |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.lifecycle                                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.name                                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.origin                                                       |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.read_only                                                    |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.ignored_dependencies        |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.is_enabled                  |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.is_inherited                |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.is_major_upgrade_enabled    |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.limit                       |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_dependency_upgrade.minimum_age                 |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_remediation_prs.is_backlog_prs_enabled         |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_remediation_prs.is_fresh_prs_enabled           |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.auto_remediation_prs.is_patch_remediation_enabled   |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.manual_remediation_prs.is_patch_remediation_enabled |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_request_assignment.assignees                   |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_request_assignment.is_enabled                  |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_request_assignment.type                        |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_requests.fail_only_for_issues_with_fix         |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_requests.is_enabled                            |                                                                                                                                                                                 | boolean          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_requests.policy                                |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.pull_requests.severity_threshold                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.settings.recurring_tests.frequency                           |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.status                                                       |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.tags                                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.target_file                                                  |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.target_reference                                             |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.target_runtime                                               |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.attributes.type                                                         |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.id                                                                      |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.meta.cli_monitored_at                                                   |                                                                                                                                                                                 | date             |
  | snyk.issues.relationships.scan_item.data.meta.latest_dependency_total.total                                      |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.meta.latest_dependency_total.updated_at                                 |                                                                                                                                                                                 | date             |
  | snyk.issues.relationships.scan_item.data.meta.latest_issue_counts.critical                                       |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.meta.latest_issue_counts.high                                           |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.meta.latest_issue_counts.low                                            |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.meta.latest_issue_counts.medium                                         |                                                                                                                                                                                 | long             |
  | snyk.issues.relationships.scan_item.data.meta.latest_issue_counts.updated_at                                     |                                                                                                                                                                                 | date             |
  | snyk.issues.relationships.scan_item.data.relationships.importer.data.id                                          |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.importer.data.type                                        |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.importer.links.related.href                               |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.organization.data.id                                      |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.organization.data.type                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.organization.links.related.href                           |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.owner.data.id                                             |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.owner.data.type                                           |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.owner.links.related.href                                  |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.target.data.id                                            |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.target.data.type                                          |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.relationships.target.links.related.href                                 |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.data.type                                                                    |                                                                                                                                                                                 | keyword          |
  | snyk.issues.relationships.scan_item.links.related                                                                |                                                                                                                                                                                 | keyword          |
  | snyk.projects                                                                                                    | Array with all related projects objects.                                                                                                                                        | flattened        |
  | snyk.related.projects                                                                                            | Array of all the related project ID's.                                                                                                                                          | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15474))Enable Agentless deployment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15377))Add latest transform to issues data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.0            |
  | **3.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15239))Collect all issue updates.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15239))Cursor position is invalidated by change from last created time to last updated time.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15239))Fix handling of Snyk API `type` and `scan_item.type` query parameters.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15239))Snyk API `type` and `scan_item.type` query parameter settings are invalidated. | 9.0.08.18.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15017))Accept undocumented API behavior.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.13.0            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14780))Fetch related projects for issues.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.13.0            |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14367))Add maximum executions configuration option for data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.13.0            |
  | **2.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13186))Removed legacy audit and vulnerabilities data streams.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13186))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.13.0            |
  | **1.27.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12964))Fix the parsing of `created_at` timestamp when unexpected time format.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.27.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12817))Prevent empty-keyed fields in `snyk.audit_logs.content.notSupported`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **1.25.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11440))Fix query parameters definition for issues data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.25.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10515))Fix fingerprint in audit_logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10073))Allow dynamic organization look-up in audit_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10346))Improve error reporting for API request failures.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9994))Fix handling of event filter parameter in audit_logs data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.12.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9924))Add support for new Snyk API                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.20.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9213))Add cloudsecurity_cdr sub category label                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.12.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **1.19.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6852))Update package-spec 2.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6663))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3870))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.3.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3651))Fixes possible indefinite pagination                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3579))Add correct field mapping for event.created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3092))Fix typo in config template for ignoring host enrichment                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2439))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2162))Initial draft of the package                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
</dropdown>