﻿---
title: Slack Integration
description: Slack is used by numerous orgazations as their primary chat and collaboration tool. The Slack integration uses Slack's API to retrieve audit events and...
url: https://www.elastic.co/docs/reference/integrations/slack
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Slack Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.26.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

[Slack](https://www.slack.com) is used by numerous orgazations as their primary chat and collaboration tool.
The Slack integration uses [Slack's API](https://api.slack.com/) to retrieve audit events and ingest them into Elasticsearch. This allows you to search, observe, and visualize the Slack log events through Elasticsearch.
The Elastic agent running this integration interacts with Slack's infrastructure using their APIs to retrieve [audit logs](https://api.slack.com/admins/audit-logs) for a workspace or enterprise.
**Please note the Audit Logs API is only available to Slack workspaces on an Enterprise Grid plan. These API methods will not work for workspaces on a Free, Standard, or Business+ plan.**

## Configuration


### Enabling the integration in Elastic

1. In Kibana go to **Management > Integrations**
2. In the "Search for integrations" search bar type **Slack**.
3. Click on "Slack" integration from the search results.
4. Click on **Add Slack** button to add Slack integration.


### Configure Slack audit logs data stream

Enter values "OAuth API Token".
1. [**OAuth API Token**](https://api.slack.com/authentication/basics) will be generated when a [Slack App](https://api.slack.com/apps) is created.


#### Configure using API Token

For the Slack integration to be able to successfully get logs the following "User Token Scopes"" must be granted to the Slack App:
- `auditlogs:read`


## Logs


### Audit

Audit logs summarize the history of changes made within the Slack Enterprise.
<dropdown title="Exported fields">
  | Field                                       | Description                                                                                                                                               | Type             |
  |---------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                  | Event timestamp.                                                                                                                                          | date             |
  | cloud.image.id                              | Image ID for the cloud instance.                                                                                                                          | keyword          |
  | data_stream.dataset                         | Data stream dataset name.                                                                                                                                 | constant_keyword |
  | data_stream.namespace                       | Data stream namespace.                                                                                                                                    | constant_keyword |
  | data_stream.type                            | Data stream type.                                                                                                                                         | constant_keyword |
  | event.dataset                               | Event dataset                                                                                                                                             | constant_keyword |
  | event.module                                | Event module                                                                                                                                              | constant_keyword |
  | host.containerized                          | If the host is a container.                                                                                                                               | boolean          |
  | host.os.build                               | OS build information.                                                                                                                                     | keyword          |
  | host.os.codename                            | OS codename, if any.                                                                                                                                      | keyword          |
  | input.type                                  | Type of Filebeat input.                                                                                                                                   | keyword          |
  | log.flags                                   | Flags for the log file.                                                                                                                                   | keyword          |
  | log.offset                                  | Offset of the entry in the log file.                                                                                                                      | long             |
  | slack.audit.actor.type                      | The type of entity performing the action.                                                                                                                 | keyword          |
  | slack.audit.actor.user.team                 | The the team of the actor if they are a user.                                                                                                             | keyword          |
  | slack.audit.context.domain                  | The domain of the Workspace or Enterprise                                                                                                                 | keyword          |
  | slack.audit.context.id                      | The ID of the workspace or enterprise                                                                                                                     | keyword          |
  | slack.audit.context.name                    | The name of the workspace or enterprise                                                                                                                   | keyword          |
  | slack.audit.context.session_id              | The identifier that is unique to each authenticated session.                                                                                              | keyword          |
  | slack.audit.context.type                    | The type of account. Either `Workspace` or `Enterprise`                                                                                                   | keyword          |
  | slack.audit.details.location                | The location the activity occured in when event.action is anomaly                                                                                         | keyword          |
  | slack.audit.details.md5                     | The md5 hash of a file associated with a `file_malicious_content_detected` event.                                                                         | keyword          |
  | slack.audit.details.previous_ip_address     | The IP address previously observed for the entity in the event when event.action is anomaly                                                               | ip               |
  | slack.audit.details.previous_user_agent     | The User-Agent string previously observed for the entity in the event when event.action is anomaly                                                        | keyword          |
  | slack.audit.details.reason                  | The anomaly rule triggered to generate the event when event.action is anomaly: asn, excessive_downloads, ip_address, session_fingerprint, tor, user_agent | keyword          |
  | slack.audit.details.url_private             | URL associated with the action.                                                                                                                           | keyword          |
  | slack.audit.entity.barriered_from_usergroup | The user group barrier when entity_type is barrier                                                                                                        | keyword          |
  | slack.audit.entity.channel                  | The channel the entity is within when entity_type is message                                                                                              | keyword          |
  | slack.audit.entity.domain                   | Domain of the entity when entity_type is Workspace or Enterprise                                                                                          | keyword          |
  | slack.audit.entity.email                    | Email address of the entity when entity_type is user                                                                                                      | keyword          |
  | slack.audit.entity.entity_type              | Type of the entity: workspace, enterprise, user, file, channel, app, workflow, user, usergroup, barrier, message, role, account_type_role.                | keyword          |
  | slack.audit.entity.filetype                 | Filetype of the entity when entity_type is file                                                                                                           | keyword          |
  | slack.audit.entity.id                       | ID of the entity                                                                                                                                          | keyword          |
  | slack.audit.entity.is_directory_approved    | If App is approved when entity_type is app                                                                                                                | boolean          |
  | slack.audit.entity.is_distributed           | If App is distributed when entity_type is app                                                                                                             | boolean          |
  | slack.audit.entity.is_org_shared            | If channel is shared when entity_type is channel                                                                                                          | boolean          |
  | slack.audit.entity.is_shared                | If channel is shared when entity_type is channel                                                                                                          | boolean          |
  | slack.audit.entity.is_workflow_app          | If App is a workflow when entity_type is app                                                                                                              | boolean          |
  | slack.audit.entity.name                     | Name of the entity                                                                                                                                        | keyword          |
  | slack.audit.entity.primary_usergroup        | The primary user group when entity_type is barrier                                                                                                        | keyword          |
  | slack.audit.entity.privacy                  | Privacy status of entity when entity_type is channel                                                                                                      | keyword          |
  | slack.audit.entity.scopes                   | The OAuth scopes when entity_type is app                                                                                                                  | keyword          |
  | slack.audit.entity.team                     | Team that the entity exists within when entity_type is user or message                                                                                    | keyword          |
  | slack.audit.entity.teams_shared_with        | List of orgs channel is shared with when entity_type is channel                                                                                           | keyword          |
  | slack.audit.entity.timestamp                | The timestamp of the entity when entity_type is message                                                                                                   | keyword          |
  | slack.audit.entity.title                    | Title of the entity when entity_type is file                                                                                                              | keyword          |
  | slack.audit.entity.type                     | The type of the entity when entity_type is role                                                                                                           | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-01-13T17:40:21.862Z",
      "agent": {
          "ephemeral_id": "4493e0ba-0e9b-43e7-ad59-2a2c6c330c73",
          "id": "6790db85-6c1f-425a-a093-87887eed5a5d",
          "name": "elastic-agent-86233",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "slack.audit",
          "namespace": "54041",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "6790db85-6c1f-425a-a093-87887eed5a5d",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "anomaly",
          "agent_id_status": "verified",
          "created": "2025-12-05T07:31:29.085Z",
          "dataset": "slack.audit",
          "id": "2125fb41-c67c-4cf5-a5c4-d90cb58dd5f9",
          "ingested": "2025-12-05T07:31:30Z",
          "kind": "event",
          "original": "{\"action\":\"anomaly\",\"actor\":{\"type\":\"user\",\"user\":{\"email\":\"aaron@example.com\",\"id\":\"e65b0f5c\",\"name\":\"roy\"}},\"context\":{\"ip_address\":\"81.2.69.143\",\"location\":{\"domain\":\"Docker\",\"id\":\"e65b11aa\",\"name\":\"Docker\",\"type\":\"workspace\"},\"ua\":\"Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:23.0) Gecko/20131011 Firefox/23.0\"},\"date_create\":1683836273,\"details\":{\"action_timestamp\":1673631621862,\"location\":\"England, GB\",\"previous_ip_address\":\"175.16.199.64\",\"previous_ua\":\"\",\"reason\":[\"asn\",\"ip_address\"]},\"entity\":{\"type\":\"user\",\"user\":{\"email\":\"jbob@example.com\",\"id\":\"asdfasdf\",\"name\":\"Joe Bob\",\"team\":\"T234SAH2\"}},\"id\":\"2125fb41-c67c-4cf5-a5c4-d90cb58dd5f9\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "related": {
          "ip": [
              "81.2.69.143"
          ],
          "user": [
              "e65b0f5c",
              "aaron@example.com"
          ]
      },
      "slack": {
          "audit": {
              "actor": {
                  "type": "user"
              },
              "context": {
                  "domain": "Docker",
                  "id": "e65b11aa",
                  "name": "Docker",
                  "type": "workspace"
              },
              "details": {
                  "location": "England, GB",
                  "previous_ip_address": "175.16.199.64",
                  "reason": [
                      "asn",
                      "ip_address"
                  ]
              },
              "entity": {
                  "email": "jbob@example.com",
                  "entity_type": "user",
                  "id": "asdfasdf",
                  "name": "Joe Bob",
                  "team": "T234SAH2"
              }
          }
      },
      "source": {
          "address": "81.2.69.143",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "ip": "81.2.69.143"
      },
      "tags": [
          "forwarded",
          "slack-audit",
          "preserve_original_event"
      ],
      "user": {
          "email": "aaron@example.com",
          "full_name": "roy",
          "id": "e65b0f5c"
      },
      "user_agent": {
          "device": {
              "name": "Other"
          },
          "name": "Firefox",
          "original": "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:23.0) Gecko/20131011 Firefox/23.0",
          "os": {
              "full": "Windows 7",
              "name": "Windows",
              "version": "7"
          },
          "version": "23.0"
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16325))Prevent updating fleet health status to degraded when the next_cursor is not present.                                                                              | 9.1.49.0.78.19.4       |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14898))Fix handling of empty Slack `context.ip_address` fields.                                                                                                               | 9.0.08.13.0            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                         | 9.0.08.13.0            |
  | **1.24.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                   | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                            | 8.13.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                          | 8.13.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11445))Map `details.url_private` and `actor` fields.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11445))Improve pipeline efficiency. | 8.13.0                 |
  | **1.21.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                   | 8.13.0                 |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                   | 8.13.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                | 8.12.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9417))Map md5 hash detail for files.                                                                                                                                      | 8.12.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret.                                                                                                                                     | 8.12.0                 |
  | **1.17.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                      | 8.10.1                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                             | 8.10.1                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                      | 8.10.1                 |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8217))Choose the correct value for the `oldest` param.                                                                                                                        | 8.10.1                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                              | 8.7.1                  |
  | **1.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8169))Keep `oldest` parameter when paginating responses.                                                                                                                      | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                         | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                                         | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7946))Update package to ECS 8.10.0 and align ECS categorization fields.                                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                | 8.7.1                  |
  | **1.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6958))Fix handling of API query param 'oldest'                                                                                                                                | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7299))Update package-spec to 2.9.0.                                                                                                                                       | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                        | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                            | 8.7.1                  |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6965))Parse action_timestamp values as microseconds since unix epoch.                                                                                                         | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                      | 8.7.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6663))Ensure error.message is correctly set for pipeline errors.                                                                                                          | 8.7.1                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                        | 8.7.1                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4999))Adds anomaly detail fields.**Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/6402))Fix formatting of 'oldest' API query parameter.    | 8.7.1                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6193))Add `slack.audit.context.session_id` field.                                                                                                                         | 8.7.1                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                            | 8.7.1                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                        | 8.1.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5677))Release Slack as GA.                                                                                                                                                | 8.1.0                  |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                        |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4642))Remove duplicate fields.                                                                                                                                                |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                        |                        |
  | **0.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4327))Remove duplicate field.                                                                                                                                               |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                  |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3278))Initial draft of the package                                                                                                                                        |                        |
</dropdown>