﻿---
title: SentinelOne Integration for Elastic
description: The SentinelOne integration collects and parses data from SentinelOne REST APIs. This integration also offers the capability to perform response actions...
url: https://www.elastic.co/docs/reference/integrations/sentinel_one
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# SentinelOne Integration for Elastic
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.1.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.3.09.2.19.1.78.19.7          |


## Overview

The [SentinelOne](https://www.sentinelone.com/) integration collects and parses data from SentinelOne REST APIs. This integration also offers the capability to perform response actions on SentinelOne hosts directly through the Elastic Security interface (introduced with v8.12.0). Additional configuration is required; for detailed guidance, refer to [documentation](https://www.elastic.co/guide/en/security/current/response-actions-config.html).

### Compatibility

This module has been tested against `SentinelOne Management Console API version 2.1`.

### How it works

This integration periodically queries the SentinelOne REST API to retrieve Activity, Agent, Alert, Application, Application Risk, Group, Threat and Threat Event logs.

## What data does this integration collect?

This integration collects log messages of the following types:
- `Activity`: Captures general actions or events occurring within the SentinelOne environment, such as policy updates or administrative operations.
- `Agent`: Provides details about endpoint agents, including their status, configuration, and activity on protected devices.
- `Alert`: Represents security notifications triggered by detected suspicious or malicious activity requiring attention.
- `Application`: Logs information about installed or executed applications identified on endpoints.
- `Application Risk`: Assesses and records the risk level or reputation of discovered applications based on behavior and source.
- `Group`: Contains configuration and status information for endpoint groups within a site or tenant.
- `Threat`: Logs confirmed malicious detections, such as malware, exploits, or ransomware identified by SentinelOne.
- `Threat Event`: Provides detailed event-level information related to a specific threat, including process, file, and network indicators.


### Supported use cases

Integrating SentinelOne Activity, Agent, Alert, Application, Application Risk, Group, Threat, and Threat Event logs with Elastic SIEM provides centralized visibility across endpoint operations and security events. Dashboards deliver insights into agent status, detections, application behavior, and threat lifecycle, helping SOC teams quickly identify malicious activity, enforce policy compliance, and accelerate investigation and response efforts.

## What do I need to use this integration?


### From SentinelOne

To collect data from SentinelOne APIs, you must have an API token. To create an API token, follow these steps:
1. Log in to the **SentinelOne Management Console** as an **Admin**.
   ![SentinelOne dashboards](https://www.elastic.co/docs/reference/integrations/images/sentinel_one/sentinel-one-dashboard.png)
2. Navigate to **Logged User Account** from top right panel in the navigation bar.
3. Click **My User**.
4. In the API token section, navigate to **Actions** > **API Token Operators** > **Generate API Token**.

   ![SentinelOne generate API token ](https://www.elastic.co/docs/reference/integrations/images/sentinel_one/sentinel-one-api-token-generate.png)
5. Enter the MFA code, if enabled.
   ![SentinelOne generate MFA Code ](https://www.elastic.co/docs/reference/integrations/images/sentinel_one/sentinel-one-mfa-code.png)
6. You will see the API token on the screen.

**Permissions Required for the Role Attached to the User**

| **Data Stream**  | **Permission**            |
|------------------|---------------------------|
| Activity         | Activity -> view          |
| Agent            | Endpoints -> view         |
| Alert            | STAR Rule Alerts -> view  |
| Application      | Applications -> view      |
| Application Risk | Applications -> viewRisks |
| Group            | Groups -> view            |
| Threat           | Threats -> view           |
| Threat Event     | Threats -> view           |


## Note

The **alert** data stream depends on STAR Custom Rules. STAR Custom Rules are supported in Cloud environments, but are not supported in on-premises environments. Because of this, the **alert** data stream is not supported in on-premises environments.

## How do I deploy this integration?

This integration supports both Elastic Agentless-based and Agent-based installations.

### Agentless-based installation

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

## Troubleshooting

- The API token generated by the user is time-limited. The user must reconfigure a new API token before it expires.
  - For console users, the default expiration time limit is 30 days.
- For service users, the expiration time limit is the same as the duration specified while generating the API token.


## Setup

1. In the top search bar in Kibana, search for **Integrations**.
2. In the search bar, type **SentinelOne**.
3. Select the **SentinelOne** integration from the search results.
4. Select **Add SentinelOne** to add the integration.
5. Enable and configure only the collection methods which you will use.
   - To **Collect SentinelOne logs via API**, you'll need to:
  - Configure **URL** and **API Token**.
- Enable/Disable the required datasets.
- For each dataset, adjust the integration configuration parameters if required, including the Interval, Preserve original event etc. to enable data collection.
6. Select **Save and continue** to save the integration.


### Validation


#### Dashboards populated

1. In the top search bar in Kibana, search for **Dashboards**.
2. In the search bar, type **SentinelOne**.
3. Select a dashboard for the dataset you are collecting, and verify the dashboard information is populated.


## Performance and scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### Logs reference


### activity

This is the `activity` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-04-19T05:14:08.925Z",
      "agent": {
          "ephemeral_id": "e6b8b354-ed66-48eb-8516-c576417e273c",
          "id": "7097c76d-ffaf-4c65-9da9-8da760e67c8a",
          "name": "elastic-agent-98755",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.activity",
          "namespace": "86823",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7097c76d-ffaf-4c65-9da9-8da760e67c8a",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-11-19T10:35:41.122Z",
          "dataset": "sentinel_one.activity",
          "id": "1234567890123456789",
          "ingested": "2025-11-19T10:35:44Z",
          "kind": "event",
          "original": "{\"accountId\":\"3214567890123456789\",\"accountName\":\"Default12\",\"activityType\":1234,\"agentId\":null,\"agentUpdatedVersion\":null,\"comments\":\"True\",\"createdAt\":\"2022-04-19T05:14:08.925421Z\",\"data\":{\"accountName\":\"Default\",\"byUser\":\"API\",\"fullScopeDetails\":\"Account Default\",\"fullScopeDetailsPath\":\"test/default\",\"groupName\":null,\"newValue\":true,\"role\":\"Level\",\"scopeLevel\":\"Account\",\"scopeName\":\"Default\",\"siteName\":null,\"userScope\":\"account\",\"username\":\"API\"},\"description\":\"API\",\"groupId\":null,\"groupName\":null,\"hash\":null,\"id\":\"1234567890123456789\",\"osFamily\":null,\"primaryDescription\":\"The management user API enabled Two factor authentication on the user API.\",\"secondaryDescription\":null,\"siteId\":null,\"siteName\":null,\"threatId\":null,\"updatedAt\":\"2022-04-18T05:14:08.922553Z\",\"userId\":\"1234567890123456789\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "message": "The management user API enabled Two factor authentication on the user API.",
      "related": {
          "user": [
              "API"
          ]
      },
      "sentinel_one": {
          "account": {
              "name": "Default12"
          },
          "activity": {
              "account": {
                  "id": "3214567890123456789"
              },
              "comments": "True",
              "data": {
                  "account": {
                      "name": "Default"
                  },
                  "fullscope": {
                      "details": "Account Default",
                      "details_path": "test/default"
                  },
                  "new": {
                      "value": "true"
                  },
                  "role": "Level",
                  "scope": {
                      "level": "Account",
                      "name": "Default"
                  },
                  "user": {
                      "name": "API",
                      "scope": "account"
                  }
              },
              "description": {
                  "primary": "The management user API enabled Two factor authentication on the user API."
              },
              "description_value": "API",
              "id": "1234567890123456789",
              "type": 1234,
              "updated_at": "2022-04-18T05:14:08.922Z"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-activity"
      ],
      "user": {
          "full_name": "API",
          "id": "1234567890123456789"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                  | Description                                                   | Type             |
  |--------------------------------------------------------|---------------------------------------------------------------|------------------|
  | @timestamp                                             | Event timestamp.                                              | date             |
  | cloud.image.id                                         | Image ID for the cloud instance.                              | keyword          |
  | data_stream.dataset                                    | Data stream dataset.                                          | constant_keyword |
  | data_stream.namespace                                  | Data stream namespace.                                        | constant_keyword |
  | data_stream.type                                       | Data stream type.                                             | constant_keyword |
  | event.dataset                                          | Event dataset.                                                | constant_keyword |
  | event.module                                           | Event module.                                                 | constant_keyword |
  | host.containerized                                     | If the host is a container.                                   | boolean          |
  | host.os.build                                          | OS build information.                                         | keyword          |
  | host.os.codename                                       | OS codename, if any.                                          | keyword          |
  | input.type                                             | Input type                                                    | keyword          |
  | log.offset                                             | Log offset                                                    | long             |
  | log.source.address                                     | Source address from which the log event was read / sent from. | keyword          |
  | sentinel_one.account.name                              |                                                               | keyword          |
  | sentinel_one.activity.account.id                       | Related account ID (if applicable).                           | keyword          |
  | sentinel_one.activity.agent.id                         | Related agent (if applicable).                                | keyword          |
  | sentinel_one.activity.comments                         | Comments.                                                     | keyword          |
  | sentinel_one.activity.data.account.id                  | Related account ID (if applicable).                           | keyword          |
  | sentinel_one.activity.data.account.name                | Related account name (if applicable).                         | keyword          |
  | sentinel_one.activity.data.attr                        | Attribute.                                                    | keyword          |
  | sentinel_one.activity.data.changed_keys                | Changed keys.                                                 | keyword          |
  | sentinel_one.activity.data.confidence.level            | Confidence level.                                             | keyword          |
  | sentinel_one.activity.data.created_at                  | Created time.                                                 | date             |
  | sentinel_one.activity.data.description                 | Description.                                                  | keyword          |
  | sentinel_one.activity.data.downloaded.url              | Downloaded URL.                                               | keyword          |
  | sentinel_one.activity.data.flattened                   | Extra activity specific data.                                 | flattened        |
  | sentinel_one.activity.data.fullscope.details           | fullscope details.                                            | keyword          |
  | sentinel_one.activity.data.fullscope.details_path      | fullscope details path.                                       | keyword          |
  | sentinel_one.activity.data.global.status               | Global status.                                                | keyword          |
  | sentinel_one.activity.data.group                       | Related group (if applicable).                                | keyword          |
  | sentinel_one.activity.data.group_name                  | Related group name (if applicable).                           | keyword          |
  | sentinel_one.activity.data.malicious.process.arguments | Malicious process arguments.                                  | keyword          |
  | sentinel_one.activity.data.new.confidence_level        | New confidence level.                                         | keyword          |
  | sentinel_one.activity.data.new.status                  | Status.                                                       | keyword          |
  | sentinel_one.activity.data.new.value                   | Value.                                                        | keyword          |
  | sentinel_one.activity.data.old.confidence_level        | Old confidence level.                                         | keyword          |
  | sentinel_one.activity.data.optionals_groups            | Optionals groups.                                             | keyword          |
  | sentinel_one.activity.data.original.status             | Original status.                                              | keyword          |
  | sentinel_one.activity.data.policy                      | Policy.                                                       | flattened        |
  | sentinel_one.activity.data.policy_name                 | Policy name.                                                  | keyword          |
  | sentinel_one.activity.data.reason                      | Reason.                                                       | keyword          |
  | sentinel_one.activity.data.role                        | Role.                                                         | keyword          |
  | sentinel_one.activity.data.role_name                   | Role name.                                                    | keyword          |
  | sentinel_one.activity.data.scope.level                 | Scope Level.                                                  | keyword          |
  | sentinel_one.activity.data.scope.name                  | Scope name.                                                   | keyword          |
  | sentinel_one.activity.data.scope_level.name            | Scope level name.                                             | keyword          |
  | sentinel_one.activity.data.site.name                   | Related site name (if applicable).                            | keyword          |
  | sentinel_one.activity.data.source                      | Source.                                                       | keyword          |
  | sentinel_one.activity.data.status                      | Status.                                                       | keyword          |
  | sentinel_one.activity.data.system                      | System.                                                       | boolean          |
  | sentinel_one.activity.data.threat.classification.name  | Threat classification name.                                   | keyword          |
  | sentinel_one.activity.data.user.name                   | User name.                                                    | keyword          |
  | sentinel_one.activity.data.user.scope                  | User scope.                                                   | keyword          |
  | sentinel_one.activity.data.uuid                        | UUID.                                                         | keyword          |
  | sentinel_one.activity.description.primary              | Primary description.                                          | keyword          |
  | sentinel_one.activity.description.secondary            | Secondary description.                                        | keyword          |
  | sentinel_one.activity.description_value                |                                                               | keyword          |
  | sentinel_one.activity.id                               | Activity ID.                                                  | keyword          |
  | sentinel_one.activity.rule_description                 |                                                               | keyword          |
  | sentinel_one.activity.rule_id                          |                                                               | keyword          |
  | sentinel_one.activity.rule_name                        |                                                               | keyword          |
  | sentinel_one.activity.severity                         |                                                               | keyword          |
  | sentinel_one.activity.threat.id                        | Related threat ID (if applicable).                            | keyword          |
  | sentinel_one.activity.type                             | Activity type.                                                | long             |
  | sentinel_one.activity.updated_at                       | Activity last updated time (UTC).                             | date             |
  | sentinel_one.site.id                                   |                                                               | keyword          |
  | sentinel_one.site.name                                 |                                                               | keyword          |
  | sentinel_one.threat_classification.name                |                                                               | keyword          |
  | sentinel_one.threat_classification.source              |                                                               | keyword          |
</dropdown>


### agent

This is the `agent` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-04-07T08:31:47.481Z",
      "agent": {
          "ephemeral_id": "d113dedc-4d4c-4edf-902c-01cfbebee496",
          "id": "f4af1d66-97e4-4128-81ef-620bd2b06381",
          "name": "elastic-agent-49562",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.agent",
          "namespace": "33892",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "f4af1d66-97e4-4128-81ef-620bd2b06381",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "host"
          ],
          "created": "2025-11-19T10:36:49.199Z",
          "dataset": "sentinel_one.agent",
          "id": "13491234512345",
          "ingested": "2025-11-19T10:36:52Z",
          "kind": "event",
          "original": "{\"accountId\":\"892341123451234512345\",\"accountName\":\"ABC\",\"activeDirectory\":{\"computerDistinguishedName\":null,\"computerMemberOf\":[],\"lastUserDistinguishedName\":null,\"lastUserMemberOf\":[]},\"activeThreats\":7,\"agentVersion\":\"12.x.x.x\",\"allowRemoteShell\":true,\"appsVulnerabilityStatus\":\"not_applicable\",\"cloudProviders\":{},\"computerName\":\"user-test\",\"consoleMigrationStatus\":\"N/A\",\"coreCount\":2,\"cpuCount\":2,\"cpuId\":\"CPU Name\",\"createdAt\":\"2022-03-18T09:12:00.519500Z\",\"detectionState\":null,\"domain\":\"WORKGROUP\",\"encryptedApplications\":false,\"externalId\":\"\",\"externalIp\":\"81.2.69.143\",\"firewallEnabled\":true,\"firstFullModeTime\":null,\"groupId\":\"1234567890123456789\",\"groupIp\":\"81.2.69.144\",\"groupName\":\"Default Group\",\"id\":\"13491234512345\",\"inRemoteShellSession\":false,\"infected\":true,\"installerType\":\".msi\",\"isActive\":true,\"isDecommissioned\":false,\"isPendingUninstall\":false,\"isUninstalled\":false,\"isUpToDate\":true,\"lastActiveDate\":\"2022-03-17T09:51:28.506000Z\",\"lastIpToMgmt\":\"81.2.69.145\",\"lastLoggedInUserName\":\"\",\"licenseKey\":\"\",\"locationEnabled\":true,\"locationType\":\"not_applicable\",\"locations\":null,\"machineType\":\"server\",\"missingPermissions\":[\"user-action-needed-bluetooth-per\",\"user_action_needed_fda\"],\"mitigationMode\":\"detect\",\"mitigationModeSuspicious\":\"detect\",\"modelName\":\"Compute Engine\",\"networkInterfaces\":[{\"gatewayIp\":\"81.2.69.145\",\"gatewayMacAddress\":\"00-00-5E-00-53-00\",\"id\":\"1234567890123456789\",\"inet\":[\"81.2.69.144\"],\"inet6\":[\"2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6\"],\"name\":\"Ethernet\",\"physical\":\"00-00-5E-00-53-00\"}],\"networkQuarantineEnabled\":false,\"networkStatus\":\"connected\",\"operationalState\":\"na\",\"operationalStateExpiration\":null,\"osArch\":\"64 bit\",\"osName\":\"Linux Server\",\"osRevision\":\"1234\",\"osStartTime\":\"2022-04-06T08:27:14Z\",\"osType\":\"linux\",\"osUsername\":null,\"rangerStatus\":\"Enabled\",\"rangerVersion\":\"21.x.x.x\",\"registeredAt\":\"2022-04-06T08:26:45.515278Z\",\"remoteProfilingState\":\"disabled\",\"remoteProfilingStateExpiration\":null,\"scanAbortedAt\":null,\"scanFinishedAt\":\"2022-04-06T09:18:21.090855Z\",\"scanStartedAt\":\"2022-04-06T08:26:52.838047Z\",\"scanStatus\":\"finished\",\"siteId\":\"1234567890123456789\",\"siteName\":\"Default site\",\"storageName\":null,\"storageType\":null,\"tags\":{\"sentinelone\":[{\"assignedAt\":\"2018-02-27T04:49:26.257525Z\",\"assignedBy\":\"test-user\",\"assignedById\":\"123456789012345678\",\"id\":\"123456789012345678\",\"key\":\"key123\",\"value\":\"value123\"}]},\"threatRebootRequired\":false,\"totalMemory\":1234,\"updatedAt\":\"2022-04-07T08:31:47.481227Z\",\"userActionsNeeded\":[\"reboot_needed\"],\"uuid\":\"XXX35XXX8Xfb4aX0X1X8X12X343X8X30\"}",
          "type": [
              "info"
          ]
      },
      "group": {
          "id": "1234567890123456789",
          "name": "Default Group"
      },
      "host": {
          "architecture": "64 bit",
          "domain": "WORKGROUP",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "id": "13491234512345",
          "ip": [
              "81.2.69.143"
          ],
          "mac": [
              "00-00-5E-00-53-00"
          ],
          "name": "user-test",
          "os": {
              "name": "Linux Server",
              "type": "linux",
              "version": "1234"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "version": "12.x.x.x"
      },
      "related": {
          "hosts": [
              "user-test",
              "WORKGROUP"
          ],
          "ip": [
              "81.2.69.143",
              "81.2.69.145",
              "81.2.69.144",
              "2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6"
          ]
      },
      "sentinel_one": {
          "account": {
              "name": "ABC"
          },
          "agent": {
              "account": {
                  "id": "892341123451234512345"
              },
              "active_threats_count": 7,
              "agent": {
                  "id": "13491234512345"
              },
              "allow_remote_shell": true,
              "apps_vulnerability_status": "not_applicable",
              "console_migration_status": "N/A",
              "core": {
                  "count": 2
              },
              "cpu": {
                  "count": 2,
                  "id": "CPU Name"
              },
              "created_at": "2022-03-18T09:12:00.519Z",
              "encrypted_application": false,
              "firewall_enabled": true,
              "group": {
                  "ip": "81.2.69.144"
              },
              "in_remote_shell_session": false,
              "infected": true,
              "installer_type": ".msi",
              "is_active": true,
              "is_decommissioned": false,
              "is_pending_uninstall": false,
              "is_uninstalled": false,
              "is_up_to_date": true,
              "last_active_date": "2022-03-17T09:51:28.506Z",
              "last_ip_to_mgmt": "81.2.69.145",
              "location": {
                  "enabled": true,
                  "type": "not_applicable"
              },
              "machine": {
                  "type": "server"
              },
              "missing_permissions": [
                  "user-action-needed-bluetooth-per",
                  "user_action_needed_fda"
              ],
              "mitigation_mode": "detect",
              "mitigation_mode_suspicious": "detect",
              "model_name": "Compute Engine",
              "network_interfaces": [
                  {
                      "gateway": {
                          "ip": "81.2.69.145",
                          "mac": "00-00-5E-00-53-00"
                      },
                      "id": "1234567890123456789",
                      "inet": [
                          "81.2.69.144"
                      ],
                      "inet6": [
                          "2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6"
                      ],
                      "name": "Ethernet"
                  }
              ],
              "network_quarantine_enabled": false,
              "network_status": "connected",
              "operational_state": "na",
              "os": {
                  "arch": "64 bit",
                  "start_time": "2022-04-06T08:27:14.000Z"
              },
              "ranger": {
                  "status": "Enabled",
                  "version": "21.x.x.x"
              },
              "registered_at": "2022-04-06T08:26:45.515Z",
              "remote_profiling_state": "disabled",
              "scan": {
                  "finished_at": "2022-04-06T09:18:21.090Z",
                  "started_at": "2022-04-06T08:26:52.838Z",
                  "status": "finished"
              },
              "tags": [
                  {
                      "assigned_at": "2018-02-27T04:49:26.257Z",
                      "assigned_by": "test-user",
                      "assigned_by_id": "123456789012345678",
                      "id": "123456789012345678",
                      "key": "key123",
                      "value": "value123"
                  }
              ],
              "threat_reboot_required": false,
              "total_memory": 1234,
              "user_action_needed": [
                  "reboot_needed"
              ],
              "uuid": "XXX35XXX8Xfb4aX0X1X8X12X343X8X30"
          },
          "site": {
              "id": "1234567890123456789",
              "name": "Default site"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-agent"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                            | Description                                                                                                                   | Type             |
  |------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                       | Event timestamp.                                                                                                              | date             |
  | cloud.image.id                                                   | Image ID for the cloud instance.                                                                                              | keyword          |
  | data_stream.dataset                                              | Data stream dataset.                                                                                                          | constant_keyword |
  | data_stream.namespace                                            | Data stream namespace.                                                                                                        | constant_keyword |
  | data_stream.type                                                 | Data stream type.                                                                                                             | constant_keyword |
  | event.dataset                                                    | Event dataset.                                                                                                                | constant_keyword |
  | event.module                                                     | Event module.                                                                                                                 | constant_keyword |
  | host.containerized                                               | If the host is a container.                                                                                                   | boolean          |
  | host.os.build                                                    | OS build information.                                                                                                         | keyword          |
  | host.os.codename                                                 | OS codename, if any.                                                                                                          | keyword          |
  | input.type                                                       | Input type                                                                                                                    | keyword          |
  | log.offset                                                       | Log offset                                                                                                                    | long             |
  | sentinel_one.account.name                                        |                                                                                                                               | keyword          |
  | sentinel_one.agent.account.id                                    | A reference to the containing account.                                                                                        | keyword          |
  | sentinel_one.agent.active_directory.computer.member_of           | Computer member of.                                                                                                           | keyword          |
  | sentinel_one.agent.active_directory.computer.name                | Computer distinguished name.                                                                                                  | keyword          |
  | sentinel_one.agent.active_directory.last_user.distinguished_name | Last user distinguished name.                                                                                                 | keyword          |
  | sentinel_one.agent.active_directory.last_user.member_of          | Last user member of.                                                                                                          | keyword          |
  | sentinel_one.agent.active_directory.mail                         | Mail.                                                                                                                         | keyword          |
  | sentinel_one.agent.active_directory.user.principal_name          | User principal name.                                                                                                          | keyword          |
  | sentinel_one.agent.active_threats_count                          | Current number of active threats.                                                                                             | long             |
  | sentinel_one.agent.agent.id                                      | Related agent (if applicable).                                                                                                | keyword          |
  | sentinel_one.agent.allow_remote_shell                            | Agent is capable and policy enabled for remote shell.                                                                         | boolean          |
  | sentinel_one.agent.apps_vulnerability_status                     | Apps vulnerability status.                                                                                                    | keyword          |
  | sentinel_one.agent.cloud_provider                                | Cloud providers for this agent.                                                                                               | flattened        |
  | sentinel_one.agent.console_migration_status                      | What step the agent is at in the process of migrating to another console, if any.                                             | keyword          |
  | sentinel_one.agent.core.count                                    | CPU cores.                                                                                                                    | long             |
  | sentinel_one.agent.cpu.count                                     | Number of CPUs.                                                                                                               | long             |
  | sentinel_one.agent.cpu.id                                        | CPU model.                                                                                                                    | keyword          |
  | sentinel_one.agent.created_at                                    | Created at.                                                                                                                   | date             |
  | sentinel_one.agent.detection_state                               | Detection State.                                                                                                              | keyword          |
  | sentinel_one.agent.encrypted_application                         | Disk encryption status.                                                                                                       | boolean          |
  | sentinel_one.agent.external.id                                   | External ID set by customer.                                                                                                  | keyword          |
  | sentinel_one.agent.firewall_enabled                              | Firewall enabled.                                                                                                             | boolean          |
  | sentinel_one.agent.first_full_mode_time                          | Date of the first time the Agent moved to full or slim detection modes.                                                       | date             |
  | sentinel_one.agent.group.ip                                      | Group subnet address.                                                                                                         | keyword          |
  | sentinel_one.agent.group.updated_at                              | Group updated at.                                                                                                             | date             |
  | sentinel_one.agent.in_remote_shell_session                       | Is the Agent in a remote shell session.                                                                                       | boolean          |
  | sentinel_one.agent.infected                                      | Indicates if the Agent has active threats.                                                                                    | boolean          |
  | sentinel_one.agent.installer_type                                | Installer package type (file extension).                                                                                      | keyword          |
  | sentinel_one.agent.is_active                                     | Indicates if the agent was recently active.                                                                                   | boolean          |
  | sentinel_one.agent.is_decommissioned                             | Is Agent decommissioned.                                                                                                      | boolean          |
  | sentinel_one.agent.is_pending_uninstall                          | Agent with a pending uninstall request.                                                                                       | boolean          |
  | sentinel_one.agent.is_uninstalled                                | Indicates if Agent was removed from the device.                                                                               | boolean          |
  | sentinel_one.agent.is_up_to_date                                 | Indicates if the agent version is up to date.                                                                                 | boolean          |
  | sentinel_one.agent.last_active_date                              | Last active date.                                                                                                             | date             |
  | sentinel_one.agent.last_ip_to_mgmt                               | The last IP used to connect to the Management console.                                                                        | ip               |
  | sentinel_one.agent.last_logged_in_user_name                      | Last logged in user name.                                                                                                     | keyword          |
  | sentinel_one.agent.license.key                                   | License key.                                                                                                                  | keyword          |
  | sentinel_one.agent.location.enabled                              | Location enabled.                                                                                                             | boolean          |
  | sentinel_one.agent.location.type                                 | Reported location type.                                                                                                       | keyword          |
  | sentinel_one.agent.locations.id                                  | Location ID.                                                                                                                  | keyword          |
  | sentinel_one.agent.locations.name                                | Location name.                                                                                                                | keyword          |
  | sentinel_one.agent.locations.scope                               | Location scope.                                                                                                               | keyword          |
  | sentinel_one.agent.machine.type                                  | Machine type.                                                                                                                 | keyword          |
  | sentinel_one.agent.missing_permissions                           |                                                                                                                               | keyword          |
  | sentinel_one.agent.mitigation_mode                               | Agent mitigation mode policy.                                                                                                 | keyword          |
  | sentinel_one.agent.mitigation_mode_suspicious                    | Mitigation mode policy for suspicious activity.                                                                               | keyword          |
  | sentinel_one.agent.model_name                                    | Device model.                                                                                                                 | keyword          |
  | sentinel_one.agent.network_interfaces.gateway.ip                 | The default gateway ip.                                                                                                       | ip               |
  | sentinel_one.agent.network_interfaces.gateway.mac                | The default gateway mac address.                                                                                              | keyword          |
  | sentinel_one.agent.network_interfaces.id                         | Id.                                                                                                                           | keyword          |
  | sentinel_one.agent.network_interfaces.inet                       | IPv4 addresses.                                                                                                               | ip               |
  | sentinel_one.agent.network_interfaces.inet6                      | IPv6 addresses.                                                                                                               | ip               |
  | sentinel_one.agent.network_interfaces.name                       | Name.                                                                                                                         | keyword          |
  | sentinel_one.agent.network_quarantine_enabled                    | Network quarantine enabled.                                                                                                   | boolean          |
  | sentinel_one.agent.network_status                                | Agent's network connectivity status.                                                                                          | keyword          |
  | sentinel_one.agent.operational_state                             | Agent operational state.                                                                                                      | keyword          |
  | sentinel_one.agent.operational_state_expiration                  | Agent operational state expiration.                                                                                           | keyword          |
  | sentinel_one.agent.os.arch                                       | OS architecture.                                                                                                              | keyword          |
  | sentinel_one.agent.os.start_time                                 | Last boot time.                                                                                                               | date             |
  | sentinel_one.agent.policy.updated_at                             | Policy updated at.                                                                                                            | date             |
  | sentinel_one.agent.ranger.status                                 | Is Agent disabled as a Ranger.                                                                                                | keyword          |
  | sentinel_one.agent.ranger.version                                | The version of Ranger.                                                                                                        | keyword          |
  | sentinel_one.agent.registered_at                                 | Time of first registration to management console (similar to createdAt).                                                      | date             |
  | sentinel_one.agent.remote_profiling_state                        | Agent remote profiling state.                                                                                                 | keyword          |
  | sentinel_one.agent.remote_profiling_state_expiration             | Agent remote profiling state expiration in seconds.                                                                           | keyword          |
  | sentinel_one.agent.scan.aborted_at                               | Abort time of last scan (if applicable).                                                                                      | date             |
  | sentinel_one.agent.scan.finished_at                              | Finish time of last scan (if applicable).                                                                                     | date             |
  | sentinel_one.agent.scan.started_at                               | Start time of last scan.                                                                                                      | date             |
  | sentinel_one.agent.scan.status                                   | Last scan status.                                                                                                             | keyword          |
  | sentinel_one.agent.storage.name                                  | Storage name.                                                                                                                 | keyword          |
  | sentinel_one.agent.storage.type                                  | Storage type.                                                                                                                 | keyword          |
  | sentinel_one.agent.tags.assigned_at                              | When tag assigned to the agent.                                                                                               | date             |
  | sentinel_one.agent.tags.assigned_by                              | full user name who assigned the tag to the agent.                                                                             | keyword          |
  | sentinel_one.agent.tags.assigned_by_id                           | User ID who assigned the tag to the agent.                                                                                    | keyword          |
  | sentinel_one.agent.tags.id                                       | Tag ID.                                                                                                                       | keyword          |
  | sentinel_one.agent.tags.key                                      | Tag key.                                                                                                                      | keyword          |
  | sentinel_one.agent.tags.value                                    | Tag value.                                                                                                                    | keyword          |
  | sentinel_one.agent.threat_reboot_required                        | Flag representing if the Agent has at least one threat with at least one mitigation action that is pending reboot to succeed. | boolean          |
  | sentinel_one.agent.total_memory                                  | Memory size (MB).                                                                                                             | long             |
  | sentinel_one.agent.user_action_needed                            | A list of pending user actions.                                                                                               | keyword          |
  | sentinel_one.agent.uuid                                          | Agent's universally unique identifier.                                                                                        | keyword          |
  | sentinel_one.site.id                                             |                                                                                                                               | keyword          |
  | sentinel_one.site.name                                           |                                                                                                                               | keyword          |
</dropdown>


### alert

This is the `alert` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2018-02-27T04:49:26.257Z",
      "agent": {
          "ephemeral_id": "38d6bc5f-ee5a-4d20-9152-5a802c430eeb",
          "id": "9f44ff99-cec0-4435-b939-8f2066427cc8",
          "name": "elastic-agent-81341",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "container": {
          "id": "string",
          "image": {
              "name": "string"
          },
          "name": "string"
      },
      "data_stream": {
          "dataset": "sentinel_one.alert",
          "namespace": "52488",
          "type": "logs"
      },
      "destination": {
          "ip": "81.2.69.144",
          "port": 1234
      },
      "dll": {
          "hash": {
              "sha1": "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d"
          },
          "path": "string"
      },
      "dns": {
          "question": {
              "name": "string"
          }
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "9f44ff99-cec0-4435-b939-8f2066427cc8",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2025-11-19T10:37:39.901Z",
          "dataset": "sentinel_one.alert",
          "id": "888456789123456789",
          "ingested": "2025-11-19T10:37:42Z",
          "kind": "event",
          "original": "{\"agentDetectionInfo\":{\"machineType\":\"string\",\"name\":\"string\",\"osFamily\":\"string\",\"osName\":\"string\",\"osRevision\":\"string\",\"siteId\":\"123456789123456789\",\"uuid\":\"string\",\"version\":\"3.x.x.x\"},\"alertInfo\":{\"alertId\":\"888456789123456789\",\"analystVerdict\":\"string\",\"createdAt\":\"2018-02-27T04:49:26.257525Z\",\"dnsRequest\":\"string\",\"dnsResponse\":\"string\",\"dstIp\":\"81.2.69.144\",\"dstPort\":\"1234\",\"dvEventId\":\"string\",\"eventType\":\"info\",\"hitType\":\"Events\",\"incidentStatus\":\"open\",\"indicatorCategory\":\"string\",\"indicatorDescription\":\"string\",\"indicatorName\":\"string\",\"loginAccountDomain\":\"string\",\"loginAccountSid\":\"string\",\"loginIsAdministratorEquivalent\":\"string\",\"loginIsSuccessful\":\"string\",\"loginType\":\"login\",\"loginsUserName\":\"string\",\"modulePath\":\"string\",\"moduleSha1\":\"aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\",\"netEventDirection\":\"string\",\"registryKeyPath\":\"string\",\"registryOldValue\":\"string\",\"registryOldValueType\":\"string\",\"registryPath\":\"string\",\"registryValue\":\"string\",\"reportedAt\":\"2018-02-27T04:49:26.257525Z\",\"source\":\"string\",\"srcIp\":\"81.2.69.142\",\"srcMachineIp\":\"81.2.69.142\",\"srcPort\":\"1234\",\"tiIndicatorComparisonMethod\":\"string\",\"tiIndicatorSource\":\"string\",\"tiIndicatorType\":\"string\",\"tiIndicatorValue\":\"string\",\"updatedAt\":\"2018-02-27T04:49:26.257525Z\"},\"containerInfo\":{\"id\":\"string\",\"image\":\"string\",\"labels\":\"string\",\"name\":\"string\"},\"kubernetesInfo\":{\"cluster\":\"string\",\"controllerKind\":\"string\",\"controllerLabels\":\"string\",\"controllerName\":\"string\",\"namespace\":\"string\",\"namespaceLabels\":\"string\",\"node\":\"string\",\"pod\":\"string\",\"podLabels\":\"string\"},\"ruleInfo\":{\"description\":\"string\",\"id\":\"string\",\"name\":\"string\",\"scopeLevel\":\"string\",\"severity\":\"Low\",\"treatAsThreat\":\"UNDEFINED\"},\"sourceParentProcessInfo\":{\"commandline\":\"string\",\"fileHashMd5\":\"5d41402abc4b2a76b9719d911017c592\",\"fileHashSha1\":\"aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\",\"fileHashSha256\":\"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\",\"filePath\":\"string\",\"fileSignerIdentity\":\"string\",\"integrityLevel\":\"unknown\",\"name\":\"string\",\"pid\":\"12345\",\"pidStarttime\":\"2018-02-27T04:49:26.257525Z\",\"storyline\":\"string\",\"subsystem\":\"unknown\",\"uniqueId\":\"string\",\"user\":\"string\"},\"sourceProcessInfo\":{\"commandline\":\"string\",\"fileHashMd5\":\"5d41402abc4b2a76b9719d911017c592\",\"fileHashSha1\":\"aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\",\"fileHashSha256\":\"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\",\"filePath\":\"string\",\"fileSignerIdentity\":\"string\",\"integrityLevel\":\"unknown\",\"name\":\"string\",\"pid\":\"12345\",\"pidStarttime\":\"2018-02-27T04:49:26.257525Z\",\"storyline\":\"string\",\"subsystem\":\"unknown\",\"uniqueId\":\"string\",\"user\":\"string\"},\"targetProcessInfo\":{\"tgtFileCreatedAt\":\"2018-02-27T04:49:26.257525Z\",\"tgtFileHashSha1\":\"aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\",\"tgtFileHashSha256\":\"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824\",\"tgtFileId\":\"string\",\"tgtFileIsSigned\":\"string\",\"tgtFileModifiedAt\":\"2018-02-27T04:49:26.257525Z\",\"tgtFileOldPath\":\"string\",\"tgtFilePath\":\"string\",\"tgtProcCmdLine\":\"string\",\"tgtProcImagePath\":\"string\",\"tgtProcIntegrityLevel\":\"unknown\",\"tgtProcName\":\"string\",\"tgtProcPid\":\"12345\",\"tgtProcSignedStatus\":\"string\",\"tgtProcStorylineId\":\"string\",\"tgtProcUid\":\"string\",\"tgtProcessStartTime\":\"2018-02-27T04:49:26.257525Z\"}}",
          "severity": 21,
          "type": [
              "info"
          ]
      },
      "file": {
          "created": "2018-02-27T04:49:26.257Z",
          "mtime": "2018-02-27T04:49:26.257Z",
          "path": "string"
      },
      "host": {
          "ip": [
              "81.2.69.142"
          ],
          "name": "string",
          "os": {
              "family": "string",
              "name": "string",
              "version": "string"
          },
          "type": "string"
      },
      "input": {
          "type": "httpjson"
      },
      "message": "string",
      "observer": {
          "serial_number": "string",
          "version": "3.x.x.x"
      },
      "orchestrator": {
          "cluster": {
              "name": "string"
          },
          "namespace": "string"
      },
      "process": {
          "code_signature": {
              "signing_id": "string"
          },
          "command_line": "string",
          "entity_id": "string",
          "executable": "string",
          "hash": {
              "md5": "5d41402abc4b2a76b9719d911017c592",
              "sha1": "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d",
              "sha256": "2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"
          },
          "name": "string",
          "parent": {
              "code_signature": {
                  "signing_id": "string"
              },
              "command_line": "string",
              "entity_id": "string",
              "executable": "string",
              "hash": {
                  "md5": "5d41402abc4b2a76b9719d911017c592",
                  "sha1": "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d",
                  "sha256": "2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"
              },
              "name": "string",
              "pid": 12345,
              "start": "2018-02-27T04:49:26.257Z",
              "user": {
                  "name": "string"
              }
          },
          "pid": 12345,
          "start": "2018-02-27T04:49:26.257Z",
          "user": {
              "name": "string"
          }
      },
      "registry": {
          "key": "string",
          "path": "string",
          "value": "string"
      },
      "related": {
          "hash": [
              "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d",
              "5d41402abc4b2a76b9719d911017c592",
              "2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"
          ],
          "hosts": [
              "string"
          ],
          "ip": [
              "81.2.69.142",
              "81.2.69.144"
          ],
          "user": [
              "string"
          ]
      },
      "rule": {
          "description": "string",
          "id": "string",
          "name": "string"
      },
      "sentinel_one": {
          "alert": {
              "analyst_verdict": "string",
              "container": {
                  "info": {
                      "labels": "string"
                  }
              },
              "dv_event": {
                  "id": "string"
              },
              "info": {
                  "dns": {
                      "response": "string"
                  },
                  "event_type": "info",
                  "hit": {
                      "type": "Events"
                  },
                  "indicator": {
                      "category": "string",
                      "description": "string",
                      "name": "string"
                  },
                  "login": {
                      "account": {
                          "sid": "string"
                      },
                      "is_administrator": "string",
                      "is_successful": "string",
                      "type": "login"
                  },
                  "registry": {
                      "old_value": "string",
                      "old_value_type": "string"
                  },
                  "reported_at": "2018-02-27T04:49:26.257Z",
                  "source": "string",
                  "status": "open",
                  "ti_indicator": {
                      "comparison_method": "string",
                      "source": "string",
                      "type": "string",
                      "value": "string"
                  },
                  "updated_at": "2018-02-27T04:49:26.257Z"
              },
              "kubernetes": {
                  "controller": {
                      "kind": "string",
                      "labels": "string",
                      "name": "string"
                  },
                  "namespace": {
                      "labels": "string"
                  },
                  "node": "string",
                  "pod": {
                      "labels": "string",
                      "name": "string"
                  }
              },
              "process": {
                  "integrity_level": "unknown",
                  "parent": {
                      "integrity_level": "unknown",
                      "storyline": "string",
                      "subsystem": "unknown"
                  },
                  "storyline": "string",
                  "subsystem": "unknown"
              },
              "rule": {
                  "scope_level": "string",
                  "severity": "Low",
                  "treat_as_threat": "UNDEFINED"
              },
              "target": {
                  "process": {
                      "file": {
                          "hash": {
                              "sha1": "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d",
                              "sha256": "2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"
                          },
                          "id": "string",
                          "is_signed": "string",
                          "old_path": "string",
                          "path": "string"
                      },
                      "proc": {
                          "cmdline": "string",
                          "image_path": "string",
                          "integrity_level": "unknown",
                          "name": "string",
                          "pid": 12345,
                          "signed_status": "string",
                          "storyline_id": "string",
                          "uid": "string"
                      },
                      "start_time": "2018-02-27T04:49:26.257Z"
                  }
              }
          },
          "site": {
              "id": "123456789123456789"
          }
      },
      "source": {
          "ip": "81.2.69.142",
          "port": 1234
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-alert"
      ],
      "user": {
          "domain": "string",
          "name": "string"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                  | Description                                                     | Type             |
  |--------------------------------------------------------|-----------------------------------------------------------------|------------------|
  | @timestamp                                             | Event timestamp.                                                | date             |
  | cloud.image.id                                         | Image ID for the cloud instance.                                | keyword          |
  | data_stream.dataset                                    | Data stream dataset.                                            | constant_keyword |
  | data_stream.namespace                                  | Data stream namespace.                                          | constant_keyword |
  | data_stream.type                                       | Data stream type.                                               | constant_keyword |
  | event.dataset                                          | Event dataset.                                                  | constant_keyword |
  | event.module                                           | Event module.                                                   | constant_keyword |
  | host.containerized                                     | If the host is a container.                                     | boolean          |
  | host.os.build                                          | OS build information.                                           | keyword          |
  | host.os.codename                                       | OS codename, if any.                                            | keyword          |
  | input.type                                             | Input type                                                      | keyword          |
  | log.offset                                             | Log offset                                                      | long             |
  | log.source.address                                     | Source address from which the log event was read / sent from.   | keyword          |
  | sentinel_one.alert.agent.computer_name                 | Computer distinguished name.                                    | keyword          |
  | sentinel_one.alert.agent.id                            | Agent ID.                                                       | keyword          |
  | sentinel_one.alert.agent.infected                      | Agent infected.                                                 | boolean          |
  | sentinel_one.alert.agent.is_active                     | Is active.                                                      | boolean          |
  | sentinel_one.alert.agent.is_decommissioned             | Is decommissioned.                                              | boolean          |
  | sentinel_one.alert.agent.machine_type                  | Machine type.                                                   | keyword          |
  | sentinel_one.alert.agent.os.type                       | OS type.                                                        | keyword          |
  | sentinel_one.alert.analyst_verdict                     | Analyst verdict.                                                | keyword          |
  | sentinel_one.alert.container.info.labels               | Container info labels.                                          | keyword          |
  | sentinel_one.alert.dv_event.id                         | DV event id.                                                    | keyword          |
  | sentinel_one.alert.info.dns.response                   | IP address, DNS, type, etc. in response.                        | keyword          |
  | sentinel_one.alert.info.event_type                     | Event type.                                                     | keyword          |
  | sentinel_one.alert.info.hit.type                       | Type of hit reported from agent.                                | keyword          |
  | sentinel_one.alert.info.indicator.category             | Indicator categories for this process.                          | keyword          |
  | sentinel_one.alert.info.indicator.description          | Indicator_description.                                          | keyword          |
  | sentinel_one.alert.info.indicator.name                 | Indicator names for this process.                               | keyword          |
  | sentinel_one.alert.info.login.account.sid              | SID of the account that attempted to login.                     | keyword          |
  | sentinel_one.alert.info.login.is_administrator         | Is the login attempt administrator equivalent.                  | keyword          |
  | sentinel_one.alert.info.login.is_successful            | Was the login attempt successful.                               | keyword          |
  | sentinel_one.alert.info.login.type                     | Type of login which was performed.                              | keyword          |
  | sentinel_one.alert.info.registry.old_value             | Registry previous value (in case of modification).              | keyword          |
  | sentinel_one.alert.info.registry.old_value_type        | Registry previous value type (in case of modification).         | keyword          |
  | sentinel_one.alert.info.reported_at                    | Timestamp of alert creation in STAR.                            | date             |
  | sentinel_one.alert.info.source                         | Source reported from agent.                                     | keyword          |
  | sentinel_one.alert.info.status                         | Incident status.                                                | keyword          |
  | sentinel_one.alert.info.ti_indicator.comparison_method | The comparison method used by SentinelOne to trigger the event. | keyword          |
  | sentinel_one.alert.info.ti_indicator.source            | The value of the identified Threat Intelligence indicator.      | keyword          |
  | sentinel_one.alert.info.ti_indicator.type              | The type of the identified Threat Intelligence indicator.       | keyword          |
  | sentinel_one.alert.info.ti_indicator.value             | The value of the identified Threat Intelligence indicator.      | keyword          |
  | sentinel_one.alert.info.updated_at                     | Date of alert updated in Star MMS.                              | date             |
  | sentinel_one.alert.kubernetes.controller.kind          | Controller kind.                                                | keyword          |
  | sentinel_one.alert.kubernetes.controller.labels        | Controller labels.                                              | keyword          |
  | sentinel_one.alert.kubernetes.controller.name          | Controller name.                                                | keyword          |
  | sentinel_one.alert.kubernetes.namespace.labels         | Namespace labels.                                               | keyword          |
  | sentinel_one.alert.kubernetes.node                     | Node.                                                           | keyword          |
  | sentinel_one.alert.kubernetes.pod.labels               | Pod Labels.                                                     | keyword          |
  | sentinel_one.alert.kubernetes.pod.name                 | Pod name.                                                       | keyword          |
  | sentinel_one.alert.process.integrity_level             | Integrity level.                                                | keyword          |
  | sentinel_one.alert.process.parent.integrity_level      | Integrity level.                                                | keyword          |
  | sentinel_one.alert.process.parent.storyline            | StoryLine.                                                      | keyword          |
  | sentinel_one.alert.process.parent.subsystem            | Subsystem.                                                      | keyword          |
  | sentinel_one.alert.process.storyline                   | StoryLine.                                                      | keyword          |
  | sentinel_one.alert.process.subsystem                   | Subsystem.                                                      | keyword          |
  | sentinel_one.alert.rule.scope_level                    | Scope level.                                                    | keyword          |
  | sentinel_one.alert.rule.severity                       | Rule severity.                                                  | keyword          |
  | sentinel_one.alert.rule.treat_as_threat                | Rule treat as threat type.                                      | keyword          |
  | sentinel_one.alert.target.process.file.hash.sha1       | SHA1 Signature of File.                                         | keyword          |
  | sentinel_one.alert.target.process.file.hash.sha256     | SHA256 Signature of File.                                       | keyword          |
  | sentinel_one.alert.target.process.file.id              | Unique ID of file.                                              | keyword          |
  | sentinel_one.alert.target.process.file.is_signed       | Is fle signed.                                                  | keyword          |
  | sentinel_one.alert.target.process.file.old_path        | Old path before 'Rename'.                                       | keyword          |
  | sentinel_one.alert.target.process.file.path            | Path and filename.                                              | keyword          |
  | sentinel_one.alert.target.process.proc.cmdline         | Target Process Command Line.                                    | keyword          |
  | sentinel_one.alert.target.process.proc.image_path      | Target Process Image path                                       | keyword          |
  | sentinel_one.alert.target.process.proc.integrity_level | Integrity level of target process.                              | keyword          |
  | sentinel_one.alert.target.process.proc.name            | Target Process Name.                                            | keyword          |
  | sentinel_one.alert.target.process.proc.pid             | Target Process ID (PID).                                        | long             |
  | sentinel_one.alert.target.process.proc.signed_status   | Target Process Signed Status.                                   | keyword          |
  | sentinel_one.alert.target.process.proc.storyline_id    | Target Process StoryLine ID.                                    | keyword          |
  | sentinel_one.alert.target.process.proc.uid             | Target Process Unique ID.                                       | keyword          |
  | sentinel_one.alert.target.process.start_time           | Target Process Start Time.                                      | date             |
  | sentinel_one.site.id                                   |                                                                 | keyword          |
</dropdown>


### application

This is the `application` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-11-19T10:38:39.090Z",
      "agent": {
          "ephemeral_id": "800ab008-1e5a-4db6-8e31-cc61875da3d4",
          "id": "0d101c1b-0608-4563-bccd-9de1928b614f",
          "name": "elastic-agent-14879",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.application",
          "namespace": "83873",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "0d101c1b-0608-4563-bccd-9de1928b614f",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "package"
          ],
          "dataset": "sentinel_one.application",
          "id": "2218357748550497214",
          "ingested": "2025-11-19T10:38:42Z",
          "kind": "event",
          "original": "{\"accountName\":\"7-Zip\",\"applicationInstallationDate\":\"2025-04-13T10:45:01Z\",\"applicationInstallationPath\":null,\"applicationName\":\"Igor Pavlov\",\"coreCount\":2,\"cpe\":\"cpe:2.3:a:abc:igor:8.17.3:*:*:*:*:*:*:*\",\"cpuCount\":1,\"detectionDate\":\"2025-06-19T18:00:51.166610Z\",\"endpointId\":\"216970508828266268\",\"endpointName\":\"srv-win-defend-03\",\"endpointType\":\"server\",\"endpointUuid\":\"eb655be8be894dae97711ebb9a9091ae\",\"fileSize\":517364,\"groupName\":\"Default Group\",\"id\":\"2218357748550497214\",\"osArch\":\"64 bit\",\"osName\":\"Windows Server 2022 Datacenter\",\"osType\":\"windows\",\"osVersion\":\"Windows Server 2022 Datacenter 20348\",\"siteName\":\"Default site\",\"version\":\"8.17.3\"}",
          "type": [
              "info"
          ]
      },
      "group": {
          "name": "Default Group"
      },
      "host": {
          "architecture": "64 bit",
          "id": "216970508828266268",
          "name": "srv-win-defend-03",
          "os": {
              "full": "Windows Server 2022 Datacenter 20348",
              "name": "Windows Server 2022 Datacenter",
              "type": "windows"
          },
          "type": "server"
      },
      "input": {
          "type": "cel"
      },
      "package": {
          "installed": "2025-04-13T10:45:01.000Z",
          "name": "Igor Pavlov",
          "size": 517364,
          "version": "8.17.3"
      },
      "related": {
          "hosts": [
              "srv-win-defend-03"
          ]
      },
      "sentinel_one": {
          "account": {
              "name": "7-Zip"
          },
          "application": {
              "application_installation_date": "2025-04-13T10:45:01.000Z",
              "application_name": "Igor Pavlov",
              "core_count": 2,
              "cpe": "cpe:2.3:a:abc:igor:8.17.3:*:*:*:*:*:*:*",
              "cpu_count": 1,
              "detection_date": "2025-06-19T18:00:51.166Z",
              "endpoint_id": "216970508828266268",
              "endpoint_name": "srv-win-defend-03",
              "endpoint_type": "server",
              "endpoint_uuid": "eb655be8be894dae97711ebb9a9091ae",
              "file_size": 517364,
              "group_name": "Default Group",
              "id": "2218357748550497214",
              "os_arch": "64 bit",
              "os_name": "Windows Server 2022 Datacenter",
              "os_type": "windows",
              "os_version": "Windows Server 2022 Datacenter 20348",
              "version": "8.17.3"
          },
          "site": {
              "name": "Default site"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "sentinel_one-application"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |--------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                                    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                          | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                           | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                                             | Type of filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                                             | Log offset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | sentinel_one.account.name                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.application_installation_date |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.application.application_installation_path |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.application_name              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.application_vendor            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.application_versions_count    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.application.core_count                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.application.cpe                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.cpu_count                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.application.detection_date                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.application.endpoint_id                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.endpoint_name                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.endpoint_type                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.endpoint_uuid                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.endpoints_count               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.application.estimate                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.application.file_size                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.application.group_name                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.id                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.os_arch                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.os_name                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.os_type                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.os_version                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application.version                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.site.name                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


### application risk

This is the `application risk` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-29T19:25:47.000Z",
      "agent": {
          "ephemeral_id": "519ebcce-3d96-4c5b-a880-3f18b50a195a",
          "id": "887e0ce4-9b7b-40e6-ac11-b62380aa2767",
          "name": "elastic-agent-11705",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.application_risk",
          "namespace": "55690",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "887e0ce4-9b7b-40e6-ac11-b62380aa2767",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "created": "2025-06-02T04:46:51.710Z",
          "dataset": "sentinel_one.application_risk",
          "id": "2228104980801805822",
          "ingested": "2025-11-19T10:39:33Z",
          "kind": "state",
          "original": "{\"application\":\"7-Zip 22.01\",\"applicationName\":\"7-Zip\",\"applicationVendor\":\"Igor Pavlov\",\"applicationVersion\":\"22.01\",\"baseScore\":\"7.00\",\"cveId\":\"CVE-2025-0411\",\"cvssVersion\":\"3.1\",\"daysDetected\":59,\"detectionDate\":\"2025-06-02T04:46:51.710569Z\",\"endpointId\":\"2162143406517023959\",\"endpointName\":\"test_endpoint\",\"endpointType\":\"desktop\",\"id\":\"2228104980801805822\",\"lastScanDate\":\"2025-07-29T19:25:47Z\",\"lastScanResult\":\"Succeeded\",\"markType\":\"\",\"markedBy\":null,\"markedDate\":null,\"osType\":\"windows\",\"publishedDate\":\"2025-01-20T07:04:04Z\",\"reason\":null,\"severity\":\"HIGH\",\"status\":\"Detected\"}",
          "outcome": "success",
          "severity": 73,
          "type": [
              "info"
          ]
      },
      "host": {
          "id": "2162143406517023959",
          "os": {
              "type": "windows"
          },
          "type": "desktop"
      },
      "input": {
          "type": "cel"
      },
      "package": {
          "name": "7-Zip",
          "version": "22.01"
      },
      "resource": {
          "id": "2162143406517023959",
          "name": "test_endpoint"
      },
      "sentinel_one": {
          "application_risk": {
              "application": "7-Zip 22.01",
              "application_vendor": "Igor Pavlov",
              "days_detected": 59,
              "detection_date": "2025-06-02T04:46:51.710Z",
              "last_scan_date": "2025-07-29T19:25:47.000Z",
              "last_scan_result": "Succeeded",
              "severity": "HIGH",
              "status": "Detected"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-application_risk"
      ],
      "vulnerability": {
          "cve": "CVE-2025-0411",
          "id": "CVE-2025-0411",
          "package": {
              "published_date": "2025-01-20T07:04:04.000Z"
          },
          "score": {
              "base": 7,
              "version": "3.1"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                                         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                               | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                                                  | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | labels.is_transform_source                                  | Distinguishes between documents that are a source for a transform and documents that are an output of a transform, to facilitate easier filtering.                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | log.offset                                                  | Log offset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | observer.vendor                                             | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | resource.id                                                 | The ID of the vulnerable resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | resource.name                                               | The name of the vulnerable resource.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | sentinel_one.application_risk.application                   | Composed application name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.application_risk.application_name              | Application name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.application_risk.application_vendor            | Application vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | sentinel_one.application_risk.application_version           | Application version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | sentinel_one.application_risk.base_score                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | float            |
  | sentinel_one.application_risk.cve_id                        | CVE Id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.application_risk.cvss_version                  | Cvss version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.application_risk.days_detected                 | Days detected.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | sentinel_one.application_risk.detection_date                | Detection date.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.application_risk.endpoint_id                   | Endpoint id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.application_risk.endpoint_name                 | Endpoint name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.application_risk.endpoint_type                 | Endpoint type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.application_risk.exploit_code_maturity         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application_risk.id                            | Id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | sentinel_one.application_risk.last_scan_date                | Last scan date.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.application_risk.last_scan_result              | Last scan result.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.application_risk.mark_type                     | Mark type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.application_risk.marked_by                     | Marked by.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.application_risk.marked_date                   | Marked date.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | date             |
  | sentinel_one.application_risk.mitigation_status             | Risk mitigation status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.application_risk.mitigation_status_change_time | Mitigation status change time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | date             |
  | sentinel_one.application_risk.mitigation_status_changed_by  | Mitigation status changer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.application_risk.mitigation_status_reason      | Mitigation status reason.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.application_risk.nvd_base_score                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | sentinel_one.application_risk.nvd_cvss_version              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application_risk.os_type                       | OS type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | sentinel_one.application_risk.published_date                | Published date.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.application_risk.reason                        | Reason.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.application_risk.remediation_level             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application_risk.report_confidence             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.application_risk.risk_score                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | sentinel_one.application_risk.severity                      | Severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.application_risk.status                        | Risk status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | vulnerability.cve                                           | The CVE id of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | vulnerability.package.published_date                        | When the vulnerability was published.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
</dropdown>


### group

This is the `group` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-04-05T16:01:57.564Z",
      "agent": {
          "ephemeral_id": "da92d416-3f7d-47f5-8a18-c844c45a204a",
          "id": "8f8db98d-a5de-4e44-9028-92faf7cdb865",
          "name": "elastic-agent-24227",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.group",
          "namespace": "64327",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8f8db98d-a5de-4e44-9028-92faf7cdb865",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "iam"
          ],
          "created": "2025-11-19T10:40:29.178Z",
          "dataset": "sentinel_one.group",
          "ingested": "2025-11-19T10:40:32Z",
          "kind": "event",
          "original": "{\"createdAt\":\"2022-04-05T16:01:56.928383Z\",\"creator\":\"Test User\",\"creatorId\":\"1234567890123456789\",\"filterId\":null,\"filterName\":null,\"id\":\"1234567890123456789\",\"inherits\":true,\"isDefault\":true,\"name\":\"Default Group\",\"rank\":null,\"registrationToken\":\"eyxxxxxxxxxxxxxxxxxxxxkixZxx1xxxxx8xxx2xODA0ZxxxxTIwNjhxxxxxxxxxxxxxxiMWYxx1Ixxnxxxx0=\",\"siteId\":\"1234567890123456789\",\"totalAgents\":1,\"type\":\"static\",\"updatedAt\":\"2022-04-05T16:01:57.564266Z\"}",
          "type": [
              "info"
          ]
      },
      "group": {
          "id": "1234567890123456789",
          "name": "Default Group"
      },
      "input": {
          "type": "httpjson"
      },
      "related": {
          "user": [
              "Test User"
          ]
      },
      "sentinel_one": {
          "group": {
              "agent": {
                  "count": 1
              },
              "created_at": "2022-04-05T16:01:56.928Z",
              "creator": {
                  "id": "1234567890123456789"
              },
              "inherits": true,
              "is_default": true,
              "registration_token": "eyxxxxxxxxxxxxxxxxxxxxkixZxx1xxxxx8xxx2xODA0ZxxxxTIwNjhxxxxxxxxxxxxxxiMWYxx1Ixxnxxxx0=",
              "type": "static"
          },
          "site": {
              "id": "1234567890123456789"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-group"
      ],
      "user": {
          "full_name": "Test User"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                 | Description                                                   | Type             |
  |---------------------------------------|---------------------------------------------------------------|------------------|
  | @timestamp                            | Event timestamp.                                              | date             |
  | cloud.image.id                        | Image ID for the cloud instance.                              | keyword          |
  | data_stream.dataset                   | Data stream dataset.                                          | constant_keyword |
  | data_stream.namespace                 | Data stream namespace.                                        | constant_keyword |
  | data_stream.type                      | Data stream type.                                             | constant_keyword |
  | event.dataset                         | Event dataset.                                                | constant_keyword |
  | event.module                          | Event module.                                                 | constant_keyword |
  | host.containerized                    | If the host is a container.                                   | boolean          |
  | host.os.build                         | OS build information.                                         | keyword          |
  | host.os.codename                      | OS codename, if any.                                          | keyword          |
  | input.type                            | Input type                                                    | keyword          |
  | log.offset                            | Log offset                                                    | long             |
  | log.source.address                    | Source address from which the log event was read / sent from. | keyword          |
  | sentinel_one.group.agent.count        |                                                               | long             |
  | sentinel_one.group.created_at         |                                                               | date             |
  | sentinel_one.group.creator.id         |                                                               | keyword          |
  | sentinel_one.group.filter.id          |                                                               | keyword          |
  | sentinel_one.group.filter.name        |                                                               | keyword          |
  | sentinel_one.group.inherits           |                                                               | boolean          |
  | sentinel_one.group.is_default         |                                                               | boolean          |
  | sentinel_one.group.rank               |                                                               | long             |
  | sentinel_one.group.registration_token |                                                               | keyword          |
  | sentinel_one.group.type               |                                                               | keyword          |
  | sentinel_one.site.id                  |                                                               | keyword          |
</dropdown>


### threat

This is the `threat` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-04-06T08:54:17.194Z",
      "agent": {
          "ephemeral_id": "402c85c2-f3e1-4ef9-97eb-86f207d4ec64",
          "id": "9520e44c-407c-4082-a5c6-6dbaea7f4264",
          "name": "elastic-agent-36635",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.threat",
          "namespace": "55649",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "9520e44c-407c-4082-a5c6-6dbaea7f4264",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "action": "SentinelOne Cloud",
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2025-11-19T10:41:22.249Z",
          "dataset": "sentinel_one.threat",
          "id": "1234567890123456789",
          "ingested": "2025-11-19T10:41:23Z",
          "kind": "alert",
          "original": "{\"agentDetectionInfo\":{\"accountId\":\"111245567890123456789\",\"accountName\":\"Default2\",\"agentDetectionState\":null,\"agentDomain\":\"WORKGROUP\",\"agentIpV4\":\"127.0.0.1\",\"agentIpV6\":\"2a02:cf40::\",\"agentLastLoggedInUpn\":null,\"agentLastLoggedInUserMail\":null,\"agentLastLoggedInUserName\":\"\",\"agentMitigationMode\":\"protect\",\"agentOsName\":\"linux\",\"agentOsRevision\":\"1234\",\"agentRegisteredAt\":\"2022-04-08T08:26:45.515278Z\",\"agentUuid\":\"fwfbxxxxxxxxxxqcfjfnxxxxxxxxx\",\"agentVersion\":\"21.x.x\",\"cloudProviders\":{},\"externalIp\":\"81.2.69.143\",\"groupId\":\"1444567890123456789\",\"groupName\":\"Default Group\",\"siteId\":\"1234567890123456789\",\"siteName\":\"Default site\"},\"agentRealtimeInfo\":{\"accountId\":\"1456567890123456789\",\"accountName\":\"Default2\",\"activeThreats\":8,\"agentComputerName\":\"test-LINUX\",\"agentDecommissionedAt\":null,\"agentDomain\":\"WORKGROUP\",\"agentId\":\"1234567890123456789\",\"agentInfected\":true,\"agentIsActive\":true,\"agentIsDecommissioned\":false,\"agentMachineType\":\"server\",\"agentMitigationMode\":\"detect\",\"agentNetworkStatus\":\"connected\",\"agentOsName\":\"linux\",\"agentOsRevision\":\"1234\",\"agentOsType\":\"linux\",\"agentUuid\":\"fwfbxxxxxxxxxxqcfjfnxxxxxxxxx\",\"agentVersion\":\"21.x.x.1234\",\"groupId\":\"1234567890123456789\",\"groupName\":\"Default Group\",\"networkInterfaces\":[{\"id\":\"1234567890123456789\",\"inet\":[\"10.0.0.1\"],\"inet6\":[\"2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6\"],\"name\":\"Ethernet\",\"physical\":\"DE:AD:00:00:BE:EF\"}],\"operationalState\":\"na\",\"rebootRequired\":false,\"scanAbortedAt\":null,\"scanFinishedAt\":\"2022-04-09T09:18:21.090855Z\",\"scanStartedAt\":\"2022-04-09T08:26:52.838047Z\",\"scanStatus\":\"finished\",\"siteId\":\"1234567890123456789\",\"siteName\":\"Default site\",\"storageName\":null,\"storageType\":null,\"userActionsNeeded\":[]},\"containerInfo\":{\"id\":null,\"image\":null,\"labels\":null,\"name\":null},\"id\":\"1234567890123456789\",\"indicators\":[],\"kubernetesInfo\":{\"cluster\":null,\"controllerKind\":null,\"controllerLabels\":null,\"controllerName\":null,\"namespace\":null,\"namespaceLabels\":null,\"node\":null,\"pod\":null,\"podLabels\":null},\"mitigationStatus\":[{\"action\":\"unquarantine\",\"actionsCounters\":{\"failed\":0,\"notFound\":0,\"pendingReboot\":0,\"success\":1,\"total\":1},\"agentSupportsReport\":true,\"groupNotFound\":false,\"lastUpdate\":\"2022-04-06T08:54:17.198002Z\",\"latestReport\":\"/threats/mitigation-report\",\"mitigationEndedAt\":\"2022-04-06T08:54:17.101000Z\",\"mitigationStartedAt\":\"2022-04-06T08:54:17.101000Z\",\"status\":\"success\"},{\"action\":\"kill\",\"actionsCounters\":null,\"agentSupportsReport\":true,\"groupNotFound\":false,\"lastUpdate\":\"2022-04-06T08:45:55.303355Z\",\"latestReport\":null,\"mitigationEndedAt\":\"2022-04-06T08:45:55.297364Z\",\"mitigationStartedAt\":\"2022-04-06T08:45:55.297363Z\",\"status\":\"success\"}],\"threatInfo\":{\"analystVerdict\":\"undefined\",\"analystVerdictDescription\":\"Undefined\",\"automaticallyResolved\":false,\"browserType\":null,\"certificateId\":\"\",\"classification\":\"Trojan\",\"classificationSource\":\"Cloud\",\"cloudFilesHashVerdict\":\"black\",\"collectionId\":\"1234567890123456789\",\"confidenceLevel\":\"malicious\",\"createdAt\":\"2022-04-06T08:45:54.519988Z\",\"detectionEngines\":[{\"key\":\"sentinelone_cloud\",\"title\":\"SentinelOne Cloud\"}],\"detectionType\":\"static\",\"engines\":[\"SentinelOne Cloud\"],\"externalTicketExists\":false,\"externalTicketId\":null,\"failedActions\":false,\"fileExtension\":\"EXE\",\"fileExtensionType\":\"Executable\",\"filePath\":\"default.exe\",\"fileSize\":1234,\"fileVerificationType\":\"NotSigned\",\"identifiedAt\":\"2022-04-06T08:45:53.968000Z\",\"incidentStatus\":\"unresolved\",\"incidentStatusDescription\":\"Unresolved\",\"initiatedBy\":\"agent_policy\",\"initiatedByDescription\":\"Agent Policy\",\"initiatingUserId\":null,\"initiatingUsername\":null,\"isFileless\":false,\"isValidCertificate\":false,\"maliciousProcessArguments\":null,\"md5\":null,\"mitigatedPreemptively\":false,\"mitigationStatus\":\"not_mitigated\",\"mitigationStatusDescription\":\"Not mitigated\",\"originatorProcess\":\"default.exe\",\"pendingActions\":false,\"processUser\":\"test user\",\"publisherName\":\"\",\"reachedEventsLimit\":false,\"rebootRequired\":false,\"sha1\":\"aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d\",\"sha256\":null,\"storyline\":\"D0XXXXXXXXXXAF4D\",\"threatId\":\"1234567890123456789\",\"threatName\":\"default.exe\",\"updatedAt\":\"2022-04-06T08:54:17.194122Z\"},\"whiteningOptions\":[\"hash\"]}",
          "type": [
              "info"
          ]
      },
      "file": {
          "path": "default.exe"
      },
      "group": {
          "id": "1234567890123456789",
          "name": "Default Group"
      },
      "host": {
          "domain": "WORKGROUP",
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "id": "1234567890123456789",
          "ip": [
              "81.2.69.143"
          ],
          "mac": [
              "DE-AD-00-00-BE-EF"
          ],
          "name": "test-LINUX",
          "os": {
              "name": "linux",
              "type": "linux"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "message": "Threat Detected: default.exe (malicious)",
      "observer": {
          "version": "21.x.x.1234"
      },
      "process": {
          "name": "default.exe"
      },
      "related": {
          "hash": [
              "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d"
          ],
          "hosts": [
              "test-LINUX"
          ],
          "ip": [
              "127.0.0.1",
              "2a02:cf40::",
              "81.2.69.143",
              "10.0.0.1",
              "2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6"
          ],
          "user": [
              "test user"
          ]
      },
      "sentinel_one": {
          "account": {
              "name": "Default2"
          },
          "site": {
              "id": "1234567890123456789",
              "name": "Default site"
          },
          "threat": {
              "agent": {
                  "account": {
                      "id": "1456567890123456789"
                  },
                  "active_threats": 8,
                  "group": {
                      "id": "1234567890123456789",
                      "name": "Default Group"
                  },
                  "id": "1234567890123456789",
                  "infected": true,
                  "is_active": true,
                  "is_decommissioned": false,
                  "machine_type": "server",
                  "mitigation_mode": "detect",
                  "network_interface": [
                      {
                          "id": "1234567890123456789",
                          "inet": [
                              "10.0.0.1"
                          ],
                          "inet6": [
                              "2a02:cf40:add:4002:91f2:a9b2:e09a:6fc6"
                          ],
                          "name": "Ethernet"
                      }
                  ],
                  "network_status": "connected",
                  "operational_state": "na",
                  "os": {
                      "version": "1234"
                  },
                  "reboot_required": false,
                  "scan": {
                      "finished_at": "2022-04-09T09:18:21.090Z",
                      "started_at": "2022-04-09T08:26:52.838Z",
                      "status": "finished"
                  },
                  "site": {
                      "id": "1234567890123456789",
                      "name": "Default site"
                  },
                  "uuid": "fwfbxxxxxxxxxxqcfjfnxxxxxxxxx"
              },
              "analysis": {
                  "description": "Undefined",
                  "verdict": "undefined"
              },
              "automatically_resolved": false,
              "cloudfiles_hash_verdict": "black",
              "collection": {
                  "id": "1234567890123456789"
              },
              "confidence_level": "malicious",
              "created_at": "2022-04-06T08:45:54.519Z",
              "detection": {
                  "account": {
                      "id": "111245567890123456789",
                      "name": "Default2"
                  },
                  "agent": {
                      "domain": "WORKGROUP",
                      "group": {
                          "id": "1444567890123456789",
                          "name": "Default Group"
                      },
                      "ipv4": [
                          "127.0.0.1"
                      ],
                      "ipv6": [
                          "2a02:cf40::"
                      ],
                      "mitigation_mode": "protect",
                      "os": {
                          "name": "linux",
                          "version": "1234"
                      },
                      "registered_at": "2022-04-08T08:26:45.515Z",
                      "uuid": "fwfbxxxxxxxxxxqcfjfnxxxxxxxxx",
                      "version": "21.x.x"
                  },
                  "engines": [
                      {
                          "key": "sentinelone_cloud",
                          "title": "SentinelOne Cloud"
                      }
                  ],
                  "type": "static"
              },
              "engines": [
                  "SentinelOne Cloud"
              ],
              "external_ticket": {
                  "exist": false
              },
              "failed_actions": false,
              "file": {
                  "extension": {
                      "type": "Executable"
                  },
                  "identified_at": "2022-04-06T08:45:53.968Z",
                  "verification_type": "NotSigned"
              },
              "id": "1234567890123456789",
              "incident": {
                  "status": "unresolved",
                  "status_description": "Unresolved"
              },
              "initiated": {
                  "description": "Agent Policy",
                  "name": "agent_policy"
              },
              "is_fileless": false,
              "is_valid_certificate": false,
              "mitigated_preemptively": false,
              "mitigation": {
                  "description": "Not mitigated",
                  "status": "not_mitigated"
              },
              "mitigation_status": [
                  {
                      "action": "unquarantine",
                      "action_counters": {
                          "failed": 0,
                          "not_found": 0,
                          "pending_reboot": 0,
                          "success": 1,
                          "total": 1
                      },
                      "agent_supports_report": true,
                      "group_not_found": false,
                      "last_update": "2022-04-06T08:54:17.198Z",
                      "latest_report": "/threats/mitigation-report",
                      "mitigation_ended_at": "2022-04-06T08:54:17.101Z",
                      "mitigation_started_at": "2022-04-06T08:54:17.101Z",
                      "status": "success"
                  },
                  {
                      "action": "kill",
                      "agent_supports_report": true,
                      "group_not_found": false,
                      "last_update": "2022-04-06T08:45:55.303Z",
                      "mitigation_ended_at": "2022-04-06T08:45:55.297Z",
                      "mitigation_started_at": "2022-04-06T08:45:55.297Z",
                      "status": "success"
                  }
              ],
              "name": "default.exe",
              "originator_process": "default.exe",
              "pending_actions": false,
              "process_user": "test user",
              "reached_events_limit": false,
              "reboot_required": false,
              "storyline": "D0XXXXXXXXXXAF4D",
              "threat_id": "1234567890123456789",
              "whitening_option": [
                  "hash"
              ]
          },
          "threat_classification": {
              "name": "Trojan",
              "source": "Cloud"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "sentinel_one-threat"
      ],
      "threat": {
          "indicator": {
              "file": {
                  "extension": "EXE",
                  "hash": {
                      "sha1": "aaf4c61ddcc5e8a2dabede0f3b482cd9aea9434d"
                  },
                  "path": "default.exe",
                  "size": 1234
              }
          }
      },
      "user": {
          "name": "test user"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                | Description                                                                                                                                                                                                                                                                                                                                    | Type             |
  |----------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                           | Event timestamp.                                                                                                                                                                                                                                                                                                                               | date             |
  | cloud.image.id                                                       | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                               | keyword          |
  | data_stream.dataset                                                  | Data stream dataset.                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.namespace                                                | Data stream namespace.                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.type                                                     | Data stream type.                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                        | Event dataset.                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.module                                                         | Event module.                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | host.containerized                                                   | If the host is a container.                                                                                                                                                                                                                                                                                                                    | boolean          |
  | host.os.build                                                        | OS build information.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.os.codename                                                     | OS codename, if any.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type                                                           | Input type                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | log.offset                                                           | Log offset                                                                                                                                                                                                                                                                                                                                     | long             |
  | sentinel_one.account.name                                            |                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.site.id                                                 |                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.site.name                                               |                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.agent.account.id                                 | Account id.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.agent.active_threats                             | Active threats.                                                                                                                                                                                                                                                                                                                                | long             |
  | sentinel_one.threat.agent.decommissioned_at                          | Decommissioned at.                                                                                                                                                                                                                                                                                                                             | boolean          |
  | sentinel_one.threat.agent.group.id                                   | Group id.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.agent.group.name                                 | Group name.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.agent.id                                         | Related agent (if applicable).                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.threat.agent.infected                                   | Agent infected.                                                                                                                                                                                                                                                                                                                                | boolean          |
  | sentinel_one.threat.agent.is_active                                  | Is active.                                                                                                                                                                                                                                                                                                                                     | boolean          |
  | sentinel_one.threat.agent.is_decommissioned                          | Is decommissioned.                                                                                                                                                                                                                                                                                                                             | boolean          |
  | sentinel_one.threat.agent.machine_type                               | Machine type.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.agent.mitigation_mode                            | Agent mitigation mode policy.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.agent.network_interface.id                       | Device's network interfaces id.                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.agent.network_interface.inet                     | Device's network interfaces IPv4 addresses.                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.agent.network_interface.inet6                    | Device's network interfaces IPv6 addresses.                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.agent.network_interface.name                     | Device's network interfaces IPv4 Name.                                                                                                                                                                                                                                                                                                         | keyword          |
  | sentinel_one.threat.agent.network_status                             | Network status.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.agent.operational_state                          | Agent operational state.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | sentinel_one.threat.agent.os.version                                 | OS revision.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.agent.reboot_required                            | A reboot is required on the endpoint for at least one acton on the threat.                                                                                                                                                                                                                                                                     | boolean          |
  | sentinel_one.threat.agent.scan.aborted_at                            | Abort time of last scan (if applicable).                                                                                                                                                                                                                                                                                                       | keyword          |
  | sentinel_one.threat.agent.scan.finished_at                           | Finish time of last scan (if applicable).                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.agent.scan.started_at                            | Start time of last scan.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | sentinel_one.threat.agent.scan.status                                | Scan status.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.agent.site.id                                    | Site id.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | sentinel_one.threat.agent.site.name                                  | Site name.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | sentinel_one.threat.agent.storage.name                               | Storage Name.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.agent.storage.type                               | Storage Type.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.agent.user_action_needed                         | A list of pending user actions. List items possible values: "none, reboot_needed, user_acton_needed, upgrade_needed, incompatible_os, unprotected, user_acton_needed_fda, user_acton_needed_rs_fda,user_acton_needed_network, rebootless_without_dynamic_detection, extended_exclusions_partially_accepted, user_action_needed_bluetooth_per". | keyword          |
  | sentinel_one.threat.agent.uuid                                       | UUID.                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | sentinel_one.threat.analysis.description                             | Analyst verdict description.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.analysis.verdict                                 | Analyst verdict.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.automatically_resolved                           | Automatically resolved.                                                                                                                                                                                                                                                                                                                        | boolean          |
  | sentinel_one.threat.browser_type                                     | Browser type.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.certificate.id                                   | File Certificate ID.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | sentinel_one.threat.cloudfiles_hash_verdict                          | Cloud files hash verdict.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.collection.id                                    | Collection id.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.threat.confidence_level                                 | SentinelOne threat confidence level.                                                                                                                                                                                                                                                                                                           | keyword          |
  | sentinel_one.threat.container.labels                                 | Container labels.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat.created_at                                       | Timestamp of date creation in the Management Console.                                                                                                                                                                                                                                                                                          | date             |
  | sentinel_one.threat.detection.account.id                             | Orig account id.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.detection.account.name                           | Orig account name.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat.detection.agent.domain                           | Network domain.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.detection.agent.group.id                         | Orig group id.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.threat.detection.agent.group.name                       | Orig group name.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.detection.agent.ipv4                             | Orig agent ipv4.                                                                                                                                                                                                                                                                                                                               | ip               |
  | sentinel_one.threat.detection.agent.ipv6                             | Orig agent ipv6.                                                                                                                                                                                                                                                                                                                               | ip               |
  | sentinel_one.threat.detection.agent.last_logged_in.upn               | UPN of last logged in user.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.detection.agent.mitigation_mode                  | Agent mitigation mode policy.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.detection.agent.os.name                          | Orig agent OS name.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.threat.detection.agent.os.version                       | Orig agent OS revision.                                                                                                                                                                                                                                                                                                                        | keyword          |
  | sentinel_one.threat.detection.agent.registered_at                    | Time of first registration to management console.                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.threat.detection.agent.uuid                             | UUID of the agent.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat.detection.agent.version                          | Orig agent version.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.threat.detection.cloud_providers                        | Cloud providers for this agent.                                                                                                                                                                                                                                                                                                                | flattened        |
  | sentinel_one.threat.detection.engines.key                            | List of engines that detected the threat key.                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.detection.engines.title                          | List of engines that detected the threat title.                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.detection.state                                  | The Agent's detection state at time of detection.                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat.detection.type                                   | Detection type.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.engines                                          | List of engines that detected the threat.                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.external_ticket.exist                            | External ticket exists.                                                                                                                                                                                                                                                                                                                        | boolean          |
  | sentinel_one.threat.external_ticket.id                               | External ticket id.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.threat.failed_actions                                   | At least one action failed on the threat.                                                                                                                                                                                                                                                                                                      | boolean          |
  | sentinel_one.threat.file.extension.type                              | File extension type.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | sentinel_one.threat.file.identified_at                               | Identified at.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.threat.file.verification_type                           | File verification type.                                                                                                                                                                                                                                                                                                                        | keyword          |
  | sentinel_one.threat.id                                               | Threat id.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | sentinel_one.threat.incident.status                                  | Incident status.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.incident.status_description                      | Incident status description.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.indicators.category.id                           | Indicators Category Id.                                                                                                                                                                                                                                                                                                                        | long             |
  | sentinel_one.threat.indicators.category.name                         | Indicators Category Name.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.indicators.description                           | Indicators Description.                                                                                                                                                                                                                                                                                                                        | keyword          |
  | sentinel_one.threat.initiated.description                            | Initiated by description.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.initiated.name                                   | Source of threat.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat.initiating_user.id                               | Initiating user id.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.threat.initiating_user.name                             | Initiating user username.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.is_fileless                                      | Is fileless.                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | sentinel_one.threat.is_valid_certificate                             | True if the certificate is valid.                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat.kubernetes.cluster                               | Cluster.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | sentinel_one.threat.kubernetes.controller.kind                       | Controller kind.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.kubernetes.controller.labels                     | Controller labels.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat.kubernetes.controller.name                       | Controller name.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.kubernetes.namespace.labels                      | Namespace labels.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat.kubernetes.namespace.name                        | Namespace name.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat.kubernetes.node                                  | Node.                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | sentinel_one.threat.kubernetes.pod.labels                            | Pod labels.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.kubernetes.pod.name                              | Pod name.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | sentinel_one.threat.malicious_process_arguments                      | Malicious process arguments.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.mitigated_preemptively                           | True is the threat was blocked before execution.                                                                                                                                                                                                                                                                                               | boolean          |
  | sentinel_one.threat.mitigation.description                           | Mitigation status description.                                                                                                                                                                                                                                                                                                                 | keyword          |
  | sentinel_one.threat.mitigation.status                                | Mitigation status.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat.mitigation_status.action                         | Action.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | sentinel_one.threat.mitigation_status.action_counters.failed         | Actions counters Failed.                                                                                                                                                                                                                                                                                                                       | long             |
  | sentinel_one.threat.mitigation_status.action_counters.not_found      | Actions counters Not found.                                                                                                                                                                                                                                                                                                                    | long             |
  | sentinel_one.threat.mitigation_status.action_counters.pending_reboot | Actions counters Pending reboot.                                                                                                                                                                                                                                                                                                               | long             |
  | sentinel_one.threat.mitigation_status.action_counters.success        | Actions counters Success.                                                                                                                                                                                                                                                                                                                      | long             |
  | sentinel_one.threat.mitigation_status.action_counters.total          | Actions counters Total.                                                                                                                                                                                                                                                                                                                        | long             |
  | sentinel_one.threat.mitigation_status.agent_supports_report          | The Agent generates a full mitigation report.                                                                                                                                                                                                                                                                                                  | boolean          |
  | sentinel_one.threat.mitigation_status.group_not_found                | Agent could not find the threat.                                                                                                                                                                                                                                                                                                               | boolean          |
  | sentinel_one.threat.mitigation_status.last_update                    | Timestamp of last mitigation status update.                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.mitigation_status.latest_report                  | Report download URL. If None, there is no report.                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat.mitigation_status.mitigation_ended_at            | The time the Agent finished the mitigation.                                                                                                                                                                                                                                                                                                    | keyword          |
  | sentinel_one.threat.mitigation_status.mitigation_started_at          | The time the Agent started the mitigation.                                                                                                                                                                                                                                                                                                     | keyword          |
  | sentinel_one.threat.mitigation_status.report_id                      | Report identifier.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat.mitigation_status.status                         | Status.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | sentinel_one.threat.name                                             | Threat name.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | sentinel_one.threat.originator_process                               | Originator process.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | sentinel_one.threat.pending_actions                                  | At least one action is pending on the threat.                                                                                                                                                                                                                                                                                                  | boolean          |
  | sentinel_one.threat.process_user                                     | Process user.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | sentinel_one.threat.publisher.name                                   | Certificate publisher.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | sentinel_one.threat.reached_events_limit                             | Has number of OS events for this threat reached the limit, resulting in a partial attack storyline.                                                                                                                                                                                                                                            | boolean          |
  | sentinel_one.threat.reboot_required                                  | A reboot is required on the endpoint for at least one threat.                                                                                                                                                                                                                                                                                  | boolean          |
  | sentinel_one.threat.storyline                                        | Storyline identifier from agent.                                                                                                                                                                                                                                                                                                               | keyword          |
  | sentinel_one.threat.threat_id                                        | Threat id.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | sentinel_one.threat.whitening_option                                 | Whitening options.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | sentinel_one.threat_classification.name                              |                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | sentinel_one.threat_classification.source                            |                                                                                                                                                                                                                                                                                                                                                | keyword          |
</dropdown>


### threat event

This is the `threat event` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-10-22T11:30:00.000Z",
      "agent": {
          "ephemeral_id": "b7dae0a8-8a03-4b8a-8bdd-101df93a42af",
          "id": "a8992072-5255-4dac-9197-44b16d9ce68b",
          "name": "elastic-agent-69444",
          "type": "filebeat",
          "version": "8.19.7"
      },
      "data_stream": {
          "dataset": "sentinel_one.threat_event",
          "namespace": "93680",
          "type": "logs"
      },
      "destination": {
          "ip": "89.160.20.128",
          "port": 443
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "a8992072-5255-4dac-9197-44b16d9ce68b",
          "snapshot": true,
          "version": "8.19.7"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-22T11:30:00.000Z",
          "dataset": "sentinel_one.threat_event",
          "id": "id_004",
          "ingested": "2025-11-19T10:42:22Z",
          "kind": "event",
          "original": "{\"activeContentFileId\":\"fileid_004\",\"activeContentHash\":\"hash_004\",\"activeContentPath\":\"D:\\\\content\\\\file4\",\"agentDomain\":\"domain4\",\"agentGroupId\":\"group_04\",\"agentId\":\"agent_004\",\"agentInfected\":false,\"agentIp\":\"89.160.20.156\",\"agentIsActive\":true,\"agentIsDecommissioned\":false,\"agentMachineType\":\"x64\",\"agentName\":\"Agent_4\",\"agentNetworkStatus\":\"online\",\"agentOs\":\"Windows 10\",\"agentUuid\":\"uuid_004\",\"agentVersion\":\"1.3.0\",\"connectionStatus\":\"active\",\"createdAt\":\"2025-10-22T11:30:00Z\",\"direction\":\"outbound\",\"dnsRequest\":\"google.com\",\"dnsResponse\":\"8.8.8.8\",\"dstIp\":\"89.160.20.128\",\"dstPort\":443,\"eventType\":\"network\",\"fileFullName\":\"C:\\\\Program Files\\\\Chrome\\\\chrome.exe\",\"fileId\":\"file_004\",\"fileMd5\":\"md5_004\",\"fileSha1\":\"sha1_004\",\"fileSha256\":\"sha256_004\",\"fileSize\":\"4096\",\"fileType\":\"exe\",\"hasActiveContent\":false,\"id\":\"id_004\",\"indicatorCategory\":\"spyware\",\"indicatorDescription\":\"tracking software\",\"indicatorMetadata\":\"meta4\",\"indicatorName\":\"Spyware4\",\"loginsBaseType\":\"domain\",\"loginsUserName\":\"user_login4\",\"md5\":\"md5_sample4\",\"networkMethod\":\"GET\",\"networkSource\":\"WAN\",\"networkUrl\":\"https://google.com\",\"objectType\":\"process\",\"oldFileMd5\":\"old_md54\",\"oldFileName\":\"chrome_old.exe\",\"oldFileSha1\":\"old_sha14\",\"oldFileSha256\":\"old_sha2564\",\"parentPid\":\"4001\",\"parentProcessGroupId\":\"group_parent_04\",\"parentProcessIsMalicious\":false,\"parentProcessName\":\"explorer.exe\",\"parentProcessUniqueKey\":\"unique_parent_004\",\"pid\":\"4567\",\"processCmd\":\"chrome.exe --new-tab\",\"processDisplayName\":\"Google Chrome\",\"processGroupId\":\"group_04\",\"processImagePath\":\"C:\\\\Program Files\\\\Chrome\\\\chrome.exe\",\"processImageSha1Hash\":\"sha1_process4\",\"processIntegrityLevel\":\"medium\",\"processIsMalicious\":false,\"processIsRedirectedCommandProcessor\":\"false\",\"processIsWow64\":\"false\",\"processName\":\"chrome.exe\",\"processRoot\":\"C:\\\\\",\"processSessionId\":\"session_004\",\"processStartTime\":\"2025-10-22T11:00:00Z\",\"processSubSystem\":\"subsystem4\",\"processUniqueKey\":\"unique_004\",\"processUserName\":\"user4\",\"protocol\":\"TCP\",\"publisher\":\"Google\",\"registryClassification\":\"application\",\"registryId\":\"reg_004\",\"registryPath\":\"HKCU\\\\Software\\\\Test4\",\"relatedToThreat\":false,\"rpid\":\"rpid_004\",\"sha1\":\"sha1_sample4\",\"sha256\":\"sha256_sample4\",\"signatureSignedInvalidReason\":\"None\",\"signedStatus\":\"Signed\",\"siteId\":\"site_004\",\"siteName\":\"SiteD\",\"srcIp\":\"127.0.0.1\",\"srcPort\":34567,\"storyline\":\"storyline4\",\"taskName\":\"task4\",\"taskPath\":\"C:\\\\Tasks\\\\task4\",\"threatStatus\":\"clean\",\"tid\":\"tid_004\",\"trueContext\":\"context4\",\"user\":\"user4\",\"verifiedStatus\":\"Verified\"}"
      },
      "file": {
          "hash": {
              "md5": "md5_004",
              "sha1": "sha1_004",
              "sha256": "sha256_004"
          },
          "name": "C:\\Program Files\\Chrome\\chrome.exe",
          "size": 4096,
          "type": "exe"
      },
      "input": {
          "type": "cel"
      },
      "network": {
          "transport": "tcp"
      },
      "process": {
          "command_line": "chrome.exe --new-tab",
          "executable": "C:\\Program Files\\Chrome\\chrome.exe",
          "hash": {
              "sha1": "sha1_process4"
          },
          "name": "chrome.exe",
          "parent": {
              "name": "explorer.exe",
              "pid": 4001
          },
          "pid": 4567,
          "start": "2025-10-22T11:00:00.000Z",
          "user": {
              "name": "user4"
          }
      },
      "registry": {
          "path": "HKCU\\Software\\Test4"
      },
      "related": {
          "hash": [
              "sha1_004",
              "sha256_004",
              "md5_004",
              "sha1_process4"
          ],
          "ip": [
              "89.160.20.156",
              "127.0.0.1",
              "89.160.20.128"
          ],
          "user": [
              "user_login4",
              "user4"
          ]
      },
      "sentinel_one": {
          "site": {
              "id": "site_004",
              "name": "SiteD"
          },
          "threat_event": {
              "active_content": {
                  "file_id": "fileid_004",
                  "hash": "hash_004",
                  "path": "D:\\content\\file4"
              },
              "agent": {
                  "domain": "domain4",
                  "group_id": "group_04",
                  "id": "agent_004",
                  "infected": false,
                  "ip": "89.160.20.156",
                  "is_active": true,
                  "is_decommissioned": false,
                  "machine_type": "x64",
                  "name": "Agent_4",
                  "network_status": "online",
                  "os": "Windows 10",
                  "uuid": "uuid_004",
                  "version": "1.3.0"
              },
              "connection_status": "active",
              "created_at": "2025-10-22T11:30:00.000Z",
              "direction": "outbound",
              "dns_request": "google.com",
              "dns_response": "8.8.8.8",
              "dst": {
                  "ip": "89.160.20.128",
                  "port": 443
              },
              "event_type": "network",
              "file": {
                  "full_name": "C:\\Program Files\\Chrome\\chrome.exe",
                  "id": "file_004",
                  "md5": "md5_004",
                  "sha1": "sha1_004",
                  "sha256": "sha256_004",
                  "size": "4096",
                  "type": "exe"
              },
              "has_active_content": false,
              "id": "id_004",
              "indicator": {
                  "category": "spyware",
                  "description": "tracking software",
                  "metadata": "meta4",
                  "name": "Spyware4"
              },
              "logins_base_type": "domain",
              "logins_user_name": "user_login4",
              "md5": "md5_sample4",
              "network": {
                  "method": "GET",
                  "source": "WAN",
                  "url": "https://google.com"
              },
              "object_type": "process",
              "old_file": {
                  "md5": "old_md54",
                  "name": "chrome_old.exe",
                  "sha1": "old_sha14",
                  "sha256": "old_sha2564"
              },
              "parent_pid": "4001",
              "parent_process": {
                  "group_id": "group_parent_04",
                  "is_malicious": false,
                  "name": "explorer.exe",
                  "unique_key": "unique_parent_004"
              },
              "pid": "4567",
              "process": {
                  "cmd": "chrome.exe --new-tab",
                  "display_name": "Google Chrome",
                  "group_id": "group_04",
                  "image_path": "C:\\Program Files\\Chrome\\chrome.exe",
                  "image_sha1_hash": "sha1_process4",
                  "integrity_level": "medium",
                  "is_malicious": false,
                  "is_redirected_command_processor": "false",
                  "is_wow64": "false",
                  "name": "chrome.exe",
                  "root": "C:\\",
                  "session_id": "session_004",
                  "start_time": "2025-10-22T11:00:00.000Z",
                  "sub_system": "subsystem4",
                  "unique_key": "unique_004",
                  "user_name": "user4"
              },
              "protocol": "TCP",
              "publisher": "Google",
              "registry": {
                  "classification": "application",
                  "id": "reg_004",
                  "path": "HKCU\\Software\\Test4"
              },
              "related_to_threat": false,
              "rpid": "rpid_004",
              "sha1": "sha1_sample4",
              "sha256": "sha256_sample4",
              "signature_signed_invalid_reason": "None",
              "signed_status": "Signed",
              "src": {
                  "ip": "127.0.0.1",
                  "port": 34567
              },
              "storyline": "storyline4",
              "task_name": "task4",
              "task_path": "C:\\Tasks\\task4",
              "threat_status": "clean",
              "tid": "tid_004",
              "true_context": "context4",
              "user": "user4",
              "verified_status": "Verified"
          }
      },
      "source": {
          "ip": "127.0.0.1",
          "port": 34567
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "sentinel_one-threat_event"
      ],
      "threat": {
          "indicator": {
              "description": "tracking software",
              "name": "Spyware4"
          }
      },
      "url": {
          "full": "https://google.com"
      },
      "user": {
          "name": "user4"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                        | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                                               | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                             | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                                  | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                     | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                      | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                                                        | Type of filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                                                        | Log offset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | sentinel_one.site.id                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.site.name                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.active_content.file_id                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.active_content.hash                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.active_content.path                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.domain                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.group_id                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.id                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.infected                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.agent.ip                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | sentinel_one.threat_event.agent.is_active                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.agent.is_decommissioned                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.agent.machine_type                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.name                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.network_status                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.os                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.uuid                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.agent.version                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.connection_status                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.created_at                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.threat_event.direction                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.dns_request                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.dns_response                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.dst.ip                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | sentinel_one.threat_event.dst.port                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.threat_event.event_type                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.full_name                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.id                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.md5                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.sha1                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.sha256                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.size                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.file.type                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.has_active_content                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.id                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.indicator.category                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.indicator.description                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.indicator.metadata                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.indicator.name                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.logins_base_type                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.logins_user_name                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.md5                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.network.method                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.network.source                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.network.url                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.object_type                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.old_file.md5                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.old_file.name                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.old_file.sha1                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.old_file.sha256                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.parent_pid                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.parent_process.group_id                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.parent_process.is_malicious             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.parent_process.name                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.parent_process.unique_key               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.pid                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.cmd                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.display_name                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.group_id                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.image_path                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.image_sha1_hash                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.integrity_level                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.is_malicious                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.process.is_redirected_command_processor |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.is_wow64                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.root                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.session_id                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.start_time                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | sentinel_one.threat_event.process.sub_system                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.unique_key                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.process.user_name                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.protocol                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.publisher                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.registry.classification                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.registry.id                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.registry.path                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.related_to_threat                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | sentinel_one.threat_event.rpid                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.sha1                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.sha256                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.signature_signed_invalid_reason         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.signed_status                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.src.ip                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | sentinel_one.threat_event.src.port                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | sentinel_one.threat_event.storyline                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.task_name                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.task_path                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.threat_status                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.tid                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.true_context                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.user                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | sentinel_one.threat_event.verified_status                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![SentinelOne Activity Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-activities-dashboard.png)

  ![SentinelOne Agent Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-agents-dashboard.png)

  ![SentinelOne Alerts Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-alerts-dashboard.png)

  ![SentinelOne Application Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-application-dashboard.png)

  ![SentinelOne Application Risk Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-application-risk-dashboard.png)

  ![SentinelOne Group Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-group-dashboard.png)

  ![SentinelOne Threat Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-threats-dashboard.png)

  ![SentinelOne Threat Event Dashboard](https://epr.elastic.co/package/sentinel_one/2.1.0/img/sentinel-one-threat-event-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                               | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16885))Added parsing support for ECS `rule.*` fields and related custom fields in the activity data stream.                                                                                                                                                                                                                                                         | 9.3.09.2.19.1.78.19.7  |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16728))Split domain-qualified `user.name` values into `user.domain`.                                                                                                                                                                                                                                                                                                    | 9.3.09.2.19.1.78.19.7  |
  | **2.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15931))Unified the site, account, and threat-classification field structures under the `sentinel_one.*` namespaceacross all data streams, and removed older fields.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15931))Enhanced the ECS mappings across all data streams.                                                  | 9.3.09.2.19.1.78.19.7  |
  | **1.43.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16070))Do not log expected empty template results as DEGRADED health in agent or group data streams.                                                                                                                                                                                                                                                                    | 9.3.09.2.19.1.78.19.7  |
  | **1.43.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15993))Do not log expected empty template results as DEGRADED health in activity, alert or threat data streams.                                                                                                                                                                                                                                                         | 9.3.09.2.19.1.78.19.7  |
  | **1.43.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15771))Add support for threat event data stream.                                                                                                                                                                                                                                                                                                                    | 9.3.09.2.19.1.78.19.7  |
  | **1.42.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15862))Improved input section layout by updating titles to include data stream names.                                                                                                                                                                                                                                                                               | 9.1.49.0.78.19.48.18.7 |
  | **1.41.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15446))Add configuration option to filter results by Site IDs in the application data stream, improve UI layout, and readme document.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15446))Enhanced error handling in the CEL program for API calls to prevent "no such key: batch_size" errors in the application risk data stream. | 9.1.49.0.78.19.48.18.7 |
  | **1.40.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15437))Update deprecated visualization charts and implemented best practices in the existing dashboards.                                                                                                                                                                                                                                                            | 9.1.49.0.78.19.48.18.7 |
  | **1.39.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15420))Update README instructions for generating the API token.                                                                                                                                                                                                                                                                                                     | 9.1.49.0.78.19.48.18.7 |
  | **1.38.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14910))Add support for application risk data stream.                                                                                                                                                                                                                                                                                                                | 9.1.49.0.78.19.48.18.7 |
  | **1.37.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14834))Add support for application data stream.                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.0            |
  | **1.36.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14302))Add configuration option to filter results by Site IDs.                                                                                                                                                                                                                                                                                                      | 9.0.08.18.0            |
  | **1.35.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                      | 9.0.08.18.0            |
  | **1.35.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13955))Normalize `event.severity` values across EDR integrations.                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **1.34.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13943))Fix the `Activities by OS Family` visualization in the Activities dashboard.                                                                                                                                                                                                                                                                                     | 9.0.08.18.0            |
  | **1.34.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                                                                      | 9.0.08.18.0            |
  | **1.34.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13628))Populate ECS field `message` for threat, alert and activity datastreams.                                                                                                                                                                                                                                                                                     | 9.0.08.18.0            |
  | **1.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13373))Update `host.*` ECS mappings.                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12345))Updated integration logo.                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **1.31.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13478))Fix handling of events with empty string values.                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13452))Enable request trace log removal.                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13107))Add agentless deployment.                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **1.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12593))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12702))Handle comma-separated IP lists.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12702))Improve error handling.                                                                                                                                                                                                             | 8.13.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11036))Document limitation for using the alert data stream in on-premises environments.                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10345))Add agent.* to alerts data.                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                          | 8.13.0                 |
  | **1.23.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10186))Fix sample event MAC address.                                                                                                                                                                                                                                                                                                                                    | 8.12.0                 |
  | **1.23.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10103))Change default interval to 30s for all data streams.                                                                                                                                                                                                                                                                                                         | 8.12.0                 |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10136))Fix sample event.                                                                                                                                                                                                                                                                                                                                                | 8.12.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `host.ip` field conform to ECS field definition.                                                                                                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10102))Add agent.id to all agent related data.                                                                                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9927))Fix Ingest Pipline Error in SentinelOne Package with k8s Elastic Agent.                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                                                                                                                                                                                                          | 8.12.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret and fix incorrect mappings.                                                                                                                                                                                                                                                                                                    | 8.12.0                 |
  | **1.19.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.19.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8611))Add information to README about support for response actions                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8270))Add support for a missing field.                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.15.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7985))Correct invalid ECS field usages at root-level.                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                          | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6932))Convert dashboards to Lens.                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6663))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                  | 8.0.07.17.0            |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                        | 8.0.07.17.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4840))Set event.id from SentinelOne Threat ID                                                                                                                                                                                                                                                                                                                       | 8.0.07.17.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                  | 8.0.07.17.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4677))Add an on_failure processor to the date processor and update the pagination termination condition.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4677))Update newValue field type in Activity data stream.                                                                                                                     | 8.0.07.17.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                  | 8.0.07.17.0            |
  | **1.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4296))Ensure stability of related.hash array ordering.                                                                                                                                                                                                                                                                                                                | 8.0.07.17.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3787))Enrich the event.category, event.type, event.kind and event.outcome field based on activity.                                                                                                                                                                                                                                                                      | 8.0.07.17.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3669))Set event.kind to alert for Sentinel One Threats.                                                                                                                                                                                                                                                                                                             | 8.0.07.17.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3910))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                   | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3859))Make GA                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.17.0            |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                            |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3232))Initial Release                                                                                                                                                                                                                                                                                                                                               |                        |
</dropdown>