﻿---
title: Prebuilt Security Detection Rules
description: The detection rules package stores the prebuilt security rules for the Elastic Security detection engine. To download or update the rules, click Settings...
url: https://www.elastic.co/docs/reference/integrations/security_detection_engine
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Prebuilt Security Detection Rules
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 9.3.3 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.3.0                          |

The detection rules package stores the prebuilt security rules for the Elastic Security [detection engine](https://www.elastic.co/guide/en/security/7.13/detection-engine-overview.html).
To download or update the rules, click **Settings** > **Install Prebuilt Security Detection Rules assets**.
Then [import](https://www.elastic.co/guide/en/security/current/rules-ui-management.html)
the rules into the Detection engine.

## License Notice


## Changelog

<dropdown title="Changelog">
  | Version           | Details                                                                                                                                                                                                                               | Minimum Kibana version |
  |-------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **9.3.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17336))Release security rules update                                                                                                                | 9.3.0                  |
  | **9.3.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17328))Release security rules update                                                                                                                |                        |
  | **9.3.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17095))Release security rules update                                                                                                                | 9.3.0                  |
  | **9.3.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17089))Release security rules update                                                                                                                |                        |
  | **9.3.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16961))Release security rules update                                                                                                                | 9.3.0                  |
  | **9.3.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16935))Release security rules update                                                                                                                |                        |
  | **9.2.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16435))Release security rules update                                                                                                                | 9.2.0                  |
  | **9.2.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16407))Release security rules update                                                                                                                |                        |
  | **9.2.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16106))Release security rules update                                                                                                                | 9.2.0                  |
  | **9.2.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16102))Release security rules update                                                                                                                |                        |
  | **9.2.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15940))Release security rules update                                                                                                                | 9.2.0                  |
  | **9.2.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15936))Release security rules update                                                                                                                |                        |
  | **9.2.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15687))Release security rules update                                                                                                                | 9.2.0                  |
  | **9.2.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15683))Release security rules update                                                                                                                |                        |
  | **9.1.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15581))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.8-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15577))Release security rules update                                                                                                                |                        |
  | **9.1.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15389))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15349))Release security rules update                                                                                                                |                        |
  | **9.1.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15123))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.6-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15118))Release security rules update                                                                                                                |                        |
  | **9.1.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14971))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14967))Release security rules update                                                                                                                |                        |
  | **9.1.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14830))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14826))Release security rules update                                                                                                                |                        |
  | **9.1.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14808))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.3-beta.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14803))Release security rules update                                                                                                                |                        |
  | **9.1.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14719))Release security rules update AI4DSOC Testing                                                                                                |                        |
  | **9.1.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14657))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.2-beta.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14652))Release security rules update                                                                                                                |                        |
  | **9.1.2-beta.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14643))Release security rules update                                                                                                                |                        |
  | **9.1.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14634))Release security rules update                                                                                                                |                        |
  | **9.1.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14452))Release security rules update                                                                                                                | 9.1.0                  |
  | **9.1.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14447))Release security rules update                                                                                                                |                        |
  | **9.0.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14255))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14249))Release security rules update                                                                                                                |                        |
  | **9.0.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14118))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.6-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14114))Release security rules update                                                                                                                |                        |
  | **9.0.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13942))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.5-beta.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13937))Release security rules update                                                                                                                |                        |
  | **9.0.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13839))Release security rules update                                                                                                                |                        |
  | **9.0.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13815))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13810))Release security rules update                                                                                                                |                        |
  | **9.0.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13744))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13737))Release security rules update                                                                                                                |                        |
  | **9.0.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13707))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13686))Release security rules update                                                                                                                |                        |
  | **9.0.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13471))Release security rules update                                                                                                                | 9.0.0                  |
  | **9.0.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13468))Release security rules update                                                                                                                |                        |
  | **8.17.7**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13086))Release security rules update                                                                                                                | 9.0.08.17.0            |
  | **8.17.7-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13079))Release security rules update                                                                                                                |                        |
  | **8.17.6**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12811))Release security rules update                                                                                                                | 8.17.0                 |
  | **8.17.6-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12806))Release security rules update                                                                                                                |                        |
  | **8.17.5**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12676))Release security rules update                                                                                                                | 8.17.0                 |
  | **8.17.5-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12672))Release security rules update                                                                                                                |                        |
  | **8.17.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12590))Release security rules update                                                                                                                | 8.17.0                 |
  | **8.17.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12585))Release security rules update                                                                                                                |                        |
  | **8.17.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12416))Release security rules update                                                                                                                | 8.17.0                 |
  | **8.17.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12409))Release security rules update                                                                                                                |                        |
  | **8.17.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pulls/12266))Release security rules update                                                                                                               | 8.17.0                 |
  | **8.17.2-beta.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pulls/12261))Release security rules update                                                                                                               |                        |
  | **8.17.2-beta.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11929))Fix broken link for Prebuilt Security Detection Rules                                                                                            |                        |
  | **8.17.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12063))Release security rules update                                                                                                                | 8.17.0                 |
  | **8.17.1-beta.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12059))Release security rules update                                                                                                                |                        |
  | **8.17.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12043))Release security rules update                                                                                                                |                        |
  | **8.16.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11904))Release security rules update                                                                                                                | 8.16.0                 |
  | **8.16.2-beta.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11900))Release security rules update                                                                                                                |                        |
  | **8.16.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11866))Release security rules update for testing smart limits                                                                                       |                        |
  | **8.16.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11702))Release security rules update                                                                                                                | 8.16.0                 |
  | **8.16.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11697))Release security rules update                                                                                                                |                        |
  | **8.15.9**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11549))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.9-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11546))Release security rules update                                                                                                                |                        |
  | **8.15.8**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11431))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.8-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11427))Release security rules update                                                                                                                |                        |
  | **8.15.7**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11387))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.7-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11383))Release security rules update                                                                                                                |                        |
  | **8.15.6**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11303))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.6-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11296))Release security rules update                                                                                                                |                        |
  | **8.15.5**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11156))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.5-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11142))Release security rules update                                                                                                                |                        |
  | **8.15.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10990))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10983))Release security rules update                                                                                                                |                        |
  | **8.15.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10839))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10835))Release security rules update                                                                                                                |                        |
  | **8.15.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10717))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10712))Release security rules update                                                                                                                |                        |
  | **8.15.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10603))Release security rules update                                                                                                                | 8.15.0                 |
  | **8.15.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10598))Release security rules update                                                                                                                |                        |
  | **8.14.6**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10434))Release security rules update                                                                                                                | 8.14.0                 |
  | **8.14.6-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10430))Release security rules update                                                                                                                |                        |
  | **8.14.5**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10302))Release security rules update                                                                                                                | 8.14.0                 |
  | **8.14.5-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10297))Release security rules update                                                                                                                |                        |
  | **8.14.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10245))Release security rules update                                                                                                                | 8.14.0                 |
  | **8.14.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10239))Release security rules update                                                                                                                |                        |
  | **8.14.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10133))Release security rules update                                                                                                                | 8.14.0                 |
  | **8.14.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10128))Release security rules update                                                                                                                |                        |
  | **8.14.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10015))Release security rules update                                                                                                                | 8.14.0                 |
  | **8.14.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10011))Release security rules update**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9938))Add security capability |                        |
  | **8.14.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9883))Release security rules update                                                                                                                 | 8.14.0                 |
  | **8.14.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9877))Release security rules update                                                                                                                 |                        |
  | **8.13.6**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9801))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.6-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9795))Release security rules update                                                                                                                 |                        |
  | **8.13.5**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9762))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.5-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9758))Release security rules update                                                                                                                 |                        |
  | **8.13.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9684))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9679))Release security rules update                                                                                                                 |                        |
  | **8.13.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9507))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9497))Release security rules update                                                                                                                 |                        |
  | **8.13.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9421))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9412))Release security rules update                                                                                                                 |                        |
  | **8.13.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9301))Release security rules update                                                                                                                 | 8.13.0                 |
  | **8.13.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9284))Release security rules update                                                                                                                 |                        |
  | **8.12.5**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9218))Release security rules update                                                                                                                 | 8.12.0                 |
  | **8.12.5-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9207))Release security rules update                                                                                                                 |                        |
  | **8.12.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9099))Release security rules update                                                                                                                 | 8.12.0                 |
  | **8.12.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9094))Release security rules update                                                                                                                 |                        |
  | **8.12.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8982))Release security rules update                                                                                                                 | 8.12.0                 |
  | **8.12.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8968))Release security rules update                                                                                                                 |                        |
  | **8.12.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8820))Release security rules update                                                                                                                 | 8.12.0                 |
  | **8.12.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8818))Release security rules update                                                                                                                 |                        |
  | **8.12.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8732))Release security rules update                                                                                                                 | 8.12.0                 |
  | **8.12.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8714))Release security rules update                                                                                                                 |                        |
  | **8.11.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8599))Release security rules update                                                                                                                 | 8.11.0                 |
  | **8.11.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8595))Release security rules update                                                                                                                 |                        |
  | **8.11.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8506))Release security rules update                                                                                                                 | 8.11.0                 |
  | **8.11.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8486))Release security rules update                                                                                                                 |                        |
  | **8.11.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8288))Release security rules update                                                                                                                 | 8.11.0                 |
  | **8.11.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8282))Release security rules update                                                                                                                 |                        |
  | **8.11.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8202))Release security rules update                                                                                                                 | 8.11.0                 |
  | **8.11.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8198))Release security rules update                                                                                                                 |                        |
  | **8.10.4-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8076))Release security rules update                                                                                                                 |                        |
  | **8.10.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7869))Release security rules update                                                                                                                 | 8.10.1                 |
  | **8.10.3-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7857))Release security rules update                                                                                                                 |                        |
  | **8.10.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7700))Release security rules update                                                                                                                 | 8.10.0                 |
  | **8.10.2-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7686))Release security rules update                                                                                                                 |                        |
  | **8.10.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7457))Release security rules update                                                                                                                 | 8.10.0                 |
  | **8.10.1-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7450))Release security rules update                                                                                                                 |                        |
  | **8.9.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7227))Release security rules update                                                                                                                 | 8.9.0                  |
  | **8.9.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7223))Release security rules update                                                                                                                 |                        |
  | **8.9.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6957))Release security rules update                                                                                                                 | 8.9.0                  |
  | **8.9.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6956))Release security rules update                                                                                                                 |                        |
  | **8.8.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6955))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6953))Release security rules update                                                                                                                 |                        |
  | **8.7.9**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6951))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.9-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6940))Release security rules update                                                                                                                 |                        |
  | **8.6.9**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6937))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.9.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6760))Release security rules update                                                                                                                 | 8.9.0                  |
  | **8.8.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6759))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.7.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6757))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.6.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6755))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.5.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6754))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.8.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6726))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6725))Release security rules update                                                                                                                 |                        |
  | **8.7.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6724))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6721))Release security rules update                                                                                                                 |                        |
  | **8.6.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6720))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6718))Release security rules update                                                                                                                 |                        |
  | **8.5.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6717))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.7-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6715))Release security rules update                                                                                                                 |                        |
  | **8.8.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6572))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6564))Release security rules update                                                                                                                 |                        |
  | **8.7.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6563))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.6-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6560))Release security rules update                                                                                                                 |                        |
  | **8.6.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6558))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.6-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6557))Release security rules update                                                                                                                 |                        |
  | **8.5.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6556))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.6-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6552))Release security rules update                                                                                                                 |                        |
  | **8.8.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6441))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6437))Release security rules update                                                                                                                 |                        |
  | **8.7.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6436))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6434))Release security rules update                                                                                                                 |                        |
  | **8.6.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6433))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6424))Release security rules update                                                                                                                 |                        |
  | **8.5.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6416))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6410))Release security rules update                                                                                                                 |                        |
  | **8.8.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6261))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6260))Release security rules update                                                                                                                 |                        |
  | **8.7.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6259))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6257))Release security rules update                                                                                                                 |                        |
  | **8.6.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6254))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6252))Release security rules update                                                                                                                 |                        |
  | **8.5.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6250))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6242))Release security rules update                                                                                                                 |                        |
  | **8.8.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6009))Release security rules update                                                                                                                 | 8.8.0                  |
  | **8.8.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6008))Release security rules update                                                                                                                 |                        |
  | **8.7.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6007))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6006))Release security rules update                                                                                                                 |                        |
  | **8.6.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6005))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6004))Release security rules update                                                                                                                 |                        |
  | **8.5.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6002))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6000))Release security rules update                                                                                                                 |                        |
  | **8.4.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5996))Release security rules update                                                                                                                 | 8.4.0                  |
  | **8.4.5-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5995))Release security rules update                                                                                                                 |                        |
  | **8.7.3-beta.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5931))Release security rules update                                                                                                                 |                        |
  | **8.7.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5860))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5857))Release security rules update                                                                                                                 |                        |
  | **8.6.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5856))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5844))Release security rules update                                                                                                                 |                        |
  | **8.5.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5843))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5842))Release security rules update                                                                                                                 |                        |
  | **8.4.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5839))Release security rules update                                                                                                                 | 8.4.0                  |
  | **8.4.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5837))Release security rules update                                                                                                                 |                        |
  | **8.7.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5272))Release security rules update                                                                                                                 | 8.7.0                  |
  | **8.7.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5265))Release security rules update                                                                                                                 |                        |
  | **8.6.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5264))Release security rules update                                                                                                                 | 8.6.0                  |
  | **8.6.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5263))Release security rules update                                                                                                                 |                        |
  | **8.5.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5262))Release security rules update                                                                                                                 | 8.5.0                  |
  | **8.5.1-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5261))Release security rules update                                                                                                                 |                        |
  | **8.4.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5257))Release security rules update                                                                                                                 | 8.4.0                  |
  | **8.4.3-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5238))Release security rules update                                                                                                                 |                        |
  | **8.4.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5062))Release security rules update                                                                                                                 | 8.4.0                  |
  | **8.4.2-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5027))Release security rules update                                                                                                                 |                        |
  | **8.3.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5024))Release security rules update                                                                                                                 | 8.3.0                  |
  | **8.3.4-beta.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5000))Release security rules update                                                                                                                 |                        |
  | **8.3.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4965))Release security rules update                                                                                                                 | 8.3.0                  |
  | **8.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4740))Release security rules update                                                                                                                 | 8.4.0                  |
  | **8.3.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4063))Release security rules update                                                                                                                 | 8.3.0                  |
  | **8.2.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4021))Release security rules update                                                                                                                 | 8.2.0                  |
  | **7.16.4**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4010))Release security rules update                                                                                                                 | 7.16.0                 |
  | **8.1.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3565))Release security rules update                                                                                                                 | 8.1.0                  |
  | **7.16.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3556))Release security rules update                                                                                                                 | 7.16.0                 |
  | **1.0.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3238))Release security rules update                                                                                                                 | 8.0.0                  |
  | **0.16.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3191))Release security rules update                                                                                                                 |                        |
  | **0.16.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2709))Release security rules update                                                                                                                 |                        |
  | **1.0.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2605))Release security rules update                                                                                                                 | 8.0.0                  |
  | **0.14.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2329))Release security rules update                                                                                                                 |                        |
  | **0.14.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1924))Release security rules update                                                                                                                 |                        |
  | **0.14.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1591))Release security rules update                                                                                                                 |                        |
  | **0.13.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1361))Release security rules update                                                                                                                 |                        |
  | **0.13.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1297))Release security rules update                                                                                                                 |                        |
  | **0.13.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1177))Release security rules update                                                                                                                 |                        |
  | **0.13.1-dev.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1144))Pre-release for 0.13.1 security rules                                                                                                             |                        |
  | **0.13.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1127))Fix package for 7.13.0 from detection-rules                                                                                                       |                        |
  | **0.13.0-dev.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1126))Publish package for 7.13.0 from detection-rules                                                                                               |                        |
  | **0.0.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/987))Fix security rules naming                                                                                                                          |                        |
  | **0.0.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/938))Change the rules to match Kibana 7.13 prepackaged                                                                                              |                        |
  | **0.0.1-dev.3**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/896))Change the integration title                                                                                                                   |                        |
  | **0.0.1-dev.2**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/797))Change the saved object type to security-rule                                                                                                  |                        |
  | **0.0.1-dev.1**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/797))Create package for security's detection engine                                                                                                 |                        |
</dropdown>