﻿---
title: Security AI Prompts Integration (Beta)
description: The Security AI Prompts integration provides pre-configured AI-driven security prompts that enhance automated threat detection and response in Elastic...
url: https://www.elastic.co/docs/reference/integrations/security_ai_prompts
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Security AI Prompts Integration (Beta)
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.0.13 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Minimum Kibana version(s)**                                                                   | 9.1.08.19.0                     |


## Overview

The **Security AI Prompts** integration provides pre-configured AI-driven security prompts that enhance automated threat detection and response in Elastic Security. These prompts help security analysts generate AI-assisted insights and streamline their investigative workflows.
This integration is in **beta** and subject to changes. Feedback and contributions are welcome.

## Requirements

- Elastic Stack **8.19.x**, **9.1.x**, or later.
- Kibana with the **Elastic Assistant** plugin enabled.


## Installation

This integration is automatically installed when users visit the **Security Solution** in Kibana. No manual setup is required.

## Usage

1. Navigate to **Security Solution** in Kibana.
2. AI-generated security prompts will be used in AI Assistant, Attack Discovery, and other security AI features to assist in investigations and threat analysis.


## Known Issues & Limitations

This integration is currently in beta and subject to change.
Future versions may include automatic prompt synchronization.

## Contributing

Contributions are welcome! If you encounter issues or have suggestions, please open an issue or submit a pull request.

## License

This integration is subject to the Elastic License.

## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                   | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.0.13** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16441))Update Entity Highlights AI prompt                                               | 9.1.08.19.0            |
  | **1.0.12** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16210))Improvements to Value Report prompt to limit the character size of the response. | 9.1.08.19.0            |
  | **1.0.11** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15515))Improvements to Attack Discovery prompts to reduce false positives.              | 9.1.08.19.0            |
  | **1.0.10** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15848))Update Security AI prompts with latest changes from Kibana                       | 9.1.08.19.0            |
  | **1.0.9**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15750))Add new Entity Highlights prompts                                                | 9.1.08.19.0            |
  | **1.0.8**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15674))Update ease prompts                                                              | 9.1.08.19.0            |
  | **1.0.7**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15656))Update AI Assistant for Asset Inventory prompt                                   | 9.1.08.19.0            |
  | **1.0.6**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15648))Update Security AI prompts with latest changes from Kibana                       | 9.1.08.19.0            |
  | **1.0.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15502))Add prompts for integrations knowledge tool                                      | 9.1.08.19.0            |
  | **1.0.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15393))Add prompts for AI Assistant in Asset Inventory                                  | 9.1.08.19.0            |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15358))Fix knowledge history and add some defend insights and entity analytics prompts. | 9.1.08.19.0            |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15281))Fix missing knowledgeHistory                                                     | 9.1.08.19.0            |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15213))Adds prompts for value report                                                    | 9.1.08.19.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14678))First release of the Security AI Prompts package                                 | 9.1.08.19.0            |
  | **0.0.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14555))Update KnowledgeBaseRetrievalTool and AskAboutESQLTool prompts                   |                        |
  | **0.0.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14536))Update AI Assistant context prompts and starter prompts. Also update readme.     |                        |
  | **0.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14296))Add new Security AI prompts (AI Assistant context prompts and starter prompts).  |                        |
  | **0.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14171))Updated defend insights Security AI prompts.                                     |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13323))Initial draft of the package                                                     |                        |
</dropdown>