﻿---
title: Google Santa Integration
description: The Google Santa integration collects and parses logs from Google Santa, a security tool for macOS that monitors process executions and can blacklist/whitelist...
url: https://www.elastic.co/docs/reference/integrations/santa
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Google Santa Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 3.24.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

The Google Santa integration collects and parses logs from [Google Santa](https://github.com/google/santa), a security tool for macOS that monitors process executions and can blacklist/whitelist
binaries.

## Compatibility

The Google Santa integration was tested with logs from Santa 2022.4.
**Google Santa is available for MacOS only.**
The integration is by default configured to read logs from `/var/db/santa/santa.log`.

## Logs


### Google Santa log

This is the Google Santa `log` dataset.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-05-12T11:30:05.248Z",
      "agent": {
          "ephemeral_id": "7f9603e8-5411-4ed1-acdc-d842f98e5c8b",
          "id": "fa4b2c2b-d00f-4e96-aaf3-d5de2b8544e6",
          "name": "elastic-agent-97786",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "santa.log",
          "namespace": "85590",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "fa4b2c2b-d00f-4e96-aaf3-d5de2b8544e6",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "action": "link",
          "agent_id_status": "verified",
          "dataset": "santa.log",
          "ingested": "2024-10-01T13:57:49Z",
          "kind": "event"
      },
      "file": {
          "path": "/private/var/db/santa/santa.log",
          "target_path": "/private/var/db/santa/santa.log.0"
      },
      "group": {
          "id": "0",
          "name": "wheel"
      },
      "host": {
          "architecture": "aarch64",
          "containerized": false,
          "hostname": "elastic-agent-97786",
          "id": "8269eab9370b4429947d2a16c3058fcb",
          "ip": [
              "172.19.0.2",
              "172.18.0.4"
          ],
          "mac": [
              "02-42-AC-12-00-04",
              "02-42-AC-13-00-02"
          ],
          "name": "elastic-agent-97786",
          "os": {
              "codename": "focal",
              "family": "debian",
              "kernel": "6.10.0-linuxkit",
              "name": "Ubuntu",
              "platform": "ubuntu",
              "type": "linux",
              "version": "20.04.6 LTS (Focal Fossa)"
          }
      },
      "input": {
          "type": "log"
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/santa.log"
          },
          "level": "I",
          "offset": 1150
      },
      "process": {
          "args": [
              "/usr/sbin/newsyslog"
          ],
          "entity_id": "fa4b2c2b-d00f-4e96-aaf3-d5de2b8544e6-71559-1096716",
          "executable": "/usr/sbin/newsyslog",
          "name": "newsyslog",
          "parent": {
              "pid": 1
          },
          "pid": 71559,
          "start": "2022-05-12T11:30:05.248Z"
      },
      "related": {
          "user": [
              "root"
          ]
      },
      "santa": {
          "action": "LINK",
          "pidversion": 1096716
      },
      "tags": [
          "santa-log"
      ],
      "user": {
          "id": "0",
          "name": "root"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                         | Description                                | Type             |
  |-------------------------------|--------------------------------------------|------------------|
  | @timestamp                    | Event timestamp.                           | date             |
  | cloud.image.id                | Image ID for the cloud instance.           | keyword          |
  | data_stream.dataset           | Data stream dataset.                       | constant_keyword |
  | data_stream.namespace         | Data stream namespace.                     | constant_keyword |
  | data_stream.type              | Data stream type.                          | constant_keyword |
  | event.dataset                 | Event dataset                              | constant_keyword |
  | event.module                  | Event module                               | constant_keyword |
  | host.containerized            | If the host is a container.                | boolean          |
  | host.os.build                 | OS build information.                      | keyword          |
  | host.os.codename              | OS codename, if any.                       | keyword          |
  | input.type                    | Input type                                 | keyword          |
  | log.offset                    | Log offset                                 | long             |
  | santa.action                  | Action                                     | keyword          |
  | santa.certificate.common_name | Common name from code signing certificate. | keyword          |
  | santa.certificate.sha256      | SHA256 hash of code signing certificate.   | keyword          |
  | santa.decision                | Decision that santad took.                 | keyword          |
  | santa.disk.appearance         | Timestamp for volume operation.            | date             |
  | santa.disk.bsdname            | The disk BSD name.                         | keyword          |
  | santa.disk.bus                | The disk bus protocol.                     | keyword          |
  | santa.disk.dmgpath            | The DMG (disk image) path.                 | keyword          |
  | santa.disk.fs                 | The disk volume kind (filesystem type).    | keyword          |
  | santa.disk.model              | The disk model.                            | keyword          |
  | santa.disk.mount              | The disk volume path.                      | keyword          |
  | santa.disk.serial             | The disk serial number.                    | keyword          |
  | santa.disk.volume             | The volume name.                           | keyword          |
  | santa.event.uid               | Event UID.                                 | keyword          |
  | santa.event.user              | Event user.                                | keyword          |
  | santa.explain                 | Further details for the decision.          | keyword          |
  | santa.graphical_session_id    | The graphical session ID.                  | long             |
  | santa.mode                    | Operating mode of Santa.                   | keyword          |
  | santa.pidversion              | macOS process identity version.            | long             |
  | santa.reason                  | Reason for the decision.                   | keyword          |
  | santa.team_id                 | Team ID.                                   | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![kibana santa log overview](https://epr.elastic.co/package/santa/3.24.0/img/kibana-santa-log-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **3.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                                        | 8.13.0                 |
  | **3.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **3.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **3.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11299))Update ingest pipeline to avoid failures with unexpected log formats.                                                                                                    | 8.13.0                 |
  | **3.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **3.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11048))Add support for team ID field.                                                                                                                                           | 8.13.0                 |
  | **3.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **3.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9403))Update manifest format version to v3.0.3.                                                                                                                                 | 8.7.1                  |
  | **3.16.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **3.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.7.1                  |
  | **3.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **3.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **3.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **3.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **3.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **3.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **3.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6910))Convert dashboards to Lens.                                                                                                                                               | 8.7.1                  |
  | **3.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6855))Update to package-spec 2.9.0.                                                                                                                                             | 8.1.0                  |
  | **3.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6663))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.1.0                  |
  | **3.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.1.0                  |
  | **3.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.1.0                  |
  | **3.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.1.0                  |
  | **3.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.1.0                  |
  | **3.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4516))Migrate the visualizations to by value in dashboards to minimize the saved object clutter and reduce time to load                                                         | 8.1.0                  |
  | **3.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.17.0            |
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3869))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.17.0            |
  | **3.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.17.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.17.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3373))Add `process.entity_id` field.                                                                                                                                            | 8.0.07.17.0            |
  | **3.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3347))Update log format to support the GA releases of Santa. The pre-GA Santa log format (circa 2017) is no longer accepted.                                                    |                        |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                         | 8.0.07.17.0            |
  | **2.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.17.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2437))Update to ECS 8.0**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2437))process.ppid replaced with process.parent.pid (breaking change)  | 8.0.07.17.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2260))Add 8.0.0 version constraint                                                                                                                                              | 8.0.07.16.0            |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2088))Uniform with guidelines                                                                                                                                                   | 7.16.0                 |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1984))Update Title and Description.                                                                                                                                             | 7.16.0                 |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1848))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1718))make GA                                                                                                                                                                   |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1676))Update to ECS 1.12.0                                                                                                                                                      |                        |
  | **0.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1502))Convert to generated ECS fields                                                                                                                                           |                        |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1416))update to ECS 1.11.0                                                                                                                                                      |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                            |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1273))Set "event.module" and "event.dataset"                                                                                                                                    |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1100))update to ECS 1.10.0 and adding event.original options                                                                                                                    |                        |
  | **0.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/868))update to ECS 1.9.0                                                                                                                                                        |                        |
  | **0.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/740))Fix compatibility with Kibana                                                                                                                                              |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/440))initial release                                                                                                                                                            |                        |
</dropdown>