﻿---
title: Qualys Vulnerability Management, Detection and Response (VMDR)
description: This Qualys VMDR integration is a cloud-based service that gives you immediate, global visibility into where your IT systems might be vulnerable to the...
url: https://www.elastic.co/docs/reference/integrations/qualys_vmdr
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Qualys Vulnerability Management, Detection and Response (VMDR)
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 6.15.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.08.19.0                     |

This [Qualys VMDR](https://www.qualys.com/apps/vulnerability-management-detection-response/) integration is a cloud-based service that gives you immediate, global visibility into where your IT systems might be vulnerable to the latest Internet threats and how to protect them. It helps you to continuously identify threats and monitor unexpected changes in your network before they turn into breaches.
The Qualys VMDR integration uses REST API mode to collect data. Elastic Agent fetches data via API endpoints.

## Compatibility

This module has been tested against the latest Qualys VMDR version **v2**.

## Data streams

The Qualys VMDR integration collects data for the following three events:

| Event Type           |
|----------------------|
| Asset Host Detection |
| Knowledge Base       |
| User Activity Log    |

Reference for [Rest APIs](https://qualysguard.qg2.apps.qualys.com/qwebhelp/fo_portal/api_doc/index.htm) of Qualys VMDR.
Starting from Qualys VMDR integration version 6.0, the `Asset Host Detection` data stream includes enriched vulnerabilities data from Qualys Knowledge Base API.

## Requirements


### Agentless-enabled integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

### Permissions


#### Asset host detection


| Role            | Permission                               |
|-----------------|------------------------------------------|
| *Managers*      | All VM scanned hosts in subscription     |
| *Unit Managers* | VM scanned hosts in user’s business unit |
| *Scanners*      | VM scanned hosts in user’s account       |
| *Readers*       | VM scanned hosts in user’s account       |


#### Knowledge base

*Managers*, *Unit Managers*, *Scanners*, *Readers* have permission to download vulnerability data from the KnowledgeBase.

#### User activity log


| Role            | Permission                                    |
|-----------------|-----------------------------------------------|
| *Managers*      | All actions taken by all users                |
| *Unit Managers* | Actions taken by users in their business unit |
| *Scanners*      | Own actions only                              |
| *Readers*       | Own actions only                              |


## Setup


### Collect data through REST API

Assuming that you already have a Qualys user account, to identify your Qualys platform and get the API URL, check the [Qualys documentation](https://www.qualys.com/platform-identification/).
Alternatively, to get the API URL log in to your Qualys account and go to **Help** > **About**. You’ll find your URL under **Security Operations Center (SOC)**.

### Enable the integration in Elastic

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search top bar, type **Qualys VMDR**.
3. Select the **Qualys VMDR** integration and add it.
4. While adding the integration, if you want to collect Asset Host Detection data via REST API, then you have to put the following details:
   - username
- password
- url
- interval
- input parameters
- batch size
   or if you want to collect Knowledge Base data via REST API, then you have to put the following details:
   - username
- password
- url
- initial interval
- interval
- input parameters
   or if you want to collect User Activity log data via REST API, then you have to put the following details:
   - username
- password
- url
- initial interval
- interval
5. Save the integration.

<note>
  By default, the input parameter is set to `action=list`.
</note>


## Data reference


### Asset host detection

This is the `Asset Host Detection` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-12-30T06:25:12.497Z",
      "agent": {
          "ephemeral_id": "83655e80-2729-4332-8ace-457dd3a0bcef",
          "id": "12042b44-811d-4c3e-b827-11cfb8074c86",
          "name": "elastic-agent-48916",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "cloud": {
          "instance": {
              "name": "adfssrvr"
          }
      },
      "data_stream": {
          "dataset": "qualys_vmdr.asset_host_detection",
          "namespace": "83470",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "12042b44-811d-4c3e-b827-11cfb8074c86",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "dataset": "qualys_vmdr.asset_host_detection",
          "id": "11111111",
          "ingested": "2025-12-30T06:25:15Z",
          "kind": "alert",
          "original": "{\"DETECTION_LIST\":{\"AFFECT_RUNNING_KERNEL\":\"0\",\"CVE\":\"CVE-2023-48161,CVE-2024-21208,CVE-2024-21210,CVE-2024-21217,CVE-2024-21235\",\"FIRST_FOUND_DATETIME\":\"2021-02-05T04:50:45Z\",\"IS_DISABLED\":\"0\",\"IS_IGNORED\":\"0\",\"LAST_FIXED_DATETIME\":\"2022-12-14T06:52:57Z\",\"LAST_FOUND_DATETIME\":\"2024-03-08T20:15:41Z\",\"LAST_PROCESSED_DATETIME\":\"2024-03-08T20:15:41Z\",\"LAST_TEST_DATETIME\":\"2024-03-08T20:15:41Z\",\"LAST_UPDATE_DATETIME\":\"2024-03-08T20:15:41Z\",\"LATEST_VULNERABILITY_DETECTION_SOURCE\":\"Cloud Agent\",\"MITRE_TACTIC_ID\":\"TA0008, TA0004\",\"MITRE_TACTIC_NAME\":\"lateral-movement, privilege-escalation\",\"MITRE_TECHNIQUE_ID\":\"T1210, T1068\",\"MITRE_TECHNIQUE_NAME\":\"Exploitation of Remote Services, Exploitation for Privilege Escalation\",\"QDS\":{\"#text\":\"35\",\"severity\":\"LOW\"},\"QDS_FACTORS\":{\"QDS_FACTOR\":[{\"#text\":\"7.7\",\"name\":\"CVSS\"},{\"#text\":\"v3.x\",\"name\":\"CVSS_version\"},{\"#text\":\"0.00232\",\"name\":\"epss\"},{\"#text\":\"AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H\",\"name\":\"CVSS_vector\"}]},\"QID\":\"101\",\"RESULTS\":\"Package\\tInstalled Version\\tRequired Version\\nlinux-cloud-tools-4.4.0\\t1074-aws_4.4.0-1074.84\\t1092\\nlinux-aws-tools-4.4.0\\t1074_4.4.0-1074.84\\t1092\\nlinux-aws-headers-4.4.0\\t1074_4.15.0-1126.135\\t1092\\nlinux-tools-4.4.0\\t1074-aws_4.4.0-1074.84\\t1092\\nlinux-aws-cloud-tools-4.4.0\\t1074_4.4.0-1074.84\\t1092\",\"SEVERITY\":\"3\",\"SSL\":\"0\",\"STATUS\":\"Active\",\"TIMES_FOUND\":\"5393\",\"TRURISK_ELIMINATION_STATUS\":\"FIXED\",\"TYPE\":\"Confirmed\",\"UNIQUE_VULN_ID\":\"11111111\",\"VULNERABILITY_DETECTION_SOURCES\":\"Cloud Agent,Internal Scanner\"},\"DNS\":\"adfssrvr.adfs.local\",\"DNS_DATA\":{\"DOMAIN\":\"adfs.local\",\"FQDN\":\"adfssrvr.adfs.local\",\"HOSTNAME\":\"adfssrvr\"},\"ID\":\"1\",\"IP\":\"10.50.2.111\",\"KNOWLEDGE_BASE\":{\"CATEGORY\":\"CGI\",\"CONSEQUENCE\":\"Depending on the vulnerability being exploited, an unauthenticated remote attacker could conduct cross-site scripting, clickjacking or MIME-type sniffing attacks.\",\"CVE_LIST\":[\"CVE-2022-31629\",\"CVE-2022-31628\"],\"CVSS\":{\"BASE\":{\"#text\":\"7.7\",\"source\":\"service\"},\"TEMPORAL\":\"4.0\",\"VECTOR_STRING\":\"CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H\"},\"DIAGNOSIS\":\"This QID reports the absence of the following\",\"DISCOVERY\":{\"REMOTE\":\"1\"},\"LAST_SERVICE_MODIFICATION_DATETIME\":\"2023-06-29T12:20:46Z\",\"PATCHABLE\":\"0\",\"PCI_FLAG\":\"1\",\"PUBLISHED_DATETIME\":\"2017-06-05T21:34:49Z\",\"QID\":\"101\",\"SEVERITY_LEVEL\":\"2\",\"SOFTWARE_LIST\":{\"SOFTWARE\":[{\"PRODUCT\":\"None\",\"VENDOR\":\"multi-vendor\"}]},\"SOLUTION\":\"\\u003cB\\u003eNote:\\u003c/B\\u003e To better debug the results of this QID\",\"THREAT_INTELLIGENCE\":{\"THREAT_INTEL\":[{\"id\":\"8\"}]},\"TITLE\":\"HTTP Security Header Not Detected\",\"VULN_TYPE\":\"Vulnerability\"},\"LAST_PC_SCANNED_DATE\":\"2023-06-28T09:58:12Z\",\"LAST_SCAN_DATETIME\":\"2023-07-03T06:25:17Z\",\"LAST_VM_SCANNED_DATE\":\"2023-07-03T06:23:47Z\",\"LAST_VM_SCANNED_DURATION\":\"1113\",\"NETBIOS\":\"ADFSSRVR\",\"OS\":\"Windows 2016/2019/10\",\"TRACKING_METHOD\":\"IP\",\"interval_id\":\"47a80f3f-ccfb-45ac-b90e-c0a618bb5bb8\",\"interval_start\":\"2025-12-30T06:25:12.491602751Z\"}",
          "type": [
              "info"
          ]
      },
      "host": {
          "domain": "ADFSSRVR",
          "hostname": "adfssrvr",
          "id": "1",
          "ip": [
              "10.50.2.111"
          ],
          "name": "adfssrvr.adfs.local",
          "os": {
              "full": "Windows 2016/2019/10",
              "platform": "windows",
              "type": "windows"
          }
      },
      "input": {
          "type": "cel"
      },
      "observer": {
          "vendor": "Qualys VMDR"
      },
      "package": {
          "fixed_version": [
              "1092",
              "1092",
              "1092",
              "1092",
              "1092"
          ],
          "name": [
              "linux-cloud-tools-4.4.0",
              "linux-aws-tools-4.4.0",
              "linux-aws-headers-4.4.0",
              "linux-tools-4.4.0",
              "linux-aws-cloud-tools-4.4.0"
          ],
          "version": [
              "1074-aws_4.4.0-1074.84",
              "1074_4.4.0-1074.84",
              "1074_4.15.0-1126.135",
              "1074-aws_4.4.0-1074.84",
              "1074_4.4.0-1074.84"
          ]
      },
      "qualys_vmdr": {
          "asset_host_detection": {
              "dns": "adfssrvr.adfs.local",
              "dns_data": {
                  "domain": "adfs.local",
                  "fqdn": "adfssrvr.adfs.local",
                  "hostname": "adfssrvr"
              },
              "id": "1",
              "interval_id": "47a80f3f-ccfb-45ac-b90e-c0a618bb5bb8",
              "interval_start": "2025-12-30T06:25:12.491Z",
              "ip": "10.50.2.111",
              "knowledge_base": {
                  "category": "CGI",
                  "consequence": {
                      "value": "Depending on the vulnerability being exploited, an unauthenticated remote attacker could conduct cross-site scripting, clickjacking or MIME-type sniffing attacks."
                  },
                  "cve_list": [
                      "CVE-2022-31629",
                      "CVE-2022-31628"
                  ],
                  "cvss": {
                      "base_obj": {
                          "#text": "7.7",
                          "source": "service"
                      },
                      "temporal": "4.0",
                      "vector_string": "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H"
                  },
                  "diagnosis": {
                      "value": "This QID reports the absence of the following"
                  },
                  "discovery": {
                      "remote": 1
                  },
                  "last": {
                      "service_modification_datetime": "2023-06-29T12:20:46.000Z"
                  },
                  "patchable": false,
                  "pci_flag": true,
                  "published_datetime": "2017-06-05T21:34:49.000Z",
                  "qid": "101",
                  "severity_level": "Medium",
                  "software_list": [
                      {
                          "product": "None",
                          "vendor": "multi-vendor"
                      }
                  ],
                  "solution": {
                      "value": "<B>Note:</B> To better debug the results of this QID"
                  },
                  "threat_intelligence": {
                      "intel": [
                          {
                              "id": "8"
                          }
                      ]
                  },
                  "title": "HTTP Security Header Not Detected",
                  "vuln_type": "Vulnerability"
              },
              "last_pc_scanned_date": "2023-06-28T09:58:12.000Z",
              "last_scan_datetime": "2023-07-03T06:25:17.000Z",
              "last_vm_scanned_date": "2023-07-03T06:23:47.000Z",
              "last_vm_scanned_duration": 1113,
              "netbios": "ADFSSRVR",
              "os": "Windows 2016/2019/10",
              "package_nested": [
                  {
                      "fixed_version": "1092",
                      "name": "linux-cloud-tools-4.4.0",
                      "version": "1074-aws_4.4.0-1074.84"
                  },
                  {
                      "fixed_version": "1092",
                      "name": "linux-aws-tools-4.4.0",
                      "version": "1074_4.4.0-1074.84"
                  },
                  {
                      "fixed_version": "1092",
                      "name": "linux-aws-headers-4.4.0",
                      "version": "1074_4.15.0-1126.135"
                  },
                  {
                      "fixed_version": "1092",
                      "name": "linux-tools-4.4.0",
                      "version": "1074-aws_4.4.0-1074.84"
                  },
                  {
                      "fixed_version": "1092",
                      "name": "linux-aws-cloud-tools-4.4.0",
                      "version": "1074_4.4.0-1074.84"
                  }
              ],
              "tracking_method": "IP",
              "vulnerability": {
                  "affect_running_kernel": "0",
                  "cve": [
                      "CVE-2023-48161",
                      "CVE-2024-21208",
                      "CVE-2024-21210",
                      "CVE-2024-21217",
                      "CVE-2024-21235"
                  ],
                  "first_found_datetime": "2021-02-05T04:50:45.000Z",
                  "is_disabled": false,
                  "is_ignored": false,
                  "last_fixed_datetime": "2022-12-14T06:52:57.000Z",
                  "last_found_datetime": "2024-03-08T20:15:41.000Z",
                  "last_processed_datetime": "2024-03-08T20:15:41.000Z",
                  "last_test_datetime": "2024-03-08T20:15:41.000Z",
                  "last_update_datetime": "2024-03-08T20:15:41.000Z",
                  "latest_vulnerability_detection_source": "Cloud Agent",
                  "mitre_tactic_id": [
                      "TA0008",
                      "TA0004"
                  ],
                  "mitre_tactic_name": [
                      "lateral-movement",
                      "privilege-escalation"
                  ],
                  "mitre_technique_id": [
                      "T1210",
                      "T1068"
                  ],
                  "mitre_technique_name": [
                      "Exploitation of Remote Services",
                      "Exploitation for Privilege Escalation"
                  ],
                  "qds": {
                      "score": 35,
                      "severity": "LOW"
                  },
                  "qds_factors": [
                      {
                          "name": "CVSS",
                          "text": "7.7"
                      },
                      {
                          "name": "CVSS_version",
                          "text": "v3.x"
                      },
                      {
                          "name": "epss",
                          "text": "0.00232"
                      },
                      {
                          "name": "CVSS_vector",
                          "text": "AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H"
                      }
                  ],
                  "qid": 101,
                  "results": "Package||Installed Version||Required Version;;linux-cloud-tools-4.4.0||1074-aws_4.4.0-1074.84||1092;;linux-aws-tools-4.4.0||1074_4.4.0-1074.84||1092;;linux-aws-headers-4.4.0||1074_4.15.0-1126.135||1092;;linux-tools-4.4.0||1074-aws_4.4.0-1074.84||1092;;linux-aws-cloud-tools-4.4.0||1074_4.4.0-1074.84||1092",
                  "severity": 3,
                  "ssl": "0",
                  "status": "Active",
                  "times_found": 5393,
                  "trurisk_elimination_status": "FIXED",
                  "type": "Confirmed",
                  "unique_vuln_id": "11111111",
                  "vulnerability_detection_sources": [
                      "Cloud Agent",
                      "Internal Scanner"
                  ]
              }
          }
      },
      "related": {
          "hosts": [
              "adfssrvr",
              "adfssrvr.adfs.local",
              "1",
              "ADFSSRVR"
          ],
          "ip": [
              "10.50.2.111"
          ]
      },
      "resource": {
          "id": "1",
          "name": "adfssrvr.adfs.local"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "qualys_vmdr-asset_host_detection",
          "provider_cloud_data"
      ],
      "vulnerability": {
          "category": [
              "CGI"
          ],
          "classification": "CVSS",
          "description": "This QID reports the absence of the following",
          "enumeration": "CVE",
          "id": [
              "CVE-2022-31629",
              "CVE-2022-31628"
          ],
          "package": {
              "fixed_version": [
                  "1092",
                  "1092",
                  "1092",
                  "1092",
                  "1092"
              ],
              "name": [
                  "linux-cloud-tools-4.4.0",
                  "linux-aws-tools-4.4.0",
                  "linux-aws-headers-4.4.0",
                  "linux-tools-4.4.0",
                  "linux-aws-cloud-tools-4.4.0"
              ],
              "version": [
                  "1074-aws_4.4.0-1074.84",
                  "1074_4.4.0-1074.84",
                  "1074_4.15.0-1126.135",
                  "1074-aws_4.4.0-1074.84",
                  "1074_4.4.0-1074.84"
              ]
          },
          "reference": [
              "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-31629",
              "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-31628"
          ],
          "scanner": {
              "vendor": "Qualys"
          },
          "score": {
              "base": 7.7,
              "version": "3.1"
          },
          "severity": "High",
          "title": "HTTP Security Header Not Detected"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                                     | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                                                                            | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                                                          | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                                                               | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                                                                  | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                                                                   | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                                                                                     | Type of filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                                                                                     | Log offset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | observer.vendor                                                                                | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | package.fixed_version                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.asset_id                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.cloud_provider                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.cloud_provider_tags.cloud_tag.last_success_date               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.cloud_provider_tags.cloud_tag.name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.cloud_provider_tags.cloud_tag.value                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.cloud_resource_id                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.cloud_service                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.dns                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.dns_data.domain                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.dns_data.fqdn                                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.dns_data.hostname                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.ec2_instance_id                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.id                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.interval_id                                                   | The universally unique identifier (UUID) values will change with each interval of ingestion.                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | qualys_vmdr.asset_host_detection.interval_start                                                | The start time of the interval of ingestion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | date             |
  | qualys_vmdr.asset_host_detection.ip                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | qualys_vmdr.asset_host_detection.ipv6                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | ip               |
  | qualys_vmdr.asset_host_detection.knowledge_base.automatic_pci_fail                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.bugtraq_list.id                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.bugtraq_list.url                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.category                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.changelog_list.info.change_date                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.knowledge_base.changelog_list.info.comments                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.compliance_list.description                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.compliance_list.section                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.compliance_list.type                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.consequence.comment                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.consequence.value                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.exploits.explt_src.list.explt.desc |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.exploits.explt_src.list.explt.link |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.exploits.explt_src.list.explt.ref  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.exploits.explt_src.name            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.alias        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.id           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.link         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.platform     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.rating       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.list.info.type         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.correlation.malware.src.name                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cve_list                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.access.complexity                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.access.vector                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.authentication                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.base                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.base_obj                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | flattened        |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.exploitability                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.impact.availability                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.impact.confidentiality                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.impact.integrity                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.remediation_level                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.report_confidence                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.temporal                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss.vector_string                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.attack.complexity                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.attack.vector                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.base                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.exploit_code_maturity                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.impact.availability                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.impact.confidentiality                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.impact.integrity                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.privileges_required                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.remediation_level                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.report_confidence                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.scope                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.temporal                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.user_interaction                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.vector_string                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.cvss_v3.version                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.detection_info                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.diagnosis.comment                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | qualys_vmdr.asset_host_detection.knowledge_base.diagnosis.value                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | qualys_vmdr.asset_host_detection.knowledge_base.discovery.additional_info                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.discovery.auth_type_list.value                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.discovery.remote                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.knowledge_base.error                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.id_range                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.ids                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.is_disabled                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | qualys_vmdr.asset_host_detection.knowledge_base.last.customization.datetime                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.knowledge_base.last.customization.user_login                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.last.service_modification_datetime             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.knowledge_base.patch_published_date                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.knowledge_base.patchable                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | qualys_vmdr.asset_host_detection.knowledge_base.pci_flag                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | qualys_vmdr.asset_host_detection.knowledge_base.pci_reasons.value                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.published_datetime                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.knowledge_base.qid                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.severity_level                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.software_list.product                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.software_list.vendor                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.solution.comment                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | qualys_vmdr.asset_host_detection.knowledge_base.solution.value                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | qualys_vmdr.asset_host_detection.knowledge_base.supported_modules                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.threat_intelligence.intel.id                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.threat_intelligence.intel.text                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.title                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.vendor_reference_list.id                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.vendor_reference_list.url                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.knowledge_base.vuln_type                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.last_pc_scanned_date                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.last_scan_datetime                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.last_vm_auth_scanned_date                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.last_vm_auth_scanned_duration                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.last_vm_scanned_date                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.last_vm_scanned_duration                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.last.error.date                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.last.error.value                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.last.status                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.last.success_date                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.name                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.alicloud.attribute.value                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.last.error.date                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.last.error.value                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.last.status                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.last.success_date                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.name                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.azure.attribute.value                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.last.error.date                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.last.error.value                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.last.status                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.last.success_date                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.name                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.ec2.attribute.value                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.last.error.date                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.last.error.value                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.last.status                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.last.success_date                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.name                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.metadata.google.attribute.value                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.netbios                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.network_id                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.os                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.os_cpe                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.package_nested                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | nested           |
  | qualys_vmdr.asset_host_detection.package_nested.fixed_version                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.package_nested.name                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.package_nested.version                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.qg_hostid                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.tags.background_color                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.tags.color                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.tags.id                                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.tags.name                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.tracking_method                                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.affect_exploitable_config                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.affect_running_kernel                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.affect_running_service                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.asset_cve                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.cve                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.first_found_datetime                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.first_reopened_datetime                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.fqdn                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.instance                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.is_disabled                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | qualys_vmdr.asset_host_detection.vulnerability.is_ignored                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | qualys_vmdr.asset_host_detection.vulnerability.last_fixed_datetime                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.last_found_datetime                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.last_processed_datetime                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.last_reopened_datetime                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.last_test_datetime                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.last_update_datetime                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.asset_host_detection.vulnerability.latest_vulnerability_detection_source           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.mitre_tactic_id                                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.mitre_tactic_name                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.mitre_technique_id                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.mitre_technique_name                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.port                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.vulnerability.protocol                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.qds.score                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          |
  | qualys_vmdr.asset_host_detection.vulnerability.qds.severity                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.qds_factors.name                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.qds_factors.text                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.qid                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          |
  | qualys_vmdr.asset_host_detection.vulnerability.results                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.service                                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.severity                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.vulnerability.ssl                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.status                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.times_found                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.vulnerability.times_reopened                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | qualys_vmdr.asset_host_detection.vulnerability.trurisk_elimination_status                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.type                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.unique_vuln_id                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.asset_host_detection.vulnerability.vulnerability_detection_sources                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.id                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.name                                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | vulnerability.package.fixed_version                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | vulnerability.package.name                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | vulnerability.package.version                                                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | vulnerability.scanner.vendor                                                                   | The name of the vulnerability scanner vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | vulnerability.title                                                                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


### Knowledge base

This is the `Knowledge Base` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-06-29T12:20:46.000Z",
      "agent": {
          "ephemeral_id": "98b85997-99e2-41ee-bb02-6532fae2b357",
          "id": "706ea693-7cbe-44f8-902f-ee169e228005",
          "name": "elastic-agent-80703",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "data_stream": {
          "dataset": "qualys_vmdr.knowledge_base",
          "namespace": "60071",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "706ea693-7cbe-44f8-902f-ee169e228005",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "dataset": "qualys_vmdr.knowledge_base",
          "id": "2",
          "ingested": "2025-12-29T10:51:56Z",
          "kind": "alert",
          "original": "{\"BUGTRAQ_LIST\":{\"BUGTRAQ\":[{\"ID\":\"9821\",\"URL\":\"https://url.com/bid/9821\"}]},\"CATEGORY\":\"CGI\",\"CONSEQUENCE\":\"Depending on the vulnerability being exploited, an unauthenticated remote attacker could conduct cross-site scripting, clickjacking or MIME-type sniffing attacks.\",\"CVE_LIST\":[\"CVE-2022-31629\",\"CVE-2022-31628\"],\"DIAGNOSIS\":\"This QID reports the absence of the following\",\"DISCOVERY\":{\"REMOTE\":\"1\"},\"LAST_SERVICE_MODIFICATION_DATETIME\":\"2023-06-29T12:20:46Z\",\"PATCHABLE\":\"0\",\"PCI_FLAG\":\"1\",\"PUBLISHED_DATETIME\":\"2017-06-05T21:34:49Z\",\"QID\":\"2\",\"SEVERITY_LEVEL\":\"2\",\"SOFTWARE_LIST\":{\"SOFTWARE\":[{\"PRODUCT\":\"fusion\",\"VENDOR\":\"vmware\"}]},\"SOLUTION\":\"\\u003cB\\u003eNote:\\u003c/B\\u003e To better debug the results of this QID\",\"THREAT_INTELLIGENCE\":{\"THREAT_INTEL\":[{\"#text\":\"No_Patch\",\"id\":\"8\"}]},\"TITLE\":\"HTTP Security Header Not Detected\",\"VENDOR_REFERENCE_LIST\":{\"VENDOR_REFERENCE\":[{\"ID\":\"VMSA-2024-0010\",\"URL\":\"https://support.broadcom.com/web/ecx/support-content-notification/-/external/content/SecurityAdvisories/0/24280\"}]},\"VULN_TYPE\":\"Vulnerability\"}",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "qualys_vmdr": {
          "knowledge_base": {
              "bugtraq_list": [
                  {
                      "id": "9821",
                      "url": "https://url.com/bid/9821"
                  }
              ],
              "category": "CGI",
              "consequence": {
                  "value": "Depending on the vulnerability being exploited, an unauthenticated remote attacker could conduct cross-site scripting, clickjacking or MIME-type sniffing attacks."
              },
              "cve_list": [
                  "CVE-2022-31629",
                  "CVE-2022-31628"
              ],
              "diagnosis": {
                  "value": "This QID reports the absence of the following"
              },
              "discovery": {
                  "remote": 1
              },
              "last": {
                  "service_modification_datetime": "2023-06-29T12:20:46.000Z"
              },
              "patchable": false,
              "pci_flag": true,
              "published_datetime": "2017-06-05T21:34:49.000Z",
              "qid": "2",
              "severity_level": "2",
              "software_list": [
                  {
                      "product": "fusion",
                      "vendor": "vmware"
                  }
              ],
              "solution": {
                  "value": "<B>Note:</B> To better debug the results of this QID"
              },
              "threat_intelligence": {
                  "intel": [
                      {
                          "id": "8",
                          "text": "No_Patch"
                      }
                  ]
              },
              "title": "HTTP Security Header Not Detected",
              "vendor_reference_list": [
                  {
                      "id": "VMSA-2024-0010",
                      "url": "https://support.broadcom.com/web/ecx/support-content-notification/-/external/content/SecurityAdvisories/0/24280"
                  }
              ],
              "vuln_type": "Vulnerability"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "qualys_vmdr-knowledge_base"
      ],
      "vulnerability": {
          "category": [
              "CGI"
          ],
          "id": [
              "CVE-2022-31629",
              "CVE-2022-31628"
          ],
          "severity": "Medium"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                     | Description             | Type             |
  |---------------------------------------------------------------------------|-------------------------|------------------|
  | @timestamp                                                                | Event timestamp.        | date             |
  | data_stream.dataset                                                       | Data stream dataset.    | constant_keyword |
  | data_stream.namespace                                                     | Data stream namespace.  | constant_keyword |
  | data_stream.type                                                          | Data stream type.       | constant_keyword |
  | event.dataset                                                             | Event dataset.          | constant_keyword |
  | event.module                                                              | Event module.           | constant_keyword |
  | input.type                                                                | Type of filebeat input. | keyword          |
  | log.offset                                                                | Log offset.             | long             |
  | qualys_vmdr.knowledge_base.automatic_pci_fail                             |                         | keyword          |
  | qualys_vmdr.knowledge_base.bugtraq_list.id                                |                         | keyword          |
  | qualys_vmdr.knowledge_base.bugtraq_list.url                               |                         | keyword          |
  | qualys_vmdr.knowledge_base.category                                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.changelog_list.info.change_date                |                         | date             |
  | qualys_vmdr.knowledge_base.changelog_list.info.comments                   |                         | keyword          |
  | qualys_vmdr.knowledge_base.compliance_list.description                    |                         | keyword          |
  | qualys_vmdr.knowledge_base.compliance_list.section                        |                         | keyword          |
  | qualys_vmdr.knowledge_base.compliance_list.type                           |                         | keyword          |
  | qualys_vmdr.knowledge_base.consequence.comment                            |                         | keyword          |
  | qualys_vmdr.knowledge_base.consequence.value                              |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.exploits.explt_src.list.explt.desc |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.exploits.explt_src.list.explt.link |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.exploits.explt_src.list.explt.ref  |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.exploits.explt_src.name            |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.alias        |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.id           |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.link         |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.platform     |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.rating       |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.list.info.type         |                         | keyword          |
  | qualys_vmdr.knowledge_base.correlation.malware.src.name                   |                         | keyword          |
  | qualys_vmdr.knowledge_base.cve_list                                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.access.complexity                         |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.access.vector                             |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.authentication                            |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.base                                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.base_obj                                  |                         | flattened        |
  | qualys_vmdr.knowledge_base.cvss.exploitability                            |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.impact.availability                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.impact.confidentiality                    |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.impact.integrity                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.remediation_level                         |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.report_confidence                         |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.temporal                                  |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss.vector_string                             |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.attack.complexity                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.attack.vector                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.base                                   |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.exploit_code_maturity                  |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.impact.availability                    |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.impact.confidentiality                 |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.impact.integrity                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.privileges_required                    |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.remediation_level                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.report_confidence                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.scope                                  |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.temporal                               |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.user_interaction                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.vector_string                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.cvss_v3.version                                |                         | keyword          |
  | qualys_vmdr.knowledge_base.detection_info                                 |                         | keyword          |
  | qualys_vmdr.knowledge_base.diagnosis.comment                              |                         | match_only_text  |
  | qualys_vmdr.knowledge_base.diagnosis.value                                |                         | match_only_text  |
  | qualys_vmdr.knowledge_base.discovery.additional_info                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.discovery.auth_type_list.value                 |                         | keyword          |
  | qualys_vmdr.knowledge_base.discovery.remote                               |                         | long             |
  | qualys_vmdr.knowledge_base.error                                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.id_range                                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.ids                                            |                         | keyword          |
  | qualys_vmdr.knowledge_base.is_disabled                                    |                         | boolean          |
  | qualys_vmdr.knowledge_base.last.customization.datetime                    |                         | date             |
  | qualys_vmdr.knowledge_base.last.customization.user_login                  |                         | keyword          |
  | qualys_vmdr.knowledge_base.last.service_modification_datetime             |                         | date             |
  | qualys_vmdr.knowledge_base.patch_published_date                           |                         | date             |
  | qualys_vmdr.knowledge_base.patchable                                      |                         | boolean          |
  | qualys_vmdr.knowledge_base.pci_flag                                       |                         | boolean          |
  | qualys_vmdr.knowledge_base.pci_reasons.value                              |                         | keyword          |
  | qualys_vmdr.knowledge_base.published_datetime                             |                         | date             |
  | qualys_vmdr.knowledge_base.qid                                            |                         | keyword          |
  | qualys_vmdr.knowledge_base.severity_level                                 |                         | keyword          |
  | qualys_vmdr.knowledge_base.software_list.product                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.software_list.vendor                           |                         | keyword          |
  | qualys_vmdr.knowledge_base.solution.comment                               |                         | match_only_text  |
  | qualys_vmdr.knowledge_base.solution.value                                 |                         | match_only_text  |
  | qualys_vmdr.knowledge_base.supported_modules                              |                         | keyword          |
  | qualys_vmdr.knowledge_base.threat_intelligence.intel.id                   |                         | keyword          |
  | qualys_vmdr.knowledge_base.threat_intelligence.intel.text                 |                         | keyword          |
  | qualys_vmdr.knowledge_base.title                                          |                         | keyword          |
  | qualys_vmdr.knowledge_base.vendor_reference_list.id                       |                         | keyword          |
  | qualys_vmdr.knowledge_base.vendor_reference_list.url                      |                         | keyword          |
  | qualys_vmdr.knowledge_base.vuln_type                                      |                         | keyword          |
</dropdown>


### User activity

This is the `User Activity` dataset. It connects to an [API](https://docs.qualys.com/en/vm/api/users/index.htm#t=activity%2Fexport_activity.htm)
that exports the user activity log.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-01-18T12:45:24.000Z",
      "agent": {
          "ephemeral_id": "8541dd66-de0a-4e54-a66e-3f9dc02867df",
          "id": "3acf31e6-1468-482c-b38b-d3b7397270dd",
          "name": "elastic-agent-32349",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "qualys_vmdr.user_activity",
          "namespace": "28709",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "3acf31e6-1468-482c-b38b-d3b7397270dd",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "action": "request",
          "agent_id_status": "verified",
          "category": [
              "api"
          ],
          "dataset": "qualys_vmdr.user_activity",
          "ingested": "2024-09-25T21:52:05Z",
          "kind": "event",
          "original": "{\"Action\":\"request\",\"Date\":\"2024-01-18T12:45:24Z\",\"Details\":\"API: /api/2.0/fo/activity_log/index.php\",\"Module\":\"auth\",\"User IP\":\"10.113.195.136\",\"User Name\":\"john\",\"User Role\":\"Reader\"}",
          "provider": "auth",
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "cel"
      },
      "message": "API: /api/2.0/fo/activity_log/index.php",
      "qualys_vmdr": {
          "user_activity": {
              "Action": "request",
              "Date": "2024-01-18T12:45:24Z",
              "Details": "API: /api/2.0/fo/activity_log/index.php",
              "Module": "auth",
              "User_IP": "10.113.195.136",
              "User_Name": "john",
              "User_Role": "Reader"
          }
      },
      "related": {
          "ip": [
              "10.113.195.136"
          ],
          "user": [
              "john"
          ]
      },
      "source": {
          "ip": "10.113.195.136"
      },
      "tags": [
          "preserve_duplicate_custom_fields",
          "preserve_original_event",
          "forwarded",
          "qualys_vmdr-user_activity"
      ],
      "user": {
          "name": "john",
          "roles": [
              "Reader"
          ]
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                 | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace               | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                    | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                       | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                        | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                          | Type of filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | qualys_vmdr.user_activity.Action    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.user_activity.Date      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | qualys_vmdr.user_activity.Details   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.user_activity.Module    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.user_activity.User_IP   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.user_activity.User_Name |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | qualys_vmdr.user_activity.User_Role |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Qualys VMDR Asset Host Detection Dashboard Screenshot](https://epr.elastic.co/package/qualys_vmdr/6.15.0/img/qualys-vmdr-asset-host-detection-dashboard.png)

  ![Qualys VMDR Knowledge Base Dashboard Screenshot](https://epr.elastic.co/package/qualys_vmdr/6.15.0/img/qualys-vmdr-knowledge-base-dashboard.png)

  ![Qualys VMDR User Activity Dashboard Screenshot](https://epr.elastic.co/package/qualys_vmdr/6.15.0/img/qualys-vmdr-user-activity-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **6.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16727))Update knowledge base API to v4 for asset_host_detection and knowledge_base data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.08.19.0            |
  | **6.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16623))Update XSD schema name to match Host Detection API v5.0 response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.1.08.19.0            |
  | **6.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16436))Add support for Host Detection API v5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.08.19.0            |
  | **6.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16146))Add cloudsecurity_cdr sub category label                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.08.19.0            |
  | **6.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15890))Allow user configuration of `/api/3.0/fo/knowledge_base/vuln/` request limits.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.08.19.0            |
  | **6.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15840))Improve handling of host query lists in asset_host_detection data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.08.19.0            |
  | **6.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out documents containing an error.message from vulnerability latest index.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.1.08.19.0            |
  | **6.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` sub category label.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.1.08.19.0            |
  | **6.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14899))Implement X-RateLimit header handling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.1.08.19.0            |
  | **6.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14791))Update the logic for populating the `vulnerability.score.base`, `vulnerability.score.version`, and `vulnerability.severity` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.1.08.19.0            |
  | **6.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14393))Use `terminate` processor instead of `fail` processor to handle agent errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.1.08.19.0            |
  | **6.7.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14014))Remove duplicated installation instructions from the documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.1.08.19.0            |
  | **6.7.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.1.08.19.0            |
  | **6.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14175))Prevent sending requests with an empty `ids` parameter to the knowledge_base API in asset_host_detection datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.1.08.19.0            |
  | **6.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13840))Enhance the data collection of the `asset_host_detection` data stream to generate unique identifiers for each interval of ingestion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.1.08.19.0            |
  | **6.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.1.08.19.0            |
  | **6.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13455))Add latest transform for Host Detections.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.08.19.0            |
  | **6.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13344))Update to v3 API for asset and knowledge_base data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 9.0.08.18.0            |
  | **6.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13203))Add agentless deployment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.0            |
  | **6.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13168))Fix `event.category` for Qualys vulnerabilities.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.16.0            |
  | **6.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13035))Enable request trace log removal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.16.0            |
  | **6.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12997))Added description to ssl nodes in package manifest.yml file to including links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.16.0            |
  | **6.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12969))Fix package_nested field in asset data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.16.0            |
  | **6.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.16.0            |
  | **6.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12734))Tolerate missing version details in asset_host_detection vulnerability results.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.16.0                 |
  | **6.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11999))Mapping changes in asset_host_detection for Cloud Detection and Response (CDR) workflows.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.16.0                 |
  | **5.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12428))Add "show_igs" UI option that allows users to fetch detections records with `Information Gathered`.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12428))Added fingerprint processor to avoid duplicate detections from same host, same QID, and scan datetime.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **5.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **5.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **5.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12092))Handle empty XML responses in Qualys asset_host_detection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **5.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **5.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12009))Capture error with decode_xml.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **5.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12006))Truncate very long field values.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **5.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11927))Document required user role permissions to each API.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11927))Cleanup duplicate processors in asset host detection.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11927))Remove stale kibana.version requirement from README                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **5.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11877))Handle _LIST fields as array in knowledge_base data-stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **5.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **5.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11248))Retain event.original for asset_host_detection and knowledge_base as JSON.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **5.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11100))Set `vulnerability.score.base` field based on the item *CVSS* item under field `qualys_vmdr.asset_host_detection.vulnerability.qds_factors`**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11100))Set `vulnerability.classification` field to *CVSS***Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11100))Set `vulnerability.severity` field based on `vulnerability.score.base`**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11100))Set `vulnerability.scanner.vendor` field to *Qualys***Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11100))Set `vulnerability.score.version` field based on the item *CVSS_vector* item under field `qualys_vmdr.asset_host_detection.vulnerability.qds_factors` | 8.13.0                 |
  | **5.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10966))Rename fields to match Qualys name.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10966))Convert numeric fields to long/integer.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10966))Lowercase `cloud.provider` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **4.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10658))Allow user configuration of cloud metadata collection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **4.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10759))Ensure last_modified_after query parameter is in the correct format.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **4.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10677))Fix CEL access to unset state.params in knowledge_base.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **4.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10605))Map cloud provider metadata to cloud fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **4.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10477))Fix handling of the activity_log API response body.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **4.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10170))Check the HTTP status code before processing the response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **4.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10374))Reduce severity of error from documents lacking response IDs in knowledge base.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **4.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10320))Use field names matching Qualys names.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **3.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10346))Improve error reporting for API request failures.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **3.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10188))Fix date format to match user activity API behaviour.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                 |
  | **3.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10035))Disable the new user activity data stream by default. Add a toggle to preserve original event to the user activity data stream. Format the since_datetime query parameter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10017))Add new data stream for collecting user activity logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10003))Allow original event preservation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.12.0                 |
  | **3.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9375))Expand documents to map each CVS per vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.12.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9371))Increase request timeout default and document timeout length warning.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9293))Expand documents to map each vulnerability per host.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                 |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.9.0                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8833))Release package as GA.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.9.0                  |
  | **0.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8507))Fix mapping of vulnerability type and severity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8290))Add request tracer logging to integration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8297))Handle invalid input parameter for Knowledge Base data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7961))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **0.2.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7623))Update data collection of knowledge base data stream to handle different log format.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6872))Initial Release.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
</dropdown>