﻿---
title: QNAP NAS
description: The QNAP NAS integration collects Event and Access logs from QNAP NAS devices. The log dataset receives QNAP NAS Event and Access logs over the syslog...
url: https://www.elastic.co/docs/reference/integrations/qnap_nas
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# QNAP NAS
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.24.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | Network Protocol                |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |

The QNAP NAS integration collects Event and Access logs from [QNAP NAS](https://www.qnap.com/en/) devices.

## Log

The `log` dataset receives QNAP NAS Event and Access logs over the syslog protocol. This has been tested with QTS 4.5.4 but is expected to work with new versions.  This integration is only compatible with the "Send to Syslog Server" option which uses the RFC-3164 syslog format. Both Event and Access events are supported. All protocols; UDP, TCP, TLS are supported.

### Example event

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-30T20:24:24.000Z",
      "agent": {
          "ephemeral_id": "d78177be-a52f-47d7-ab88-ce74c24bde53",
          "id": "8ad7c85d-9943-4b05-b50f-ccab228ad581",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.1.0"
      },
      "data_stream": {
          "dataset": "qnap_nas.log",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "8ad7c85d-9943-4b05-b50f-ccab228ad581",
          "snapshot": false,
          "version": "8.1.0"
      },
      "event": {
          "action": "create-directory",
          "agent_id_status": "verified",
          "category": [
              "file"
          ],
          "created": "2022-10-30T20:24:24.000Z",
          "dataset": "qnap_nas.log",
          "ingested": "2022-11-24T09:21:53Z",
          "kind": "event",
          "provider": "conn-log",
          "timezone": "+00:00",
          "type": [
              "creation"
          ]
      },
      "file": {
          "path": "path/to/files/New folder"
      },
      "host": {
          "name": "qnap-nas01"
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.24.0.4:35244"
          },
          "syslog": {
              "priority": 30
          }
      },
      "observer": {
          "product": "NAS",
          "type": "nas",
          "vendor": "QNAP"
      },
      "process": {
          "name": "qulogd",
          "pid": 14629
      },
      "qnap": {
          "nas": {
              "connection_type": "Samba",
              "file": {
                  "path": "path/to/files/New folder"
              }
          }
      },
      "related": {
          "hosts": [
              "user-laptop"
          ],
          "ip": [
              "10.50.36.33"
          ],
          "user": [
              "admin.user"
          ]
      },
      "source": {
          "address": "10.50.36.33",
          "domain": "user-laptop",
          "ip": "10.50.36.33"
      },
      "tags": [
          "qnap-nas",
          "forwarded"
      ],
      "user": {
          "name": "admin.user"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |----------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                       | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | date             |
  | data_stream.dataset              | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace            | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.type                 | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | ecs.version                      | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                    | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.action                     | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | event.created                    | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                    | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.ingested                   | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.module                     | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.original                   | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                   | keyword          |
  | event.timezone                   | This field should be populated when the event's timestamp does not include timezone information already (e.g. default Syslog timestamps). It's optional otherwise. Acceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").                                                                                                                                                                                                                                                                                                             | keyword          |
  | file.extension                   | File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | file.path                        | Full path to the file, including the file name. It should include the drive letter, when appropriate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | file.path.text                   | Multi-field of `file.path`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | group.name                       | Name of the group.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.name                        | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | input.type                       | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                    | Path to the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | log.flags                        | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                       | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | log.source.address               | Source address from which the log event was read / sent from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | log.syslog.priority              | Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | message                          | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | observer.product                 | The product name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | observer.type                    | The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | observer.vendor                  | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | process.name                     | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | process.name.text                | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | process.pid                      | Process id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | qnap.nas.application             | QNAP application that generated the event                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | qnap.nas.category                | Sub-component of the QNAP application that generated the event                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | qnap.nas.connection_type         | Connection type (ex. Samba)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | qnap.nas.file.new_path           | Renamed/Moved path of accessed resource                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | qnap.nas.file.path               | Path of accessed resource                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | related.hosts                    | All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | related.ip                       | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | related.user                     | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.address                   | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.domain                    | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                        | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | tags                             | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.name                        | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user.name.text                   | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | user.target.name                 | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user.target.name.text            | Multi-field of `user.target.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15805))Preserve event.original on pipeline error.                                                                                                                               | 9.0.08.11.0            |
  | **1.23.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15569))Generate processor tags and normalize error handler.                                                                                                                     | 9.0.08.11.0            |
  | **1.23.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                          | 9.0.08.11.0            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13522))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 9.0.08.11.0            |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                               | 9.0.08.7.1             |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12574))ECS version updated to 8.17.0.                                                                                                                                           | 8.7.1                  |
  | **1.20.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12288))Fix mapping of event.created.                                                                                                                                                | 8.7.1                  |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11286))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                             | 8.7.1                  |
  | **1.19.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6904))Convert visualizations to lens.                                                                                                                                           | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6663))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.1.0                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.1.0                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                                                                                     | 8.1.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.1.0                  |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5051))Ensure numeric timezones are correctly interpreted.                                                                                                                           | 8.1.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.1.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                                       | 8.1.0                  |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4516))Migrate the visualizations to by value in dashboards to minimize the saved object clutter and reduce time to load                                                         | 8.1.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3869))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3155))Added link to QNAP documentation in the readme file                                                                                                                       | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                         | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2435))Update to ECS 8.0                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2202))initial release                                                                                                                                                           |                        |
</dropdown>