﻿---
title: Pulse Connect Secure Integration
description: This integration is for Pulse Connect Secure. This integration includes one or more Kibana dashboards that visualizes the data collected by the integration...
url: https://www.elastic.co/docs/reference/integrations/pulse_connect_secure
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Pulse Connect Secure Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | Network Protocol               |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

This integration is for [Pulse Connect Secure](https://www.pulsesecure.net/products/remote-access-overview/).

## Log

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-10-19T09:10:35.000+02:00",
      "agent": {
          "ephemeral_id": "59d9a27c-2780-41a3-b336-00bff722f3ec",
          "id": "d2a14a09-96fc-4f81-94ef-b0cd75ad71e7",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "client": {
          "address": "89.160.20.156",
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156"
      },
      "data_stream": {
          "dataset": "pulse_connect_secure.log",
          "namespace": "47711",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "d2a14a09-96fc-4f81-94ef-b0cd75ad71e7",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "created": "2021-10-19T09:10:35.000+02:00",
          "dataset": "pulse_connect_secure.log",
          "ingested": "2024-06-12T03:21:05Z",
          "kind": "event",
          "original": "Oct 19 09:10:35 pcs-node1 1 2021-10-19T09:10:35+02:00 10.5.2.3 PulseSecure: - - - 2021-10-19 09:10:35 - pcs-node1 - [89.160.20.156] user.name(REALM)[REALM_ROLES] - Agent login succeeded for user.name/REALM (session:sid74fa8e00ca601280318287f67dfaee7cc6da40db0be6ac75) from 89.160.20.156 with Pulse-Secure/9.1.13.11723 (Windows 10) Pulse/9.1.13.11723.",
          "outcome": "success",
          "timezone": "+02:00"
      },
      "host": {
          "hostname": "pcs-node1"
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "172.19.0.5:42415"
          }
      },
      "message": "Agent login succeeded for user.name/REALM (session:sid74fa8e00ca601280318287f67dfaee7cc6da40db0be6ac75) from 89.160.20.156 with Pulse-Secure/9.1.13.11723 (Windows 10) Pulse/9.1.13.11723.",
      "observer": {
          "ip": [
              "10.5.2.3"
          ],
          "name": "pcs-node1",
          "product": "Pulse Secure Connect",
          "type": "vpn",
          "vendor": "Pulse Secure"
      },
      "pulse_secure": {
          "realm": "REALM",
          "role": "REALM_ROLES",
          "session": {
              "id": "sid74fa8e00ca601280318287f67dfaee7cc6da40db0be6ac75"
          }
      },
      "source": {
          "address": "89.160.20.156",
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "pulse_connect_secure-log"
      ],
      "user": {
          "name": "user.name"
      },
      "user_agent": {
          "device": {
              "name": "Other"
          },
          "name": "Other",
          "original": "Pulse-Secure/9.1.13.11723 (Windows 10) Pulse/9.1.13.11723",
          "os": {
              "full": "Windows 10",
              "name": "Windows",
              "version": "10"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                         | Description                                                                                                                                                                                                                                                                                                                       | Type             |
  |-------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                    | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date             |
  | cloud.image.id                | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset           | Data stream dataset.                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.namespace         | Data stream namespace.                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.type              | Data stream type.                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.dataset                 | Event dataset                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | event.module                  | Event module                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | host.containerized            | If the host is a container.                                                                                                                                                                                                                                                                                                       | boolean          |
  | host.os.build                 | OS build information.                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.codename              | OS codename, if any.                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                    | Input type                                                                                                                                                                                                                                                                                                                        | keyword          |
  | log.flags                     | Flags for the log file.                                                                                                                                                                                                                                                                                                           | keyword          |
  | log.offset                    | Log offset                                                                                                                                                                                                                                                                                                                        | long             |
  | log.source.address            | Source address from which the log event was read / sent from.                                                                                                                                                                                                                                                                     | keyword          |
  | pulse_secure.realm            | test                                                                                                                                                                                                                                                                                                                              | keyword          |
  | pulse_secure.role             | test                                                                                                                                                                                                                                                                                                                              | keyword          |
  | pulse_secure.session.id       | test                                                                                                                                                                                                                                                                                                                              | keyword          |
  | pulse_secure.session.id_short |                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Pulse Connect Secure overview dashboard](https://epr.elastic.co/package/pulse_connect_secure/2.6.0/img/pulse_connect_secure-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13747))Add dashboard.                                                                                                                                                           | 9.0.08.13.0            |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **2.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.13.0                 |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10546))Allow domain separators to include extra backslash characters.                                                                                                           | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10136))Fix sample event.                                                                                                                                                            | 8.0.07.16.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `event.category` and `event.type` fields conform to ECS field definition.                                                                                           | 8.0.07.16.0            |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9587))Fix ingest pipeline warnings                                                                                                                                                  | 8.0.07.16.0            |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9403))Update manifest format version to v3.0.3.                                                                                                                                 | 8.0.07.16.0            |
  | **1.18.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9107))Fix duplicate session field                                                                                                                                                   | 8.0.07.16.0            |
  | **1.18.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.0.07.16.0            |
  | **1.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8873))Handle session token in vpn log                                                                                                                                               | 8.0.07.16.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.0.07.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.0.07.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7298))Update package-spec to 2.9.0.                                                                                                                                             | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6662))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5887))Allow user-defined TCP options.                                                                                                                                           | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5556))Handle user domain for SAML events.                                                                                                                                       | 8.0.07.16.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                                       | 8.0.07.16.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4633))Remove duplicate fields.                                                                                                                                                      | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4121))Fix minor issues with grok patterns                                                                                                                                           | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3869))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3544))Add mapping for `event.create`                                                                                                                                                | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3428))Make GA                                                                                                                                                                   | 8.0.07.16.0            |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                         |                        |
  | **0.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2552))Add support for parsing syslog priority values                                                                                                                            |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2434))Update to ECS 8.0                                                                                                                                                         |                        |
  | **0.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1998))initial release                                                                                                                                                           |                        |
</dropdown>