﻿---
title: Broadcom ProxySG
description: ProxySG is a secure web gateway solution that enhances the security, performance, and management of web traffic for enterprises by providing URL filtering,...
url: https://www.elastic.co/docs/reference/integrations/proxysg
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Broadcom ProxySG
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.7.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Ingestion method(s)**                                                                         | File, Network Protocol                                         |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                                                    |

<admonition title="The Broadcom ProxySG integration v0.7.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

ProxySG is a secure web gateway solution that enhances the security, performance, and management of web traffic for enterprises by providing URL
filtering, advanced threat protection, and SSL inspection to identify and block malicious activities. It improves web application performance and
reduces bandwidth usage by caching frequently accessed content, while supporting user authentication and access control policies based on various
attributes. Additionally, ProxySG offers detailed reporting and analytics tools for insights into web usage patterns, security incidents, and policy
compliance. Deployed as a physical or virtual appliance or in the cloud, ProxySG serves as a proxy server that inspects, filters, and manages web
traffic to strengthen an organization's network security posture.

## Data streams

The ProxySG integration collects access logs from an appliance. Log can be provided with syslog or files uploaded from the appliance.
Log formats supported by ProxySG are available [here](https://techdocs.broadcom.com/us/en/symantec-security-software/web-and-network-security/edge-swg/7-3/getting-started/page-help-administration/page-help-logging/log-formats/default-formats.html).
Currently the ProxySG integration supports the following formats:
- main


## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

ProxySG access logs can be exported from the appliance via syslog or file upload; the integration supports both.

### Syslog

Configure ProxySG to send access logs via syslog to a remote server.
Add the integration, and configure it with "Collect logs from ProxySG via UDP" or "Collect logs from ProxySG via TCP".
In advanced options, select the "Access Log Format" value that matches the configured appliance access log format.

### File Upload

Configure ProxySG to upload access logs to a remove server on a schedule.
Add the integration, and configure it with "Collect access logs from ProxySG via logging server file"
In advanced options, set "Paths" to the file pattern that matches the location files will be uploaded to on the remote server.
Select the "Access Log Format" value that matches the configured appliance access log format.

### Access Logs

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2024-03-22T16:16:01Z",
      "agent": {
          "ephemeral_id": "c62f5fcb-3497-49a3-988a-a076cc2b9dd6",
          "id": "d4460588-94a9-4ddb-8a40-c80a3b7db55a",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.14.1"
      },
      "client": {
          "bytes": 969,
          "ip": "10.82.255.36",
          "user": {
              "name": "aeinstein"
          }
      },
      "data_stream": {
          "dataset": "proxysg.log",
          "namespace": "55535",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "d4460588-94a9-4ddb-8a40-c80a3b7db55a",
          "snapshot": false,
          "version": "8.14.1"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "proxysg.log",
          "duration": 48000000,
          "ingested": "2024-09-12T22:16:57Z",
          "original": "2024-03-22 16:16:01 48 10.82.255.36 302 TCP_NC_MISS 1242 969 GET https pixel.tapad.com 443 /idsync/ex/push ?partner_id=2499&partner_device_id=aeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553&partner_url=https%3A%2F%2Fa.vidoomy.com%2Fapi%2Frtbserver%2Fpbscookie%3Fuid%3Daeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553%26vid%3D280fa751e99651c4193ef92f6dab0f92%26dspid%3DCEN aeinstein - - pixel.tapad.com - https://vid.vidoomy.com/ OBSERVED \"FastwebRes_CallCntr;Web Ads/Analytics\" - 142.182.19.21 34.111.113.62 \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36\" sha256WithRSAEncryption",
          "timezone": "+00:00"
      },
      "http": {
          "request": {
              "method": "GET",
              "referrer": "-"
          },
          "response": {
              "status_code": 302
          }
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "172.19.0.6:47495"
          },
          "syslog": {
              "appname": "serverd",
              "facility": {
                  "code": 1,
                  "name": "user-level"
              },
              "hostname": "srvr",
              "priority": 13,
              "severity": {
                  "code": 5,
                  "name": "Notice"
              },
              "version": "1"
          }
      },
      "observer": {
          "product": "ProxySG",
          "vendor": "Broadcom"
      },
      "proxysg": {
          "client": {
              "ip": "10.82.255.36"
          },
          "client_to_server": {
              "auth_group": "-",
              "bytes": "969",
              "categories": "FastwebRes_CallCntr;Web Ads/Analytics",
              "host": "pixel.tapad.com",
              "method": "GET",
              "referer": "-",
              "uri_path": "/idsync/ex/push",
              "uri_port": 443,
              "uri_query": "?partner_id=2499&partner_device_id=aeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553&partner_url=https%3A%2F%2Fa.vidoomy.com%2Fapi%2Frtbserver%2Fpbscookie%3Fuid%3Daeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553%26vid%3D280fa751e99651c4193ef92f6dab0f92%26dspid%3DCEN",
              "uri_scheme": "https",
              "user_agent": "https://vid.vidoomy.com/",
              "username": "aeinstein"
          },
          "remote_to_server": {
              "content_type": "pixel.tapad.com"
          },
          "server": {
              "action": "TCP_NC_MISS",
              "ip": "142.182.19.21",
              "supplier_name": "-"
          },
          "server_to_client": {
              "bytes": "1242",
              "filter_result": "OBSERVED",
              "status": "302"
          },
          "time_taken": 48,
          "x_virus_id": "-"
      },
      "server": {
          "bytes": 1242,
          "ip": "142.182.19.21"
      },
      "tags": [
          "preserve_original_event",
          "forwarded"
      ],
      "url": {
          "domain": "pixel.tapad.com",
          "path": "/idsync/ex/push",
          "port": 443,
          "query": "?partner_id=2499&partner_device_id=aeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553&partner_url=https%3A%2F%2Fa.vidoomy.com%2Fapi%2Frtbserver%2Fpbscookie%3Fuid%3Daeb66687-eabe-442e-b11e-79494b740d0d-640ba437-5553%26vid%3D280fa751e99651c4193ef92f6dab0f92%26dspid%3DCEN",
          "registered_domain": "tapad.com",
          "scheme": "https",
          "subdomain": "pixel",
          "top_level_domain": "com"
      },
      "user_agent": {
          "device": {
              "name": "Generic Feature Phone"
          },
          "name": "Other",
          "original": "https://vid.vidoomy.com/"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                             | Description                        | Type             |
  |-------------------------------------------------------------------|------------------------------------|------------------|
  | @timestamp                                                        | Event timestamp.                   | date             |
  | client.bytes                                                      | Count of bytes sent by the client. | long             |
  | data_stream.dataset                                               | Data stream dataset.               | constant_keyword |
  | data_stream.namespace                                             | Data stream namespace.             | constant_keyword |
  | data_stream.type                                                  | Data stream type.                  | constant_keyword |
  | input.type                                                        | Type of input.                     | keyword          |
  | log.file.device_id                                                | Log file device ID.                | keyword          |
  | log.file.inode                                                    | Log file inode.                    | keyword          |
  | log.offset                                                        | Log offset.                        | long             |
  | log.source.address                                                | Source address for the log.        | keyword          |
  | proxysg.client.ip                                                 |                                    | keyword          |
  | proxysg.client_to_server.auth_group                               |                                    | keyword          |
  | proxysg.client_to_server.auth_groups                              |                                    | keyword          |
  | proxysg.client_to_server.bytes                                    |                                    | keyword          |
  | proxysg.client_to_server.categories                               |                                    | keyword          |
  | proxysg.client_to_server.certificate_subject                      |                                    | keyword          |
  | proxysg.client_to_server.connection_negotiated_cipher             |                                    | keyword          |
  | proxysg.client_to_server.connection_negotiated_cipher_size        |                                    | keyword          |
  | proxysg.client_to_server.connection_negotiated_ssl_version        |                                    | keyword          |
  | proxysg.client_to_server.host                                     |                                    | keyword          |
  | proxysg.client_to_server.icap_error_details                       |                                    | keyword          |
  | proxysg.client_to_server.icap_status                              |                                    | keyword          |
  | proxysg.client_to_server.method                                   |                                    | keyword          |
  | proxysg.client_to_server.ocsp_error                               |                                    | keyword          |
  | proxysg.client_to_server.referer                                  |                                    | keyword          |
  | proxysg.client_to_server.rs_content_type                          |                                    | keyword          |
  | proxysg.client_to_server.threat_id                                |                                    | keyword          |
  | proxysg.client_to_server.threat_risk                              |                                    | keyword          |
  | proxysg.client_to_server.threat_source                            |                                    | keyword          |
  | proxysg.client_to_server.uri_extension                            |                                    | keyword          |
  | proxysg.client_to_server.uri_path                                 |                                    | keyword          |
  | proxysg.client_to_server.uri_port                                 |                                    | long             |
  | proxysg.client_to_server.uri_query                                |                                    | keyword          |
  | proxysg.client_to_server.uri_scheme                               |                                    | keyword          |
  | proxysg.client_to_server.user_agent                               |                                    | keyword          |
  | proxysg.client_to_server.userdn                                   |                                    | keyword          |
  | proxysg.client_to_server.username                                 |                                    | keyword          |
  | proxysg.client_to_server.x_requested_with                         |                                    | keyword          |
  | proxysg.remote.ip                                                 |                                    | keyword          |
  | proxysg.remote.supplier_country                                   |                                    | keyword          |
  | proxysg.remote_to_server.certificate_hostection_negotname         |                                    | keyword          |
  | proxysg.remote_to_server.certificate_hostection_negotnamecategory |                                    | keyword          |
  | proxysg.remote_to_server.certificate_hostname                     |                                    | keyword          |
  | proxysg.remote_to_server.certificate_hostname_category            |                                    | keyword          |
  | proxysg.remote_to_server.certificate_hostname_threat_risk         |                                    | keyword          |
  | proxysg.remote_to_server.certificate_observed_errors              |                                    | keyword          |
  | proxysg.remote_to_server.certificate_validate_status              |                                    | keyword          |
  | proxysg.remote_to_server.connection_negotiated_cipher             |                                    | keyword          |
  | proxysg.remote_to_server.connection_negotiated_cipher_size        |                                    | keyword          |
  | proxysg.remote_to_server.connection_negotiated_cipher_strength    |                                    | keyword          |
  | proxysg.remote_to_server.connection_negotiated_ssl_version        |                                    | keyword          |
  | proxysg.remote_to_server.content_type                             |                                    | keyword          |
  | proxysg.remote_to_server.icap_error_details                       |                                    | keyword          |
  | proxysg.remote_to_server.icap_status                              |                                    | keyword          |
  | proxysg.remote_to_server.ocsp_error                               |                                    | keyword          |
  | proxysg.remote_to_server.threat_id                                |                                    | keyword          |
  | proxysg.remote_to_server.threat_source                            |                                    | keyword          |
  | proxysg.server.action                                             |                                    | keyword          |
  | proxysg.server.hierarchy                                          |                                    | keyword          |
  | proxysg.server.ip                                                 |                                    | keyword          |
  | proxysg.server.sitename                                           |                                    | keyword          |
  | proxysg.server.supplier_country                                   |                                    | keyword          |
  | proxysg.server.supplier_failures                                  |                                    | keyword          |
  | proxysg.server.supplier_ip                                        |                                    | keyword          |
  | proxysg.server.supplier_name                                      |                                    | keyword          |
  | proxysg.server_to_client.bytes                                    |                                    | keyword          |
  | proxysg.server_to_client.filter_result                            |                                    | keyword          |
  | proxysg.server_to_client.status                                   |                                    | keyword          |
  | proxysg.time_taken                                                |                                    | long             |
  | proxysg.x_bluecoat.access_security_policy_action                  |                                    | keyword          |
  | proxysg.x_bluecoat.access_security_policy_reason                  |                                    | keyword          |
  | proxysg.x_bluecoat.access_type                                    |                                    | keyword          |
  | proxysg.x_bluecoat.appliance_name                                 |                                    | keyword          |
  | proxysg.x_bluecoat.application_groups                             |                                    | keyword          |
  | proxysg.x_bluecoat.application_name                               |                                    | keyword          |
  | proxysg.x_bluecoat.application_operation                          |                                    | keyword          |
  | proxysg.x_bluecoat.location_id                                    |                                    | keyword          |
  | proxysg.x_bluecoat.location_name                                  |                                    | keyword          |
  | proxysg.x_bluecoat.placeholder                                    |                                    | keyword          |
  | proxysg.x_bluecoat.reference_id                                   |                                    | keyword          |
  | proxysg.x_bluecoat.request_tenant_id                              |                                    | keyword          |
  | proxysg.x_bluecoat.transaction_uuid                               |                                    | keyword          |
  | proxysg.x_client_agent_sw                                         |                                    | keyword          |
  | proxysg.x_client_agent_type                                       |                                    | keyword          |
  | proxysg.x_client_device_id                                        |                                    | keyword          |
  | proxysg.x_client_device_name                                      |                                    | keyword          |
  | proxysg.x_client_device_type                                      |                                    | keyword          |
  | proxysg.x_client_os                                               |                                    | keyword          |
  | proxysg.x_client_security_posture_details                         |                                    | keyword          |
  | proxysg.x_client_security_posture_risk_score                      |                                    | keyword          |
  | proxysg.x_cloud_rs                                                |                                    | keyword          |
  | proxysg.x_cs_certificate_subject                                  |                                    | keyword          |
  | proxysg.x_cs_client_ip_country                                    |                                    | keyword          |
  | proxysg.x_cs_connection_negotiated_cipher                         |                                    | keyword          |
  | proxysg.x_cs_connection_negotiated_cipher_size                    |                                    | keyword          |
  | proxysg.x_cs_connection_negotiated_ssl_version                    |                                    | keyword          |
  | proxysg.x_cs_ocsp_error                                           |                                    | keyword          |
  | proxysg.x_data_leak_detected                                      |                                    | keyword          |
  | proxysg.x_exception_id                                            |                                    | keyword          |
  | proxysg.x_icap_reqmod_header_x_icap_metadata                      |                                    | keyword          |
  | proxysg.x_icap_respmod_header_x_icap_metadata                     |                                    | keyword          |
  | proxysg.x_random_ipv6                                             |                                    | keyword          |
  | proxysg.x_rs_certificate_hostname                                 |                                    | keyword          |
  | proxysg.x_rs_certificate_hostname_categories                      |                                    | keyword          |
  | proxysg.x_rs_certificate_hostname_threat_risk                     |                                    | keyword          |
  | proxysg.x_rs_certificate_observed_errors                          |                                    | keyword          |
  | proxysg.x_rs_certificate_signature_algorithm                      |                                    | keyword          |
  | proxysg.x_rs_certificate_validate_status                          |                                    | keyword          |
  | proxysg.x_rs_connection_negotiated_cipher                         |                                    | keyword          |
  | proxysg.x_rs_connection_negotiated_cipher_size                    |                                    | keyword          |
  | proxysg.x_rs_connection_negotiated_ssl_version                    |                                    | keyword          |
  | proxysg.x_rs_ocsp_error                                           |                                    | keyword          |
  | proxysg.x_sc_connection_issuer_keyring                            |                                    | keyword          |
  | proxysg.x_sc_connection_issuer_keyring_alias                      |                                    | keyword          |
  | proxysg.x_virus_id                                                |                                    | keyword          |
  | server.bytes                                                      | Count of bytes sent by the server. | long             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![ProxySG dashboard](https://epr.elastic.co/package/proxysg/0.7.0/img/screenshot-0.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                             | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15805))Preserve event.original on pipeline error.                                                                 |                        |
  | **0.6.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15568))Generate processor tags and normalize error handler.                                                       |                        |
  | **0.6.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15607))Updated the ECS field mapping.                                                                                 |                        |
  | **0.6.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                            |                        |
  | **0.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                 |                        |
  | **0.5.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                   |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12572))ECS version updated to 8.17.0.                                                                             |                        |
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12349))Add configuration for custom filestream options. Ensure filestream fingerprint is disabled in system test. |                        |
  | **0.3.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11718))Add format config to all inputs                                                                                |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11679))Do not do syslog parsing by default in TCP and UCP inputs                                                  |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11609))Add support for 'bcreportermain_v1', 'bcreporterssl_v1' and 'ssl' formats                                  |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10459))Initial creation of the integration.                                                                       |                        |
</dropdown>