﻿---
title: Prometheus OTel Scrape (Guided)
description: This package allows you to scrape Prometheus-compatible metrics endpoints using the OpenTelemetry Collector's Prometheus receiver. This package configures...
url: https://www.elastic.co/docs/reference/integrations/prometheus_input_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Prometheus OTel Scrape (Guided)
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The Prometheus OTel Scrape (Guided) integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

This package allows you to scrape Prometheus-compatible metrics endpoints using the OpenTelemetry Collector's [Prometheus receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/prometheusreceiver).

### How it works

This package configures the Prometheus receiver in the EDOT collector to scrape metrics from Prometheus-compatible endpoints. The Elastic Agent processes and enriches the data before sending it to Elasticsearch for indexing and analysis.

## Configuration

Configure individual fields like targets, scrape interval, and TLS settings through the Fleet UI.
**Looking for raw config mode?** If you have an existing Prometheus `scrape_configs` YAML that you want to use directly, consider using the [Prometheus OTel Scrape (Bring Your Own Config)](https://github.com/elastic/integrations/tree/main/packages/prometheus_input_otel_raw) package instead.

### Settings


| Setting          | Description                           | Default          |
|------------------|---------------------------------------|------------------|
| Scrape Targets   | List of targets in `host:port` format | `localhost:9090` |
| Scrape Interval  | How frequently to scrape targets      | `60s`            |
| Scrape Timeout   | Timeout for scraping                  | `10s`            |
| Metrics Path     | HTTP path to fetch metrics            | `/metrics`       |
| Scheme           | Protocol scheme (HTTP/HTTPS)          | `http`           |
| Honor Labels     | Honor labels from scraped metrics     | `false`          |
| Honor Timestamps | Honor timestamps from scraped metrics | `true`           |


### TLS Configuration

For HTTPS endpoints, you can configure:
- Skip TLS verification for self-signed certificates
- CA certificate path for custom certificate authorities
- Client certificate and key for mutual TLS authentication


### Basic Authentication

Username and password can be configured for endpoints requiring basic authentication.

## Configuration Reference

For detailed configuration options and their descriptions, refer to the [Prometheus Receiver documentation](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/prometheusreceiver/README.md) in the upstream OpenTelemetry Collector repository.

## Use Cases

- Monitor applications exposing Prometheus metrics
- Scrape Node Exporter, cAdvisor, or other Prometheus exporters
- Collect custom application metrics in Prometheus format
- Migrate from Prometheus to Elastic Observability


## Compatibility

This package requires:
- Kibana 9.2.0 or later
- Elastic Agent with OpenTelemetry Collector support


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                          | Minimum Kibana version |
  |-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17117))Initial release of the Prometheus OpenTelemetry Input package with guided configuration |                        |
</dropdown>