﻿---
title: Profilingmetrics OpenTelemetry Assets
description: Profilingmetrics OpenTelemetry Assets must be used with OpenTelemetry profiling data. You need to run EDOT with the profiling receiver configured. You...
url: https://www.elastic.co/docs/reference/integrations/profilingmetrics_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Profilingmetrics OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.0.4 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The Profilingmetrics OpenTelemetry Assets integration v0.0.4 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

Profilingmetrics OpenTelemetry Assets must be used with OpenTelemetry profiling data.

## Requirements

You need to run EDOT with the [profiling](https://www.elastic.co/docs/reference/edot-collector/config/configure-profiles-collection) receiver configured.
You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.

## Setup

Use the [profilingmetricsconnector](https://www.elastic.co/docs/reference/edot-collector/config/configure-profiles-collection#generate-metrics-from-profiles) to generate metrics from OpenTelemetry profiling data.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Sample screenshot](https://epr.elastic.co/package/profilingmetrics_otel/0.0.4/img/assets-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                             | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.0.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17280))Fix links in the documentation                             |                        |
  | **0.0.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17239))Enable discovery on profilingmetricsconnector.otel dataset |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15695))Update Dashboard                                           |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15695))Initial draft of the package                               |                        |
</dropdown>