﻿---
title: Overview
description: Universal Profiling provides fleet-wide, whole-system, continuous profiling with zero instrumentation. Get a comprehensive understanding of what lines...
url: https://www.elastic.co/docs/reference/integrations/profiler_agent
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Overview
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 8.17.3 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Required permissions**                                                                        | Root privileges                 |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.17.3                     |

[Universal Profiling](https://www.elastic.co/observability/universal-profiling) provides fleet-wide, whole-system, continuous profiling with zero instrumentation.
Get a comprehensive understanding of what lines of code are consuming compute resources throughout your entire fleet by visualizing your data in Kibana using the flamegraph, stacktraces, and top functions views.

## Requirements

- The workloads to be profiled must be running on Linux machines; The minimum supported kernel version is either 4.19 for x86_64 or 5.5 for ARM64 machines.
- Elastic Cloud, version 8.10 or higher


## Key Features


### Frictionless Deployment

Powered by eBPF, Universal Profiling does not require any application source code changes, instrumentation, on-host debug symbols, or other intrusive operations. Just deploy the agent and receive profiling data a few minutes later.

### Always-on in Production

With extremely low overhead, Universal Profiling aims to stay within a budget of 1% of CPU usage and less than 250MB of RAM, meaning that for most workloads, even in production, it can run 24/7 with no noticeable impact on the profiled systems.

### Whole-System Visibility

Universal Profiling builds stack traces that go from the kernel, through userspace native code, all the way into code running in higher level runtimes, enabling unprecedented insight into your system’s behaviour at all levels.

### Heterogeneous Visibility

Universal Profiling even supports mixed-language stack traces. For example, Python or Java code calling native code and then calling into the kernel
The following language runtimes are supported: PHP, Python, Java (or any JVM language), Go, Rust, C/C++, Node.js/V8, Ruby, and Perl.
The minimum supported versions are:
- PHP: >= 7.3
- Python: >= 3.6
- JVM/JDK: >= 7
- V8: >= 8.1.0
- Ruby: >= 2.5
- Perl: >= 5.28

[Learn more](https://www.elastic.co/guide/en/observability/current/universal-profiling.html)

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![metricbeat aws overview](https://epr.elastic.co/package/profiler_agent/8.17.3/img/flamegraph-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version           | Details                                                                                                                                   | Minimum Kibana version |
  |-------------------|-------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **8.17.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13163))Update Kibana constraint to support 9.0.0.       | 9.0.08.17.3            |
  | **8.17.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13164))Update ownership                                 | 8.17.1                 |
  | **8.17.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12455))Update screenshot of flamegraph                  | 8.17.1                 |
  | **8.17.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11707))Add project_id                                   | 8.17.0                 |
  | **8.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10724))Update requirement text                          | 8.13.2                 |
  | **8.13.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9523))Add disable_tls option                            | 8.13.2                 |
  | **8.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8651))Add privileges section and update to 3.0.2 format | 8.12.0                 |
  | **8.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7232))Promote package for GA                            | 8.9.0                  |
  | **8.8.0-preview** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5930))Initial draft of the package                      |                        |
</dropdown>