﻿---
title: Living off the Land Attack Detection
description: The Living off the Land Attack (LotL) Detection package contains a supervised machine learning model, called ProblemChild and associated assets, which...
url: https://www.elastic.co/docs/reference/integrations/problemchild
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Living off the Land Attack Detection
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.4.5 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Platinum                       |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.9.0                     |

The Living off the Land Attack (LotL) Detection package contains a supervised machine learning model, called [ProblemChild and associated assets](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration), which are used to detect living off the land (LotL) activity in your environment. This package requires a Platinum subscription. Please ensure that you have a Trial or Platinum level subscription installed on your cluster before proceeding. This package is licensed under [Elastic License 2.0](https://www.elastic.co/licensing/elastic-license).
This package support data from Elastic Endpoint via Elastic Defend or winlogbeat on Windows only, although Elastic Defend is reccomended. Prior to using this integration, Elastic Defend should be installed through Elastic Agent (or winlogbeat should be enrolled) and collecting data from hosts. See [Configure endpoint protection with Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend) for more information.
<note>
  In versions 2.1.1 and later, this package ignores data in cold and frozen data tiers to reduce heap memory usage, avoid running on outdated data, and to follow best practices.
</note>

For more detailed information refer to the following blogs and webinar:
- [Detecting Living-off-the-land attacks with new Elastic Integration](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)
- [ProblemChild: Detecting living-off-the-land attacks using the Elastic Stack](https://www.elastic.co/blog/problemchild-detecting-living-off-the-land-attacks)
- [ProblemChild: Generate alerts to detect living-off-the-land attacks](https://www.elastic.co/blog/problemchild-generate-alerts-to-detect-living-off-the-land-attacks)
- [Webinar: ProblemChild: Detecting living-off-the-land attacks using the Elastic Stack](https://www.elastic.co/webinars/problemchild)


## Installation

1. **Upgrading**: If upgrading from a version below v2.0.0, see the section v2.0.0 and beyond.
2. **Add the Integration Package**: Install the package via **Management > Integrations > Add Living off the Land Detection**. Configure the integration name and agent policy. Click Save and Continue. (Note that this integration does not rely on an agent, and can be assigned to a policy without an agent.)
3. **Install assets**: Install the assets by clicking **Settings > Install Living off the Land Detection assets**.
4. **Configure the pipeline**: To configure the pipeline you can use one of the following steps:
   - If using Elastic Defend, add a custom pipeline to the data stream. Go to **Stack Management > Ingest Pipelines**, and check if the pipeline `logs-endpoint.events.process@custom` exists.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/custom-pipeline.png)
  If it does not exist, you can create it by running the following command in the Dev Console. Be sure to replace `<VERSION>` with the current package version.
  ```
  PUT _ingest/pipeline/logs-endpoint.events.process@custom
  {
    "processors": [
      {
        "pipeline": {
          "name": "<VERSION>-problem_child_ingest_pipeline",
          "ignore_missing_pipeline": true,
          "ignore_failure": true
        }
      }
    ]
  }
  ```
- If `logs-endpoint.events.process@custom` already exists, select the three dots next to it and choose **Edit**. Click **Add a processor**. Select **Pipeline** for Processor, enter `<VERSION>-problem_child_ingest_pipeline` for name (replacing `<VERSION>` with the current package version), and check **Ignore missing pipeline** and **Ignore failures for this processor**. Select **Add Processor**.
- If using an Elastic Beat such as Winlogbeat, see the next step on how to add the ingest pipeline as part of the component template
5. **Add the required mappings to the component template**: Go to **Stack Management > Index Management > Component Templates**. Templates that can be edited to add custom components will be marked with a `@custom` suffix. For instance, the custom component template for Elastic Defend process events is `logs-endpoint.events.process@custom`. **Note:** Do not attempt to edit the `@package` template if present. ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/component-templates.png)
   #### Elastic Defend
   - If the `@custom` component template does not exist, you can execute the following command in the Dev Console to create it and then continue to the **Rollover** section in these instructions. Be sure to change `<VERSION>` to the current package version.
  ```
  PUT _component_template/{COMPONENT_TEMPLATE_NAME}@custom
  {
    "template": {
      "mappings": {
        "properties": {
          "blocklist_label": {
            "type": "long"
          },
          "problemchild": {
            "type": "object",
            "properties": {
              "prediction": {
                "type": "long"
              },
              "prediction_probability": {
                "type": "float"
              }
            }
          }
        }
      }
    }
  }
  ```
- If the `@custom` component template already exists, you will need to edit it to add mappings for data to be properly enriched. Click the three dots next to it and select **Edit**.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/component-templates-edit.png)
- Proceed to the mappings step in the UI. Click **Add Field** at the bottom of the page and create a `blocklist_label` field of type `Long`:
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/field1.png)
- Then create an `Object` field for `problemchild`.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/field2.png)
- Finally create two properties under ProblemChild.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/field2a.png)
- The first for `prediction` of type `Long` and then for `prediction_probability` or type `Float`.
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/field3.png)
- Your component mappings should look like the following:
  ![Component Templates](https://www.elastic.co/docs/reference/integrations/images/problemchild/fields-complete.png)
- Click **Review** then **Save Component Template**.
   #### Winlogbeat
   - If using an Elastic Beat such as Winlogbeat, create a new component template with a name like `winlogbeat-problemchild-<VERSION>`, replacing `<VERSION>` with the current package version. You can do this by executing the following command in the Dev Tools:
  ```
  PUT _component_template/winlogbeat-problemchild-<VERSION>
  {
    "template": {
      "mappings": {
        "properties": {
          "blocklist_label": {
            "type": "long"
          },
          "problemchild": {
            "type": "object",
            "properties": {
              "prediction": {
                "type": "long"
              },
              "prediction_probability": {
                "type": "float"
              }
            }
          }
        }
      },
      "settings": {
        "index": {
          "final_pipeline": "<VERSION>-problem_child_ingest_pipeline"
        }
      }
    }
  }
  ```
- Then, after creating the component template, you will need to add it to the appropriate index template. Navigate to **Stack Management > Data > Index Management > Index Templates**. Find the index template `winlogbeat-{WINLOGBEAT_VERSION}` for the Winlogbeat version that you are using and click **Edit**. Then click on **Component templates**. Add the `winlogbeat-problemchild-<VERSION>` component template that was created in the previous step. Click **Review template** then **Save template**.
6. **Rollover** Depending on your environment, you may need to [rollover](https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-rollover-index.html) in order for these mappings to get picked up. The deault index pattern for Elastic Defend is `logs-endpoint.events.process-default` and `winlogbeat-<WINLOGBEAT_VERSION>` for Winlogbeat.
   ```
   POST INDEX_NAME/_rollover
   ```
7. **(Optional) [Create a data view](https://www.elastic.co/guide/en/kibana/current/data-views.html) specificially for your windows process logs (index pattern or data stream name)**
8. **Add preconfigured anomaly detection jobs**: In **Stack Management -> Anomaly Detection Jobs**, you will see **Select data view or saved search**. Select the data view created in the previous step. Then under `Use preconfigured jobs` you will see `Living off the Land Attack Detection`. When you select the card, you will see several pre-configured anomaly detection jobs that you can create depending on what makes the most sense for your environment. **Warning**: if the ingest pipeline hasn't run for some reason, such as no eligible data has come in yet, or the required mapping has not been added, *you won't be able to see this card yet*. If that is the case, try troubleshooting the ingest pipeline, and if any predictions have been populated yet.
9. **Enable detection rules**: You can also enable detection rules to alert on LotL activity in your environment, based on anomalies flagged by the above ML jobs. As of version 2.0.0 of this package, these rules are available as part of the Detection Engine, and can be found using the tag `Use Case: Living off the Land Attack Detection`. See this [documentation](https://www.elastic.co/guide/en/security/current/prebuilt-rules-management.html#load-prebuilt-rules) for more information on importing and enabling the rules.

![Domain Generation Detection Detection Rules](https://www.elastic.co/docs/reference/integrations/images/problemchild/lotlrules.png)
*In **Security > Rules**, filtering with the “Use Case: Living off the Land Attack Detection” tag*

## Anomaly Detection Jobs

Detects potential LotL activity by identifying malicious processes.

| Job                                  | Description                                                                                                                                            |
|--------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------|
| problem_child_rare_process_by_host   | Looks for a process that has been classified as malicious on a host that does not commonly manifest malicious process activity.                        |
| problem_child_high_sum_by_host       | Looks for a set of one or more malicious child processes on a single host.                                                                             |
| problem_child_rare_process_by_user   | Looks for a process that has been classified as malicious where the user context is unusual and does not commonly manifest malicious process activity. |
| problem_child_rare_process_by_parent | Looks for rare malicious child processes spawned by a parent process.                                                                                  |
| problem_child_high_sum_by_user       | Looks for a set of one or more malicious processes, started by the same user.                                                                          |
| problem_child_high_sum_by_parent     | Looks for a set of one or more malicious child processes spawned by the same parent process.                                                           |


## Customize ML jobs for Living off the Land Attack Detection

To customize the datafeed query and other settings such as model memory limit, frequency, query delay, bucket span and influencers for the Living off the Land Attack Detection ML jobs, follow the steps below.
1. To update the datafeed query, stop the datafeed and select **Edit job** from the Actions menu.
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_1.png)
2. In the Edit job window, navigate to the **Datafeed** section and update the query filters. You can add or remove field values to help reduce noise and false positives based on your environment.
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_2.png)
3. You may also update the model memory limit if your environment has high data volume or if the job requires additional resources. Go to the **Job details** section and update the **Model memory limit** and hit **Save**. For more information on resizing ML jobs, refer to the [documentation](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/anomaly-detection-scale#set-model-memory-limit).
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_3.png)
4. In order to do more advanced changes to your job, clone the job by selecting **Clone job** from the **Actions** menu.
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_4.png)
5. In the cloned job, you can update datafeed settings such as **Frequency** and **Query delay**, which help control how often data is analyzed and account for ingestion delays.
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_5.png)
6. You can also modify the job configuration by adjusting the **Bucket span** and by adding or removing **Influencers** to improve anomaly attribution.
   ![Living off the Land Attack Detection jobs](https://www.elastic.co/docs/reference/integrations/images/problemchild/problemchild_ml_job_6.png)
7. Finally, assign a new Job ID, and click on **Create job**, and start the datafeed to apply the updated settings.


## v2.0.0 and beyond

v2.0.0 of the package introduces breaking changes, namely deprecating detection rules from the package. To continue receiving updates to LotL Detection, we recommend upgrading to v2.0.0 after doing the following:
- Uninstall existing rules associated with this package: Navigate to **Security > Rules** and delete the following rules:
  - Machine Learning Detected a Suspicious Windows Event Predicted to be Malicious Activity
- Unusual Process Spawned By a Host
- Suspicious Windows Process Cluster Spawned by a Host
- Machine Learning Detected a Suspicious Windows Event with a High Malicious Probability Score
- Suspicious Windows Process Cluster Spawned by a Parent Process
- Unusual Process Spawned By a User
- Unusual Process Spawned By a Parent Process
- Suspicious Windows Process Cluster Spawned by a User

Depending on the version of the package you're using, you might also be able to search for the above rules using the tag `Living off the Land`.
- Upgrade the LotL package to v2.0.0 using the steps [here](https://www.elastic.co/guide/en/fleet/current/upgrade-integration.html)
- Install the new rules as described in the *Enable detection rules* section below


## Licensing

Usage in production requires that you have a license key that permits use of machine learning features.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Sample screenshot](https://epr.elastic.co/package/problemchild/2.4.5/img/sample-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                 | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.4.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17039))Update package docs with customization steps for ML jobs and transforms                        | 9.0.08.9.0             |
  | **2.4.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16209))Add filtering for Elastic endpoint agents                                                          | 9.0.08.9.0             |
  | **2.4.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15405))Update installation instructions                                                               | 9.0.08.9.0             |
  | **2.4.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15229))Remove instructions to change the `default_pipeline` for an index                                  | 9.0.08.9.0             |
  | **2.4.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14358))Update platform support docs                                                                   | 9.0.08.9.0             |
  | **2.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13058))Add exclusions for Elastic endpoint agents                                                     | 9.0.08.9.0             |
  | **2.3.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13172))Change the description of ML jobs                                                              | 9.0.08.9.0             |
  | **2.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12940))Add support for Kibana `9.0.0`                                                                 | 9.0.08.9.0             |
  | **2.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12168))Add agent policy documentation                                                                 | 8.9.0                  |
  | **2.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11367))Improved notation of painless script if block in ingest pipeline                               | 8.9.0                  |
  | **2.1.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10823))Add fields for integration package testing                                                         | 8.9.0                  |
  | **2.1.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10476))Add mapping instructions                                                                           | 8.9.0                  |
  | **2.1.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9791))Improve package installation documentation                                                      | 8.9.0                  |
  | **2.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8473))Remove "experimental" messaging from docs                                                       | 8.9.0                  |
  | **2.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8500))Add query settings to ignore frozen and cold data tiers                                         | 8.9.0                  |
  | **2.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8106))Add serverless support                                                                          | 8.9.0                  |
  | **2.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7579))Moving detection rules to the `detection-rules` repo, bumped license version, subscription tier | 8.9.0                  |
  | **1.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7579))Convert detection rules to EQL                                                                  | 8.0.0                  |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7618))Update blog post link and minor bug fixes                                                           | 8.0.0                  |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7501))Ensure event.kind is correctly set for pipeline errors.                                         | 8.0.0                  |
  | **1.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6241))Add the Advanced Analytics (UEBA) subcategory                                                   | 8.0.0                  |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5721))Update version number to follow GA format and to improve visibility                             | 8.0.0                  |
  | **0.0.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4829))Cleaning up ML job groups and rule tags, documentation updates                                  |                        |
  | **0.0.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3999))Fix the ML jobs query.                                                                              |                        |
  | **0.0.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3777))Add a `LotL` tag to all rules, fix a script in the inference pipeline, update ML job configs.       |                        |
  | **0.0.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3022))Update ProblemChild integration Readme                                                              |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2115))Initial release of the package                                                                  |                        |
</dropdown>