﻿---
title: Palo Alto Cortex XDR Integration
description: Palo Alto Networks Cortex XDR is a powerful security solution that gives you complete visibility into network traffic, user behavior, and endpoint activity...
url: https://www.elastic.co/docs/reference/integrations/panw_cortex_xdr
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Palo Alto Cortex XDR Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, Google Cloud Storage      |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4               |

[Palo Alto Networks Cortex XDR](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR/Cortex-XDR-Pro-Administrator-Guide/Overview) is a powerful security solution that gives you complete visibility into network traffic, user behavior, and endpoint activity. It streamlines threat investigation by correlating data from various sensors, uncovering attack timelines and root causes with clarity. With Cortex XDR, you can take immediate response actions and minimize threat impact. Additionally, it enables proactive threat prevention through customizable detection rules, including BIOCs, IOCs, and Correlation Rules, helping you stay ahead of emerging threats.
The Palo Alto Cortex XDR integration collects [alerts](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR-REST-API/Get-Alerts-Multi-Events-v1) and [incidents](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR-REST-API/Get-all-Incidents) via the REST API and supports [endpoint event forwarding](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR/Cortex-XDR-Pro-Administrator-Guide/Manage-Event-Forwarding) through Google Cloud Storage (GCS).

## Data streams

**[Alerts](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR-REST-API/Get-Alerts-Multi-Events-v1)** – Retrieves alerts generated by Cortex XDR based on raw endpoint data. A single alert may include one or more local endpoint events, each of which is ingested as a separate document in Elasticsearch. Requires both an API Key and API Key ID.
**[Incidents](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR-REST-API/Get-all-Incidents)** – Retrieves incidents generated by Cortex XDR. Each incident may include one or more endpoint events, each stored as a separate document in Elasticsearch. When an incident is modified in the Cortex XDR UI (e.g., severity or status changes, alerts linked), a new document reflecting the updated values is indexed. Requires both an API Key and API Key ID.
**[Event](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR/Cortex-XDR-Pro-Administrator-Guide/Manage-Event-Forwarding)** - Retrieves events forwarded by Cortex XDR to Google Cloud Storage (GCS).

## Requirements


### Agentless enabled integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments.  This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

## Compatibility

This integration is compatible with Palo Alto Cortex XDR version **V3.13**. For the REST API, it has been tested with versions **v1** and **v2**.

## Setup


### To collect logs through REST API, follow the below steps:

<note>
  To collect logs from API version v1, use the **HTTP JSON** input type. To collect logs from API version v2, use the **CEL** input type.
</note>

1. Log in to your Cortex XDR portal.
2. Navigate to **Settings > Configurations > Integrations > API Keys**.
3. Select **+ New Key** to generate a new API key.
4. Choose the type of API key you want to generate: **Standard** or **Advanced**, based on the desired security level.
5. (Optional) To define a time limit for the API key, enable **Expiration Date** and set the desired expiration.
6. Select the **access level** for this key:
   - Choose from existing **Roles**, or
- Select **Custom** for granular permission settings.
7. Click **Generate** to create the key.
8. **Copy the API Key** shown in the notification and store it securely — you won’t be able to view it again.
9. Locate the **API Key ID** in the **ID** column of the API Keys table. This represents your `x-xdr-auth-id`.
10. To get your **Domain Name**, right-click the API key and select **View Examples**.
   - Copy the domain part from the **CURL example URL** (e.g., `https://api-{fqdn}/public_api/...`).

**Reference:** [Cortex XDR – Get Started with APIs](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR-REST-API/Get-Started-with-Cortex-XDR-APIs)

### To collect endpoint logs using Event Forwarding, follow the below steps:

1. In your Cortex XDR portal, navigate to:
   **Settings > Configurations > Data Management > Event Forwarding**.
2. In the **Activation** section, enable **Endpoints Event Forwarding** to export raw endpoint data for Cortex XDR Pro EP and Cloud Endpoints.
   - A temporary GCS bucket is automatically created by Cortex XDR(Cortex XDR uses GCS as the storage destination by default).
- Logs are stored as line-delimited JSON gzip files.
3. In the **Destination** section:
   - Copy the GCS storage path.
- Download the Service Account JSON Web Token (JWT) file containing access credentials.
4. To configure data collection in Elastic, use the following details:
   - **Project ID**
- **Service Account Key** (downloaded JSON file)
- **Bucket path** (copied from the GCS destination)

**Reference:** [Cortex XDR - Manage Event Forwarding](https://docs-cortex.paloaltonetworks.com/r/Cortex-XDR/Cortex-XDR-Pro-Administrator-Guide/Manage-Event-Forwarding)
<note>
  The endpoint event forwarding feature requires a Cortex XDR Pro license along with the Event Forwarding add-on. Enabling this feature requires Administrator access.
</note>


### Enabling the integration in Elastic

1. In Kibana, navigate to Management > Integrations.
2. In the "Search for integrations" bar, search for Palo Alto Cortex XDR.
3. Select the "Palo Alto Cortex XDR" integration from the search results.
4. Click "Add Palo Alto Cortex XDR" to add the integration.
5. Configure the integration with the required parameters based on your preferred method of data collection:

- For REST API (applies to both Alerts and Incidents with HTTP JSON and CEL input):
  - API Domain
- API Token
- API Token ID
- Interval
- Initial Interval
- For GCS (used for event collection via endpoint event forwarding):
  - Project ID
- Service Account Key or Service Account Credentials File
- Buckets

1. Click **Save and continue** to complete the integration setup.


## Logs reference


### Alerts

This is the `Alerts` dataset.

#### Example

<dropdown title="Exported fields">
  | Field                                                             | Description                                                    | Type             |
  |-------------------------------------------------------------------|----------------------------------------------------------------|------------------|
  | @timestamp                                                        | Event timestamp.                                               | date             |
  | cloud.image.id                                                    | Image ID for the cloud instance.                               | keyword          |
  | data_stream.dataset                                               | Data stream dataset name.                                      | constant_keyword |
  | data_stream.namespace                                             | Data stream namespace.                                         | constant_keyword |
  | data_stream.type                                                  | Data stream type.                                              | constant_keyword |
  | event.dataset                                                     | Event dataset                                                  | constant_keyword |
  | event.module                                                      | Event module                                                   | constant_keyword |
  | host.containerized                                                | If the host is a container.                                    | boolean          |
  | host.os.build                                                     | OS build information.                                          | keyword          |
  | host.os.codename                                                  | OS codename, if any.                                           | keyword          |
  | input.type                                                        | Type of Filebeat input.                                        | keyword          |
  | log.flags                                                         | Flags for the log file.                                        | keyword          |
  | log.offset                                                        | Offset of the entry in the log file.                           | long             |
  | panw_cortex.xdr.action_country                                    |                                                                | keyword          |
  | panw_cortex.xdr.action_external_hostname                          | Any external hostname related to the specific event action.    | keyword          |
  | panw_cortex.xdr.action_file_macro_sha256                          |                                                                | keyword          |
  | panw_cortex.xdr.action_local_ip                                   |                                                                | ip               |
  | panw_cortex.xdr.action_local_ip_v6                                |                                                                | ip               |
  | panw_cortex.xdr.action_local_port                                 |                                                                | long             |
  | panw_cortex.xdr.action_pretty                                     | Pretty description of the action type.                         | keyword          |
  | panw_cortex.xdr.action_process_causality_id                       | The parent processor ID related to the action.                 | keyword          |
  | panw_cortex.xdr.action_process_signature_status                   |                                                                | keyword          |
  | panw_cortex.xdr.action_remote_ip                                  |                                                                | ip               |
  | panw_cortex.xdr.action_remote_ip_v6                               |                                                                | ip               |
  | panw_cortex.xdr.action_remote_port                                |                                                                | long             |
  | panw_cortex.xdr.actor_causality_id                                | The parent process ID of the actor process.                    | keyword          |
  | panw_cortex.xdr.actor_process_causality_id                        | The parent processor ID related to the actor.                  | keyword          |
  | panw_cortex.xdr.actor_process_command_line                        | Actor full command line.                                       | keyword          |
  | panw_cortex.xdr.actor_process_image_md5                           |                                                                | keyword          |
  | panw_cortex.xdr.actor_process_image_name                          | Actor binary name.                                             | keyword          |
  | panw_cortex.xdr.actor_process_image_path                          |                                                                | keyword          |
  | panw_cortex.xdr.actor_process_image_sha256                        | SHA256 hash indentifier of the actor.                          | keyword          |
  | panw_cortex.xdr.actor_process_instance_id                         | The process ID related to the actor.                           | keyword          |
  | panw_cortex.xdr.actor_process_os_pid                              |                                                                | long             |
  | panw_cortex.xdr.actor_process_signature_status                    | The signature of the actor process.                            | keyword          |
  | panw_cortex.xdr.actor_process_signature_vendor                    | The signature vendor of the actor process.                     | keyword          |
  | panw_cortex.xdr.actor_thread_thread_id                            |                                                                | long             |
  | panw_cortex.xdr.agent_data_collection_status                      | Collection status of the agent.                                | boolean          |
  | panw_cortex.xdr.agent_host_boot_time                              | Uptime of the host.                                            | date             |
  | panw_cortex.xdr.agent_install_type                                | Display name of the actor.                                     | keyword          |
  | panw_cortex.xdr.agent_ip_addresses_v6                             | Agent ipv6 address                                             | ip               |
  | panw_cortex.xdr.agent_is_vdi                                      | If agent is running inside a Virtual Desktop.                  | boolean          |
  | panw_cortex.xdr.agent_version                                     | Version of the XDR Endpoint agent.                             | keyword          |
  | panw_cortex.xdr.alert_id                                          | The ID of the alert.                                           | keyword          |
  | panw_cortex.xdr.alert_type                                        | The type of the alert.                                         | keyword          |
  | panw_cortex.xdr.association_strength                              |                                                                | long             |
  | panw_cortex.xdr.attempt_counter                                   | Attempts to block or stop the malicious process.               | long             |
  | panw_cortex.xdr.bioc_category_enum_key                            | Behavior Indicator type key.                                   | keyword          |
  | panw_cortex.xdr.bioc_description                                  | A description of the related bioc event.                       | flattened        |
  | panw_cortex.xdr.bioc_indicator                                    | The Behavioral Indicator type matching to the event.           | keyword          |
  | panw_cortex.xdr.case_id                                           |                                                                | long             |
  | panw_cortex.xdr.category                                          | The Alert category.                                            | keyword          |
  | panw_cortex.xdr.causality_actor_causality_id                      |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_command_line              |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_execution_time            |                                                                | long             |
  | panw_cortex.xdr.causality_actor_process_image_md5                 |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_image_name                |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_image_path                |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_image_sha256              |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_signature_status          |                                                                | keyword          |
  | panw_cortex.xdr.causality_actor_process_signature_vendor          |                                                                | keyword          |
  | panw_cortex.xdr.cloud_provider                                    |                                                                | keyword          |
  | panw_cortex.xdr.cluster_name                                      |                                                                | keyword          |
  | panw_cortex.xdr.container_id                                      |                                                                | keyword          |
  | panw_cortex.xdr.contains_featured_host                            |                                                                | keyword          |
  | panw_cortex.xdr.contains_featured_ip                              |                                                                | keyword          |
  | panw_cortex.xdr.contains_featured_user                            |                                                                | keyword          |
  | panw_cortex.xdr.deduplicate_tokens                                |                                                                | keyword          |
  | panw_cortex.xdr.description                                       | A description of the related event.                            | keyword          |
  | panw_cortex.xdr.detection_timestamp                               |                                                                | date             |
  | panw_cortex.xdr.dns_query_name                                    | The related DNS query for the event.                           | keyword          |
  | panw_cortex.xdr.dss_country                                       |                                                                | keyword          |
  | panw_cortex.xdr.dss_department                                    |                                                                | keyword          |
  | panw_cortex.xdr.dss_groups                                        |                                                                | keyword          |
  | panw_cortex.xdr.dss_job_title                                     |                                                                | keyword          |
  | panw_cortex.xdr.dst_action_country                                | The country related to the destination.                        | keyword          |
  | panw_cortex.xdr.dst_action_external_hostname                      | The external hostname of the destination.                      | keyword          |
  | panw_cortex.xdr.dst_action_external_port                          | The external (NAT) port of the destination.                    | keyword          |
  | panw_cortex.xdr.dst_agent_id                                      | The endpoint ID of a destination agent.                        | keyword          |
  | panw_cortex.xdr.dst_association_strength                          |                                                                | long             |
  | panw_cortex.xdr.dst_causality_actor_process_execution_time        | The process execution time of the destination process.         | keyword          |
  | panw_cortex.xdr.dynamic_fields                                    |                                                                | keyword          |
  | panw_cortex.xdr.end_match_attempt_ts                              |                                                                | date             |
  | panw_cortex.xdr.endpoint_id                                       | The unique ID of the endpoint.                                 | keyword          |
  | panw_cortex.xdr.event_id                                          | The ID unique to the underlying event related to the alert.    | keyword          |
  | panw_cortex.xdr.event_sub_type                                    | Sub type of the event related to the alert.                    | integer          |
  | panw_cortex.xdr.event_timestamp                                   |                                                                | date             |
  | panw_cortex.xdr.event_type                                        | Event type                                                     | keyword          |
  | panw_cortex.xdr.events.action_country                             |                                                                | keyword          |
  | panw_cortex.xdr.events.action_external_hostname                   | Any external hostname related to the specific event action.    | keyword          |
  | panw_cortex.xdr.events.action_file_macro_sha256                   |                                                                | keyword          |
  | panw_cortex.xdr.events.action_process_causality_id                | The parent processor ID related to the action.                 | keyword          |
  | panw_cortex.xdr.events.actor_causality_id                         | The parent process ID of the actor process.                    | keyword          |
  | panw_cortex.xdr.events.actor_process_causality_id                 | The parent processor ID related to the actor.                  | keyword          |
  | panw_cortex.xdr.events.actor_process_command_line                 | Actor full command line.                                       | keyword          |
  | panw_cortex.xdr.events.actor_process_image_name                   | Actor binary name.                                             | keyword          |
  | panw_cortex.xdr.events.actor_process_image_sha256                 | SHA256 hash indentifier of the actor.                          | keyword          |
  | panw_cortex.xdr.events.actor_process_instance_id                  | The process ID related to the actor.                           | keyword          |
  | panw_cortex.xdr.events.actor_process_signature_status             | The signature of the actor process.                            | keyword          |
  | panw_cortex.xdr.events.actor_process_signature_vendor             | The signature vendor of the actor process.                     | keyword          |
  | panw_cortex.xdr.events.agent_host_boot_time                       | Uptime of the host.                                            | date             |
  | panw_cortex.xdr.events.agent_install_type                         | Display name of the actor.                                     | keyword          |
  | panw_cortex.xdr.events.association_strength                       |                                                                | long             |
  | panw_cortex.xdr.events.contains_featured_host                     |                                                                | keyword          |
  | panw_cortex.xdr.events.contains_featured_ip                       |                                                                | keyword          |
  | panw_cortex.xdr.events.contains_featured_user                     |                                                                | keyword          |
  | panw_cortex.xdr.events.dns_query_name                             | The related DNS query for the event.                           | keyword          |
  | panw_cortex.xdr.events.dst_action_country                         | The country related to the destination.                        | keyword          |
  | panw_cortex.xdr.events.dst_action_external_hostname               | The external hostname of the destination.                      | keyword          |
  | panw_cortex.xdr.events.dst_action_external_port                   | The external (NAT) port of the destination.                    | keyword          |
  | panw_cortex.xdr.events.dst_agent_id                               | The endpoint ID of a destination agent.                        | keyword          |
  | panw_cortex.xdr.events.dst_association_strength                   |                                                                | long             |
  | panw_cortex.xdr.events.dst_causality_actor_process_execution_time | The process execution time of the destination process.         | keyword          |
  | panw_cortex.xdr.events.event_id                                   | The ID unique to the underlying event related to the alert.    | keyword          |
  | panw_cortex.xdr.events.event_sub_type                             | Sub type of the event related to the alert.                    | integer          |
  | panw_cortex.xdr.events.event_type                                 | Event type                                                     | keyword          |
  | panw_cortex.xdr.events.fw_app_category                            | Layer 7 application category related to the firewall event.    | keyword          |
  | panw_cortex.xdr.events.fw_app_id                                  | The layer 7 application ID from the firewall event.            | keyword          |
  | panw_cortex.xdr.events.fw_app_subcategory                         | Layer 7 application subcategory related to the firewall event. | keyword          |
  | panw_cortex.xdr.events.fw_app_technology                          | Layer 7 application type related to the firewall event.        | keyword          |
  | panw_cortex.xdr.events.fw_device_name                             | Related firewall device.                                       | keyword          |
  | panw_cortex.xdr.events.fw_email_recipient                         |                                                                | keyword          |
  | panw_cortex.xdr.events.fw_email_sender                            |                                                                | keyword          |
  | panw_cortex.xdr.events.fw_email_subject                           |                                                                | keyword          |
  | panw_cortex.xdr.events.fw_is_phishing                             | If event is related to a phishing campaign.                    | keyword          |
  | panw_cortex.xdr.events.fw_misc                                    | Additional information related to the firewall event.          | keyword          |
  | panw_cortex.xdr.events.fw_url_domain                              | Related domain to the firewall event.                          | keyword          |
  | panw_cortex.xdr.events.fw_vsys                                    | The related VSYS name if applicable.                           | keyword          |
  | panw_cortex.xdr.events.fw_xff                                     |                                                                | keyword          |
  | panw_cortex.xdr.events.module_id                                  | The ID of the module that caught the event.                    | keyword          |
  | panw_cortex.xdr.events.os_actor_causality_id                      | The ID of the OS actor process                                 | keyword          |
  | panw_cortex.xdr.events.os_actor_effective_username                | Username related to the OS actor.                              | keyword          |
  | panw_cortex.xdr.events.os_actor_process_causality_id              | The ID of the parent process related to the OS actor.          | keyword          |
  | panw_cortex.xdr.events.os_actor_process_command_line              | OS actor full command line example.                            | keyword          |
  | panw_cortex.xdr.events.os_actor_process_image_name                | OS actor binary name.                                          | keyword          |
  | panw_cortex.xdr.events.os_actor_process_image_path                | OS actor binary path.                                          | keyword          |
  | panw_cortex.xdr.events.os_actor_process_image_sha256              | SHA256 hash indentifier of the OS actor process.               | keyword          |
  | panw_cortex.xdr.events.os_actor_process_instance_id               | The process ID related to the OS actor.                        | keyword          |
  | panw_cortex.xdr.events.os_actor_process_os_pid                    | The OS PID related to the related process.                     | integer          |
  | panw_cortex.xdr.events.os_actor_process_signature_status          | Signature of the OS actor process.                             | keyword          |
  | panw_cortex.xdr.events.os_actor_process_signature_vendor          | Signature vendor of the OS actor process.                      | keyword          |
  | panw_cortex.xdr.events.os_actor_thread_thread_id                  | The thread ID related to the related OS actor process.         | integer          |
  | panw_cortex.xdr.events.story_id                                   |                                                                | keyword          |
  | panw_cortex.xdr.external_id                                       | External ID related to the Alert itself.                       | keyword          |
  | panw_cortex.xdr.filter_rule_id                                    | ID of the filter rule.                                         | keyword          |
  | panw_cortex.xdr.fw_app_category                                   | Layer 7 application category related to the firewall event.    | keyword          |
  | panw_cortex.xdr.fw_app_id                                         | The layer 7 application ID from the firewall event.            | keyword          |
  | panw_cortex.xdr.fw_app_subcategory                                | Layer 7 application subcategory related to the firewall event. | keyword          |
  | panw_cortex.xdr.fw_app_technology                                 | Layer 7 application type related to the firewall event.        | keyword          |
  | panw_cortex.xdr.fw_device_name                                    | Related firewall device.                                       | keyword          |
  | panw_cortex.xdr.fw_email_recipient                                |                                                                | keyword          |
  | panw_cortex.xdr.fw_email_sender                                   |                                                                | keyword          |
  | panw_cortex.xdr.fw_email_subject                                  |                                                                | keyword          |
  | panw_cortex.xdr.fw_is_phishing                                    | If event is related to a phishing campaign.                    | keyword          |
  | panw_cortex.xdr.fw_misc                                           | Additional information related to the firewall event.          | keyword          |
  | panw_cortex.xdr.fw_url_domain                                     | Related domain to the firewall event.                          | keyword          |
  | panw_cortex.xdr.fw_vsys                                           | The related VSYS name if applicable.                           | keyword          |
  | panw_cortex.xdr.fw_xff                                            |                                                                | keyword          |
  | panw_cortex.xdr.identity_sub_type                                 |                                                                | keyword          |
  | panw_cortex.xdr.identity_type                                     |                                                                | keyword          |
  | panw_cortex.xdr.image_name                                        |                                                                | keyword          |
  | panw_cortex.xdr.is_pcap                                           | If alert contains pcap.                                        | boolean          |
  | panw_cortex.xdr.is_whitelisted                                    | If process is whitelisted.                                     | boolean          |
  | panw_cortex.xdr.last_modified_ts                                  |                                                                | date             |
  | panw_cortex.xdr.local_insert_ts                                   |                                                                | date             |
  | panw_cortex.xdr.mac                                               | Main MAC address of the agent.                                 | keyword          |
  | panw_cortex.xdr.mac_address                                       | Array of all the MAC addresses related to the agent.           | keyword          |
  | panw_cortex.xdr.mac_addresses                                     |                                                                | keyword          |
  | panw_cortex.xdr.matching_service_rule_id                          |                                                                | keyword          |
  | panw_cortex.xdr.matching_status                                   | Matching status of the endpoint group.                         | keyword          |
  | panw_cortex.xdr.mitre_tactic_id_and_name                          |                                                                | keyword          |
  | panw_cortex.xdr.mitre_technique_id_and_name                       |                                                                | keyword          |
  | panw_cortex.xdr.module_id                                         | The ID of the module that caught the event.                    | keyword          |
  | panw_cortex.xdr.operation_name                                    |                                                                | keyword          |
  | panw_cortex.xdr.original_tags                                     | Original tags for the asset.                                   | keyword          |
  | panw_cortex.xdr.os_actor_causality_id                             | The ID of the OS actor process                                 | keyword          |
  | panw_cortex.xdr.os_actor_effective_username                       | Username related to the OS actor.                              | keyword          |
  | panw_cortex.xdr.os_actor_process_causality_id                     | The ID of the parent process related to the OS actor.          | keyword          |
  | panw_cortex.xdr.os_actor_process_command_line                     | OS actor full command line example.                            | keyword          |
  | panw_cortex.xdr.os_actor_process_image_name                       | OS actor binary name.                                          | keyword          |
  | panw_cortex.xdr.os_actor_process_image_path                       | OS actor binary path.                                          | keyword          |
  | panw_cortex.xdr.os_actor_process_image_sha256                     | SHA256 hash indentifier of the OS actor process.               | keyword          |
  | panw_cortex.xdr.os_actor_process_instance_id                      | The process ID related to the OS actor.                        | keyword          |
  | panw_cortex.xdr.os_actor_process_os_pid                           | The OS PID related to the related process.                     | integer          |
  | panw_cortex.xdr.os_actor_process_signature_status                 | Signature of the OS actor process.                             | keyword          |
  | panw_cortex.xdr.os_actor_process_signature_vendor                 | Signature vendor of the OS actor process.                      | keyword          |
  | panw_cortex.xdr.os_actor_thread_thread_id                         | The thread ID related to the related OS actor process.         | integer          |
  | panw_cortex.xdr.project                                           |                                                                | keyword          |
  | panw_cortex.xdr.referenced_resource                               |                                                                | keyword          |
  | panw_cortex.xdr.resolution_comment                                |                                                                | keyword          |
  | panw_cortex.xdr.resolution_status                                 |                                                                | keyword          |
  | panw_cortex.xdr.resource_sub_type                                 |                                                                | keyword          |
  | panw_cortex.xdr.resource_type                                     |                                                                | keyword          |
  | panw_cortex.xdr.severity                                          |                                                                | keyword          |
  | panw_cortex.xdr.source                                            |                                                                | keyword          |
  | panw_cortex.xdr.starred                                           | If alert type is prioritized (starred).                        | boolean          |
  | panw_cortex.xdr.story_id                                          |                                                                | keyword          |
  | panw_cortex.xdr.tags                                              |                                                                | keyword          |
  | panw_cortex.xdr.user_agent                                        |                                                                | keyword          |
  | panw_cortex.xdr.user_name                                         |                                                                | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-11-29T23:09:23.118Z",
      "agent": {
          "ephemeral_id": "a0d177ad-9718-457c-a632-fb07a95f4a53",
          "id": "fb8225aa-8e6e-4e78-81cd-07a99ca64805",
          "name": "elastic-agent-26720",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "panw_cortex_xdr.alerts",
          "namespace": "42727",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "fb8225aa-8e6e-4e78-81cd-07a99ca64805",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "DETECTED",
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2019-09-22T13:36:03.318Z",
          "dataset": "panw_cortex_xdr.alerts",
          "id": "<external_id>",
          "ingested": "2026-01-29T10:28:28Z",
          "kind": "alert",
          "original": "{\"action\":\"DETECTED\",\"action_country\":[\"UNKNOWN\"],\"action_external_hostname\":null,\"action_file_macro_sha256\":null,\"action_file_md5\":null,\"action_file_name\":null,\"action_file_path\":null,\"action_file_sha256\":null,\"action_local_ip\":null,\"action_local_ip_v6\":null,\"action_local_port\":null,\"action_pretty\":\"Detected\",\"action_process_causality_id\":null,\"action_process_image_command_line\":null,\"action_process_image_name\":null,\"action_process_image_sha256\":null,\"action_process_instance_id\":null,\"action_process_signature_status\":[\"N/A\"],\"action_process_signature_vendor\":null,\"action_registry_data\":null,\"action_registry_full_key\":null,\"action_registry_key_name\":null,\"action_registry_value_name\":null,\"action_remote_ip\":null,\"action_remote_ip_v6\":null,\"action_remote_port\":null,\"actor_causality_id\":[\"\\u003cactor_causality_id\\u003e\"],\"actor_process_causality_id\":[\"\\u003cprocess_causality_id\\u003e\"],\"actor_process_command_line\":[\"\\u003ccommand_line\\u003e\"],\"actor_process_image_md5\":[\"\\u003cimage_md5\\u003e\"],\"actor_process_image_name\":[\"\\u003cimage_name\\u003e\"],\"actor_process_image_path\":[\"\\u003cimage_path\\u003e\"],\"actor_process_image_sha256\":[\"\\u003cimage_sha256\\u003e\"],\"actor_process_instance_id\":[\"\\u003cinstance_id\\u003e\"],\"actor_process_os_pid\":[996],\"actor_process_signature_status\":[\"Signed\"],\"actor_process_signature_vendor\":[\"\\u003csignature_vendor\\u003e\"],\"actor_thread_thread_id\":[7452],\"agent_data_collection_status\":null,\"agent_device_domain\":null,\"agent_fqdn\":null,\"agent_host_boot_time\":[1669128165772],\"agent_install_type\":\"STANDARD\",\"agent_ip_addresses_v6\":null,\"agent_is_vdi\":false,\"agent_os_sub_type\":\"\\u003cos_sub_type\\u003e\",\"agent_os_type\":\"\\u003cos_type\\u003e\",\"agent_version\":\"\\u003cagent_version\\u003e\",\"alert_id\":\"1\",\"alert_type\":\"Unclassified\",\"association_strength\":[50],\"attempt_counter\":0,\"bioc_category_enum_key\":null,\"bioc_indicator\":null,\"case_id\":9629,\"category\":\"\\u003ccategory\\u003e\",\"causality_actor_causality_id\":[\"\\u003ccausality_id\\u003e\"],\"causality_actor_process_command_line\":[\"\\u003ccommand_line\\u003e\"],\"causality_actor_process_execution_time\":[1669528171295],\"causality_actor_process_image_md5\":[\"\\u003cimage_md5\\u003e\"],\"causality_actor_process_image_name\":[\"\\u003cimage_name\\u003e\"],\"causality_actor_process_image_path\":[\"\\u003cimage_path\\u003e\"],\"causality_actor_process_image_sha256\":[\"\\u003csha256\\u003e\"],\"causality_actor_process_signature_status\":[\"Signed\"],\"causality_actor_process_signature_vendor\":[\"\\u003csignature_vendor\\u003e\"],\"cloud_provider\":null,\"cluster_name\":null,\"container_id\":null,\"contains_featured_host\":[\"NO\"],\"contains_featured_ip\":[\"NO\"],\"contains_featured_user\":[\"NO\"],\"deduplicate_tokens\":null,\"description\":\"The user domain\\\\username enabled a default account. The default account enabled: domain\\\\username\",\"detection_timestamp\":1569159363318,\"dns_query_name\":null,\"dss_country\":null,\"dss_department\":null,\"dss_groups\":null,\"dss_job_title\":null,\"dst_action_country\":null,\"dst_action_external_hostname\":null,\"dst_action_external_port\":null,\"dst_agent_id\":[\"\\u003cagent_id\\u003e\"],\"dst_association_strength\":null,\"dst_causality_actor_process_execution_time\":null,\"dynamic_fields\":null,\"end_match_attempt_ts\":null,\"endpoint_id\":\"\\u003cendpoint_id\\u003e\",\"event_id\":[\"\\u003cevent_id\\u003e\"],\"event_sub_type\":[1],\"event_timestamp\":[1701299363118],\"event_type\":[\"Process Execution\"],\"events\":null,\"external_id\":\"\\u003cexternal_id\\u003e\",\"filter_rule_id\":null,\"fw_app_category\":null,\"fw_app_id\":null,\"fw_app_subcategory\":null,\"fw_app_technology\":null,\"fw_device_name\":null,\"fw_email_recipient\":null,\"fw_email_sender\":null,\"fw_email_subject\":null,\"fw_interface_from\":null,\"fw_interface_to\":null,\"fw_is_phishing\":[\"N/A\"],\"fw_misc\":null,\"fw_rule\":null,\"fw_rule_id\":null,\"fw_serial_number\":null,\"fw_url_domain\":null,\"fw_vsys\":null,\"fw_xff\":null,\"host_ip\":[\"192.168.2.2\"],\"host_name\":\"\\u003chost_name\\u003e\",\"identity_sub_type\":null,\"identity_type\":null,\"image_name\":null,\"is_pcap\":false,\"is_whitelisted\":false,\"last_modified_ts\":null,\"local_insert_ts\":1673372647792,\"mac_addresses\":null,\"matching_service_rule_id\":\"\\u003cservice_rule_id\\u003e\",\"matching_status\":\"MATCHED\",\"mitre_tactic_id_and_name\":[\"TA0005 - Defense Evasion\"],\"mitre_technique_id_and_name\":[\"T1089 - Disabling Security Tools\"],\"module_id\":null,\"name\":\"A user enabled the Windows DefaultAccount\",\"operation_name\":null,\"original_tags\":[\"EG:k8s agents\",\"EG:windows\",\"ET:DESKTOP-FCCIPAN\"],\"os_actor_causality_id\":null,\"os_actor_effective_username\":null,\"os_actor_process_causality_id\":[\"\\u003cprocess_causality_id\\u003e\"],\"os_actor_process_command_line\":[\"\\u003ccommand_line\\u003e\"],\"os_actor_process_image_name\":[\"\\u003cimage_name\\u003e\"],\"os_actor_process_image_path\":[\"\\u003cimage_path\\u003e\"],\"os_actor_process_image_sha256\":[\"\\u003cimage_sha256\\u003e\"],\"os_actor_process_instance_id\":[\"\\u003cinstance_id\\u003e\"],\"os_actor_process_os_pid\":[996],\"os_actor_process_signature_status\":[\"Signed\"],\"os_actor_process_signature_vendor\":[\"\\u003cSignature_vendor\\u003e\"],\"os_actor_thread_thread_id\":[7205],\"project\":null,\"referenced_resource\":null,\"resolution_comment\":null,\"resolution_status\":\"STATUS_010_NEW\",\"resource_sub_type\":null,\"resource_type\":null,\"severity\":\"low\",\"source\":null,\"starred\":true,\"story_id\":null,\"tags\":[\"ET:DESKTOP-FCCIPAN\",\"EG:k8s agents\",\"EG:windows\"],\"user_agent\":null,\"user_name\":[\"\\u003cuser_name\\u003e\"]}",
          "reason": "The user domain\\username enabled a default account. The default account enabled: domain\\username",
          "severity": 2,
          "type": [
              "info"
          ]
      },
      "host": {
          "hostname": "<host_name>",
          "id": "<endpoint_id>",
          "ip": [
              "192.168.2.2"
          ],
          "name": "<host_name>",
          "os": {
              "name": "<os_type>",
              "version": "<os_sub_type>"
          }
      },
      "input": {
          "type": "cel"
      },
      "message": "A user enabled the Windows DefaultAccount",
      "panw_cortex": {
          "xdr": {
              "action_country": [
                  "UNKNOWN"
              ],
              "action_pretty": "Detected",
              "actor_causality_id": [
                  "<actor_causality_id>"
              ],
              "actor_process_causality_id": [
                  "<process_causality_id>"
              ],
              "actor_process_signature_status": [
                  "Signed"
              ],
              "agent_host_boot_time": "2022-11-22T14:42:45.772Z",
              "agent_install_type": "STANDARD",
              "agent_is_vdi": false,
              "agent_version": "<agent_version>",
              "alert_id": "1",
              "alert_type": "Unclassified",
              "association_strength": [
                  50
              ],
              "attempt_counter": 0,
              "case_id": 9629,
              "category": "<category>",
              "contains_featured_host": [
                  "NO"
              ],
              "contains_featured_ip": [
                  "NO"
              ],
              "contains_featured_user": [
                  "NO"
              ],
              "dst_agent_id": [
                  "<agent_id>"
              ],
              "event_id": [
                  "<event_id>"
              ],
              "event_sub_type": [
                  1
              ],
              "event_type": [
                  "Process Execution"
              ],
              "fw_is_phishing": [
                  "N/A"
              ],
              "is_pcap": false,
              "is_whitelisted": false,
              "local_insert_ts": "2023-01-10T17:44:07.792Z",
              "matching_service_rule_id": "<service_rule_id>",
              "matching_status": "MATCHED",
              "original_tags": [
                  "EG:k8s agents",
                  "EG:windows",
                  "ET:DESKTOP-FCCIPAN"
              ],
              "os_actor_process_causality_id": [
                  "<process_causality_id>"
              ],
              "os_actor_process_command_line": [
                  "<command_line>"
              ],
              "os_actor_process_image_name": [
                  "<image_name>"
              ],
              "os_actor_process_image_path": [
                  "<image_path>"
              ],
              "os_actor_process_image_sha256": [
                  "<image_sha256>"
              ],
              "os_actor_process_instance_id": [
                  "<instance_id>"
              ],
              "os_actor_process_os_pid": [
                  996
              ],
              "os_actor_process_signature_status": [
                  "Signed"
              ],
              "os_actor_process_signature_vendor": [
                  "<Signature_vendor>"
              ],
              "os_actor_thread_thread_id": [
                  7205
              ],
              "resolution_status": "STATUS_010_NEW",
              "starred": true
          }
      },
      "process": {
          "code_signature": {
              "status": [
                  "N/A"
              ],
              "subject_name": [
                  "<signature_vendor>"
              ]
          },
          "command_line": [
              "<command_line>"
          ],
          "entity_id": [
              "<instance_id>"
          ],
          "executable": [
              "<image_path>"
          ],
          "hash": {
              "md5": [
                  "<image_md5>"
              ],
              "sha256": [
                  "<image_sha256>"
              ]
          },
          "name": [
              "<image_name>"
          ],
          "parent": {
              "code_signature": {
                  "status": [
                      "Signed"
                  ],
                  "subject_name": [
                      "<signature_vendor>"
                  ]
              },
              "command_line": [
                  "<command_line>"
              ],
              "entity_id": [
                  "<causality_id>"
              ],
              "executable": [
                  "<image_path>"
              ],
              "hash": {
                  "md5": [
                      "<image_md5>"
                  ],
                  "sha256": [
                      "<sha256>"
                  ]
              },
              "name": [
                  "<image_name>"
              ],
              "uptime": [
                  1669528171295
              ]
          },
          "pid": [
              996
          ],
          "thread": {
              "id": [
                  7452
              ]
          }
      },
      "related": {
          "hash": [
              "<image_md5>",
              "<sha256>",
              "<image_sha256>"
          ],
          "user": [
              "<user_name>"
          ]
      },
      "source": {
          "user": {
              "name": "<user_name>"
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "panw_cortex_xdr",
          "ET:DESKTOP-FCCIPAN",
          "EG:k8s agents",
          "EG:windows"
      ],
      "threat": {
          "framework": "MITRE ATT&CK",
          "tactic": {
              "id": [
                  "TA0005"
              ],
              "name": [
                  "Defense Evasion"
              ]
          },
          "technique": {
              "id": [
                  "T1089"
              ],
              "name": [
                  "Disabling Security Tools"
              ]
          }
      },
      "user": {
          "name": "<user_name>"
      }
  }
  ```
</dropdown>


### Event

This is the `Event` dataset.

#### Example

<dropdown title="Exported fields">
  | Field                                                             | Description             | Type             |
  |-------------------------------------------------------------------|-------------------------|------------------|
  | @timestamp                                                        | Event timestamp.        | date             |
  | data_stream.dataset                                               | Data stream dataset.    | constant_keyword |
  | data_stream.namespace                                             | Data stream namespace.  | constant_keyword |
  | data_stream.type                                                  | Data stream type.       | constant_keyword |
  | event.dataset                                                     | Event dataset.          | constant_keyword |
  | event.module                                                      | Event module.           | constant_keyword |
  | gcs.storage.bucket.name                                           |                         | keyword          |
  | gcs.storage.object.content_type                                   |                         | keyword          |
  | gcs.storage.object.name                                           |                         | keyword          |
  | input.type                                                        | Type of filebeat input. | keyword          |
  | log.offset                                                        | Log offset.             | long             |
  | panw_cortex.xdr.event.action.boot_time                            |                         | date             |
  | panw_cortex.xdr.event.action.file.access_time                     |                         | date             |
  | panw_cortex.xdr.event.action.file.attributes                      |                         | keyword          |
  | panw_cortex.xdr.event.action.file.create_time                     |                         | date             |
  | panw_cortex.xdr.event.action.file.device_type                     |                         | keyword          |
  | panw_cortex.xdr.event.action.file.group                           |                         | keyword          |
  | panw_cortex.xdr.event.action.file.group_name                      |                         | keyword          |
  | panw_cortex.xdr.event.action.file.is_anonymous                    |                         | boolean          |
  | panw_cortex.xdr.event.action.file.last_writer_actor               |                         | keyword          |
  | panw_cortex.xdr.event.action.file.md5                             |                         | keyword          |
  | panw_cortex.xdr.event.action.file.mod_time                        |                         | date             |
  | panw_cortex.xdr.event.action.file.mode                            |                         | keyword          |
  | panw_cortex.xdr.event.action.file.name                            |                         | keyword          |
  | panw_cortex.xdr.event.action.file.operation_flags                 |                         | keyword          |
  | panw_cortex.xdr.event.action.file.owner                           |                         | keyword          |
  | panw_cortex.xdr.event.action.file.owner_name                      |                         | keyword          |
  | panw_cortex.xdr.event.action.file.path                            |                         | keyword          |
  | panw_cortex.xdr.event.action.file.pe_info                         |                         | keyword          |
  | panw_cortex.xdr.event.action.file.prev_type                       |                         | keyword          |
  | panw_cortex.xdr.event.action.file.previous_file_name              |                         | keyword          |
  | panw_cortex.xdr.event.action.file.previous_file_path              |                         | keyword          |
  | panw_cortex.xdr.event.action.file.sha256                          |                         | keyword          |
  | panw_cortex.xdr.event.action.file.signature_is_embedded           |                         | boolean          |
  | panw_cortex.xdr.event.action.file.signature_product               |                         | keyword          |
  | panw_cortex.xdr.event.action.file.signature_status                |                         | keyword          |
  | panw_cortex.xdr.event.action.file.signature_vendor                |                         | keyword          |
  | panw_cortex.xdr.event.action.file.size                            |                         | long             |
  | panw_cortex.xdr.event.action.file.type                            |                         | keyword          |
  | panw_cortex.xdr.event.action.local_ip                             |                         | ip               |
  | panw_cortex.xdr.event.action.local_port                           |                         | long             |
  | panw_cortex.xdr.event.action.module.base_address                  |                         | keyword          |
  | panw_cortex.xdr.event.action.module.boot_code_integrity           |                         | keyword          |
  | panw_cortex.xdr.event.action.module.code_integrity                |                         | keyword          |
  | panw_cortex.xdr.event.action.module.file_info                     |                         | keyword          |
  | panw_cortex.xdr.event.action.module.image_size                    |                         | double           |
  | panw_cortex.xdr.event.action.module.last_writer_actor             |                         | keyword          |
  | panw_cortex.xdr.event.action.module.md5                           |                         | keyword          |
  | panw_cortex.xdr.event.action.module.other_load_location           |                         | keyword          |
  | panw_cortex.xdr.event.action.module.page_protection               |                         | keyword          |
  | panw_cortex.xdr.event.action.module.path                          |                         | keyword          |
  | panw_cortex.xdr.event.action.module.sha256                        |                         | keyword          |
  | panw_cortex.xdr.event.action.module.signature_is_embedded         |                         | boolean          |
  | panw_cortex.xdr.event.action.module.signature_product             |                         | keyword          |
  | panw_cortex.xdr.event.action.module.signature_status              |                         | keyword          |
  | panw_cortex.xdr.event.action.module.signature_vendor              |                         | keyword          |
  | panw_cortex.xdr.event.action.module.system_properties             |                         | keyword          |
  | panw_cortex.xdr.event.action.network.connection_id                |                         | keyword          |
  | panw_cortex.xdr.event.action.network.creation_time                |                         | date             |
  | panw_cortex.xdr.event.action.network.is_server                    |                         | boolean          |
  | panw_cortex.xdr.event.action.network.protocol                     |                         | keyword          |
  | panw_cortex.xdr.event.action.network.stats_is_last                |                         | boolean          |
  | panw_cortex.xdr.event.action.powered_off                          |                         | keyword          |
  | panw_cortex.xdr.event.action.process.fds                          |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_command_line           |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_extension              |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_md5                    |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_name                   |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_path                   |                         | keyword          |
  | panw_cortex.xdr.event.action.process.image_sha256                 |                         | keyword          |
  | panw_cortex.xdr.event.action.process.in_txn                       |                         | boolean          |
  | panw_cortex.xdr.event.action.process.instance_execution_time      |                         | date             |
  | panw_cortex.xdr.event.action.process.instance_id                  |                         | keyword          |
  | panw_cortex.xdr.event.action.process.integrity_level              |                         | keyword          |
  | panw_cortex.xdr.event.action.process.last_writer_actor            |                         | keyword          |
  | panw_cortex.xdr.event.action.process.os_pid                       |                         | long             |
  | panw_cortex.xdr.event.action.process.pe_load_info                 |                         | keyword          |
  | panw_cortex.xdr.event.action.process.peb                          |                         | keyword          |
  | panw_cortex.xdr.event.action.process.peb32                        |                         | keyword          |
  | panw_cortex.xdr.event.action.process.privileges                   |                         | keyword          |
  | panw_cortex.xdr.event.action.process.scheduled_task_name          |                         | keyword          |
  | panw_cortex.xdr.event.action.process.signature_is_embedded        |                         | boolean          |
  | panw_cortex.xdr.event.action.process.signature_product            |                         | keyword          |
  | panw_cortex.xdr.event.action.process.signature_status             |                         | keyword          |
  | panw_cortex.xdr.event.action.process.signature_vendor             |                         | keyword          |
  | panw_cortex.xdr.event.action.process.termination_code             |                         | long             |
  | panw_cortex.xdr.event.action.process.termination_date             |                         | date             |
  | panw_cortex.xdr.event.action.process.token                        |                         | keyword          |
  | panw_cortex.xdr.event.action.process.user_sid                     |                         | keyword          |
  | panw_cortex.xdr.event.action.process.username                     |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.data                        |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.file_path                   |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.key_name                    |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.old_key_name                |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.return_val                  |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.value_name                  |                         | keyword          |
  | panw_cortex.xdr.event.action.registry.value_type                  |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_ip                            |                         | ip               |
  | panw_cortex.xdr.event.action.remote_port                          |                         | long             |
  | panw_cortex.xdr.event.action.remote_process.image_command_line    |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.image_md5             |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.image_name            |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.image_path            |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.image_sha256          |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.instance_id           |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.integrity_level       |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.os_pid                |                         | long             |
  | panw_cortex.xdr.event.action.remote_process.signature_is_embedded |                         | boolean          |
  | panw_cortex.xdr.event.action.remote_process.signature_product     |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.signature_status      |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.signature_vendor      |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.thread_id             |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.thread_start_address  |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.user_sid              |                         | keyword          |
  | panw_cortex.xdr.event.action.remote_process.username              |                         | keyword          |
  | panw_cortex.xdr.event.action.socket_type                          |                         | keyword          |
  | panw_cortex.xdr.event.action.total_download                       |                         | long             |
  | panw_cortex.xdr.event.action.total_upload                         |                         | long             |
  | panw_cortex.xdr.event.action.user_is_local_session                |                         | boolean          |
  | panw_cortex.xdr.event.action.user_session_id                      |                         | keyword          |
  | panw_cortex.xdr.event.action.user_status                          |                         | keyword          |
  | panw_cortex.xdr.event.action.user_status_sid                      |                         | keyword          |
  | panw_cortex.xdr.event.action.username                             |                         | keyword          |
  | panw_cortex.xdr.event.address_mapping                             |                         | keyword          |
  | panw_cortex.xdr.event.agent.content_version                       |                         | keyword          |
  | panw_cortex.xdr.event.agent.hostname                              |                         | keyword          |
  | panw_cortex.xdr.event.agent.id                                    |                         | keyword          |
  | panw_cortex.xdr.event.agent.interface_map                         |                         | keyword          |
  | panw_cortex.xdr.event.agent.ip_addresses                          |                         | ip               |
  | panw_cortex.xdr.event.agent.ip_addresses_v6                       |                         | ip               |
  | panw_cortex.xdr.event.agent.os_sub_type                           |                         | keyword          |
  | panw_cortex.xdr.event.agent.os_type                               |                         | keyword          |
  | panw_cortex.xdr.event.agent.version                               |                         | keyword          |
  | panw_cortex.xdr.event.event_id                                    |                         | keyword          |
  | panw_cortex.xdr.event.event_rpc_func_opnum                        |                         | keyword          |
  | panw_cortex.xdr.event.event_rpc_interface_uuid                    |                         | keyword          |
  | panw_cortex.xdr.event.event_sub_type                              |                         | keyword          |
  | panw_cortex.xdr.event.event_timestamp                             |                         | date             |
  | panw_cortex.xdr.event.event_type                                  |                         | keyword          |
  | panw_cortex.xdr.event.event_version                               |                         | keyword          |
  | panw_cortex.xdr.event.host_metadata.domain                        |                         | keyword          |
  | panw_cortex.xdr.event.host_metadata.hostname                      |                         | keyword          |
  | panw_cortex.xdr.event.host_metadata.interface_map                 |                         | keyword          |
  | panw_cortex.xdr.event.id                                          |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.local_ip                           |                         | ip               |
  | panw_cortex.xdr.event.os_actor.local_port                         |                         | long             |
  | panw_cortex.xdr.event.os_actor.primary_user_sid                   |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.primary_username                   |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_command_line               |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_image_md5                  |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_image_name                 |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_image_path                 |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_image_sha256               |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_instance_id                |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_logon_id                   |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_os_pid                     |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.process_signature_status           |                         | keyword          |
  | panw_cortex.xdr.event.os_actor.remote_ip                          |                         | ip               |
  | panw_cortex.xdr.event.os_actor.thread_thread_id                   |                         | keyword          |
  | panw_cortex.xdr.event.uuid                                        |                         | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2026-01-09T09:53:25.240Z",
      "agent": {
          "ephemeral_id": "41b0fb66-8a23-49d9-ad8f-de62d6617c6f",
          "id": "6a5b6dac-f7f7-4ab2-bfed-80a8c1b2bd0c",
          "name": "elastic-agent-55081",
          "type": "filebeat",
          "version": [
              "8.18.0"
          ]
      },
      "cloud": {
          "provider": "google cloud"
      },
      "data_stream": {
          "dataset": "panw_cortex_xdr.event",
          "namespace": "14968",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "6a5b6dac-f7f7-4ab2-bfed-80a8c1b2bd0c",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "panw_cortex_xdr.event",
          "ingested": "2026-01-09T09:53:28Z",
          "kind": "event"
      },
      "gcs": {
          "storage": {
              "bucket": {
                  "name": "testbucket"
              },
              "object": {
                  "content_type": "application/x-ndjson",
                  "name": "test-event.log"
              }
          }
      },
      "input": {
          "type": "gcs"
      },
      "log": {
          "file": {
              "path": "gs://testbucket/test-event.log"
          },
          "offset": 0
      },
      "observer": {
          "product": "Cortex XDR",
          "vendor": "Palo Alto Networks"
      },
      "panw_cortex": {
          "xdr": {
              "event": {
                  "agent": {
                      "os_type": "NO_HOST"
                  }
              }
          }
      },
      "tags": [
          "forwarded",
          "panw_cortex_xdr-event"
      ]
  }
  ```
</dropdown>


### Incidents

This is the `Incidents` dataset.

#### Example

<dropdown title="Exported fields">
  | Field                                          | Description                                          | Type             |
  |------------------------------------------------|------------------------------------------------------|------------------|
  | @timestamp                                     | Event timestamp.                                     | date             |
  | cloud.image.id                                 | Image ID for the cloud instance.                     | keyword          |
  | data_stream.dataset                            | Data stream dataset name.                            | constant_keyword |
  | data_stream.namespace                          | Data stream namespace.                               | constant_keyword |
  | data_stream.type                               | Data stream type.                                    | constant_keyword |
  | event.dataset                                  | Event dataset                                        | constant_keyword |
  | event.module                                   | Event module                                         | constant_keyword |
  | host.containerized                             | If the host is a container.                          | boolean          |
  | host.os.build                                  | OS build information.                                | keyword          |
  | host.os.codename                               | OS codename, if any.                                 | keyword          |
  | input.type                                     | Type of Filebeat input.                              | keyword          |
  | log.flags                                      | Flags for the log file.                              | keyword          |
  | log.offset                                     | Offset of the entry in the log file.                 | long             |
  | panw_cortex.xdr.aggregated_score               | Aggregated incident score.                           | long             |
  | panw_cortex.xdr.alert_categories               | Categories for alerts contained in the incident.     | keyword          |
  | panw_cortex.xdr.alert_count                    | Count of alerts.                                     | long             |
  | panw_cortex.xdr.alerts_grouping_status         | Is alert grouping enabled for this incident.         | keyword          |
  | panw_cortex.xdr.assigned_user_mail             | Email for the assigned user.                         | keyword          |
  | panw_cortex.xdr.assigned_user_pretty_name      | Pretty name for the assigned user.                   | keyword          |
  | panw_cortex.xdr.creation_time                  | Incident creation time.                              | date             |
  | panw_cortex.xdr.critical_severity_alert_count  | Count of critical severity alerts for this incident. | long             |
  | panw_cortex.xdr.detection_time                 | Detection time.                                      | flattened        |
  | panw_cortex.xdr.high_severity_alert_count      | Count of high severity alerts for this incident.     | long             |
  | panw_cortex.xdr.host_count                     | Count of hosts related to this incident.             | long             |
  | panw_cortex.xdr.hosts                          | Host names and host ID's related to this incident.   | keyword          |
  | panw_cortex.xdr.incident_id                    | Incident ID                                          | keyword          |
  | panw_cortex.xdr.incident_name                  | Incident name                                        | keyword          |
  | panw_cortex.xdr.incident_sources               | Detection sources for this incident.                 | keyword          |
  | panw_cortex.xdr.low_severity_alert_count       | Count of low severity alerts for this incident.      | long             |
  | panw_cortex.xdr.manual_description             | Manual incident description.                         | keyword          |
  | panw_cortex.xdr.manual_score                   | Manual incident score.                               | flattened        |
  | panw_cortex.xdr.manual_severity                | Manual incident severity.                            | keyword          |
  | panw_cortex.xdr.med_severity_alert_count       | Count of medium severity alerts for this incident.   | long             |
  | panw_cortex.xdr.mitre_tactics_ids_and_names    | MITRE tactic ID's and names                          | keyword          |
  | panw_cortex.xdr.mitre_techniques_ids_and_names | MITRE technique ID's and names                       | keyword          |
  | panw_cortex.xdr.modification_time              | Incident modification time.                          | date             |
  | panw_cortex.xdr.notes                          | Incident notes.                                      | keyword          |
  | panw_cortex.xdr.original_tags                  | Original tags for the asset.                         | keyword          |
  | panw_cortex.xdr.predicted_score                | Predicted incident score.                            | long             |
  | panw_cortex.xdr.resolve_comment                | Incident resolution comment.                         | keyword          |
  | panw_cortex.xdr.resolved_timestamp             | Incident resolution timestamp.                       | date             |
  | panw_cortex.xdr.rule_based_score               | Rule based incident score.                           | long             |
  | panw_cortex.xdr.starred                        | Starred incident.                                    | boolean          |
  | panw_cortex.xdr.status                         | Incident status.                                     | keyword          |
  | panw_cortex.xdr.user_count                     | Count of users related to the incident.              | long             |
  | panw_cortex.xdr.users                          | Usernames related to the incident.                   | keyword          |
  | panw_cortex.xdr.wildfire_hits                  | Count of Wildfire hits.                              | long             |
  | panw_cortex.xdr.xdr_url                        | URL to Cortex XDR incident.                          | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-08-14T01:20:00.230Z",
      "agent": {
          "ephemeral_id": "e1814412-1326-41f3-b153-5bd708d40552",
          "id": "7f5f6bca-166d-46a2-874d-55a948603d37",
          "name": "elastic-agent-65535",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "panw_cortex_xdr.incidents",
          "namespace": "39520",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7f5f6bca-166d-46a2-874d-55a948603d37",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "malware"
          ],
          "created": "2023-08-14T01:20:00.230Z",
          "dataset": "panw_cortex_xdr.incidents",
          "id": "893",
          "ingested": "2026-01-29T10:01:50Z",
          "kind": "alert",
          "original": "{\"aggregated_score\":5,\"alert_categories\":[\"Exfiltration\"],\"alert_count\":1,\"alerts_grouping_status\":\"Enabled\",\"assigned_user_mail\":null,\"assigned_user_pretty_name\":null,\"creation_time\":1691976000230,\"critical_severity_alert_count\":0,\"description\":\"'Large Upload (Generic)' generated by XDR Analytics detected on host test1234 involving user nt authority\\\\system\",\"detection_time\":null,\"high_severity_alert_count\":0,\"host_count\":1,\"hosts\":[\"test1234:b567c1a651e66999158aef5d864dad25\"],\"incident_id\":\"893\",\"incident_name\":null,\"incident_sources\":[\"XDR Analytics\"],\"low_severity_alert_count\":1,\"manual_description\":null,\"manual_score\":null,\"manual_severity\":null,\"med_severity_alert_count\":0,\"mitre_tactics_ids_and_names\":[\"TA0010 - Exfiltration\"],\"mitre_techniques_ids_and_names\":[\"T1048 - Exfiltration Over Alternative Protocol\"],\"modification_time\":1691976000230,\"notes\":null,\"original_tags\":[\"DS:PANW/XDR Agent\",\"EG:win-server-ex-ransomeware_report\",\"EG:win-server-default\"],\"predicted_score\":5,\"resolve_comment\":null,\"resolved_timestamp\":null,\"rule_based_score\":null,\"severity\":\"low\",\"starred\":false,\"status\":\"new\",\"tags\":[\"DS:PANW/XDR Agent\",\"EG:win-server-default\",\"EG:win-server-ex-ransomeware_report\"],\"user_count\":1,\"users\":[\"nt authority\\\\system\"],\"wildfire_hits\":0,\"xdr_url\":\"https://test.xdr.eu.paloaltonetworks.com/incident-view?caseId=893\"}",
          "reason": "'Large Upload (Generic)' generated by XDR Analytics detected on host test1234 involving user nt authority\\system",
          "severity": 2,
          "type": [
              "info"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "panw_cortex": {
          "xdr": {
              "aggregated_score": 5,
              "alert_categories": [
                  "Exfiltration"
              ],
              "alert_count": 1,
              "alerts_grouping_status": "Enabled",
              "creation_time": "2023-08-14T01:20:00.230Z",
              "critical_severity_alert_count": 0,
              "high_severity_alert_count": 0,
              "host_count": 1,
              "hosts": [
                  "test1234:b567c1a651e66999158aef5d864dad25"
              ],
              "incident_sources": [
                  "XDR Analytics"
              ],
              "low_severity_alert_count": 1,
              "med_severity_alert_count": 0,
              "mitre_tactics_ids_and_names": [
                  "TA0010 - Exfiltration"
              ],
              "mitre_techniques_ids_and_names": [
                  "T1048 - Exfiltration Over Alternative Protocol"
              ],
              "modification_time": "2023-08-14T01:20:00.230Z",
              "original_tags": [
                  "DS:PANW/XDR Agent",
                  "EG:win-server-ex-ransomeware_report",
                  "EG:win-server-default"
              ],
              "predicted_score": 5,
              "starred": false,
              "status": "new",
              "user_count": 1,
              "users": [
                  "nt authority\\system"
              ],
              "wildfire_hits": 0,
              "xdr_url": "https://test.xdr.eu.paloaltonetworks.com/incident-view?caseId=893"
          }
      },
      "related": {
          "hosts": [
              "test1234"
          ],
          "user": [
              "system"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "panw_cortex_xdr",
          "DS:PANW/XDR Agent",
          "EG:win-server-default",
          "EG:win-server-ex-ransomeware_report"
      ],
      "threat": {
          "framework": "MITRE ATT&CK",
          "tactic": {
              "id": [
                  "TA0010"
              ],
              "name": [
                  "Exfiltration"
              ]
          },
          "technique": {
              "id": [
                  "T1048"
              ],
              "name": [
                  "Exfiltration Over Alternative Protocol"
              ]
          }
      }
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Alerts Dashboard](https://epr.elastic.co/package/panw_cortex_xdr/2.5.0/img/panw_cortex_xdr-alerts.png)

  ![Events Dashboard](https://epr.elastic.co/package/panw_cortex_xdr/2.5.0/img/panw_cortex_xdr-events.png)

  ![Incidents Dashboard](https://epr.elastic.co/package/panw_cortex_xdr/2.5.0/img/panw_cortex_xdr-incidents.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17120))Prevent updating fleet health status to degraded when template evaluation fails.                                                                                         | 9.1.49.0.78.19.4       |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14393))Use `terminate` processor instead of `fail` processor to handle agent errors.                                                                                            | 9.0.08.18.0            |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                  | 9.0.08.18.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14091))Improve rate limit configuration.                                                                                                                                        | 9.0.08.18.0            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13680))Add event data stream to collect event forwarding logs via the Google Cloud Storage input and add dashboards for alert and incident data stream.                         | 9.0.08.18.0            |
  | **2.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12997))Updated description to ssl nodes to be consistent with other packages descriptions.                                                                                          | 9.0.08.13.0            |
  | **2.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13007))Fix CEL type conversion in alerts v2.                                                                                                                                        | 9.0.08.13.0            |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12725))Add support for alerts v2 API.                                                                                                                                           | 8.13.0                 |
  | **1.32.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12857))Delete the `remove` processor thats clearing all fields and update rename processors with `override - true`.                                                                 | 8.13.0                 |
  | **1.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12342))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10774))Use Cortex XDR SIEM ingestion time for cursor progression.                                                                                                               | 8.13.0                 |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9246))Modify incident handling to match Defender for Endpoint. Change fingerprint, timestamp, and search cursor to modification_time. Add severity:critical.                    | 8.13.0                 |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                      | 8.12.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.24.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9175))Clean up null handling                                                                                                                                                        | 8.7.1                  |
  | **1.24.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping of group fields                                                                                                                                                   | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7389))Add incident type events                                                                                                                                                  | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7295))Update package-spec to 2.9.0.                                                                                                                                             | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7190))Document SSL options                                                                                                                                                      | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6662))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6057))Lowercase host.name field                                                                                                                                                 | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6051))Drop empty events                                                                                                                                                         | 8.0.07.15.0            |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6043))Map Threat ECS fields to Mitre                                                                                                                                            | 8.0.07.15.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.15.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.15.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5244))Add support for Advanced security level                                                                                                                                   | 8.0.07.15.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.15.0            |
  | **1.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4828))Conform user fields to ECS standards.                                                                                                                                         | 8.0.07.15.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4633))Remove duplicate fields.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4633))Make mac addresses conform with ECS syntax.                       | 8.0.07.15.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.15.0            |
  | **1.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.15.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3953))Bugfix on rename processors with conditionals.                                                                                                                            | 8.0.07.15.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3869))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.15.0            |
  | **1.3.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3767))Fix possible endless pagination.                                                                                                                                              | 8.0.07.15.0            |
  | **1.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.15.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3635))Fix rate limit.                                                                                                                                                               | 8.0.07.15.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.15.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3144))Updated the links in the file to Palo Alto Cortex XDR documentation                                                                                                       | 8.0.07.15.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2799))Update to ECS 8.2 to use new email field set.                                                                                                                             | 8.0.07.15.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.15.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2431))Update to ECS 8.0                                                                                                                                                         | 8.0.07.15.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2360))GA integration                                                                                                                                                            | 8.0.07.15.0            |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2275))Add 8.0.0 version constraint                                                                                                                                              |                        |
  | **0.2.6**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            |                        |
  | **0.2.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                |                        |
  | **0.2.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2092))Uniform with guidelines                                                                                                                                                   |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1980))Update Title and Description.                                                                                                                                             |                        |
  | **0.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1921))Fix duplicate events                                                                                                                                                          |                        |
  | **0.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1841))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1673))Update to ECS 1.12.0                                                                                                                                                      |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1327))initial release                                                                                                                                                           |                        |
</dropdown>