﻿---
title: OpenTelemetry internal telemetry Assets
description: This package contains dashboards that visualize the internal metrics from OpenTelemetry components. The OTel collector dashboards are compatible with...
url: https://www.elastic.co/docs/reference/integrations/otel_internal_telemetry
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# OpenTelemetry internal telemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.0.3 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.1                                                          |

<admonition title="The OpenTelemetry Internal Telemetry integration v0.0.3 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

This package contains dashboards that visualize the internal metrics from OpenTelemetry components.

### Compatibility

The OTel collector dashboards are compatible with the metrics defined [here in the OpenTelemetry collector documentation](https://opentelemetry.io/docs/collector/internal-telemetry/). The oldest tested version of the OpenTelemetry Collector in combination with this package is v1.44.0.

### How it works

The dashboards rely on field names defined in above documentation.

## What do I need to use this integration?

You need to follow [the documentation](https://opentelemetry.io/docs/collector/internal-telemetry/) of the OpenTelemetry collector to setup and send internal telemetry to your cluster.
The most important prerequisite is to define the `telemetry` section under `service`:
```
service:
  telemetry:
    metrics:
      readers:
        - periodic:
            exporter:
              otlp:
                protocol: http/protobuf
                endpoint: https://backend:4318
```

With this, you'll have internal telemetry on `normal` verbosity level.
The above configuration defines an OTLP endpoint that sends internal telemetry to a target collector over an OTLP connection. This target collector then exports the internal telemetry data to Elasticsearch using the `elasticsearch` exporter. The integration subsequently reads this internal telemetry data from Elasticsearch.
For all the other config, refer to the upstream documentation.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Metrics Overview](https://epr.elastic.co/package/otel_internal_telemetry/0.0.3/img/otel-metrics-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                             | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.0.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17248))Extend docs                                                                                                                                                |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17199))Use SVG for icon                                                                                                                                           |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16305))Adding visualizations for OpenTelemetry Collector internal telemetry including CPU, memory, usage, queue size, failed and exported spans, metrics, traces. |                        |
</dropdown>