﻿---
title: Osquery Manager integration
description: With this integration, you can centrally manage Osquery deployments to Elastic Agents in your Fleet and query host data through distributed SQL. This...
url: https://www.elastic.co/docs/reference/integrations/osquery_manager
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Osquery Manager integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.22.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Required permissions**                                                                        | Root privileges                 |
| **Minimum Kibana version(s)**                                                                   | 9.3.0                           |

With this integration, you can centrally manage [Osquery](https://osquery.io/) deployments to Elastic Agents in your Fleet and query host data through distributed SQL.
This integration adds an Osquery UI in Kibana where you can:
- Run live queries for one or more agents
- View a history of past queries and their results
- Schedule queries to capture OS state changes over time
- Save queries and build a library of queries for specific use cases

Osquery results are stored in Elasticsearch, so that you can use the power of the stack to search, analyze, and visualize Osquery data.

## Investigate with Osquery

For information about using Osquery, refer to the [Osquery Kibana documentation](https://www.elastic.co/docs/solutions/security/investigate/osquery).
This includes information about required privileges; how to run, schedule, and save queries; how to map osquery fields to ECS; and other useful information about managing Osquery with this integration.
For information about Osquery tables, refer to the [Osquery schema documentation](https://osquery.io/schema) and [Osquery Extension for Elastic](https://github.com/elastic/beats/blob/main/x-pack/osquerybeat/ext/osquery-extension/README.md).

## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                     | Minimum Kibana version |
  |------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17085))Add core forensics packs                                                                                                           | 9.3.0                  |
  | **1.21.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16717))Update documentation and add link to Osquery tables                                                                                | 9.3.0                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15888))Add core forensics saved queries                                                                                                   | 9.3.0                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16509))Update osquery to version 5.19.0                                                                                                   | 9.3.0                  |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15781))Add root requirement for the integration                                                                                               | 9.2.0                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15321))Update osquery to version 5.18.1 and ECS to 9.10.0                                                                                 | 9.2.0                  |
  | **1.18.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14256))Adjust result mapping to match action responses                                                                                        | 9.0.08.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13255))Update schema for osquery 5.15.0                                                                                                   | 9.0.08.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12821))Add support for Kibana `9.0.0`.                                                                                                    | 9.0.08.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11583))Add mappings for ECS email fields                                                                                                  | 8.16.0                 |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11146))Update schema for osquery 5.13.1                                                                                                   | 8.16.0                 |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10641))Update schema for osquery 5.12.1                                                                                                   | 8.16.0                 |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9661))Add action responses data stream                                                                                                    | 8.15.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8488))Update schema for osquery 5.10.2                                                                                                    | 8.12.0                 |
  | **1.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mapping of group fields                                                                                                             | 8.10.1                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7894))Upgrade osquery_manager for serverless, pick up ECS 8.10.0                                                                          | 8.10.1                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7094))Update schema for osquery 5.8.2                                                                                                     | 8.10.0                 |
  | **1.8.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6836))Convert dashboards to Lens                                                                                                          | 8.7.1                  |
  | **1.7.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6770))Fix elf.sections mapping                                                                                                            | 8.7.0                  |
  | **1.7.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6190))Resolve mapping conflicts for user.id, user.group.id, group.id                                                                      | 8.7.0                  |
  | **1.7.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5136))Fix mapping conflicts                                                                                                               | 8.7.0                  |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                              | 8.7.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5175))Update schema for osquery 5.7.0                                                                                                     | 8.7.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4990))Fix osquery_manager data_stream values for 8.6.0 with ingest pipeline                                                               | 8.6.0                  |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4640))Update kibana constraint to ^8.6                                                                                                    | 8.6.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4483))Update schema for osquery 5.5.1                                                                                                     |                        |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3659))Add prebuilt DFIR-related saved queries                                                                                             | 8.4.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3922))Update schema for osquery 5.4.0                                                                                                     | 8.4.0                  |
  | **1.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3725))Fix field mapping conflicts**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3725))Update to ECS v8.3.0 | 8.3.0                  |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3386))Update prebuilt saved queries objects                                                                                               | 8.3.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2998))Add prebuilt saved queries                                                                                                          |                        |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3093))Update readme to remove exported fields                                                                                             | 8.2.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2851))Add packs and dashboards                                                                                                            | 8.2.0                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2836))Upgrade schema and readme to match osquery 5.2.2.                                                                                   |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2534))GA                                                                                                                                  | 8.0.07.16.0            |
  | **0.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2524))Add explicit mapping for the text fields                                                                                            |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2322))Add 8.0.0 version constraint                                                                                                        |                        |
  | **0.7.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2327))Update fields and readme with host_users, host_groups, host_processes tables.                                                       |                        |
  | **0.7.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2007))Update team owner.                                                                                                                  |                        |
  | **0.7.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1996))Update description.                                                                                                                 |                        |
  | **0.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2327))Update ecs.yml to include all `date` and `ip` ECS 1.12.0 fields types.                                                              |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1703))Update to ECS 1.12.0                                                                                                                |                        |
  | **0.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1756))Upgrade schema and readme to match osquery 5.0.1.                                                                                   |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1715))Change the package to adopt the native osquery configuration better.                                                                |                        |
  | **0.5.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1734))Updates readme and adds link to Kibana docs                                                                                         |                        |
  | **0.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1574))Updates host.ip field mapping from keyword to ip data type                                                                          |                        |
  | **0.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1456))Updates mapping and readme for osquery 4.9.0                                                                                        |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                      |                        |
  | **0.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1360))Update ECS mapping format based on the latest developers feedback                                                                   |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1318))ECS mapping configuration support for queries/streams                                                                               |                        |
  | **0.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1281))Updates Osquery Manager readme for 7.14 Release                                                                                     |                        |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1213))Updates Osquery Manager mapping and readme for osquery 4.8.0                                                                        |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/985))Add platform and version fields to the streams configuration                                                                         |                        |
  | **0.2.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1020))Update schema fields description and README                                                                                         |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/978))Update manifest and README                                                                                                           |                        |
  | **0.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/948))Update docs                                                                                                                          |                        |
  | **0.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/916))change to beta                                                                                                                       |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/902))Explicit mappings                                                                                                                    |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/812))initial release                                                                                                                      |                        |
</dropdown>