﻿---
title: Microsoft Office 365 Integration
description: The Microsoft Office 365 integration for Elastic collects activity data using the Office 365 Management Activity API. This data enables monitoring, searching,...
url: https://www.elastic.co/docs/reference/integrations/o365
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Microsoft Office 365 Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.3.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                    |


## Overview

The Microsoft Office 365 integration for Elastic collects activity data using the [Office 365 Management Activity API](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference). This data enables monitoring, searching, and analyzing user and admin actions across Microsoft Office 365, including activity from services like SharePoint and Exchange.

### How it works

The integration works by collecting user, admin, system, and policy actions, as well as events from Office 365 and Azure AD activity logs exposed by the [Office 365 Management Activity API](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference).

### Compatibility

- **API Version**: The Microsoft Office 365 integration is compatible with version 1.0 of Microsoft Office 365 Management API.
- **Supported Workloads**: This integration supports the following Microsoft Office 365 workloads:
  - Audit.AzureActiveDirectory
- Audit.Exchange
- Audit.SharePoint
- Audit.General
- DLP.All

For detailed information on the supported record types within these workloads, please refer to the [AuditLogRecordType documentation](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-schema#auditlogrecordtype).

## What data does this integration collect?

This integration collects log messages of the following types:
- `Audit`: Uses the [Office 365 Management Activity API](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference) to retrieve audit messages from Office 365 and Azure AD activity logs. These are the same logs that are available under [Audit Log Search](https://learn.microsoft.com/en-us/purview/audit-search) in the Microsoft Purview portal.


### Supported use cases

Integrating Microsoft Office 365 with Elastic SIEM enables collection of audit logs for monitoring and analysis, which can then be visualized in Kibana.

## What do I need to use this integration?

To use this integration you need to [enable `Audit Log`](https://learn.microsoft.com/en-us/purview/audit-log-enable-disable) and register an application in [Microsoft Entra ID (formerly known as Azure Active Directory)](https://www.microsoft.com/en-us/security/business/identity-access/microsoft-entra-id).
Once the Microsoft Entra ID application is registered, you can set up its credentials and permissions, and gather the information needed by the Microsoft Office 365 Elastic integration, as follows:
1. Note the `Application (client) ID` and `Directory (tenant) ID` in the registered application's `Overview` page.
2. Create a new secret to configure the authentication of your application, as follows:
   - Navigate to `Manage -> Certificates & Secrets` section.
- Click `New client secret`, provide a description and create the new secret.
  ![New Client Secret](https://www.elastic.co/docs/reference/integrations/images/o365/new_client_secrets.png)
- Note the `Value` which is required for setup of the integration.
  ![Value](https://www.elastic.co/docs/reference/integrations/images/o365/value.png)
3. Add permissions to your registered application. Please refer to the [Office 365 Management API documentation](https://learn.microsoft.com/en-us/office/office-365-management-api/get-started-with-office-365-management-apis#specify-the-permissions-your-app-requires-to-access-the-office-365-management-apis) for more details.
   - Navigate to `Manage -> API permissions` page. Under Configured permissions click `Add a permission`.
- Select `Office 365 Management APIs` tile from the listed tiles.
  ![Select management API](https://www.elastic.co/docs/reference/integrations/images/o365/select_management_api.png)
- Click `Application permissions`.
  ![API Permission](https://www.elastic.co/docs/reference/integrations/images/o365/permission_type.png)
- Under `ActivityFeed`, select `ActivityFeed.Read` permission. This is minimum required permissions to read audit logs of your organization as [provided in the documentation](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference). Optionally, select `ActivityFeed.ReadDlp` to read DLP policy events.
- Click `Add permissions`.
  ![Required Permission](https://www.elastic.co/docs/reference/integrations/images/o365/required_permission.png)
- If `User.Read` permission under `Microsoft.Graph` tile is not added by default, add this permission.
- After the permissions are added, the admin has to grant consent for these permissions.

The instructions above assume that you wish to collect data from your own tenant. If that is not the case, additional steps are required to obtain tenant admin consent for the required permissions. The API documentation describes [a method of gathering consent via redirect URLs](https://learn.microsoft.com/en-us/office/office-365-management-api/get-started-with-office-365-management-apis#get-office-365-tenant-admin-consent), and other consent flows may be possible.

## How do I deploy this integration?

This integration supports both Elastic Agentless-based and Agent-based installations.

### Agentless-based installation

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

### Setup

1. In the top search bar in Kibana, search for **Integrations**.
2. In the search bar, type **Microsoft Office 365**.
3. Select the **Microsoft Office 365** integration from the search results.
4. Select **Add Microsoft Office 365** to add the integration.
5. Enable and configure only the collection methods which you will use.
   - To **Collect audit logs**, you'll need to configure **Application (client) ID**, **Client Secret** and **Directory (tenant) ID**.
- Do not use **DEPRECATED - Collect audit logs** as it's deprecated.
6. Select **Save and continue** to save the integration.


### Validation


#### Dashboards populated

1. In the top search bar in Kibana, search for **Dashboards**.
2. In the search bar, type **Microsoft Office 365**.
3. Select a dashboard for the dataset you are collecting, and verify the dashboard information is populated.


#### Transforms healthy

1. In the top search bar in Kibana, search for **Transforms**.
2. Select the **Data / Transforms** from the search results.
3. In the search bar, type **o365**.
4. All transforms from the search results should indicate **Healthy** under the **Health** column.


### Troubleshooting

In the case of a permissions issue, it can be useful to enable request tracing and look at request trace logs to inspect the interaction with the server. Token values can be decoded using , and should include a `roles` section with the configured permissions.
When errors occur in the Microsoft Office 365 integration while collecting data, refer to the Office 365 Management Activity API documentation for the full list of error codes and their meanings. See the official [Office 365 Management Activity API — Errors](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference#errors).

### Migration From the Deprecated o365audit Input

<note>
  As Microsoft is no longer supporting Azure Active Directory Authentication Library (ADAL), the existing o365audit input has been deprecated in favor of the [CEL](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-cel.html) input in version `1.18.0`. Hence for versions `>= 1.18.0`, certificate based authentication (provided by earlier o365audit input) is no longer supported.
</note>

We request that users upgrading from integration version `< 1.18.0` to `>= 1.18.0` follow these steps:
1. Upgrade the Elastic Stack version to `>= 8.7.1`.
2. Upgrade the integration navigating via `Integrations -> Microsoft Office 365 -> Settings -> Upgrade`
3. Upgrade the integration policy navigating via `Integrations -> Microsoft Office 365 -> integration policies -> Version (Upgrade)`. If `Upgrade` option doesn't appear under the `Version`, that means the policy is already upgraded in the previous step. Please go to the next step.
4. Modify the integration policy:
   - Disable existing configuration (marked as `Deprecated`) and enable `Collect Office 365 audit logs via CEL` configuration.
- Add the required parameters such as `Directory (tenant) ID`, `Application (client) ID`, `Client Secret` based on the previous configuration.
- Verify/Update `Initial Interval` configuration parameter to start fetching events from. This defaults to 7 days. Even if there is overlap in times, the events are not duplicated.
- Update the other configuration parameters as required and hit `Save Integration`.

Please refer [Upgrade an integration](https://www.elastic.co/guide/en/fleet/current/upgrade-integration.html) in case of any issues while performing integration upgrade.

## Data latency

This integration works by creating a subscription for each enabled content type, checking each subscription for available data, and downloading any data that is available.
As discussed in Microsoft's [Working with the Office 365 Management Activity API](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference#working-with-the-office-365-management-activity-api) documentation, when a subscription is first created it can take up to 12 hours for the first data to become available. Users of this integration should expect to see that initial delay.
Data may become available out of order, so the earliest data will not necessarily be downloaded first. Data will be downloaded in the order in which it becomes available.
If a new integration policy is created to fetch data from existing subscriptions, earlier data may be available and the integration will try to fetch it. This can help to fill short gaps in data. The Initial Interval setting controls how far back it will look. By default it will check for data that became available in the last week, which is the maximum time range allowed by the API.

## Reference


### Logs reference


#### Audit

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-02-07T16:43:53.000Z",
      "agent": {
          "ephemeral_id": "f173faa4-2d61-4c41-8670-06930fd22753",
          "id": "e9670ccb-33fc-41b0-90c1-b67dcf953c6a",
          "name": "elastic-agent-35357",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "client": {
          "address": "213.97.47.133",
          "ip": "213.97.47.133"
      },
      "data_stream": {
          "dataset": "o365.audit",
          "namespace": "12427",
          "type": "logs"
      },
      "device": {
          "id": "62eedfc0-b73c-206c-a59d-16457c7ebcd8"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e9670ccb-33fc-41b0-90c1-b67dcf953c6a",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "action": "PageViewed",
          "agent_id_status": "verified",
          "category": [
              "web"
          ],
          "code": "SharePoint",
          "dataset": "o365.audit",
          "id": "99d005e6-a4c6-46fd-117c-08d7abeceab5",
          "ingested": "2025-12-15T13:36:59Z",
          "kind": "event",
          "original": "{\"ClientIP\":\"213.97.47.133\",\"CorrelationId\":\"622b339f-4000-a000-f25f-92b3478c7a25\",\"CreationTime\":\"2020-02-07T16:43:53\",\"CustomUniqueId\":true,\"EventSource\":\"SharePoint\",\"ExtendedProperties\":[{\"Name\":\"additionalDetails\",\"Value\":\"{\\\"DeviceId\\\":\\\"62eedfc0-b73c-206c-a59d-16457c7ebcd8\\\",\\\"DeviceOSType\\\":\\\"Linux\\\",\\\"DeviceTrustType\\\":\\\"\\\"}\"}],\"Id\":\"99d005e6-a4c6-46fd-117c-08d7abeceab5\",\"ItemType\":\"Page\",\"ListItemUniqueId\":\"59a8433d-9bb8-cfef-6edc-4c0fc8b86875\",\"ObjectId\":\"https://testsiem-my.sharepoint.com/personal/asr_testsiem_onmicrosoft_com/_layouts/15/onedrive.aspx\",\"Operation\":\"PageViewed\",\"OrganizationId\":\"b86ab9d4-fcf1-4b11-8a06-7a8f91b47fbd\",\"RecordType\":4,\"Site\":\"d5180cfc-3479-44d6-b410-8c985ac894e3\",\"UserAgent\":\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:72.0) Gecko/20100101 Firefox/72.0\",\"UserId\":\"asr@testsiem.onmicrosoft.com\",\"UserKey\":\"i:0h.f|membership|1003200096971f55@live.com\",\"UserType\":0,\"Version\":1,\"WebId\":\"8c5c94bb-8396-470c-87d7-8999f440cd30\",\"Workload\":\"OneDrive\"}",
          "outcome": "success",
          "provider": "OneDrive",
          "type": [
              "info"
          ]
      },
      "host": {
          "id": "b86ab9d4-fcf1-4b11-8a06-7a8f91b47fbd",
          "name": "testsiem.onmicrosoft.com"
      },
      "input": {
          "type": "cel"
      },
      "network": {
          "type": "ipv4"
      },
      "o365": {
          "audit": {
              "CorrelationId": "622b339f-4000-a000-f25f-92b3478c7a25",
              "CreationTime": "2020-02-07T16:43:53",
              "CustomUniqueId": true,
              "EventSource": "SharePoint",
              "ExtendedProperties": {
                  "additionalDetails": {
                      "DeviceId": "62eedfc0-b73c-206c-a59d-16457c7ebcd8",
                      "DeviceOSType": "Linux"
                  }
              },
              "ItemType": "Page",
              "ListItemUniqueId": "59a8433d-9bb8-cfef-6edc-4c0fc8b86875",
              "ObjectId": "https://testsiem-my.sharepoint.com/personal/asr_testsiem_onmicrosoft_com/_layouts/15/onedrive.aspx",
              "RecordType": "4",
              "Site": "d5180cfc-3479-44d6-b410-8c985ac894e3",
              "UserId": "asr@testsiem.onmicrosoft.com",
              "UserKey": "i:0h.f|membership|1003200096971f55@live.com",
              "UserType": "0",
              "Version": "1",
              "WebId": "8c5c94bb-8396-470c-87d7-8999f440cd30"
          }
      },
      "organization": {
          "id": "b86ab9d4-fcf1-4b11-8a06-7a8f91b47fbd"
      },
      "related": {
          "hosts": [
              "testsiem.onmicrosoft.com"
          ],
          "ip": [
              "213.97.47.133"
          ],
          "user": [
              "asr",
              "asr@testsiem.onmicrosoft.com"
          ]
      },
      "source": {
          "ip": "213.97.47.133"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "o365-cel"
      ],
      "user": {
          "domain": "testsiem.onmicrosoft.com",
          "email": "asr@testsiem.onmicrosoft.com",
          "id": "asr@testsiem.onmicrosoft.com",
          "name": "asr"
      },
      "user_agent": {
          "device": {
              "name": "Mac"
          },
          "name": "Firefox",
          "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:72.0) Gecko/20100101 Firefox/72.0",
          "os": {
              "full": "Mac OS X 10.14",
              "name": "Mac OS X",
              "version": "10.14"
          },
          "version": "72.0"
      }
  }
  ```
</dropdown>


### ECS field reference


#### Audit

<dropdown title="Exported fields">
  | Field                                                              | Description                                                                  | Type             |
  |--------------------------------------------------------------------|------------------------------------------------------------------------------|------------------|
  | @timestamp                                                         | Event timestamp.                                                             | date             |
  | application.name                                                   | Name of the application.                                                     | keyword          |
  | cloud.image.id                                                     | Image ID for the cloud instance.                                             | keyword          |
  | data_stream.dataset                                                | Data stream dataset name.                                                    | constant_keyword |
  | data_stream.namespace                                              | Data stream namespace.                                                       | constant_keyword |
  | data_stream.type                                                   | Data stream type.                                                            | constant_keyword |
  | event.dataset                                                      | Event dataset                                                                | constant_keyword |
  | event.module                                                       | Event module                                                                 | constant_keyword |
  | host.containerized                                                 | If the host is a container.                                                  | boolean          |
  | host.os.build                                                      | OS build information.                                                        | keyword          |
  | host.os.codename                                                   | OS codename, if any.                                                         | keyword          |
  | input.type                                                         | Type of Filebeat input.                                                      | keyword          |
  | log.flags                                                          | Flags for the log file.                                                      | keyword          |
  | log.offset                                                         | Offset of the entry in the log file.                                         | long             |
  | o365.audit.AadAppId                                                |                                                                              | keyword          |
  | o365.audit.Actions                                                 |                                                                              | flattened        |
  | o365.audit.Activity                                                |                                                                              | keyword          |
  | o365.audit.Actor.ID                                                |                                                                              | keyword          |
  | o365.audit.Actor.Type                                              |                                                                              | keyword          |
  | o365.audit.ActorContextId                                          |                                                                              | keyword          |
  | o365.audit.ActorInfoString                                         |                                                                              | keyword          |
  | o365.audit.ActorIpAddress                                          |                                                                              | keyword          |
  | o365.audit.ActorUserId                                             |                                                                              | keyword          |
  | o365.audit.ActorYammerUserId                                       |                                                                              | keyword          |
  | o365.audit.AdditionalData.Name                                     |                                                                              | keyword          |
  | o365.audit.AdditionalData.Value                                    |                                                                              | keyword          |
  | o365.audit.AdditionalInfo.*                                        |                                                                              | object           |
  | o365.audit.AirAdminActionSource                                    |                                                                              | keyword          |
  | o365.audit.AirAdminActionType                                      |                                                                              | keyword          |
  | o365.audit.AlertEntityId                                           |                                                                              | keyword          |
  | o365.audit.AlertId                                                 |                                                                              | keyword          |
  | o365.audit.AlertLinks                                              |                                                                              | flattened        |
  | o365.audit.AlertType                                               |                                                                              | keyword          |
  | o365.audit.AppAccessContext.*                                      |                                                                              | object           |
  | o365.audit.AppId                                                   |                                                                              | keyword          |
  | o365.audit.Application                                             |                                                                              | keyword          |
  | o365.audit.ApplicationDisplayName                                  |                                                                              | keyword          |
  | o365.audit.ApplicationId                                           |                                                                              | keyword          |
  | o365.audit.Approver                                                |                                                                              | keyword          |
  | o365.audit.AttachmentData.FileName                                 |                                                                              | keyword          |
  | o365.audit.AttachmentData.FileType                                 |                                                                              | keyword          |
  | o365.audit.AttachmentData.FileVerdict                              |                                                                              | keyword          |
  | o365.audit.AttachmentData.MalwareFamily                            |                                                                              | keyword          |
  | o365.audit.AttachmentData.SHA256                                   |                                                                              | keyword          |
  | o365.audit.AuthDetails.Name                                        |                                                                              | keyword          |
  | o365.audit.AuthDetails.Value                                       |                                                                              | keyword          |
  | o365.audit.AuthenticationType                                      |                                                                              | keyword          |
  | o365.audit.AzureActiveDirectoryEventType                           |                                                                              | keyword          |
  | o365.audit.BCLValue                                                |                                                                              | keyword          |
  | o365.audit.BulkApprovalId                                          |                                                                              | keyword          |
  | o365.audit.Category                                                |                                                                              | keyword          |
  | o365.audit.ClientAppId                                             |                                                                              | keyword          |
  | o365.audit.ClientApplication                                       |                                                                              | keyword          |
  | o365.audit.ClientIP                                                |                                                                              | keyword          |
  | o365.audit.ClientIPAddress                                         |                                                                              | keyword          |
  | o365.audit.ClientInfoString                                        |                                                                              | keyword          |
  | o365.audit.ClientRequestId                                         |                                                                              | keyword          |
  | o365.audit.CmdletVersion                                           |                                                                              | keyword          |
  | o365.audit.Comments                                                |                                                                              | text             |
  | o365.audit.Connector                                               |                                                                              | keyword          |
  | o365.audit.CorrelationId                                           |                                                                              | keyword          |
  | o365.audit.CreationTime                                            |                                                                              | keyword          |
  | o365.audit.CustomUniqueId                                          |                                                                              | boolean          |
  | o365.audit.Data.ad                                                 |                                                                              | keyword          |
  | o365.audit.Data.af                                                 |                                                                              | keyword          |
  | o365.audit.Data.aii                                                |                                                                              | keyword          |
  | o365.audit.Data.ail                                                |                                                                              | keyword          |
  | o365.audit.Data.alk                                                |                                                                              | keyword          |
  | o365.audit.Data.als                                                |                                                                              | keyword          |
  | o365.audit.Data.an                                                 |                                                                              | keyword          |
  | o365.audit.Data.at                                                 |                                                                              | date             |
  | o365.audit.Data.cid                                                |                                                                              | keyword          |
  | o365.audit.Data.cpid                                               |                                                                              | keyword          |
  | o365.audit.Data.dm                                                 |                                                                              | keyword          |
  | o365.audit.Data.dpn                                                |                                                                              | keyword          |
  | o365.audit.Data.eid                                                |                                                                              | keyword          |
  | o365.audit.Data.etps                                               |                                                                              | keyword          |
  | o365.audit.Data.etype                                              |                                                                              | keyword          |
  | o365.audit.Data.f3u                                                |                                                                              | keyword          |
  | o365.audit.Data.flattened                                          | The full Data document.                                                      | flattened        |
  | o365.audit.Data.fvs                                                |                                                                              | keyword          |
  | o365.audit.Data.imsgid                                             |                                                                              | keyword          |
  | o365.audit.Data.lon                                                |                                                                              | keyword          |
  | o365.audit.Data.mat                                                |                                                                              | keyword          |
  | o365.audit.Data.md                                                 |                                                                              | date             |
  | o365.audit.Data.ms                                                 |                                                                              | keyword          |
  | o365.audit.Data.od                                                 |                                                                              | keyword          |
  | o365.audit.Data.op                                                 |                                                                              | keyword          |
  | o365.audit.Data.ot                                                 |                                                                              | keyword          |
  | o365.audit.Data.plk                                                |                                                                              | keyword          |
  | o365.audit.Data.pud                                                |                                                                              | keyword          |
  | o365.audit.Data.reid                                               |                                                                              | keyword          |
  | o365.audit.Data.rid                                                |                                                                              | keyword          |
  | o365.audit.Data.sev                                                |                                                                              | keyword          |
  | o365.audit.Data.sict                                               |                                                                              | keyword          |
  | o365.audit.Data.sid                                                |                                                                              | keyword          |
  | o365.audit.Data.sip                                                |                                                                              | ip               |
  | o365.audit.Data.sitmi                                              |                                                                              | keyword          |
  | o365.audit.Data.srt                                                |                                                                              | keyword          |
  | o365.audit.Data.ssic                                               |                                                                              | keyword          |
  | o365.audit.Data.suid                                               |                                                                              | keyword          |
  | o365.audit.Data.tdc                                                |                                                                              | keyword          |
  | o365.audit.Data.te                                                 |                                                                              | date             |
  | o365.audit.Data.thn                                                |                                                                              | keyword          |
  | o365.audit.Data.tht                                                |                                                                              | keyword          |
  | o365.audit.Data.tid                                                |                                                                              | keyword          |
  | o365.audit.Data.tpid                                               |                                                                              | keyword          |
  | o365.audit.Data.tpt                                                |                                                                              | keyword          |
  | o365.audit.Data.trc                                                |                                                                              | keyword          |
  | o365.audit.Data.ts                                                 |                                                                              | date             |
  | o365.audit.Data.tsd                                                |                                                                              | keyword          |
  | o365.audit.Data.ttdt                                               |                                                                              | date             |
  | o365.audit.Data.ttr                                                |                                                                              | keyword          |
  | o365.audit.Data.upfc                                               |                                                                              | keyword          |
  | o365.audit.Data.upfv                                               |                                                                              | keyword          |
  | o365.audit.Data.ut                                                 |                                                                              | keyword          |
  | o365.audit.Data.von                                                |                                                                              | keyword          |
  | o365.audit.Data.wl                                                 |                                                                              | keyword          |
  | o365.audit.Data.zfh                                                |                                                                              | keyword          |
  | o365.audit.Data.zfn                                                |                                                                              | keyword          |
  | o365.audit.Data.zmfh                                               |                                                                              | keyword          |
  | o365.audit.Data.zmfn                                               |                                                                              | keyword          |
  | o365.audit.Data.zu                                                 |                                                                              | keyword          |
  | o365.audit.DataType                                                |                                                                              | keyword          |
  | o365.audit.DatabaseType                                            |                                                                              | keyword          |
  | o365.audit.DeepLinkUrl                                             |                                                                              | keyword          |
  | o365.audit.DeliveryAction                                          |                                                                              | keyword          |
  | o365.audit.Description                                             |                                                                              | match_only_text  |
  | o365.audit.DetectionMethod                                         |                                                                              | keyword          |
  | o365.audit.DetectionType                                           |                                                                              | keyword          |
  | o365.audit.DeviceName                                              |                                                                              | keyword          |
  | o365.audit.Directionality                                          |                                                                              | keyword          |
  | o365.audit.EffectiveOrganization                                   |                                                                              | keyword          |
  | o365.audit.EndTimeUtc                                              |                                                                              | date             |
  | o365.audit.EntityType                                              |                                                                              | keyword          |
  | o365.audit.ErrorNumber                                             |                                                                              | keyword          |
  | o365.audit.EventData                                               |                                                                              | keyword          |
  | o365.audit.EventDeepLink                                           |                                                                              | keyword          |
  | o365.audit.EventSource                                             |                                                                              | keyword          |
  | o365.audit.ExceptionInfo.*                                         |                                                                              | object           |
  | o365.audit.ExchangeAggregatedFolders.FolderItems.Id                | Item ID                                                                      | keyword          |
  | o365.audit.ExchangeAggregatedFolders.FolderItems.ImmutableId       | Immutable ID of the item                                                     | keyword          |
  | o365.audit.ExchangeAggregatedFolders.FolderItems.InternetMessageId | Internet message ID                                                          | keyword          |
  | o365.audit.ExchangeAggregatedFolders.FolderItems.SizeInBytes       | Size of the item in bytes                                                    | long             |
  | o365.audit.ExchangeAggregatedFolders.Id                            | Folder ID                                                                    | keyword          |
  | o365.audit.ExchangeAggregatedFolders.Path                          | Path of the folder                                                           | keyword          |
  | o365.audit.ExchangeAggregatedMessages.Id                           | Message ID                                                                   | keyword          |
  | o365.audit.ExchangeAggregatedMessages.MessageItems.Id              | Message item ID                                                              | keyword          |
  | o365.audit.ExchangeAggregatedMessages.MessageItems.SizeInBytes     | Size of the message item in bytes                                            | long             |
  | o365.audit.ExchangeAggregatedMessages.Path                         | Path of the message                                                          | keyword          |
  | o365.audit.ExchangeMetaData.*                                      |                                                                              | long             |
  | o365.audit.ExchangeMetaData.CC                                     |                                                                              | keyword          |
  | o365.audit.ExchangeMetaData.MessageID                              |                                                                              | keyword          |
  | o365.audit.ExchangeMetaData.Sent                                   |                                                                              | date             |
  | o365.audit.ExchangeMetaData.Subject                                |                                                                              | keyword          |
  | o365.audit.ExchangeMetaData.To                                     |                                                                              | keyword          |
  | o365.audit.ExchangeMetaData.UniqueID                               |                                                                              | keyword          |
  | o365.audit.Experience                                              |                                                                              | keyword          |
  | o365.audit.ExtendedProperties.*                                    |                                                                              | object           |
  | o365.audit.ExtendedProperties.RequestType                          |                                                                              | keyword          |
  | o365.audit.ExtendedProperties.additionalDetails                    |                                                                              | object           |
  | o365.audit.ExternalAccess                                          |                                                                              | boolean          |
  | o365.audit.FileExtension                                           |                                                                              | keyword          |
  | o365.audit.FileSize                                                |                                                                              | keyword          |
  | o365.audit.FileSizeBytes                                           |                                                                              | long             |
  | o365.audit.FilteringDate                                           |                                                                              | date             |
  | o365.audit.GroupName                                               |                                                                              | keyword          |
  | o365.audit.Id                                                      |                                                                              | keyword          |
  | o365.audit.ImplicitShare                                           |                                                                              | keyword          |
  | o365.audit.IncidentId                                              |                                                                              | keyword          |
  | o365.audit.InsightData.Type                                        |                                                                              | keyword          |
  | o365.audit.InsightId                                               |                                                                              | keyword          |
  | o365.audit.InterSystemsId                                          |                                                                              | keyword          |
  | o365.audit.InternalLogonType                                       |                                                                              | keyword          |
  | o365.audit.InternetMessageId                                       |                                                                              | keyword          |
  | o365.audit.IntraSystemId                                           |                                                                              | keyword          |
  | o365.audit.InvestigationId                                         |                                                                              | keyword          |
  | o365.audit.InvestigationName                                       |                                                                              | keyword          |
  | o365.audit.InvestigationType                                       |                                                                              | keyword          |
  | o365.audit.InvestigationUrn                                        |                                                                              | keyword          |
  | o365.audit.Item.*                                                  |                                                                              | object           |
  | o365.audit.Item.*.*                                                |                                                                              | object           |
  | o365.audit.ItemName                                                |                                                                              | keyword          |
  | o365.audit.ItemType                                                |                                                                              | keyword          |
  | o365.audit.KesMailId                                               |                                                                              | keyword          |
  | o365.audit.Language                                                |                                                                              | keyword          |
  | o365.audit.LastUpdateTimeUtc                                       |                                                                              | date             |
  | o365.audit.LatestDeliveryLocation                                  |                                                                              | keyword          |
  | o365.audit.ListBaseType                                            |                                                                              | keyword          |
  | o365.audit.ListId                                                  |                                                                              | keyword          |
  | o365.audit.ListItemUniqueId                                        |                                                                              | keyword          |
  | o365.audit.LogonError                                              |                                                                              | keyword          |
  | o365.audit.LogonType                                               |                                                                              | keyword          |
  | o365.audit.LogonUserSid                                            |                                                                              | keyword          |
  | o365.audit.MailboxGuid                                             |                                                                              | keyword          |
  | o365.audit.MailboxOwnerMasterAccountSid                            |                                                                              | keyword          |
  | o365.audit.MailboxOwnerSid                                         |                                                                              | keyword          |
  | o365.audit.MailboxOwnerUPN                                         |                                                                              | keyword          |
  | o365.audit.Members                                                 |                                                                              | flattened        |
  | o365.audit.MessageDate                                             |                                                                              | keyword          |
  | o365.audit.MessageTime                                             |                                                                              | keyword          |
  | o365.audit.ModifiedProperties                                      |                                                                              | object           |
  | o365.audit.ModifiedProperties.*.*                                  |                                                                              | object           |
  | o365.audit.ModifiedProperties.Role_DisplayName.NewValue            |                                                                              | keyword          |
  | o365.audit.Name                                                    |                                                                              | keyword          |
  | o365.audit.NetworkMessageId                                        |                                                                              | keyword          |
  | o365.audit.NewValue                                                |                                                                              | keyword          |
  | o365.audit.NonPIIParameters                                        |                                                                              | keyword          |
  | o365.audit.ObjectDisplayName                                       |                                                                              | keyword          |
  | o365.audit.ObjectId                                                |                                                                              | keyword          |
  | o365.audit.ObjectType                                              |                                                                              | keyword          |
  | o365.audit.Operation                                               |                                                                              | keyword          |
  | o365.audit.OperationCount                                          |                                                                              | long             |
  | o365.audit.OperationId                                             |                                                                              | keyword          |
  | o365.audit.OperationProperties                                     |                                                                              | object           |
  | o365.audit.OrganizationId                                          |                                                                              | keyword          |
  | o365.audit.OrganizationName                                        |                                                                              | keyword          |
  | o365.audit.OriginalDeliveryLocation                                |                                                                              | keyword          |
  | o365.audit.OriginatingDomain                                       |                                                                              | keyword          |
  | o365.audit.OriginatingServer                                       |                                                                              | keyword          |
  | o365.audit.P1Sender                                                |                                                                              | keyword          |
  | o365.audit.P1SenderDomain                                          |                                                                              | keyword          |
  | o365.audit.P2Sender                                                |                                                                              | keyword          |
  | o365.audit.P2SenderDomain                                          |                                                                              | keyword          |
  | o365.audit.Parameters                                              |                                                                              | object           |
  | o365.audit.Parameters.*                                            |                                                                              | object           |
  | o365.audit.Parameters.AccessRights                                 |                                                                              | keyword          |
  | o365.audit.Parameters.AllowFederatedUsers                          |                                                                              | keyword          |
  | o365.audit.Parameters.AllowGuestUser                               |                                                                              | keyword          |
  | o365.audit.Parameters.Enabled                                      |                                                                              | keyword          |
  | o365.audit.Parameters.ForwardAsAttachmentTo                        |                                                                              | keyword          |
  | o365.audit.Parameters.ForwardTo                                    |                                                                              | keyword          |
  | o365.audit.Parameters.From                                         |                                                                              | keyword          |
  | o365.audit.Parameters.RedirectTo                                   |                                                                              | keyword          |
  | o365.audit.PhishConfidenceLevel                                    |                                                                              | keyword          |
  | o365.audit.Platform                                                |                                                                              | keyword          |
  | o365.audit.Policy                                                  |                                                                              | keyword          |
  | o365.audit.PolicyAction                                            |                                                                              | keyword          |
  | o365.audit.PolicyDetails                                           |                                                                              | flattened        |
  | o365.audit.PolicyId                                                |                                                                              | keyword          |
  | o365.audit.Recipients                                              |                                                                              | keyword          |
  | o365.audit.RecordType                                              |                                                                              | keyword          |
  | o365.audit.RelativeUrl                                             |                                                                              | keyword          |
  | o365.audit.RequestId                                               |                                                                              | keyword          |
  | o365.audit.RescanResult.Id                                         |                                                                              | keyword          |
  | o365.audit.RescanResult.RescanVerdict                              |                                                                              | keyword          |
  | o365.audit.RescanResult.Timestamp                                  |                                                                              | keyword          |
  | o365.audit.ResultCount                                             |                                                                              | keyword          |
  | o365.audit.ResultStatus                                            |                                                                              | keyword          |
  | o365.audit.RunningTime                                             |                                                                              | keyword          |
  | o365.audit.SecurityComplianceCenterEventType                       |                                                                              | keyword          |
  | o365.audit.SenderIP                                                |                                                                              | keyword          |
  | o365.audit.SenderIp                                                |                                                                              | keyword          |
  | o365.audit.SensitiveInfoDetectionIsIncluded                        |                                                                              | boolean          |
  | o365.audit.SensitivityLabelEventData.ActionSourceDetail            |                                                                              | long             |
  | o365.audit.SensitivityLabelEventData.ContentType                   |                                                                              | keyword          |
  | o365.audit.SensitivityLabelEventData.LabelEventType                |                                                                              | long             |
  | o365.audit.SensitivityLabelEventData.SensitivityLabelId            |                                                                              | keyword          |
  | o365.audit.SessionId                                               |                                                                              | keyword          |
  | o365.audit.Severity                                                |                                                                              | keyword          |
  | o365.audit.Sha1                                                    |                                                                              | keyword          |
  | o365.audit.Sha256                                                  |                                                                              | keyword          |
  | o365.audit.SharePointMetaData.*                                    |                                                                              | object           |
  | o365.audit.Site                                                    |                                                                              | keyword          |
  | o365.audit.SiteUrl                                                 |                                                                              | keyword          |
  | o365.audit.Source                                                  |                                                                              | keyword          |
  | o365.audit.SourceFileExtension                                     |                                                                              | keyword          |
  | o365.audit.SourceFileName                                          |                                                                              | keyword          |
  | o365.audit.SourceRelativeUrl                                       |                                                                              | keyword          |
  | o365.audit.StartTime                                               |                                                                              | keyword          |
  | o365.audit.StartTimeUtc                                            |                                                                              | keyword          |
  | o365.audit.Status                                                  |                                                                              | keyword          |
  | o365.audit.SubAirAdminActionTypeMail                               |                                                                              | keyword          |
  | o365.audit.Subject                                                 |                                                                              | keyword          |
  | o365.audit.SubmissionConfidenceLevel                               |                                                                              | keyword          |
  | o365.audit.SubmissionContentSubType                                |                                                                              | keyword          |
  | o365.audit.SubmissionContentType                                   |                                                                              | keyword          |
  | o365.audit.SubmissionId                                            |                                                                              | keyword          |
  | o365.audit.SubmissionState                                         |                                                                              | keyword          |
  | o365.audit.SubmissionType                                          |                                                                              | keyword          |
  | o365.audit.Submitter                                               |                                                                              | keyword          |
  | o365.audit.SubmitterId                                             |                                                                              | keyword          |
  | o365.audit.SupportTicketId                                         |                                                                              | keyword          |
  | o365.audit.SystemOverrides.Details                                 |                                                                              | keyword          |
  | o365.audit.SystemOverrides.FinalOverride                           |                                                                              | keyword          |
  | o365.audit.SystemOverrides.Result                                  |                                                                              | keyword          |
  | o365.audit.SystemOverrides.Source                                  |                                                                              | keyword          |
  | o365.audit.Target.ID                                               |                                                                              | keyword          |
  | o365.audit.Target.Type                                             |                                                                              | keyword          |
  | o365.audit.TargetContextId                                         |                                                                              | keyword          |
  | o365.audit.TargetFilePath                                          |                                                                              | keyword          |
  | o365.audit.TargetUserOrGroupName                                   |                                                                              | keyword          |
  | o365.audit.TargetUserOrGroupType                                   |                                                                              | keyword          |
  | o365.audit.TeamGuid                                                |                                                                              | keyword          |
  | o365.audit.TeamName                                                |                                                                              | keyword          |
  | o365.audit.ThreatDetectionMethods                                  |                                                                              | keyword          |
  | o365.audit.Timestamp                                               |                                                                              | keyword          |
  | o365.audit.TokenObjectId                                           |                                                                              | keyword          |
  | o365.audit.TokenTenantId                                           |                                                                              | keyword          |
  | o365.audit.UniqueSharingId                                         |                                                                              | keyword          |
  | o365.audit.UserAgent                                               |                                                                              | keyword          |
  | o365.audit.UserId                                                  |                                                                              | keyword          |
  | o365.audit.UserKey                                                 |                                                                              | keyword          |
  | o365.audit.UserType                                                |                                                                              | keyword          |
  | o365.audit.Verdict                                                 |                                                                              | keyword          |
  | o365.audit.Version                                                 |                                                                              | keyword          |
  | o365.audit.WebId                                                   |                                                                              | keyword          |
  | o365.audit.Workload                                                |                                                                              | keyword          |
  | o365.audit.WorkspaceId                                             |                                                                              | keyword          |
  | o365.audit.WorkspaceName                                           |                                                                              | keyword          |
  | o365.audit.YammerNetworkId                                         |                                                                              | keyword          |
  | session.id                                                         | The unique identifier for the authentication session.                        | keyword          |
  | token.id                                                           | The unique token identifier of the API call used to make the audited change. | keyword          |
</dropdown>


### Inputs used

These inputs are used in this integration:
- [cel](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cel)
- [o365audit (DEPRECATED)](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-o365audit)


### API usage

This integration dataset uses the following APIs:
- `Audit`: [Office 365 Management Activity API](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-reference)


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Office 365 Audit Dashboard](https://epr.elastic.co/package/o365/3.3.0/img/filebeat-o365-audit.png)

  ![Office 365 User Dashboard](https://epr.elastic.co/package/o365/3.3.0/img/o365-user-dashboard.png)

  ![Azure Permissions](https://epr.elastic.co/package/o365/3.3.0/img/filebeat-o365-azure-permissions.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16578))Add support for `host.os.*`, `email.sender.address` and `destination.user.email` field.Add `event.category` for ExchangeItem event.Expand coverage for `related.*` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16324))Improve documentation to align with new guidelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16024))Simplifies data fetching logic.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **3.0.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15981))Fix dynamic mapping conflict for `o365audit.ExtendedProperties.additionalDetails` field by explicitly defining it as an object.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15981))The `o365audit.ExtendedProperties.additionalDetails_value` field is no longer retained.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **2.33.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15796))Reverts earlier `o365.audit.OperationCount` mapping change to ensure that the field remains a long.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **2.33.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15699))Fix flattening errors in `Action` List items due to duplicate `QueryTime` fields by removing duplicate field.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15699))Fixes undefined errors by adding fields `ActorInfoString`, `OperationCount`, `TokenObjectId`, `TokenTenantId`**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15699))Fixes errors due to SizeInBytes fields in `Messages` and `Folders` structures previously imported as long  and then being sent as floats. Moves the fields to explicitly defined fields `ExchangeAggregatedMessages` and  `ExchangeAggregatedFolders`and explicitly converts SizeInBytes to long for record type 50: `ExchangeItemAggregated`. | 9.0.08.18.0            |
  | **2.32.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15632))Add device.id and user_agent fields from ExtendedProperties.additionalDetails.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.0            |
  | **2.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15660))Improve documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.0            |
  | **2.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15503))Audit event type visualization now breaks down by `event.action` and `event.provider`. `[Logs O365]` removed from all visualization titles. Added accessed resource visualization in the audit dashboard. Added user dashboard showing user info and user agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **2.29.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15476))Fix 429 due to multiple subscription start attempts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **2.29.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15445))Fix handling of error propagation within agent CEL program.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.29.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15380))Fix handling of error conditions when requesting work continuation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **2.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15325))Tolerate undocumented API changes in request parameter syntax.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.18.0            |
  | **2.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14922))Improvements in the integration UI layout, highlight deprecated data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **2.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15228))Improve permissions documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **2.26.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15154))Tolerate missing cursor elements when advancing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **2.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15134))Ensure that cursors are not updated to times in the future.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15097))Add field definitions for `o365.audit.SensitivityLabelEventData.*` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14962))Revise agent collector code to reduce memory, CPU and network load and API brittleness.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14944))Tolerate string elements in Actions list.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.0            |
  | **2.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14932))Reduce repeated work and memory allocations during agent processing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.18.0            |
  | **2.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14924))Add option to control all oauth2 endpoint_params.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **2.21.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14913))Add explicit mapping for `AuthenticationType` field to fix detection rule.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14771))Surface credential or subscription errors in Fleet status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14730))Explain data latency in the documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14587))Populate `message` field from the O365 Audit Log fields instead of `Subject` field in ComplianceDLPExchange events to better reflect Alert Titles.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **2.18.7** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14609))No delays until up-to-date.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.18.6** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14567))Stricter enforcement of maximum age limits.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.18.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14428))Ensure numeric Yammer IDs are not rendered with E-notation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.18.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14289))Fix handling of floating point encoded file sizes.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14289))Fix handling of numeric IDs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **2.18.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14316))Report failures in rename processor that occur when the organization.* fields are already present.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **2.18.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14151))Prevent convert processor failures with fields with empty string values.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14151))Avoid script parameter allocations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **2.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14085))ECS mapping improvements.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.18.0            |
  | **2.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14056))Validate organization field type before accessing subfields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.18.0            |
  | **2.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13931))Set `application.name`, `device.id`, `session.id`, and `token.id` in audit dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **2.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13983))Ignore failures in rename process for organization fields to avoid collision with Agentless organization field.This is a temporary workaround until [https://github.com/elastic/kibana/issues/221312](https://github.com/elastic/kibana/issues/221312) is addressed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **2.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13918))Populate `message` field from the O365 Audit Log `Name` field instead of `Comments` in SecurityComplianceAlerts events to better reflect Alert Titles.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.0            |
  | **2.15.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13925))Set subobjects false to `o365.audit.Parameters` and `o365.audit.ModifiedProperties` to avoid mapping conflicts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.18.0            |
  | **2.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13834))Ensure that empty results do not lead to subsequent invalid API requests.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.18.0            |
  | **2.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13795))Improve clarity of CEL agent collector code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **2.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13557))Improve rendering of `event.original` in documents.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13557))Prevent diagnostics rendering the CEL program as a double-quoted string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13452))Enable request trace log removal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13243))Enable Agentless deployments and updated default.yml to use package-spec 3.2.3.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13119))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.13.0            |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12888))Extract ECS fields from Data and AttachmentData.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12545))Static fields for use by security rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12489))Silence absent URL complaints in debug logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.13.0                 |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **2.6.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11499))Fix the processing of duplicated QueryTime in Data field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.6.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11421))Remove in-program template snippets and format CEL code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **2.6.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11329))Added guardrails to various array accessors to prevent out-of-bounds errors and cleaned up some existing code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **2.6.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11342))Add missing resource_timeout to CEL input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **2.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11052))Tighten IPv4 extraction from IPv4-mapped IPv6 addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10970))Fix definition of ExchangeMetadata subfields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **2.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10218))Add Office to titles and description to better align with integration purpose.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10233))Increase request tracer log count to ten.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.13.0                 |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.3.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10187))Improve handling of o365.audit.AdditionalInfo.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.12.0                 |
  | **2.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9493))Improve handling of o365.audit.OperationProperties.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9477))Check contentExpiration timestamp before requesting contents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9128))Set sensitive values as secret and fix incorrect mappings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                 |
  | **2.2.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8983))Fix dashboard panel filters                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.10.1                 |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9017))Prevent tenant ID being rendered into debug logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8986))Expose OAuth2 token scopes configuration value.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                  |
  | **2.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8964))Add error.message ECS field mapping.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8803))Add extra values to `related.user`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8571))Mapping, parsing of o365.audit fields Platform and Data.*.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **1.29.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8795))Add note to docs about configuring the Token URL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.29.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8494))Add required permissions to docs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8413))Allow user configuration of API request batch size.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **1.26.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8411))Preserve 'event.original' from 'o365audit' field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.25.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8402))Prevent initial API call failure when a delayed call would result in a start time before 168h in the past.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8374))Add start time fallback for responses that do not include the `startTime` query.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8374))Add mappings for `o365.audit.AdditionalInfo.*` and `o365.audit.AppAccessContext.*`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.24.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7988))Fix mappings for dynamically mapped fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7580))Increase CEL resource.tracer.maxsize to prevent loss of trace responses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7432))Fix timestamp error in CEL input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7169))Update package-spec to 2.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6621))Migrate to CEL input from o365audit input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6902))Convert visualizations to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6626))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.1.0                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.1.0                  |
  | **1.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5840))Add FileSizeBytes field in o365.audit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.1.0                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.1.0                  |
  | **1.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.1.0                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5314))Add NewValue field to o365.audit.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.1.0                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5115))Add NewValue field to o365.audit.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.1.0                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5146))Retain file, directory and URL details for `SharePointSharingOperation`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.1.0                  |
  | **1.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5047))Add fingerprint processor to prevent ingestion of duplicate events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.1.0                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.1.0                  |
  | **1.9.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4516))Migrate the visualizations to by value in dashboards to minimize the saved object clutter and reduce time to load                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.1.0                  |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4632))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.14.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.14.0            |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.14.0            |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3531))Added link to Microsoft documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.14.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3868))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.14.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.14.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.14.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3588))Extend list of mapped record types                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.14.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3204))Fix processing of ModifiedProperties when it is a list of strings                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.14.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **1.4.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3095))Replace invalid field value                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.14.0            |
  | **1.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.0.07.14.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2669))Fix grok parsing errors due to invalid IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.14.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2427))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.14.0            |
  | **1.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.14.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2252))Add 8.0.0 version constraint                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.07.14.0            |
  | **1.2.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2096))Uniform with guidelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 7.14.0                 |
  | **1.2.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2113))Fix processors configuration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 7.14.0                 |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1976))Update Title and Description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1837))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1670))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **1.1.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1642))additional type assertions in painless scripts                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 7.14.0                 |
  | **1.1.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1493))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                        |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1402))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1219))make GA**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1219))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 7.14.0                 |
  | **0.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1180))Use `wildcard` field type for the relevant ECS fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **0.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1136))small pipeline fix for parameters when they are string instead of objects                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1119))add system tests**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1119))fixes o365audit config file                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1117))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/983))moving edge processing to ingest pipelines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |                        |
  | **0.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/860))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/749))Change kibana.version constraint to be more conservative.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/716))Add changes to use ECS 1.8 fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/230))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
</dropdown>