﻿---
title: NGINX OpenTelemetry Input Package
description: The NGINX OpenTelemetry Input Package for Elastic enables collection of telemetry data from NGINX web servers through OpenTelemetry protocols using the...
url: https://www.elastic.co/docs/reference/integrations/nginx_otel_input
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# NGINX OpenTelemetry Input Package
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.2.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The NGINX OpenTelemetry Input Package integration v0.2.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The NGINX OpenTelemetry Input Package for Elastic enables collection of telemetry data from NGINX web servers through OpenTelemetry protocols using the [nginxreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/nginxreceiver#nginx-receiver).

### How it works

This package receives telemetry data from NGINX servers by configuring the NGINX endpoint in the Input Package, which then gets applied to the nginxreceiver present in the EDOT collector, which then forwards the data to Elastic Agent. The Elastic Agent processes and enriches the data before sending it to Elasticsearch for indexing and analysis. Once the data arrives into Elasticsearch, its corresponding [NGINX OpenTelemetry Assets Package](https://www.elastic.co/docs/reference/integrations/nginx_otel) gets auto installed and the dashboards light up.

## Metrics reference

For a complete list of all available metrics and their detailed descriptions, refer to the [NGINX Receiver documentation](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/nginxreceiver/documentation.md) in the upstream OpenTelemetry Collector repository.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                         | Minimum Kibana version |
  |-----------|---------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16313))Define available settings as variables |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15651))Initial draft of the package           |                        |
</dropdown>