﻿---
title: Modsecurity Integration
description: This integration periodically fetches audit logs from Modsecurity servers. It can parse audit logs created by the HTTP server. The logs were tested with...
url: https://www.elastic.co/docs/reference/integrations/modsecurity
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Modsecurity Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.22.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | File                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |

This integration periodically fetches audit logs from [Modsecurity](https://github.com/SpiderLabs/ModSecurity/) servers. It can parse audit logs created by the HTTP server.

## Compatibility

The logs were tested with ModSecurity v3 with nginx connector and ModSecurity v3 with Apache Connector. Change the default ModSecurity logging format to json as per configuration.
```
SecAuditLogParts ABDEFHIJZ
SecAuditLogType Serial
SecAuditLog /var/log/modsec_audit.json
SecAuditLogFormat JSON
```
> Be careful to drop **the list of all rules that matched for the transaction (K)** in SecAuditLogParts. That part can make raw logs too long to parse.

### Audit Log

The `Audit Log` dataset collects Modsecurity Audit logs.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                      | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                 | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                               | keyword          |
  | cloud.availability_zone               | Availability zone in which this host is running.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | cloud.project.id                      | Name of the project in Google Cloud.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.region                          | Region in which this host is running.                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                    | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset                   | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                             | constant_keyword |
  | data_stream.namespace                 | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.type                      | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                    | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                           | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | destination.domain                    | The domain name of the destination system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.                                                                                                                                                                                                | keyword          |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                          | geo_point        |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                    | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                    | keyword          |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                      | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                               | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                 | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | host.mac                              | Host mac addresses.                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.name                             | Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.                                                                                                                                                                                                                               | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                   | text             |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                           | keyword          |
  | http.request.body.content             | The full HTTP request body.                                                                                                                                                                                                                                                                                                                                                                                      | wildcard         |
  | http.request.body.content.text        | Multi-field of `http.request.body.content`.                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | http.request.bytes                    | Total size in bytes of the request (body and headers).                                                                                                                                                                                                                                                                                                                                                           | long             |
  | http.request.method                   | HTTP request method. The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field.                                                                                                                                                                                                                                            | keyword          |
  | http.request.mime_type                | Mime type of the body of the request. This value must only be populated based on the content of the request body, not on the `Content-Type` header. Comparing the mime type of a request with the request's Content-Type header can be helpful in detecting threats or misconfigured clients.                                                                                                                    | keyword          |
  | http.request.referrer                 | Referrer for this HTTP request.                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | http.response.body.content            | The full HTTP response body.                                                                                                                                                                                                                                                                                                                                                                                     | wildcard         |
  | http.response.body.content.text       | Multi-field of `http.response.body.content`.                                                                                                                                                                                                                                                                                                                                                                     | match_only_text  |
  | http.response.bytes                   | Total size in bytes of the response (body and headers).                                                                                                                                                                                                                                                                                                                                                          | long             |
  | http.response.mime_type               | Mime type of the body of the response. This value must only be populated based on the content of the response body, not on the `Content-Type` header. Comparing the mime type of a response with the response's Content-Type header can be helpful in detecting misconfigured servers.                                                                                                                           | keyword          |
  | http.response.status_code             | HTTP response status code.                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | http.version                          | HTTP version.                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | input.type                            | Input type                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                             | keyword          |
  | log.offset                            | Log offset                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | message                               | human-readable summary of the event                                                                                                                                                                                                                                                                                                                                                                              | text             |
  | modsec.audit.connector                | The name of the connector between the web server and libmodsecurity.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | modsec.audit.details                  | Modsecurity audit details.                                                                                                                                                                                                                                                                                                                                                                                       | flattened        |
  | modsec.audit.messages                 | Modsecurity audit message.                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | modsec.audit.server                   | Modsecurity server name.                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | rule.id                               | A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.                                                                                                                                                                                                                                                                                     | keyword          |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                         | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                           | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                          | geo_point        |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | transaction.id                        | Unique identifier of the transaction within the scope of its trace. A transaction is the highest level of work measured within a service, such as a request to a server.                                                                                                                                                                                                                                         | keyword          |
  | url.domain                            | Domain of the url, such as "[www.elastic.co](http://www.elastic.co)". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.                             | keyword          |
  | url.extension                         | The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword          |
  | url.fragment                          | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | url.original                          | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.                                                                                                                                     | wildcard         |
  | url.original.text                     | Multi-field of `url.original`.                                                                                                                                                                                                                                                                                                                                                                                   | match_only_text  |
  | url.path                              | Path of the request, such as "/search".                                                                                                                                                                                                                                                                                                                                                                          | wildcard         |
  | url.port                              | Port of the request, such as 443.                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | url.query                             | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.                                                                          | keyword          |
  | url.scheme                            | Scheme of the request, such as "https". Note: The `:` is not part of the scheme.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | user.name                             | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | user.name.text                        | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | user_agent.device.name                | Name of the device.                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | user_agent.name                       | Name of the user agent.                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | user_agent.original                   | Unparsed user_agent string.                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | user_agent.original.text              | Multi-field of `user_agent.original`.                                                                                                                                                                                                                                                                                                                                                                            | match_only_text  |
  | user_agent.os.full                    | Operating system name, including the version or code name.                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | user_agent.os.full.text               | Multi-field of `user_agent.os.full`.                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | user_agent.os.name                    | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | user_agent.os.name.text               | Multi-field of `user_agent.os.name`.                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | user_agent.os.version                 | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user_agent.version                    | Version of the user agent.                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15805))Preserve event.original on pipeline error.                                                                                                                               | 9.0.08.11.0            |
  | **1.21.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15563))Generate processor tags and normalize error handler.                                                                                                                     | 9.0.08.11.0            |
  | **1.21.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                          | 9.0.08.11.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13522))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                 | 9.0.08.11.0            |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                               | 9.0.08.0.07.16.0       |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12572))ECS version updated to 8.17.0.                                                                                                                                           | 8.0.07.16.0            |
  | **1.18.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11315))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.0.07.16.0            |
  | **1.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11286))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.0.07.16.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                             | 8.0.07.16.0            |
  | **1.17.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.0.07.16.0            |
  | **1.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.0.07.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8326))Add missing `destination.as.*` and `denstination.geo.*` field definitions and mapping.                                                                                        | 8.0.07.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.0.07.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.0.07.16.0            |
  | **1.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7397))Make pipeline selection more robust when nginx is configured with `server_tokens off`.                                                                                        | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6672))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.0.07.16.0            |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6620))Fix handling of apache details.                                                                                                                                               | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.6.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5418))Handle sub-second resolution timestamps.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5418))Improve error handling.                       | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5051))Add support for time zone configuration.                                                                                                                                      | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4611))Remove duplicate fields.                                                                                                                                                      | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4521))Adding better extraction of http request headers                                                                                                                          | 8.0.07.16.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3868))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.1.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3435))Fix typo in the build/docs/README.md                                                                                                                                          | 8.0.07.16.0            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3363))Fix date format, Json issues and apache modesecurity issues                                                                                                                   | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3428))Make GA                                                                                                                                                                   | 8.0.07.16.0            |
  | **0.1.5**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        |                        |
  | **0.1.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2846))Change ownership to correct owner and update versions to support 8.x                                                                                                      |                        |
  | **0.1.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                            |                        |
  | **0.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                |                        |
  | **0.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1830))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1603))Initial draft of the package                                                                                                                                              |                        |
</dropdown>