﻿---
title: Microsoft Exchange Server
description: The Microsoft Exchange Server integration allows you to monitor Exchange Server installations. The Microsoft Exchange Server integration collects logs...
url: https://www.elastic.co/docs/reference/integrations/microsoft_exchange_server
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Microsoft Exchange Server
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.4.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | File                           |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                    |

The Microsoft Exchange Server integration allows you to monitor Exchange Server installations.

## Data streams

The Microsoft Exchange Server integration collects logs of the following streams:
- Exchange HTTPProxy Logs
- Exchange Server IMAP4 POP3 Logs
- Exchange Messagetracking Logs
- Exchange SMTP logs


## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

For step-by-step instructions on how to set up an integration, see the
[Getting started](https://www.elastic.co/guide/en/starting-with-the-elasticsearch-platform-and-its-solutions/current/getting-started-observability.html) guide.

## Setup Exchange Server

To collect the SMTP Logs, the logs have to be configured on the exchange Server. To enable it, you can follow this [guide](https://learn.microsoft.com/en-us/exchange/mail-flow/connectors/configure-protocol-logging)
The other logs are enabled by default, and no further configurations are required

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Screenshot MessageTracking Dashboard](https://epr.elastic.co/package/microsoft_exchange_server/1.4.1/img/screenshot_messagtracking.png)

  ![Screenshot HTTPProxy Dashboard](https://epr.elastic.co/package/microsoft_exchange_server/1.4.1/img/screenshot_httpproxy.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                           | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16159))Fix the input templates to correctly include custom processors.                              | 9.0.08.11.0            |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13521))Allow @custom pipeline access to event.original without setting preserve_original_event. | 9.0.08.11.0            |
  | **1.3.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12846))Handle events where `networkmessageid` or `senderaddress` are not present.                   | 9.0.08.10.1            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12636))ECS version updated to 8.17.0.                                                           | 9.0.08.10.1            |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12748))Fix log.offset mapping type                                                                  | 9.0.08.10.1            |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12381))Add 9.0.0 constraint.                                                                    | 9.0.08.10.1            |
  | **1.1.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                         | 8.10.1                 |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11788))Fix relatedrecipientaddress mapping type                                                     | 8.10.1                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11002))Add conditional override when from address differs from sender address                   | 8.10.1                 |
  | **1.0.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10173))Adjust mapping to include related & error field                                              | 8.10.1                 |
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9723))Adjust mapping to include agent & host field                                                  | 8.10.1                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9560))GA of Integration, Add Dashbord Panel Titles & added System Tests                         | 8.10.1                 |
  | **0.1.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9349))Fix Recipientstatus field type, add custom processor support & adjust docs                    |                        |
  | **0.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9325))Fix missing Dashboard references                                                          |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9197))Initial release of the package                                                            |                        |
</dropdown>