﻿---
title: Menlo Security
description: Menlo Security’s isolation-centric approach splits web browsing and document retrieval between the user’s device and an isolated, Disposable Virtual Container...
url: https://www.elastic.co/docs/reference/integrations/menlo
products:
  - Elastic integrations
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Menlo Security
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.7.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.1.08.19.0                    |

Menlo Security’s isolation-centric approach splits web browsing and document retrieval between the user’s device and an isolated, Disposable Virtual Container (DVC) away from the endpoint. All risky code is executed in the isolated DVC and never reaches the endpoint. Only safe display data is sent to the user’s browser. User traffic is automatically sent to this infrastructure without any impact on the users themselves.

## Web

Menlo Security's cloud based Browser Security prevents phishing and malware attacks on any browser and any device across your hybrid enterprise.

## DLP

Data Loss Prevention (also known as Data Leak Prevention) detects potential data breaches or data ex-filtration transmissions and prevents them by detecting and optionally blocking sensitive data passing through the Menlo Security platform.

## Compatibility

This module has been tested against the Menlo Security API **version 2.0**

## Data streams

The Menlo Security integration collects data for the following two events:

| Event Type |
|------------|
| Web        |
| DLP        |


## Setup

To collect data through the REST API you will need your Menlo Security API URL and an API token.
The API token to collect logs must have the *Log Export API* permission

## Logs Reference


### Web

This is the `Web` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-11-21T13:12:37.102Z",
      "agent": {
          "ephemeral_id": "bddb12b1-a632-4451-a86a-2b9c65366d00",
          "id": "92c83619-8c8c-4500-ae81-e5b4d76cd0bf",
          "name": "elastic-agent-11134",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "client": {
          "geo": {
              "country_iso_code": "US"
          },
          "ip": "192.18.1.3"
      },
      "cloud": {
          "region": "us-east-1c"
      },
      "data_stream": {
          "dataset": "menlo.web",
          "namespace": "95262",
          "type": "logs"
      },
      "destination": {
          "geo": {
              "country_iso_code": "US"
          },
          "ip": "192.18.1.1"
      },
      "dns": {
          "answers": {
              "data": [
                  "192.18.1.1"
              ]
          }
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "92c83619-8c8c-4500-ae81-e5b4d76cd0bf",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "web",
              "network",
              "threat"
          ],
          "dataset": "menlo.web",
          "ingested": "2025-11-30T23:39:23Z",
          "kind": "alert",
          "original": "{\"event\":{\"browser_and_version\":\"Chrome_119\",\"categories\":\"Business and Economy\",\"content-type\":\"text/html; charset=UTF-8\",\"domain\":\"elastic.co\",\"dst\":\"192.18.1.1\",\"egress_country\":\"US\",\"egress_ip\":\"192.18.1.2\",\"event_time\":\"2023-11-21T13:12:37.102000\",\"file_size\":\"NA\",\"filename\":\"NA\",\"fullScanResult\":\"NA\",\"has_password\":\"false\",\"inconsistent_domain\":\"false\",\"is_iframe\":\"false\",\"magicName\":\"NA\",\"name\":\"page_request\",\"numSubfiles\":\"0\",\"origin_country\":\"US\",\"origin_ip\":\"192.18.1.1\",\"pe_reason\":\"a77757d5-d3be-47ab-9394-cfff5887ade4\",\"pe_rulename\":\"Business and Economy Category\",\"product\":\"MSIP\",\"protocol\":\"http\",\"region\":\"us-east-1c\",\"rendering_mode\":\"ACR1\",\"request_type\":\"GET\",\"response_code\":\"308\",\"risk_score\":\"low\",\"risk_tally\":\"-1\",\"sandboxActivity\":\"NA\",\"sandboxResult\":\"NA\",\"soph_dlp_ref\":\"NA\",\"tab_id\":\"1\",\"top_url\":\"http://elastic.co/\",\"ua_type\":\"supported_browser\",\"url\":\"http://elastic.co/\",\"user-agent\":\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36\",\"userid\":\"example_user\",\"vendor\":\"Menlo Security\",\"version\":\"2.0\",\"x-client-country\":\"US\",\"x-client-ip\":\"192.18.1.3\",\"xff_ip\":\"NA\"}}",
          "outcome": "unknown",
          "reason": "a77757d5-d3be-47ab-9394-cfff5887ade4"
      },
      "http": {
          "request": {
              "method": "GET"
          },
          "response": {
              "status_code": 308
          }
      },
      "input": {
          "type": "cel"
      },
      "menlo": {
          "web": {
              "categories": "Business and Economy",
              "content_type": "text/html; charset=UTF-8",
              "has_password": false,
              "is_iframe": "false",
              "request_type": "page_request",
              "risk_score": "low",
              "tab_id": "1",
              "tally": -1,
              "ua_type": "supported_browser"
          }
      },
      "network": {
          "protocol": "http"
      },
      "observer": {
          "geo": {
              "country_iso_code": "US"
          },
          "ip": [
              "192.18.1.2"
          ],
          "product": "MSIP",
          "vendor": "Menlo Security",
          "version": "2.0"
      },
      "related": {
          "ip": [
              "192.18.1.3",
              "192.18.1.1"
          ],
          "user": [
              "example_user"
          ]
      },
      "server": {
          "geo": {
              "country_iso_code": "US"
          },
          "ip": "192.18.1.1"
      },
      "source": {
          "geo": {
              "country_iso_code": "US"
          },
          "ip": "192.18.1.3"
      },
      "tags": [
          "preserve_original_event",
          "menlo",
          "forwarded"
      ],
      "url": {
          "domain": "elastic.co",
          "original": "http://elastic.co/",
          "path": "/",
          "registered_domain": "elastic.co",
          "scheme": "http",
          "top_level_domain": "co"
      },
      "user": {
          "name": "example_user"
      },
      "user_agent": {
          "device": {
              "name": "Mac"
          },
          "name": "Chrome",
          "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36",
          "os": {
              "full": "Mac OS X 10.15.7",
              "name": "Mac OS X",
              "version": "10.15.7"
          },
          "version": "119.0.0.0"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                        | Description                                                                                                                           | Type             |
  |------------------------------|---------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                   | Event timestamp.                                                                                                                      | date             |
  | cloud.image.id               | Image ID for the cloud instance.                                                                                                      | keyword          |
  | data_stream.dataset          | Data stream dataset.                                                                                                                  | constant_keyword |
  | data_stream.namespace        | Data stream namespace.                                                                                                                | constant_keyword |
  | data_stream.type             | Data stream type.                                                                                                                     | constant_keyword |
  | event.dataset                | Event dataset.                                                                                                                        | constant_keyword |
  | event.module                 | Event module.                                                                                                                         | constant_keyword |
  | host.containerized           | If the host is a container.                                                                                                           | boolean          |
  | host.os.build                | OS build information.                                                                                                                 | keyword          |
  | host.os.codename             | OS codename, if any.                                                                                                                  | keyword          |
  | input.type                   | Input type                                                                                                                            | keyword          |
  | log.offset                   | Log offset                                                                                                                            | long             |
  | menlo.web.cached             | Indicates whether the resource was obtained from the isolated browser’s cache (True) or by downloading from the origin server (False) | boolean          |
  | menlo.web.casb_app_name      | Cloud application name                                                                                                                | keyword          |
  | menlo.web.casb_cat_name      | Application category ID                                                                                                               | keyword          |
  | menlo.web.casb_fun_name      | Application function name                                                                                                             | keyword          |
  | menlo.web.casb_org_name      | Application organization name                                                                                                         | keyword          |
  | menlo.web.casb_profile_id    | Menlo CASB profile ID                                                                                                                 | keyword          |
  | menlo.web.casb_profile_name  | Menlo CASB profile name attached to application or exception rule                                                                     | keyword          |
  | menlo.web.casb_profile_type  | Menlo CASB profile type (sanctioned/unsanctioned/unclassified)                                                                        | keyword          |
  | menlo.web.casb_risk_score    | Menlo risk score for application (0-10)                                                                                               | keyword          |
  | menlo.web.categories         | Category Rules Category type classification                                                                                           | keyword          |
  | menlo.web.conn_id            | Menlo Connection ID                                                                                                                   | keyword          |
  | menlo.web.content_type       | Page type                                                                                                                             | keyword          |
  | menlo.web.has_password       | Presence of password in form POST request                                                                                             | boolean          |
  | menlo.web.is_iframe          | Is inline frame (iframe) element                                                                                                      | boolean          |
  | menlo.web.proxy_event_detail | Menlo Proxy Event Detail                                                                                                              | keyword          |
  | menlo.web.proxy_event_type   | Menlo Proxy Event Type                                                                                                                | keyword          |
  | menlo.web.req_id             | Menlo Request ID                                                                                                                      | keyword          |
  | menlo.web.request_type       | Request type                                                                                                                          | keyword          |
  | menlo.web.risk_score         | Risk calculated for URL                                                                                                               | keyword          |
  | menlo.web.sbox               | Sandbox Inspection Result                                                                                                             | keyword          |
  | menlo.web.sbox_mal_act       | List of malicious activities found                                                                                                    | keyword          |
  | menlo.web.soph               | Full file scan result                                                                                                                 | keyword          |
  | menlo.web.tab_id             | Tab creation number within a surrogate                                                                                                | keyword          |
  | menlo.web.tally              | Count of risks encountered                                                                                                            | long             |
  | menlo.web.threat_types       | Top level risk                                                                                                                        | keyword          |
  | menlo.web.threats            | Threat type identified by Menlo Security internal data                                                                                | keyword          |
  | menlo.web.ua_type            | The type of user agent                                                                                                                | keyword          |
  | menlo.web.virus_details      | Virus detail                                                                                                                          | keyword          |
  | menlo.web.xff_ip             | X-Forwarded-For HTTP header field originating client IP address                                                                       | keyword          |
</dropdown>


### DLP

This is the `DLP` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-11-30T23:37:30.347Z",
      "agent": {
          "ephemeral_id": "9998f9dc-1878-4fdc-a74f-3906648b186c",
          "id": "02dc436f-6c46-4084-9ba1-bf15f0b48d5e",
          "name": "elastic-agent-90978",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "data_stream": {
          "dataset": "menlo.dlp",
          "namespace": "57455",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "02dc436f-6c46-4084-9ba1-bf15f0b48d5e",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "action": "block",
          "agent_id_status": "verified",
          "category": [
              "intrusion_detection",
              "network"
          ],
          "created": "2020-03-09T17:17:22.227Z",
          "dataset": "menlo.dlp",
          "id": "a4c2161b3f81a287ec46d3c993a33f3b97ded5fd854fa184e7f50679303111ce",
          "ingested": "2025-11-30T23:37:33Z",
          "kind": "alert",
          "original": "{\"event\":{\"action\":\"block\",\"alerted\":\"false\",\"categories\":\"Download Sites\",\"ccl_ids\":\"CreditordebitcardnumbersGlobal\",\"ccl_match_counts\":\"1\",\"ccl_scores\":\"1\",\"domain\":\"tinynewupload.com\",\"dst_url\":\"http://tinynewupload.com/\",\"event_id\":\"a4c2161b3f81a287ec46d3c993a33f3b97ded5fd854fa184e7f50679303111ce\",\"event_time\":\"2020-03-09T17:17:22.227000\",\"file_type\":\"CSV\",\"filename\":\"more_credit_cards.csv\",\"name\":\"file_upload\",\"product\":\"MSIP\",\"protocol\":\"http\",\"request_type\":\"GET\",\"rule_id\":\"1f3ef32c-ec62-42fb-8cad-e1fee3375099\",\"rule_name\":\"Credit card block rule\",\"severity\":\"5\",\"sha256\":\"fd1aee671d92aba0f9f0a8a6d5c6b843e09c8295ced9bb85e16d97360b4d7b3a\",\"src_url\":\"http://tinynewupload.com/\",\"status\":\"dirty\",\"stream_name\":\"/safefile-input/working_file\",\"user_input\":\"false\",\"userid\":\"admin@menlosecurity.com\",\"vendor\":\"Menlo Security\",\"version\":\"2.0\"}}",
          "outcome": "success",
          "severity": 5
      },
      "file": {
          "hash": {
              "sha256": "fd1aee671d92aba0f9f0a8a6d5c6b843e09c8295ced9bb85e16d97360b4d7b3a"
          },
          "name": "more_credit_cards.csv"
      },
      "http": {
          "request": {
              "method": "GET"
          }
      },
      "input": {
          "type": "cel"
      },
      "menlo": {
          "dlp": {
              "alerted": "false",
              "category": "Download Sites",
              "ccl": {
                  "id": "CreditordebitcardnumbersGlobal",
                  "match_counts": 1,
                  "score": 1
              },
              "status": "dirty",
              "stream_name": "/safefile-input/working_file",
              "user_input": "false"
          }
      },
      "observer": {
          "product": "MSIP",
          "vendor": "Menlo Security",
          "version": "2.0"
      },
      "related": {
          "hash": [
              "fd1aee671d92aba0f9f0a8a6d5c6b843e09c8295ced9bb85e16d97360b4d7b3a"
          ],
          "user": [
              "admin",
              "admin@menlosecurity.com"
          ]
      },
      "rule": {
          "id": "1f3ef32c-ec62-42fb-8cad-e1fee3375099",
          "name": "Credit card block rule"
      },
      "tags": [
          "preserve_original_event",
          "menlo",
          "forwarded"
      ],
      "url": {
          "domain": "tinynewupload.com",
          "original": "http://tinynewupload.com/",
          "path": "/",
          "registered_domain": "tinynewupload.com",
          "scheme": "http",
          "top_level_domain": "com"
      },
      "user": {
          "domain": "menlosecurity.com",
          "email": "admin@menlosecurity.com",
          "id": "admin@menlosecurity.com",
          "name": "admin"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                      | Description                                                                 | Type             |
  |----------------------------|-----------------------------------------------------------------------------|------------------|
  | @timestamp                 | Event timestamp.                                                            | date             |
  | cloud.image.id             | Image ID for the cloud instance.                                            | keyword          |
  | data_stream.dataset        | Data stream dataset.                                                        | constant_keyword |
  | data_stream.namespace      | Data stream namespace.                                                      | constant_keyword |
  | data_stream.type           | Data stream type.                                                           | constant_keyword |
  | event.dataset              | Event dataset.                                                              | constant_keyword |
  | event.module               | Event module.                                                               | constant_keyword |
  | host.containerized         | If the host is a container.                                                 | boolean          |
  | host.os.build              | OS build information.                                                       | keyword          |
  | host.os.codename           | OS codename, if any.                                                        | keyword          |
  | input.type                 | Input type                                                                  | keyword          |
  | log.offset                 | Log offset                                                                  | long             |
  | menlo.dlp.alerted          | Whether or not an email alert was sent to a DLP Auditor profile             | boolean          |
  | menlo.dlp.category         | Category Rules Category type classification                                 | keyword          |
  | menlo.dlp.ccl.id           | Name of DLP dictionary that was violated                                    | keyword          |
  | menlo.dlp.ccl.match_counts | Number of matches of the string that caused the violation                   | long             |
  | menlo.dlp.ccl.score        | DLP score from the dictionary that caused the violation                     | long             |
  | menlo.dlp.status           | Result from the DLP engine                                                  | keyword          |
  | menlo.dlp.stream_name      | Internal name used for the file (usually working_file) or text stream (uid) | keyword          |
  | menlo.dlp.user_input       | Whether or not this event was generated as a result of user form input      | boolean          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                               | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.7.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16168))Fix handling of large numbers.                                                                                                                                                                                                   | 9.1.08.19.0            |
  | **1.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15967))Add parsing for proxy events returned by the Menlo Web API.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15967))Fix parsing of documents when the Menlo `event.categories` field is missing. | 9.0.08.13.0            |
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                      | 9.0.08.13.0            |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                             | 8.13.0                 |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                           | 8.13.0                 |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                      | 8.13.0                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                    | 8.13.0                 |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                             | 8.13.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                   | 8.13.0                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9779))Release package as GA.                                                                                                                                                                                                        | 8.13.0                 |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9315))Initial draft of the package                                                                                                                                                                                                  |                        |
</dropdown>