﻿---
title: Mattermost Integration
description: The Mattermost integration collects logs from Mattermost servers.  This integration has been tested with Mattermost version 5.31.9 but is expected to...
url: https://www.elastic.co/docs/reference/integrations/mattermost
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Mattermost Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                      |
| **Ingestion method(s)**                                                                         | File                           |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

The Mattermost integration collects logs from [Mattermost](https://docs.mattermost.com/) servers.  This integration has been tested with
Mattermost version 5.31.9 but is expected to work with other versions.

## Logs


### Audit

All access to the Mattermost REST API or CLI is audited.
<dropdown title="Exported fields">
  | Field                            | Description                                            | Type             |
  |----------------------------------|--------------------------------------------------------|------------------|
  | @timestamp                       | Event timestamp.                                       | date             |
  | cloud.image.id                   | Image ID for the cloud instance.                       | keyword          |
  | data_stream.dataset              | Data stream dataset name.                              | constant_keyword |
  | data_stream.namespace            | Data stream namespace.                                 | constant_keyword |
  | data_stream.type                 | Data stream type.                                      | constant_keyword |
  | event.dataset                    | Event dataset                                          | constant_keyword |
  | event.module                     | Event module                                           | constant_keyword |
  | host.containerized               | If the host is a container.                            | boolean          |
  | host.os.build                    | OS build information.                                  | keyword          |
  | host.os.codename                 | OS codename, if any.                                   | keyword          |
  | input.type                       | Type of Filebeat input.                                | keyword          |
  | log.flags                        | Flags for the log file.                                | keyword          |
  | log.offset                       | Offset of the entry in the log file.                   | long             |
  | mattermost.audit.api_path        | REST API endpoint                                      | keyword          |
  | mattermost.audit.channel.id      | ID of affected channel                                 | keyword          |
  | mattermost.audit.channel.name    | Name of affected channel                               | keyword          |
  | mattermost.audit.channel.type    | Type of affected channel                               | keyword          |
  | mattermost.audit.cluster.id      | Mattermost cluster ID                                  | keyword          |
  | mattermost.audit.error.message   | Mattermost error message                               | keyword          |
  | mattermost.audit.patch.id        | ID of patched channel/team/user...                     | keyword          |
  | mattermost.audit.patch.name      | Name of patched channel/team/user...                   | keyword          |
  | mattermost.audit.patch.roles     | Roles of patched user                                  | keyword          |
  | mattermost.audit.patch.type      | Type of patched channel/team/user...                   | keyword          |
  | mattermost.audit.post.channel.id | Channel ID of post                                     | keyword          |
  | mattermost.audit.post.id         | Post ID                                                | keyword          |
  | mattermost.audit.post.pinned     | Whether or not the post was pinned to the channel      | boolean          |
  | mattermost.audit.related.channel | List of channels realted to the event                  | keyword          |
  | mattermost.audit.related.team    | List of channels realted to the event                  | keyword          |
  | mattermost.audit.session.id      | ID of session used to call the API                     | keyword          |
  | mattermost.audit.status          | Outcome of action/event, ex. success, fail, attempt... | keyword          |
  | mattermost.audit.team.id         | ID of affected team                                    | keyword          |
  | mattermost.audit.team.name       | Name of affected team                                  | keyword          |
  | mattermost.audit.team.type       | Type of affected team                                  | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-12-04T23:19:32.051Z",
      "agent": {
          "ephemeral_id": "3a1ecfb2-18a4-46c9-9996-65f6853ed739",
          "id": "d2a14a09-96fc-4f81-94ef-b0cd75ad71e7",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "mattermost.audit",
          "namespace": "26102",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "d2a14a09-96fc-4f81-94ef-b0cd75ad71e7",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "action": "updateConfig",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "dataset": "mattermost.audit",
          "ingested": "2024-06-12T03:15:44Z",
          "kind": "event",
          "original": "{\"timestamp\":\"2021-12-04 23:19:32.051 Z\",\"event\":\"updateConfig\",\"status\":\"success\",\"user_id\":\"ag99yu4i1if63jrui63tsmq57y\",\"session_id\":\"pjh4n69j3p883k7hhzippskcba\",\"ip_address\":\"172.19.0.1\",\"api_path\":\"/api/v4/config\",\"cluster_id\":\"jq3utry71f8a7q9qgebmjccf4r\",\"client\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36\"}",
          "outcome": "success",
          "type": [
              "change"
          ]
      },
      "host": {
          "architecture": "x86_64",
          "containerized": false,
          "hostname": "docker-fleet-agent",
          "id": "8259e024976a406e8a54cdbffeb84fec",
          "ip": [
              "172.19.0.7"
          ],
          "mac": [
              "02-42-AC-13-00-07"
          ],
          "name": "docker-fleet-agent",
          "os": {
              "codename": "focal",
              "family": "debian",
              "kernel": "6.5.11-linuxkit",
              "name": "Ubuntu",
              "platform": "ubuntu",
              "type": "linux",
              "version": "20.04.6 LTS (Focal Fossa)"
          }
      },
      "input": {
          "type": "log"
      },
      "log": {
          "file": {
              "path": "/tmp/service_logs/audit.log"
          },
          "offset": 0
      },
      "mattermost": {
          "audit": {
              "api_path": "/api/v4/config",
              "cluster": {
                  "id": "jq3utry71f8a7q9qgebmjccf4r"
              },
              "session": {
                  "id": "pjh4n69j3p883k7hhzippskcba"
              }
          }
      },
      "related": {
          "ip": [
              "172.19.0.1"
          ],
          "user": [
              "ag99yu4i1if63jrui63tsmq57y"
          ]
      },
      "source": {
          "address": "172.19.0.1",
          "ip": "172.19.0.1"
      },
      "tags": [
          "mattermost-audit",
          "preserve_original_event"
      ],
      "url": {
          "original": "/api/v4/config",
          "path": "/api/v4/config"
      },
      "user": {
          "id": "ag99yu4i1if63jrui63tsmq57y"
      },
      "user_agent": {
          "device": {
              "name": "Other"
          },
          "name": "Chrome",
          "original": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36",
          "os": {
              "full": "Windows 10",
              "name": "Windows",
              "version": "10"
          },
          "version": "96.0.4664.45"
      }
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Mattermost Audit Dashboard](https://epr.elastic.co/package/mattermost/2.5.0/img/mattermost-audit_dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13731))Add dashboard.                                                                                                                                                           | 9.0.08.13.0            |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **2.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10136))Fix sample event.                                                                                                                                                            | 8.0.07.16.0            |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `event.type` field conform to ECS field definition.                                                                                                                 | 8.0.07.16.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9403))Update manifest format version to v3.0.3.                                                                                                                                 | 8.0.07.16.0            |
  | **1.17.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9177))Clean up null handling and Painless scripts                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.0.07.16.0            |
  | **1.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.0.07.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.0.07.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                                               | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                            | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6661))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                                                                                     | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4247))Add link to Mattermost documentation.                                                                                                                                     | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3867))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.16.0            |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2780))Update to ECS 8.2                                                                                                                                                         | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2420))Update to ECS 8.0                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2315))Initial draft of the package                                                                                                                                              | 8.0.07.16.0            |
</dropdown>