﻿---
title: Microsoft Defender XDR integration
description: The Microsoft Defender XDR integration allows you to monitor Alert, Incident (Microsoft Graph Security API), Event (Streaming API) Logs, and Vulnerability...
url: https://www.elastic.co/docs/reference/integrations/m365_defender
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Microsoft Defender XDR integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 5.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, Azure Event Hub           |
| **Minimum Kibana version(s)**                                                                   | 9.1.48.19.4                    |


## Overview

The [Microsoft Defender XDR](https://learn.microsoft.com/en-us/defender-xdr/) integration allows you to monitor Alert, Incident (Microsoft Graph Security API), Event (Streaming API) Logs, and Vulnerability (Microsoft Defender for Endpoint API) Logs. Microsoft Defender XDR is a unified pre and post-breach enterprise defense suite that natively coordinates detection, prevention, investigation, and response across endpoints, identities, email, and applications to provide integrated protection against sophisticated attacks.

### How it works

The integration works by collecting data from the Microsoft Azure Event Hub, Microsoft Graph Security REST API, and the Microsoft Defender Endpoint API.

### Compatibility

This integration supports below API versions to collect data.
- [Microsoft Graph Security REST API v1.0](https://learn.microsoft.com/en-us/graph/api/resources/security-api-overview?view=graph-rest-1.0)
  - [Alerts](https://learn.microsoft.com/en-us/graph/api/security-list-alerts_v2?view=graph-rest-1.0)
- [Incidents](https://learn.microsoft.com/en-us/graph/api/security-list-incidents?view=graph-rest-1.0)
- [Microsoft Defender for Endpoint API v1.0](https://learn.microsoft.com/en-us/defender-endpoint/api/exposed-apis-list)
  - [Vulnerabilities](https://learn.microsoft.com/en-us/defender-endpoint/api/get-assessment-software-vulnerabilities#2-export-software-vulnerabilities-assessment-via-files)
- [Microsoft Defender XDR Streaming API](https://learn.microsoft.com/en-us/defender-xdr/streaming-api?view=o365-worldwide)
  - Supported Microsoft Defender XDR Streaming event types are listed below. For more details on all available event types, refer to [documentation](https://learn.microsoft.com/en-us/defender-xdr/supported-event-types).
  | Resource types            | Description                                                                                                                                                                       |
  |---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
  | AlertEvidence             | Files, IP addresses, URLs, users, or devices associated with alerts.                                                                                                              |
  | AlertInfo                 | Alerts from M365 Defender XDR services, including severity and threat categorization.                                                                                             |
  | CloudAppEvents            | Events involving accounts and objects in Office 365 and other cloud apps and services.                                                                                            |
  | DeviceEvents              | Event types, including events triggered by security controls.                                                                                                                     |
  | DeviceFileCertificateInfo | Certificate information of signed files obtained from certificate verification events on endpoints.                                                                               |
  | DeviceFileEvents          | File creation, modification, and other file system events.                                                                                                                        |
  | DeviceImageLoadEvents     | DLL loading events.                                                                                                                                                               |
  | DeviceInfo                | Machine information, including OS information.                                                                                                                                    |
  | DeviceLogonEvents         | Sign-ins and other authentication events on devices.                                                                                                                              |
  | DeviceNetworkEvents       | Network connection and related events.                                                                                                                                            |
  | DeviceNetworkInfo         | Network properties of devices, as well as connected networks and domains.                                                                                                         |
  | DeviceProcessEvents       | Process creation and related events.                                                                                                                                              |
  | DeviceRegistryEvents      | Creation and modification of registry entries.                                                                                                                                    |
  | EmailAttachmentInfo       | Information about files attached to emails.                                                                                                                                       |
  | EmailEvents               | Microsoft 365 email events, including email delivery and blocking events.                                                                                                         |
  | EmailPostDeliveryEvents   | Security events that occur post-delivery, after Microsoft 365 delivers the emails to the recipient mailbox.                                                                       |
  | EmailUrlInfo              | Information about URLs in emails.                                                                                                                                                 |
  | IdentityInfo              | Account information from various sources, including Microsoft Entra ID.                                                                                                           |
  | IdentityLogonEvents       | Authentication events on Active Directory and Microsoft online services.                                                                                                          |
  | IdentityQueryEvents       | Queries for Active Directory objects, such as users, groups, devices, and domains.                                                                                                |
  | IdentityDirectoryEvents   | Events involving an on-premises domain controller running Active Directory (AD). This table covers a range of identity-related events and system events on the domain controller. |
  | CloudAppEvents            | Events involving accounts and objects in Office 365 and other cloud apps and services.                                                                                            |
  | UrlClickEvent             | Safe Links clicks from email messages, Teams, and Office 365 apps.                                                                                                                |


## What data does this integration collect?

The Microsoft Defender XDR integration collects logs for four types of events: Alerts, Events, Incidents, and Vulnerabilities.
**Alerts:** This data streams uses the [Microsoft Graph Security API](https://learn.microsoft.com/en-us/graph/api/resources/security-api-overview?view=graph-rest-1.0)'s [`/security/alerts_v2`](https://learn.microsoft.com/en-us/graph/api/security-list-alerts_v2?view=graph-rest-1.0) endpoint to collect alerts including suspicious activities in a customer's tenant that Microsoft or partner security providers have identified and flagged for action.
**Events:** This data stream uses the [Microsoft Defender XDR Streaming API](https://learn.microsoft.com/en-us/defender-xdr/streaming-api?view=o365-worldwide) to collect Alert, Device, Email, App and Identity Events. Events are streamed to an Azure Event Hub. For a list of supported events exposed by the Streaming API and supported by Elastic's integration, please refer to Microsoft's documentation [here](https://learn.microsoft.com/en-us/defender-xdr/supported-event-types?view=o365-worldwide).
**Incidents and Alerts:** This data streams uses the [Microsoft Graph Security API](https://learn.microsoft.com/en-us/graph/api/resources/security-api-overview?view=graph-rest-1.0)'s [`/security/incidents`](https://learn.microsoft.com/en-us/graph/api/security-list-incidents?view=graph-rest-1.0) endpoint to ingest a collection of correlated alert instances and associated metadata that reflects the story of an attack in Microsoft Defender XDR. Incidents stemming from Microsoft Defender XDR, Microsoft Defender for Endpoint, Microsoft Defender for Office 365, Microsoft Defender for Identity, Microsoft Defender for Cloud Apps, and Microsoft Purview Data Loss Prevention are supported by this integration.
**Vulnerabilities:** This data stream uses the [Microsoft Defender for Endpoint API](https://learn.microsoft.com/en-us/defender-endpoint/api/exposed-apis-list)'s [`/api/machines/SoftwareVulnerabilitiesExport`](https://learn.microsoft.com/en-us/defender-endpoint/api/get-assessment-software-vulnerabilities#2-export-software-vulnerabilities-assessment-via-files) endpoint to collect vulnerability assessments.
<note>
  The **Alerts** data stream ingests individual detection events surfaced by Microsoft and partner security providers, while **Incidents and Alerts** data stream ingests correlated collections of alerts that represent a broader attack.
</note>


### Supported Use Cases

Use the data from this integration to consolidate and correlate security alerts from multiple sources. Also, by looking into the alert, incident, and vulnerability a user can take an appropriate action in the Microsoft Defender XDR Portal.

## What do I need to use this integration?


### From Elastic

Version `4.0.0` of the Microsoft Defender XDR integration adds [Elastic latest transforms](https://www.elastic.co/docs/explore-analyze/transforms/transform-overview#latest-transform-overview). For more details, refer to the Transform setup and requirements [documentation](https://www.elastic.co/docs/explore-analyze/transforms/transform-setup).

### From Microsoft Defender XDR

Follow the steps below to configure data collection from Microsoft sources.

#### 1. Collecting Data using Azure Event Hub

- [Configure Microsoft Defender XDR to stream Advanced Hunting events to your Azure Event Hub](https://learn.microsoft.com/en-us/defender-xdr/streaming-api-event-hub?view=o365-worldwide).
- A Blob Storage account is required in order to store/retrieve/update the offset or state of the eventhub messages. This means that after stopping filebeat it can start back up at the spot that it stopped processing messages.


#### 2. Collecting Data using Microsoft Graph Security REST API (for Incidents & Alerts)

- [Register a new Azure Application](https://learn.microsoft.com/en-us/graph/auth-register-app-v2?view=graph-rest-1.0).
- Assign the required permission: **SecurityIncident.Read.All**. Refer to [this documentation](https://learn.microsoft.com/en-us/graph/auth-v2-service?view=graph-rest-1.0&tabs=http#step-1-configure-permissions-for-microsoft-graph) on how to configure permissions. Refer to [documentation](https://learn.microsoft.com/en-us/graph/api/security-list-incidents?view=graph-rest-1.0&tabs=http#permissions) on required permissions for incidents and alerts.
- Once the application is registered, note the following values for use during configuration:
  - Client ID
- Client Secret
- Tenant ID


#### 3. Collecting Data using Microsoft Defender for Endpoint API (for Vulnerabilities)

- [Register a new Azure Application](https://learn.microsoft.com/en-us/graph/auth-register-app-v2?view=graph-rest-1.0).
- Assign the required permissions: **Vulnerability.Read.All**. Refer to [this documentation](https://learn.microsoft.com/en-us/graph/auth-v2-service?view=graph-rest-1.0&tabs=http#step-1-configure-permissions-for-microsoft-graph) on how to configure permissions. Refer to [this documentation](https://learn.microsoft.com/en-us/defender-endpoint/api/get-assessment-software-vulnerabilities#22-permissions) on required permissions for vulnerability.
- After registration, retrieve the following credentials needed for configuration:
  - Client ID
- Client Secret
- Tenant ID


## How do I deploy this integration?

This integration supports both Elastic Agentless-based and Agent-based installations.

### Agentless-based installation

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

## Setup

1. In the top search bar in Kibana, search for **Integrations**.
2. In the search bar, type **Microsoft Defender XDR**.
3. Select the **Microsoft Defender XDR** integration from the search results.
4. Select **Add Microsoft Defender XDR** to add the integration.
5. Enable and configure only the collection methods which you will use.
   - To **Collect alerts and incidents using Microsoft Graph Security API**, you'll need to:
  - Configure **Client ID**, **Client Secret** and **Tenant ID**.
- To **Collect vulnerabilities using Microsoft Defender for Endpoint API**, you'll need to:
  - Configure **Client ID**, **Client Secret** and **Tenant ID**. Configure either **Subscription ID** or **Management Group Name** as the scope.
- To **Collect events using Azure Event Hub**, you'll need to:
  - Configure **Azure Event Hub**, **Connection String**, **Storage Account**, and **storage_account_key**.
6. Select **Save and continue** to save the integration.


### Validation


#### Dashboards populated

1. In the top search bar in Kibana, search for **Dashboards**.
2. In the search bar, type **Microsoft Defender XDR**.
3. Select a dashboard for the dataset you are collecting, and verify the dashboard information is populated.


#### Transforms healthy

1. In the top search bar in Kibana, search for **Transforms**.
2. Select the **Data / Transforms** from the search results.
3. In the search bar, type **m365_defender**.
4. All transforms from the search results should indicate **Healthy** under the **Health** column.


### Data Retention and ILM Configuration

A full sync pulls in a large volume of data, which can lead to storage issues or index overflow over time. To avoid this, we have set up an Index Lifecycle Management (ILM) policy that automatically deletes data older than 7 days. This helps keep storage usage under control.
<note>
  The user or service account associated with the integration must have the following **index privileges** on the relevant index have the following permissions `delete`, `delete_index`.
</note>


## Alert severity mapping

The values used in `event.severity` are consistent with Elastic Detection Rules.

| Severity Name          | `event.severity` |
|------------------------|------------------|
| Low (or Informational) | 21               |
| Medium                 | 47               |
| High                   | 73               |
| Critical               | 99               |


## Troubleshooting

- Expiring SAS URLs: The option `SAS Valid Hours` in `vulnerability` data stream controls the duration that the `Shared Access Signature (SAS)` download URLs are valid for. The default value of this option is `1h` i.e., 1 hour, and the maximum allowed value is `6h` i.e., 6 hours. Increase the value of the option `SAS Valid Hours` when you see `error.message` indicates signatures are invalid, or when you notice invalid signature errors inside CEL trace logs.


## Scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### log


### alert

This is the `alert` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-10-20T09:54:07.503Z",
      "agent": {
          "ephemeral_id": "f0b1ddcf-5c43-49cb-be37-acefdf4372d0",
          "id": "d6e963cc-04ee-46b8-af02-520891431883",
          "name": "elastic-agent-85133",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "cloud": {
          "account": {
              "id": "3adb963c-8e61-48e8-a06d-6dbb0dacea39"
          }
      },
      "data_stream": {
          "dataset": "m365_defender.alert",
          "namespace": "57227",
          "type": "logs"
      },
      "device": {
          "id": [
              "f18bd540-d5e4-46e0-8ddd-3d03a59e4e14"
          ]
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "d6e963cc-04ee-46b8-af02-520891431883",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "host"
          ],
          "created": "2023-10-20T09:53:09.883Z",
          "dataset": "m365_defender.alert",
          "duration": 2478000000,
          "end": "2023-10-20T09:51:41.993Z",
          "id": "daefa1828b-dd4e-405c-8a3b-aa28596830dd_1",
          "ingested": "2026-01-05T12:04:28Z",
          "kind": "alert",
          "original": "{\"actorDisplayName\":null,\"additionalData\":null,\"alertPolicyId\":null,\"alertWebUrl\":\"https://security.microsoft.com/alerts/daefa1828b-dd4e-405c-8a3b-aa28596830dd_1?tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39\",\"assignedTo\":null,\"category\":\"Execution\",\"classification\":null,\"comments\":[],\"createdDateTime\":\"2023-10-20T09:53:09.8839373Z\",\"description\":\"A suspicious PowerShell activity was observed on the machine. \\nThis behavior may indicate that PowerShell was used during installation, exploration, or in some cases in lateral movement activities which are used by attackers to invoke modules, download external payloads, or get more information about the system. Attackers usually use PowerShell to bypass security protection mechanisms by executing their payload in memory without touching the disk and leaving any trace.\",\"detectionSource\":\"microsoftDefenderForEndpoint\",\"detectorId\":\"7f1c3609-a3ff-40e2-995b-c01770161d68\",\"determination\":null,\"evidence\":[{\"@odata.type\":\"#microsoft.graph.security.deviceEvidence\",\"azureAdDeviceId\":\"f18bd540-d5e4-46e0-8ddd-3d03a59e4e14\",\"createdDateTime\":\"2023-10-20T09:53:10.1933333Z\",\"defenderAvStatus\":\"notSupported\",\"detailedRoles\":[\"PrimaryDevice\"],\"deviceDnsName\":\"clw555test\",\"firstSeenDateTime\":\"2023-10-20T09:50:17.7383987Z\",\"healthStatus\":\"inactive\",\"ipInterfaces\":[\"192.168.5.65\",\"fe80::cfe4:80b:615c:38fb\",\"127.0.0.1\",\"::1\"],\"loggedOnUsers\":[{\"accountName\":\"CDPUserIS-38411\",\"domainName\":\"AzureAD\"}],\"mdeDeviceId\":\"505d70d89cfa3428f7aac7d2eb3a64c60fd3d843\",\"onboardingStatus\":\"onboarded\",\"osBuild\":22621,\"osPlatform\":\"Windows11\",\"rbacGroupId\":0,\"rbacGroupName\":null,\"remediationStatus\":\"none\",\"remediationStatusDetails\":null,\"riskScore\":\"high\",\"roles\":[],\"tags\":[],\"verdict\":\"unknown\",\"version\":\"22H2\",\"vmMetadata\":null}],\"firstActivityDateTime\":\"2023-10-20T09:51:39.5154802Z\",\"id\":\"daefa1828b-dd4e-405c-8a3b-aa28596830dd_1\",\"incidentId\":\"23\",\"incidentWebUrl\":\"https://security.microsoft.com/incidents/23?tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39\",\"lastActivityDateTime\":\"2023-10-20T09:51:41.9939003Z\",\"lastUpdateDateTime\":\"2023-10-20T09:54:07.5033333Z\",\"mitreTechniques\":[\"T1059.001\"],\"productName\":\"Microsoft Defender for Endpoint\",\"providerAlertId\":\"efa1828b-dd4e-405c-8a3b-aa28596830dd_1\",\"recommendedActions\":\"1. Examine the PowerShell command line to understand what commands were executed. Note: the content may need to be decoded if it is Base64-encoded.\\n2. Search the script for more indicators to investigate - for example IP addresses (potential C\\u0026C servers), target computers etc.\\n3. Explore the timeline of this and other related machines for additional suspect activities around the time of the alert.\\n4. Look for the process that invoked this PowerShell run and their origin. Consider submitting any suspect files in the chain for deep analysis for detailed behavior information.\",\"resolvedDateTime\":null,\"serviceSource\":\"microsoftDefenderForEndpoint\",\"severity\":\"medium\",\"status\":\"new\",\"tenantId\":\"3adb963c-8e61-48e8-a06d-6dbb0dacea39\",\"threatDisplayName\":null,\"threatFamilyName\":null,\"title\":\"Suspicious PowerShell command line\"}",
          "provider": "microsoftDefenderForEndpoint",
          "severity": 47,
          "start": "2023-10-20T09:51:39.515Z",
          "type": [
              "info"
          ],
          "url": "https://security.microsoft.com/alerts/daefa1828b-dd4e-405c-8a3b-aa28596830dd_1?tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39"
      },
      "host": {
          "hostname": [
              "clw555test"
          ],
          "id": [
              "505d70d89cfa3428f7aac7d2eb3a64c60fd3d843"
          ],
          "ip": [
              "192.168.5.65",
              "fe80::cfe4:80b:615c:38fb",
              "127.0.0.1",
              "::1"
          ],
          "os": {
              "name": [
                  "Windows11"
              ],
              "version": [
                  "22H2"
              ]
          }
      },
      "input": {
          "type": "httpjson"
      },
      "m365_defender": {
          "alert": {
              "category": "Execution",
              "created_datetime": "2023-10-20T09:53:09.883Z",
              "description": "A suspicious PowerShell activity was observed on the machine. \nThis behavior may indicate that PowerShell was used during installation, exploration, or in some cases in lateral movement activities which are used by attackers to invoke modules, download external payloads, or get more information about the system. Attackers usually use PowerShell to bypass security protection mechanisms by executing their payload in memory without touching the disk and leaving any trace.",
              "detection_source": "microsoftDefenderForEndpoint",
              "detector_id": "7f1c3609-a3ff-40e2-995b-c01770161d68",
              "evidence": [
                  {
                      "azure_ad_device_id": "f18bd540-d5e4-46e0-8ddd-3d03a59e4e14",
                      "created_datetime": "2023-10-20T09:53:10.193Z",
                      "defender_av_status": "notSupported",
                      "detailed_roles": [
                          "PrimaryDevice"
                      ],
                      "device_dns_name": "clw555test",
                      "first_seen_datetime": "2023-10-20T09:50:17.738Z",
                      "health_status": "inactive",
                      "ip_interfaces": [
                          "192.168.5.65",
                          "fe80::cfe4:80b:615c:38fb",
                          "127.0.0.1",
                          "::1"
                      ],
                      "logged_on_users": [
                          {
                              "account_name": "CDPUserIS-38411",
                              "domain_name": "AzureAD"
                          }
                      ],
                      "mde_device_id": "505d70d89cfa3428f7aac7d2eb3a64c60fd3d843",
                      "odata_type": "#microsoft.graph.security.deviceEvidence",
                      "onboarding_status": "onboarded",
                      "os_build": "22621",
                      "os_platform": "Windows11",
                      "rbac_group": {
                          "id": "0"
                      },
                      "remediation_status": "none",
                      "risk_score": "high",
                      "verdict": "unknown",
                      "version": "22H2"
                  }
              ],
              "first_activity_datetime": "2023-10-20T09:51:39.515Z",
              "id": "daefa1828b-dd4e-405c-8a3b-aa28596830dd_1",
              "incident_id": "23",
              "incident_web_url": {
                  "domain": "security.microsoft.com",
                  "original": "https://security.microsoft.com/incidents/23?tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39",
                  "path": "/incidents/23",
                  "query": "tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39",
                  "scheme": "https"
              },
              "last_activity_datetime": "2023-10-20T09:51:41.993Z",
              "last_update_datetime": "2023-10-20T09:54:07.503Z",
              "mitre_techniques": [
                  "T1059.001"
              ],
              "provider_alert_id": "efa1828b-dd4e-405c-8a3b-aa28596830dd_1",
              "recommended_actions": "1. Examine the PowerShell command line to understand what commands were executed. Note: the content may need to be decoded if it is Base64-encoded.\n2. Search the script for more indicators to investigate - for example IP addresses (potential C&C servers), target computers etc.\n3. Explore the timeline of this and other related machines for additional suspect activities around the time of the alert.\n4. Look for the process that invoked this PowerShell run and their origin. Consider submitting any suspect files in the chain for deep analysis for detailed behavior information.",
              "service_source": "microsoftDefenderForEndpoint",
              "severity": "medium",
              "status": "new",
              "tenant_id": "3adb963c-8e61-48e8-a06d-6dbb0dacea39",
              "title": "Suspicious PowerShell command line",
              "web_url": {
                  "domain": "security.microsoft.com",
                  "original": "https://security.microsoft.com/alerts/daefa1828b-dd4e-405c-8a3b-aa28596830dd_1?tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39",
                  "path": "/alerts/daefa1828b-dd4e-405c-8a3b-aa28596830dd_1",
                  "query": "tid=3adb963c-8e61-48e8-a06d-6dbb0dacea39",
                  "scheme": "https"
              }
          }
      },
      "message": "A suspicious PowerShell activity was observed on the machine. \nThis behavior may indicate that PowerShell was used during installation, exploration, or in some cases in lateral movement activities which are used by attackers to invoke modules, download external payloads, or get more information about the system. Attackers usually use PowerShell to bypass security protection mechanisms by executing their payload in memory without touching the disk and leaving any trace.",
      "related": {
          "hosts": [
              "505d70d89cfa3428f7aac7d2eb3a64c60fd3d843",
              "Windows11",
              "22H2",
              "clw555test",
              "AzureAD"
          ],
          "ip": [
              "192.168.5.65",
              "fe80::cfe4:80b:615c:38fb",
              "127.0.0.1",
              "::1"
          ],
          "user": [
              "CDPUserIS-38411"
          ]
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "m365_defender-alert"
      ],
      "threat": {
          "tactic": {
              "name": [
                  "Execution"
              ]
          },
          "technique": {
              "subtechnique": {
                  "id": [
                      "T1059.001"
                  ]
              }
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                             | Description                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |-------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                        | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | data_stream.dataset                                               | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | data_stream.namespace                                             | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.type                                                  | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | event.dataset                                                     | Event dataset.                                                                                                                                                                                                                                                                                                                                                                                          | constant_keyword |
  | event.module                                                      | Event module.                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | input.type                                                        | Type of filebeat input.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                                                        | Log offset.                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | m365_defender.alert.actor_display_name                            | The adversary or activity group that is associated with this alert.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.assigned_to                                   | Owner of the alert, or null if no owner is assigned.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.alert.category                                      | The attack kill-chain category that the alert belongs to. Aligned with the MITRE ATT&CK framework.                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.classification                                | Specifies whether the alert represents a true threat. Possible values are: unknown, falsePositive, truePositive, benignPositive, unknownFutureValue.                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.alert.comments                                      | Array of comments created by the Security Operations (SecOps) team during the alert management process.                                                                                                                                                                                                                                                                                                 | flattened        |
  | m365_defender.alert.created_datetime                              | Time when Microsoft 365 Defender created the alert.                                                                                                                                                                                                                                                                                                                                                     | date             |
  | m365_defender.alert.description                                   | String value describing each alert.                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.detection_source                              | Detection technology or sensor that identified the notable component or activity.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.alert.detector_id                                   | The ID of the detector that triggered the alert.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.determination                                 | Specifies the result of the investigation, whether the alert represents a true attack and if so, the nature of the attack. Possible values are: unknown, apt, malware, securityPersonnel, securityTesting, unwantedSoftware, other, multiStagedAttack, compromisedUser, phishing, maliciousUserActivity, clean, insufficientData, confirmedUserActivity, lineOfBusinessApplication, unknownFutureValue. | keyword          |
  | m365_defender.alert.evidence.antispam_direction                   | Direction of the email relative to your network. The possible values are: Inbound, Outbound or Intraorg.                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.alert.evidence.app_id                               | Unique identifier of the application.                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.attachments_count                    | Number of attachments in the email.                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | m365_defender.alert.evidence.azure_ad_device_id                   | A unique identifier assigned to a device by Azure Active Directory (Azure AD) when device is Azure AD-joined.                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.cluster_by                           | The clustering logic of the emails inside the cluster.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.cluster_by_value                     | The value utilized to cluster the similar emails.                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.alert.evidence.created_datetime                     | The time the evidence was created and added to the alert.                                                                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.alert.evidence.defender_av_status                   | State of the Defender AntiMalware engine. The possible values are: notReporting, disabled, notUpdated, updated, unknown, notSupported, unknownFutureValue.                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.delivery_action                      | Delivery action of the email. The possible values are: Delivered, DeliveredAsSpam, Junked, Blocked, or Replaced.                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.evidence.delivery_location                    | Location where the email was delivered. The possible values are: Inbox, External, JunkFolder, Quarantine, Failed, Dropped, DeletedFolder or Forwarded.                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.detailed_roles                       | Detailed roles of the user associated with the event.                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.detection_status                     | The status of the detection.The possible values are: detected, blocked, prevented, unknownFutureValue.                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.device_dns_name                      | The fully qualified domain name (FQDN) for the device.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.display_name                         | Name of the application.                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.alert.evidence.email_count                          | Count of emails in the email cluster.                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.alert.evidence.file_details.issuer                  | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.evidence.file_details.name                    | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.file_details.odata_type              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.file_details.path                    | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.file_details.publisher               | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.file_details.sha1                    | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.evidence.file_details.sha256                  | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.file_details.signer                  | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.file_details.size                    | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.alert.evidence.first_seen_datetime                  | The date and time when the device was first seen.                                                                                                                                                                                                                                                                                                                                                       | date             |
  | m365_defender.alert.evidence.health_status                        | The health state of the device.The possible values are: active, inactive, impairedCommunication, noSensorData, noSensorDataImpairedCommunication, unknown, unknownFutureValue.                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.image_file.issuer                    | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.evidence.image_file.name                      | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.image_file.odata_type                |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.image_file.path                      | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.image_file.publisher                 | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.image_file.sha1                      | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.evidence.image_file.sha256                    | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.image_file.signer                    | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.image_file.size                      | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.alert.evidence.instance_id                          | Identifier of the instance of the Software as a Service (SaaS) application.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.evidence.instance_name                        | Name of the instance of the SaaS application.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.internet_message_id                  | Public-facing identifier for the email that is set by the sending email system.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.ip_address                           | The value of the IP Address, can be either in V4 address or V6 address format.                                                                                                                                                                                                                                                                                                                          | ip               |
  | m365_defender.alert.evidence.ip_interfaces                        | IP Interfaces related to the event.                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | m365_defender.alert.evidence.language                             | Detected language of the email content.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.alert.evidence.logged_on_users.account_name         | User account name of the logged-on user.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.alert.evidence.logged_on_users.domain_name          | User account domain of the logged-on user.                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.logged_on_users.odata_type           |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.mde_device_id                        | A unique identifier assigned to a device by Microsoft Defender for Endpoint.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.network_message_id                   | Unique identifier for the email, generated by Microsoft 365.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.network_message_ids                  | Unique identifiers for the emails in the cluster, generated by Microsoft 365.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.object_id                            | The unique identifier of the application object in Azure AD.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.odata_type                           |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.onboarding_status                    | The status of the machine onboarding to Microsoft Defender for Endpoint.The possible values are: insufficientInfo, onboarded, canBeOnboarded, unsupported, unknownFutureValue.                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.os_build                             | The build version for the operating system the device is running.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.alert.evidence.os_platform                          | The operating system platform the device is running.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.alert.evidence.p1_sender.display_name               | The name of the sender.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.alert.evidence.p1_sender.domain_name                | Sender domain.                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.p1_sender.email_address              | Sender email address.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.p1_sender.odata_type                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.p2_sender.display_name               | The name of the sender.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.alert.evidence.p2_sender.domain_name                | Sender domain.                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.p2_sender.email_address              | Sender email address.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.p2_sender.odata_type                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.parent_process.creation_datetime     | Date and time when the parent of the process was created.                                                                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.alert.evidence.parent_process.id                    | Process ID (PID) of the parent process that spawned the process.                                                                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.alert.evidence.parent_process.image_file.issuer     | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.name       | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.odata_type |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.path       | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.publisher  | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.sha1       | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.sha256     | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.signer     | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.alert.evidence.parent_process.image_file.size       | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.alert.evidence.primary_address                      | The primary email address of the mailbox.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.alert.evidence.process.command_line                 | Command line used to create the new process.                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.process.creation_datetime            | Date and time the process was created.                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | m365_defender.alert.evidence.process.id                           | Process ID (PID) of the newly created process.                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.alert.evidence.publisher                            | The name of the application publisher.                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.query                                | The query used to identify the email cluster.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.rbac_group.id                        | The ID of the role-based access control (RBAC) device group.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.rbac_group.name                      | The name of the RBAC device group.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.received_datetime                    | Date and time when the email was received.                                                                                                                                                                                                                                                                                                                                                              | date             |
  | m365_defender.alert.evidence.recipient_email_address              | Email address of the recipient, or email address of the recipient after distribution list expansion.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.alert.evidence.registry_hive                        | Registry hive of the key that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.alert.evidence.registry_key                         | Registry key that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.registry_value                       | Data of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.evidence.registry_value_name                  | Name of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.evidence.registry_value_type                  | Data type, such as binary or string, of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.evidence.remediation_status                   | Status of the remediation action taken. The possible values are: none, remediated, prevented, blocked, notFound, active, pendingApproval, declined, notRemediated, running, unknownFutureValue.                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.remediation_status_details           | Details about the remediation status.                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.risk_score                           | Risk score as evaluated by Microsoft Defender for Endpoint. The possible values are: none, informational, low, medium, high, unknownFutureValue.                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.alert.evidence.roles                                | The role/s that an evidence entity represents in an alert, e.g., an IP address that is associated with an attacker will have the evidence role "Attacker".                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.alert.evidence.saas_app_id                          | The identifier of the SaaS application.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.alert.evidence.security_group_id                    | Unique identifier of the security group.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.alert.evidence.sender_ip                            | IP address of the last detected mail server that relayed the message.                                                                                                                                                                                                                                                                                                                                   | ip               |
  | m365_defender.alert.evidence.subject                              | Subject of the email.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.alert.evidence.tags                                 | Array of custom tags associated with an evidence instance, for example to denote a group of devices, high value assets, etc.                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.threat_detection_methods             | Collection of methods used to detect malware, phishing, or other threats found in the email.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.threats                              | Collection of detection names for malware or other threats found.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.alert.evidence.type                                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.url                                  | The Unique Resource Locator (URL).                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.url_count                            | Number of embedded URLs in the email.                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.alert.evidence.urls                                 | Collection of the URLs contained in this email.                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.urn                                  | Uniform resource name (URN) of the automated investigation where the cluster was identified.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.user_account.account_name            | The user account's displayed name.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.user_account.azure_ad_user_id        | The user object identifier in Azure AD.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.alert.evidence.user_account.domain_name             | The name of the Active Directory domain of which the user is a member.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.evidence.user_account.odata_type              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.user_account.user_principal_name     | The user principal name of the account in Azure AD.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.evidence.user_account.user_sid                | The local security identifier of the user account.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.evidence.verdict                              | The decision reached by automated investigation. The possible values are: unknown, suspicious, malicious, noThreatsFound, unknownFutureValue.                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.version                              | The version of the operating system platform.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.alert.evidence.vm_metadata.cloud_provider           | The cloud provider hosting the virtual machine. The possible values are: unknown, azure, unknownFutureValue.                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.evidence.vm_metadata.odata_type               |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.evidence.vm_metadata.resource_id              | Unique identifier of the Azure resource.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.alert.evidence.vm_metadata.subscription_id          | Unique identifier of the Azure subscription the customer tenant belongs to.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.evidence.vm_metadata.vm_id                    | Unique identifier of the virtual machine instance.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.first_activity_datetime                       | The earliest activity associated with the alert.                                                                                                                                                                                                                                                                                                                                                        | date             |
  | m365_defender.alert.id                                            | Unique identifier to represent the alert resource.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.incident_id                                   | Unique identifier to represent the incident this alert resource is associated with.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.alert.incident_web_url.domain                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.extension                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.fragment                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.full                         |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.original                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.password                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.path                         |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.port                         |                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.alert.incident_web_url.query                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.scheme                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.incident_web_url.username                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.last_activity_datetime                        | The oldest activity associated with the alert.                                                                                                                                                                                                                                                                                                                                                          | date             |
  | m365_defender.alert.last_update_datetime                          | Time when the alert was last updated at Microsoft 365 Defender.                                                                                                                                                                                                                                                                                                                                         | date             |
  | m365_defender.alert.mitre_techniques                              | The attack techniques, as aligned with the MITRE ATT&CK framework.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.alert.odata_type                                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.provider_alert_id                             | The ID of the alert as it appears in the security provider product that generated the alert.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.recommended_actions                           | Recommended response and remediation actions to take in the event this alert was generated.                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.resolved_datetime                             | Time when the alert was resolved.                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | m365_defender.alert.service_source                                | The service or product that created this alert. Possible values are: microsoftDefenderForEndpoint, microsoftDefenderForIdentity, microsoftCloudAppSecurity, microsoftDefenderForOffice365, microsoft365Defender, aadIdentityProtection, appGovernance, dataLossPrevention.                                                                                                                              | keyword          |
  | m365_defender.alert.severity                                      | Indicates the possible impact on assets. The higher the severity the bigger the impact. Typically higher severity items require the most immediate attention. Possible values are: unknown, informational, low, medium, high, unknownFutureValue.                                                                                                                                                       | keyword          |
  | m365_defender.alert.status                                        | The status of the alert. Possible values are: new, inProgress, resolved, unknownFutureValue.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.alert.tenant_id                                     | The Azure Active Directory tenant the alert was created in.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.alert.threat_display_name                           | The threat associated with this alert.                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.alert.threat_family_name                            | Threat family associated with this alert.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.alert.title                                         | Brief identifying string value describing the alert.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.alert.web_url.domain                                |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.extension                             |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.fragment                              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.full                                  |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.original                              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.password                              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.path                                  |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.port                                  |                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.alert.web_url.query                                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.scheme                                |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.alert.web_url.username                              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
</dropdown>


### event

This is the `event` dataset.

#### Example

<dropdown title="Exported fields">
  | Field                                                                  | Description                                                                                                                                                                                                                                                                                                                                                                       | Type             |
  |------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                             | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | Target.process.command_line                                            | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.                                                                                                                                                                                                    | wildcard         |
  | Target.process.command_line.text                                       | Multi-field of `Target.process.command_line`.                                                                                                                                                                                                                                                                                                                                     | text             |
  | Target.process.executable                                              | Absolute path to the process executable.                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | Target.process.executable.text                                         | Multi-field of `Target.process.executable`.                                                                                                                                                                                                                                                                                                                                       | text             |
  | Target.process.name                                                    | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | Target.process.name.text                                               | Multi-field of `Target.process.name`.                                                                                                                                                                                                                                                                                                                                             | text             |
  | application.name                                                       | Name of the application.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | cloud.image.id                                                         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.instance.id                                                      | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset                                                    | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | data_stream.namespace                                                  | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.type                                                       | Data stream type.                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | dll.Ext.size                                                           | Size of the dll executable.                                                                                                                                                                                                                                                                                                                                                       | long             |
  | event.dataset                                                          | Event dataset.                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | event.module                                                           | Event module.                                                                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | host.containerized                                                     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                       | boolean          |
  | host.os.build                                                          | OS build information.                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.codename                                                       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                                                             | Input type                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | log.offset                                                             | Log offset                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.event.aad_device_id                                      | Unique identifier for the device in Azure AD.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.account.address                                    | The address of the account user.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.account.assigned_roles                             | The Microsoft Entra roles assigned to the account.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.account.blast_radius                               | The potential impact of the user account in the org.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.account.city                                       | City where the account user is located.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.account.cloud_sid                                  | The Microsoft Entra security identifer for the account.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.account.company_name                               | The company to which the account belongs.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.account.country                                    | Country/Region where the account user is located.                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.account.created                                    | Date and time when the account user was created.                                                                                                                                                                                                                                                                                                                                  | date             |
  | m365_defender.event.account.criticality_level                          | The criticality level assigned to an asset in M365 Defender XDR Exposure Management. Accepted values are Low (3) to Very High (0).                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.account.deleted_date_time                          | The date and time the user was deleted.                                                                                                                                                                                                                                                                                                                                           | date             |
  | m365_defender.event.account.department                                 | Name of the department that the account user belongs to.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.account.display_name                               | Name of the account user displayed in the address book. Typically a combination of a given or first name, a middle initiation, and a last name or surname.                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.account.distinguished_name                         | The user's distinguished name.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.account.domain                                     | Domain of the account.                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.account.email_address                              | SMTP address of the account.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.account.employee_id                                | Employee ID number of the account user.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.account.given_name                                 | Given name or first name of the account user.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.account.id                                         | An identifier for the account as found by Microsoft Defender for Cloud Apps. Could be Azure Active Directory ID, user principal name, or other identifiers.                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.account.is_enabled                                 | Indicates whether the account is enabled or not.                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | m365_defender.event.account.job_title                                  | Job title of the account user.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.account.manager                                    | The listed manager of the account user.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.account.name                                       | User name of the account.                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.account.object_id                                  | Unique identifier for the account in Azure Active Directory.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.account.on_prem_sid                                | On-premises security identifier (SID) of the account.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.account.other_mail_addresses                       | The additional email addresses of the user.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.account.phone                                      | The listed phone number of the account user.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.account.risk_level                                 | Level of the detected risk. Possible values are low, medium, high, hidden, none, and unknownFutureValue.                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.account.risk_level_details                         | Details of the detected risk.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.account.sid                                        | Security Identifier (SID) of the account.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.account.sip_proxy_address                          | Voice over IP (VOIP) session initiation protocol (SIP) address of the account.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.account.state                                      | The geographical state of the user account.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.account.surname                                    | Surname, family name, or last name of the account user.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.account.tags                                       | Tags assigned to the account user by Defender for Identity.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.account.type                                       | Type of user account, indicating its general role and access levels, such as Regular, System, Admin, DcAdmin, System, Application.                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.account.upn                                        | User principal name (UPN) of the account.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.action.result                                      | Result of the action.                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.action.trigger                                     | Indicates whether an action was triggered by an administrator (manually or through approval of a pending automated action), or by some special mechanism, such as a ZAP or Dynamic Delivery.                                                                                                                                                                                      | keyword          |
  | m365_defender.event.action.type                                        | Type of activity that triggered the event. See the [in-portal schema reference](https://learn.microsoft.com/en-us/microsoft-365/security/defender/advanced-hunting-schema-tables?view=o365-worldwide#get-schema-information-in-the-security-center) for details.                                                                                                                  | keyword          |
  | m365_defender.event.action.value                                       | Action taken on the entity.                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.active_users                                       | An array of all users that are logged on the machine at the time of the event.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.activity.objects                                   | List of objects, such as files or folders, that were involved in the recorded activity.                                                                                                                                                                                                                                                                                           | flattened        |
  | m365_defender.event.activity.type                                      | Type of activity that triggered the event.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.additional_fields                                  | Additional information about the entity or event in JSON array format.                                                                                                                                                                                                                                                                                                            | flattened        |
  | m365_defender.event.alert.categories                                   |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.alert.category                                     | Type of threat indicator or breach activity identified by the alert.                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.alert.id                                           | Unique identifier for the alert.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.app_guard_container_id                             | Identifier for the virtualized container used by Application Guard to isolate browser activity.                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.app_instance_id                                    |                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.event.application                                        | Application that performed the recorded action.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.application_id                                     | Unique identifier for the application.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.asset_value                                        | Indicates the value of a device as assigned by the user.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.attachment_count                                   | Number of attachments in the email.                                                                                                                                                                                                                                                                                                                                               | long             |
  | m365_defender.event.attack_techniques                                  | MITRE ATT&CK techniques associated with the activity that triggered the alert.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.authentication_details                             | List of pass or fail verdicts by email authentication protocols like DMARC, DKIM, SPF or a combination of multiple authentication types (CompAuth).                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.bulk_complaint_level                               | Threshold assigned to email from bulk mailers, a high bulk complaint level (BCL) means the email is more likely to generate complaints, and thus more likely to be spam.                                                                                                                                                                                                          | long             |
  | m365_defender.event.category                                           | The Advanced Hunting table name with 'AdvancedHunting-' prefix.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.certificate.countersignature_time                  | Date and time the certificate was countersigned.                                                                                                                                                                                                                                                                                                                                  | date             |
  | m365_defender.event.certificate.creation_time                          | Date and time the certificate was created.                                                                                                                                                                                                                                                                                                                                        | date             |
  | m365_defender.event.certificate.expiration_time                        | Date and time the certificate is set to expire.                                                                                                                                                                                                                                                                                                                                   | date             |
  | m365_defender.event.certificate.serial_number                          | Identifier for the certificate that is unique to the issuing certificate authority (CA).                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.change_source                                      | Identifies which identity provider or process triggered the addition of the new row. For example, the System-UserPersistence value is used for any rows added by an automated process.                                                                                                                                                                                            | keyword          |
  | m365_defender.event.city                                               | City where the client IP address is geolocated.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.client_version                                     | Version of the endpoint agent or sensor running on the machine.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.confidence_level                                   | List of confidence levels of any spam or phishing verdicts. For spam, this column shows the spam confidence level (SCL), indicating if the email was skipped (-1), found to be not spam (0,1), found to be spam with moderate confidence (5,6), or found to be spam with high confidence (9). For phishing, this column displays whether the confidence level is "High" or "Low". | flattened        |
  | m365_defender.event.connected_networks                                 | Networks that the adapter is connected to. Each JSON array contains the network name, category (public, private or domain), a description, and a flag indicating if it's connected publicly to the internet.                                                                                                                                                                      | flattened        |
  | m365_defender.event.connectors                                         | Custom instructions that define organizational mail flow and how the email was routed.                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.country_code                                       | Two-letter code indicating the country where the client IP address is geolocated.                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.crl_distribution_point_urls                        | JSON array listing the URLs of network shares that contain certificates and certificate revocation lists (CRLs).                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.default_gateways                                   | Default gateway addresses in JSON array format.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.delivery.action                                    | Delivery action of the email: Delivered, Junked, Blocked, or Replaced.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.delivery.location                                  | Location where the email was delivered: Inbox/Folder, On-premises/External, Junk, Quarantine, Failed, Dropped, Deleted items.                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.destination.device_name                            | Name of the device running the server application that processed the recorded action.                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.destination.ip_address                             | IP address of the device running the server application that processed the recorded action.                                                                                                                                                                                                                                                                                       | ip               |
  | m365_defender.event.destination.port                                   | Destination port of related network communications or activity.                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.event.detection.methods                                  | Methods used to detect malware, phishing, or other threats found in the email or at the time of click.                                                                                                                                                                                                                                                                            | flattened        |
  | m365_defender.event.detection.source                                   | Detection technology or sensor that identified the notable component or activity.                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.device.category                                    | Broader classification that groups certain device types under the following categories: Endpoint, Network device, IoT, Unknown.                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.device.id                                          | Unique identifier for the device or machine in the service.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.device.name                                        | Fully qualified domain name (FQDN) of the device, machine or endpoint.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.device.sub_type                                    | Additional modifier for certain types of devices, for example, a mobile device can be a tablet or a smartphone; only available if device discovery finds enough information about this attribute.                                                                                                                                                                                 | keyword          |
  | m365_defender.event.device.type                                        | Type of device based on purpose and functionality, such as network device, workstation, server, mobile, gaming console, or printer.                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.device_dynamic_tags                                | Device tags assigned automatically using dynamic tagging rules.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.device_manual_tags                                 | Device tags created manually using the portal UI or public API.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.dns.answers                                        | The answers returned by the server from DNS query.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.dns.header_flags                                   | Array of 2 letter DNS header flags.                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.dns.qclass_name                                    | The DNS class of records being queried.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.dns.qtype_name                                     | The type of DNS record being queried.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.dns.query                                          | The DNS query.                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.dns.rcode_name                                     | The DNS response code.                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.dns.ttls                                           | The time interval in seconds that this resource record may be cached before it should be discarded.                                                                                                                                                                                                                                                                               | double           |
  | m365_defender.event.dns_addresses                                      | DNS server addresses in JSON array format.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.email.action                                       | Final action taken on the email based on filter verdict, policies, and user actions: Move message to junk mail folder, Add X-header, Modify subject, Redirect message, Delete message, send to quarantine, No action taken, Bcc message.                                                                                                                                          | keyword          |
  | m365_defender.event.email.action_policy                                | Action policy that took effect: Antispam high-confidence, Antispam, Antispam bulk mail, Antispam phishing, Anti-phishing domain impersonation, Anti-phishing user impersonation, Anti-phishing spoof, Anti-phishing graph impersonation, Antimalware, Safe Attachments, Enterprise Transport Rules (ETR).                                                                         | keyword          |
  | m365_defender.event.email.action_policy_guid                           | Unique identifier for the policy that determined the final mail action.                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.email.cluster_id                                   | Identifier for the group of similar emails clustered based on heuristic analysis of their contents.                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.email.direction                                    | Direction of the email relative to your network: Inbound, Outbound, Intra-org.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.email.language                                     | Detected language of the email content.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.email.subject                                      | Subject of the email.                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.entity_type                                        | Type of object, such as a file, a process, a device, or a user.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.evidence.direction                                 | Indicates whether the entity is the source or the destination of a network connection.                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.evidence.role                                      | How the entity is involved in an alert, indicating whether it is impacted or is merely related.                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.exclusion_reason                                   | Indicates the reason for device exclusion.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.exposure_level                                     | Indicates the exposure level of a device.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.failure_reason                                     | Information explaining why the recorded action failed.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.file.name                                          | Name of the file that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.file.origin_ip                                     | IP address where the file was downloaded from.                                                                                                                                                                                                                                                                                                                                    | ip               |
  | m365_defender.event.file.origin_referrer_url                           | URL of the web page that links to the downloaded file.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.file.origin_url                                    | URL where the file was downloaded from.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.file.size                                          | Size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.event.file.type                                          | File extension type.                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.folder_path                                        | Folder containing the file that the recorded action was applied to.                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.initiating_process.account_domain                  | Domain of the account that ran the process responsible for the event.                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.initiating_process.account_name                    | User name of the account that ran the process responsible for the event.                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.initiating_process.account_object_id               | Azure AD object ID of the user account that ran the process responsible for the event.                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.initiating_process.account_sid                     | Security Identifier (SID) of the account that ran the process responsible for the event.                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.initiating_process.account_upn                     | User principal name (UPN) of the account that ran the process responsible for the event.                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.initiating_process.command_line                    | Command line used to run the process that initiated the event.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.initiating_process.creation_time                   | Date and time when the process that initiated the event was started.                                                                                                                                                                                                                                                                                                              | date             |
  | m365_defender.event.initiating_process.file_name                       | Name of the process that initiated the event.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.initiating_process.file_size                       | Size of the file that ran the process responsible for the event.                                                                                                                                                                                                                                                                                                                  | long             |
  | m365_defender.event.initiating_process.folder_path                     | Folder containing the process (image file) that initiated the event.                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.initiating_process.id                              | Process ID (PID) of the process that initiated the event.                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.event.initiating_process.integrity_level                 | Integrity level of the process that initiated the event. Windows assigns integrity levels to processes based on certain characteristics, such as if they were launched from an internet download. These integrity levels influence permissions to resources.                                                                                                                      | keyword          |
  | m365_defender.event.initiating_process.logon_id                        | Identifier for a logon session of the process that initiated the event. This identifier is unique on the same machine only between restarts.                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.initiating_process.md5                             | MD5 hash of the process (image file) that initiated the event.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.initiating_process.parent_creation_time            | Date and time when the parent of the process responsible for the event was started.                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.event.initiating_process.parent_file_name                | Name of the parent process that spawned the process responsible for the event.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.initiating_process.parent_id                       | Process ID (PID) of the parent process that spawned the process responsible for the event.                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.event.initiating_process.sha1                            | SHA-1 of the process (image file) that initiated the event.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.initiating_process.sha256                          | SHA-256 of the process (image file) that initiated the event. This field is usually not populated—use the SHA1 column when available.                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.initiating_process.signature_status                | Information about the signature status of the process (image file) that initiated the event.                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.initiating_process.signer_type                     | Type of file signer of the process (image file) that initiated the event.                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.initiating_process.token_elevation                 | Token type indicating the presence or absence of User Access Control (UAC) privilege elevation applied to the process that initiated the event.                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.initiating_process.version_info_company_name       | Company name from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.initiating_process.version_info_file_description   | Description from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.initiating_process.version_info_internal_file_name | Internal file name from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.initiating_process.version_info_original_file_name | Original file name from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.initiating_process.version_info_product_name       | Product name from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.initiating_process.version_info_product_version    | Product version from the version information of the process (image file) responsible for the event.                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.internet_message_id                                | Public-facing identifier for the email that is set by the sending email system.                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.ip_address                                         | Public IP address of the device from which the user clicked on the link or IP address assigned to the endpoint and used during related network communications.                                                                                                                                                                                                                    | ip               |
  | m365_defender.event.ip_addresses                                       | JSON array containing all the IP addresses assigned to the adapter, along with their respective subnet prefix and IP address space, such as public, private, or link-local.                                                                                                                                                                                                       | flattened        |
  | m365_defender.event.ip_category                                        | Additional information about the IP address.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.ip_tags                                            | Customer-defined information applied to specific IP addresses and IP address ranges.                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.ipv4_dhcp                                          | IPv4 address of DHCP server.                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | m365_defender.event.ipv6_dhcp                                          | IPv6 address of DHCP server.                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | m365_defender.event.is_admin_operation                                 | Indicates whether the activity was performed by an administrator.                                                                                                                                                                                                                                                                                                                 | boolean          |
  | m365_defender.event.is_anonymous_proxy                                 | Indicates whether the IP address belongs to a known anonymous proxy.                                                                                                                                                                                                                                                                                                              | boolean          |
  | m365_defender.event.is_azure_ad_joined                                 | Boolean indicator of whether machine is joined to the Azure Active Directory.                                                                                                                                                                                                                                                                                                     | boolean          |
  | m365_defender.event.is_azure_info_protection_applied                   | Indicates whether the file is encrypted by Azure Information Protection.                                                                                                                                                                                                                                                                                                          | boolean          |
  | m365_defender.event.is_clicked_through                                 | Indicates whether the user was able to click through to the original URL or was not allowed.                                                                                                                                                                                                                                                                                      | boolean          |
  | m365_defender.event.is_excluded                                        | Determines if the device is currently excluded from Microsoft Defender for Vulnerability Management experiences.                                                                                                                                                                                                                                                                  | boolean          |
  | m365_defender.event.is_external_user                                   | Indicates whether a user inside the network doesn't belong to the organization's domain.                                                                                                                                                                                                                                                                                          | boolean          |
  | m365_defender.event.is_impersonated                                    | Indicates whether the activity was performed by one user for another (impersonated) user.                                                                                                                                                                                                                                                                                         | boolean          |
  | m365_defender.event.is_internet_facing                                 | Indicates whether the device is internet-facing.                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | m365_defender.event.is_local_admin                                     | Boolean indicator of whether the user is a local administrator on the machine.                                                                                                                                                                                                                                                                                                    | boolean          |
  | m365_defender.event.is_root_signer_microsoft                           | Indicates whether the signer of the root certificate is Microsoft and if the file is included in Windows operating system.                                                                                                                                                                                                                                                        | boolean          |
  | m365_defender.event.is_signed                                          | Indicates whether the file is signed.                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | m365_defender.event.is_trusted                                         | Indicates whether the file is trusted based on the results of the WinVerifyTrust function, which checks for unknown root certificate information, invalid signatures, revoked certificates, and other questionable attributes.                                                                                                                                                    | boolean          |
  | m365_defender.event.isp                                                | Internet service provider (ISP) associated with the endpoint IP address.                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.issuer                                             | Information about the issuing certificate authority (CA).                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.issuer_hash                                        | Unique hash value identifying issuing certificate authority (CA).                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.join_type                                          |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.local.ip                                           | IP address assigned to the local device or machine used during communication.                                                                                                                                                                                                                                                                                                     | ip               |
  | m365_defender.event.local.ip_type                                      | Type of IP address, for example Public, Private, Reserved, Loopback, Teredo, FourToSixMapping, and Broadcast.                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.local.port                                         | TCP port on the local machine used during communication.                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.event.location                                           | City, country, or other geographic location associated with the event.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.logon.id                                           | Identifier for a logon session. This identifier is unique on the same machine only between restarts.                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.logon.type                                         | Type of logon session, specifically: Interactive, Remote interactive (RDP) logons, Network, Batch, Service.                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.mac_address                                        | MAC address of the network adapter.                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.machine_group                                      | Machine group of the machine. This group is used by role-based access control to determine access to the machine.                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.md5                                                | MD5 hash of the file that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.merged_device_ids                                  | Previous device IDs that have been assigned to the same device.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.merged_to_device_id                                | The most recent device ID assigned to a device.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.model                                              | Model name or number of the product from the vendor or manufacturer, only available if device discovery finds enough information about this attribute.                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.network.adapter_name                               | Name of the network adapter.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.network.adapter_status                             | Operational status of the network adapter. For the possible values, refer to this enumeration.                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.network.adapter_type                               | Network adapter type. For the possible values, refer to this enumeration.                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.network.adapter_vendor                             |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.network.message_id                                 | Unique identifier for the email, generated by Microsoft 365.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.network_direction                                  | The network direction used in DeviceNetworkEvents.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.oauth_application_id                               |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.object.id                                          | Unique identifier of the object that the recorded action was applied to.                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.object.name                                        | Name of the object that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.object.type                                        | Type of object, such as a file or a folder, that the recorded action was applied to.                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.onboarding_status                                  | Indicates whether the device is currently onboarded or not to Microsoft Defender for Endpoint or if the device is not supported.                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.operation_name                                     |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.org_level.action                                   | Action taken on the email in response to matches to a policy defined at the organizational level.                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.org_level.policy                                   | Organizational policy that triggered the action taken on the email.                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.os.architecture                                    | Architecture of the operating system running on the machine.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.os.build                                           | Build version of the operating system running on the machine.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.os.distribution                                    | Distribution of the OS platform, such as Ubuntu or RedHat for Linux platforms.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.os.platform                                        | Platform of the operating system running on the machine. This indicates specific operating systems, including variations within the same family, such as Windows 11, Windows 10 and Windows 7.                                                                                                                                                                                    | keyword          |
  | m365_defender.event.os.version                                         | Version of the operating system running on the machine.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.os.version_info                                    | Additional information about the OS version, such as the popular name, code name, or version number.                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.port                                               | TCP port used during communication.                                                                                                                                                                                                                                                                                                                                               | long             |
  | m365_defender.event.previous.file_name                                 | Original name of the file that was renamed as a result of the action.                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.previous.folder_path                               | Original folder containing the file before the recorded action was applied.                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.previous.registry_key                              | Original registry key of the registry value before it was modified.                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.previous.registry_value_data                       | Original data of the registry value before it was modified.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.previous.registry_value_name                       | Original name of the registry value before it was modified.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.process.command_line                               | Command line used to create the new process.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.process.creation_time                              | Date and time the process was created.                                                                                                                                                                                                                                                                                                                                            | date             |
  | m365_defender.event.process.id                                         | Process ID (PID) of the newly created process.                                                                                                                                                                                                                                                                                                                                    | long             |
  | m365_defender.event.process.integrity_level                            | Integrity level of the newly created process. Windows assigns integrity levels to processes based on certain characteristics, such as if they were launched from an internet downloaded. These integrity levels influence permissions to resources.                                                                                                                               | keyword          |
  | m365_defender.event.process.token_elevation                            | Token type indicating the presence or absence of User Access Control (UAC) privilege elevation applied to the newly created process.                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.process.version_info_company_name                  | Company name from the version information of the newly created process.                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.process.version_info_file_description              | Description from the version information of the newly created process.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.process.version_info_internal_file_name            | Internal file name from the version information of the newly created process.                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.process.version_info_original_file_name            | Original file name from the version information of the newly created process.                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.process.version_info_product_name                  | Product name from the version information of the newly created process.                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.process.version_info_product_version               | Product version from the version information of the newly created process.                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.protocol                                           | Protocol used during the communication.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.public_ip.geo.city_name                            |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.geo.continent_name                       |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.geo.country_iso_code                     |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.geo.country_name                         |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.geo.location                             |                                                                                                                                                                                                                                                                                                                                                                                   | geo_point        |
  | m365_defender.event.public_ip.geo.region_iso_code                      |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.geo.region_name                          |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.public_ip.value                                    | Public IP address used by the onboarded machine to connect to the Microsoft Defender for Endpoint service. This could be the IP address of the machine itself, a NAT device, or a proxy.                                                                                                                                                                                          | ip               |
  | m365_defender.event.query.target                                       | Name of user, group, device, domain, or any other entity type being queried.                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.query.type                                         | Type of query, such as QueryGroup, QueryUser, or EnumerateUsers.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.query.value                                        | String used to run the query.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.raw_event_data                                     | Raw event information from the source application or service in JSON format.                                                                                                                                                                                                                                                                                                      | flattened        |
  | m365_defender.event.recipient.email_address                            | Email address of the recipient, or email address of the recipient after distribution list expansion.                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.recipient.object_id                                | Unique identifier for the email recipient in Azure AD.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.registry.device_tag                                | Machine tag added through the registry.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.registry.key                                       | Registry key that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.registry.value_data                                | Data of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.registry.value_name                                | Name of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.registry.value_type                                | Data type, such as binary or string, of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.remote.device_name                                 | Name of the machine that performed a remote operation on the affected machine. Depending on the event being reported, this name could be a fully-qualified domain name (FQDN), a NetBIOS name, or a host name without domain information.                                                                                                                                         | keyword          |
  | m365_defender.event.remote.ip                                          | IP address that was being connected to.                                                                                                                                                                                                                                                                                                                                           | ip               |
  | m365_defender.event.remote.ip_type                                     | Type of IP address, for example Public, Private, Reserved, Loopback, Teredo, FourToSixMapping, and Broadcast.                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.remote.port                                        | TCP port on the remote device that was being connected to.                                                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.event.remote.url                                         | URL or fully qualified domain name (FQDN) that was being connected to.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.event.report_id                                          | Event identifier based on a repeating counter. To identify unique events, this column must be used in conjunction with the DeviceName and Timestamp columns.                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.request.account_domain                             | Domain of the account used to remotely initiate the activity.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.request.account_name                               | User name of account used to remotely initiate the activity.                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.request.account_sid                                | Security Identifier (SID) of the account used to remotely initiate the activity.                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.event.request.protocol                                   | Network protocol, if applicable, used to initiate the activity: Unknown, Local, SMB, or NFS.                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.request.source_ip                                  | IPv4 or IPv6 address of the remote device that initiated the activity.                                                                                                                                                                                                                                                                                                            | ip               |
  | m365_defender.event.request.source_port                                | Source port on the remote device that initiated the activity.                                                                                                                                                                                                                                                                                                                     | long             |
  | m365_defender.event.sender.display_name                                | Name of the sender displayed in the address book, typically a combination of a given or first name, a middle initial, and a last name or surname.                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.sender.from_address                                | Sender email address in the FROM header, which is visible to email recipients on their email clients.                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.sender.from_domain                                 | Sender domain in the FROM header, which is visible to email recipients on their email clients.                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.sender.ipv4                                        | IPv4 address of the last detected mail server that relayed the message.                                                                                                                                                                                                                                                                                                           | ip               |
  | m365_defender.event.sender.ipv6                                        | IPv6 address of the last detected mail server that relayed the message.                                                                                                                                                                                                                                                                                                           | ip               |
  | m365_defender.event.sender.mail_from_address                           | Sender email address in the MAIL FROM header, also known as the envelope sender or the Return-Path address.                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.event.sender.mail_from_domain                            | Sender domain in the MAIL FROM header, also known as the envelope sender or the Return-Path address.                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.sender.object_id                                   | Unique identifier for the sender's account in Azure AD.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.sensitivity.label                                  | Label applied to an email, file, or other content to classify it for information protection.                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.event.sensitivity.sub_label                              | Sublabel applied to an email, file, or other content to classify it for information protection; sensitivity sublabels are grouped under sensitivity labels but are treated independently.                                                                                                                                                                                         | keyword          |
  | m365_defender.event.sensor_health_state                                | Indicates health of the device's EDR sensor, if onboarded to Microsoft Defender For Endpoint.                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.service_source                                     | Product or service that provided the alert information.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.severity                                           | Indicates the potential impact (high, medium, or low) of the threat indicator or breach activity identified by the alert.                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.sha1                                               | SHA-1 of the file that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.sha256                                             | SHA-256 of the file that the recorded action was applied to. This field is usually not populated—use the SHA1 column when available.                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.share_name                                         | Name of shared folder containing the file.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.signature_type                                     | Indicates whether signature information was read as embedded content in the file itself or read from an external catalog file.                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.signer                                             | Information about the signer of the file.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.signer_hash                                        | Unique hash value identifying the signer.                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.source_provider                                    | The identity's source, such as Microsoft Entra ID, Active Directory, or a hybrid identity synchronized from Active Directory to Azure Active Directory.                                                                                                                                                                                                                           | keyword          |
  | m365_defender.event.source_system                                      | The source system for the record.                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.subject                                            | Subject of the email.                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.target.account_display_name                        | Display name of the account that the recorded action was applied to.                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.target.account_upn                                 | User principal name (UPN) of the account that the recorded action was applied to.                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.event.target.device_name                                 | Fully qualified domain name (FQDN) of the device that the recorded action was applied to.                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.tenant.id                                          |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.tenant.name                                        |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.threat.family                                      | Malware family that the suspicious or malicious file or process has been classified under.                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.event.threat.names                                       | Detection name for malware or other threats found.                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.event.threat.types                                       | Verdict from the email filtering stack on whether the email contains malware, phishing, or other threats.                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.event.time                                               | The time Microsoft Defender received the event.                                                                                                                                                                                                                                                                                                                                   | date             |
  | m365_defender.event.timestamp                                          | Date and time when the event was recorded.                                                                                                                                                                                                                                                                                                                                        | date             |
  | m365_defender.event.title                                              | Title of the alert.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.tunnel_type                                        | Tunneling protocol, if the interface is used for this purpose, for example 6to4, Teredo, ISATAP, PPTP, SSTP, and SSH.                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.type                                               | The type of record.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.url                                                | Full URL in the email subject, body, or attachment.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.event.url_chain                                          | For scenarios involving redirections, it includes URLs present in the redirection chain.                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.url_count                                          | Number of embedded URLs in the email.                                                                                                                                                                                                                                                                                                                                             | long             |
  | m365_defender.event.url_domain                                         | Domain name or host name of the URL.                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.event.url_location                                       |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.event.user_agent                                         | User agent information from the web browser or other client application.                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.event.user_agent_tags                                    | More information provided by Microsoft Defender for Cloud Apps in a tag in the user agent field. Can have any of the following values: Native client, Outdated browser, Outdated operating system, Robot.                                                                                                                                                                         | keyword          |
  | m365_defender.event.user_level_action                                  | Action taken on the email in response to matches to a mailbox policy defined by the recipient.                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.event.user_level_policy                                  | End-user mailbox policy that triggered the action taken on the email.                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.event.vendor                                             | Name of the product vendor or manufacturer, only available if device discovery finds enough information about this attribute.                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.event.workload                                           | The application from which the user clicked on the link, with the values being Email, Office and Teams.                                                                                                                                                                                                                                                                           | keyword          |
  | process.Ext.api.name                                                   |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | process.Ext.api.parameters.address                                     | The target memory address.                                                                                                                                                                                                                                                                                                                                                        | long             |
  | process.Ext.api.parameters.desired_access_numeric                      | This parameter indicates the numeric value of the `DesiredAccess` field passed to `OpenProcess` or `OpenThread`.                                                                                                                                                                                                                                                                  | long             |
  | process.Ext.api.parameters.protection                                  | The memory protection for the region of pages. Corresponds to `MEMORY_BASIC_INFORMATION.Protect`.                                                                                                                                                                                                                                                                                 | keyword          |
  | process.Ext.api.parameters.size                                        | The size of parameter values passed to the API call.                                                                                                                                                                                                                                                                                                                              | long             |
  | process.Ext.token.integrity_level_name                                 | Integrity level that determine the levels of protection or access for a principal used by Mandatory Integrity Control (MIC).                                                                                                                                                                                                                                                      | keyword          |
  | process.executable                                                     | Absolute path to the process executable.                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | process.executable.caseless                                            | Multi-field of `process.executable`.                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | process.executable.text                                                | Multi-field of `process.executable`.                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | process.name                                                           | Process name. Sometimes called program name or similar.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | process.name.caseless                                                  | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | process.name.text                                                      | Multi-field of `process.name`.                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | process.parent.group_leader.name                                       |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | url.user_info                                                          |                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### incident

This is the `incident` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-09-30T09:35:45.113Z",
      "agent": {
          "ephemeral_id": "ea0e3074-38cf-4f33-88d6-cec07743a825",
          "id": "50b0fe53-224a-4406-97f7-4fd963c16f5c",
          "name": "elastic-agent-28076",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "cloud": {
          "account": {
              "id": "b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c"
          },
          "provider": [
              "azure"
          ]
      },
      "data_stream": {
          "dataset": "m365_defender.incident",
          "namespace": "82148",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "50b0fe53-224a-4406-97f7-4fd963c16f5c",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2021-08-13T08:43:35.553Z",
          "dataset": "m365_defender.incident",
          "id": "29723951",
          "ingested": "2025-12-23T09:48:39Z",
          "kind": "alert",
          "original": "{\"@odata.type\":\"#microsoft.graph.security.incident\",\"alerts\":{\"@odata.type\":\"#microsoft.graph.security.alert\",\"actorDisplayName\":null,\"alertWebUrl\":\"https://security.microsoft.com/alerts/da637551227677560813_-961444813?tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c\",\"assignedTo\":null,\"category\":\"DefenseEvasion\",\"classification\":\"unknown\",\"comments\":[],\"createdDateTime\":\"2021-04-27T12:19:27.7211305Z\",\"description\":\"A hidden file has been launched. This activity could indicate a compromised host. Attackers often hide files associated with malicious tools to evade file system inspection and defenses.\",\"detectionSource\":\"antivirus\",\"detectorId\":\"e0da400f-affd-43ef-b1d5-afc2eb6f2756\",\"determination\":\"unknown\",\"evidence\":[{\"@odata.type\":\"#microsoft.graph.security.deviceEvidence\",\"azureAdDeviceId\":null,\"createdDateTime\":\"2021-04-27T12:19:27.7211305Z\",\"defenderAvStatus\":\"unknown\",\"deviceDnsName\":\"tempDns\",\"firstSeenDateTime\":\"2020-09-12T07:28:32.4321753Z\",\"healthStatus\":\"active\",\"loggedOnUsers\":[],\"mdeDeviceId\":\"73e7e2de709dff64ef64b1d0c30e67fab63279db\",\"onboardingStatus\":\"onboarded\",\"osBuild\":22424,\"osPlatform\":\"Windows10\",\"rbacGroupId\":75,\"rbacGroupName\":\"UnassignedGroup\",\"remediationStatus\":\"none\",\"remediationStatusDetails\":null,\"riskScore\":\"medium\",\"roles\":[\"compromised\"],\"tags\":[\"Test Machine\"],\"verdict\":\"unknown\",\"version\":\"Other\",\"vmMetadata\":{\"cloudProvider\":\"azure\",\"resourceId\":\"/subscriptions/8700d3a3-3bb7-4fbe-a090-488a1ad04161/resourceGroups/WdatpApi-EUS-STG/providers/Microsoft.Compute/virtualMachines/NirLaviTests\",\"subscriptionId\":\"8700d3a3-3bb7-4fbe-a090-488a1ad04161\",\"vmId\":\"ca1b0d41-5a3b-4d95-b48b-f220aed11d78\"}}],\"firstActivityDateTime\":\"2021-04-26T07:45:50.116Z\",\"id\":\"da637551227677560813_-9614448132\",\"incidentId\":\"28282\",\"incidentWebUrl\":\"https://security.microsoft.com/incidents/28282?tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c\",\"lastActivityDateTime\":\"2021-05-02T07:56:58.222Z\",\"lastUpdateDateTime\":\"2021-05-02T14:19:01.3266667Z\",\"mitreTechniques\":[\"T1564.001\"],\"providerAlertId\":\"da637551227677560813_-961444813\",\"recommendedActions\":\"Collect artifacts and determine scope\\n�\\tReview the machine timeline for suspicious activities that may have occurred before and after the time of the alert, and record additional related artifacts (files, IPs/URLs) \\n�\\tLook for the presence of relevant artifacts on other systems. Identify commonalities and differences between potentially compromised systems.\\n�\\tSubmit relevant files for deep analysis and review resulting detailed behavioral information.\\n�\\tSubmit undetected files to the MMPC malware portal\\n\\nInitiate containment \\u0026 mitigation \\n�\\tContact the user to verify intent and initiate local remediation actions as needed.\\n�\\tUpdate AV signatures and run a full scan. The scan might reveal and remove previously-undetected malware components.\\n�\\tEnsure that the machine has the latest security updates. In particular, ensure that you have installed the latest software, web browser, and Operating System versions.\\n�\\tIf credential theft is suspected, reset all relevant users passwords.\\n�\\tBlock communication with relevant URLs or IPs at the organization�s perimeter.\",\"resolvedDateTime\":null,\"serviceSource\":\"microsoftDefenderForEndpoint\",\"severity\":\"low\",\"status\":\"new\",\"tenantId\":\"b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c\",\"threatDisplayName\":null,\"threatFamilyName\":null,\"title\":\"Suspicious execution of hidden file\"},\"assignedTo\":\"KaiC@contoso.onmicrosoft.com\",\"classification\":\"truePositive\",\"comments\":[{\"comment\":\"Demo incident\",\"createdBy\":\"DavidS@contoso.onmicrosoft.com\",\"createdTime\":\"2021-09-30T12:07:37.2756993Z\"}],\"createdDateTime\":\"2021-08-13T08:43:35.5533333Z\",\"determination\":\"multiStagedAttack\",\"displayName\":\"Multi-stage incident involving Initial access \\u0026 Command and control on multiple endpoints reported by multiple sources\",\"id\":\"29723951\",\"incidentWebUrl\":\"https://security.microsoft.com/incidents/2972395?tid=12f988bf-16f1-11af-11ab-1d7cd011db47\",\"lastUpdateDateTime\":\"2021-09-30T09:35:45.1133333Z\",\"redirectIncidentId\":null,\"severity\":\"medium\",\"status\":\"active\",\"tags\":[\"Demo\"],\"tenantId\":\"b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c\"}",
          "provider": "microsoftDefenderForEndpoint",
          "severity": 47,
          "url": "https://security.microsoft.com/incidents/2972395?tid=12f988bf-16f1-11af-11ab-1d7cd011db47"
      },
      "host": {
          "hostname": [
              "tempDns"
          ],
          "id": [
              "73e7e2de709dff64ef64b1d0c30e67fab63279db"
          ],
          "name": [
              "tempdns"
          ],
          "os": {
              "name": [
                  "Windows10"
              ],
              "version": [
                  "Other"
              ]
          }
      },
      "input": {
          "type": "httpjson"
      },
      "m365_defender": {
          "incident": {
              "alert": {
                  "alert_web_url": {
                      "domain": "security.microsoft.com",
                      "original": "https://security.microsoft.com/alerts/da637551227677560813_-961444813?tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
                      "path": "/alerts/da637551227677560813_-961444813",
                      "query": "tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
                      "scheme": "https"
                  },
                  "category": "DefenseEvasion",
                  "classification": "unknown",
                  "created_datetime": "2021-04-27T12:19:27.721Z",
                  "description": "A hidden file has been launched. This activity could indicate a compromised host. Attackers often hide files associated with malicious tools to evade file system inspection and defenses.",
                  "detection_source": "antivirus",
                  "detector_id": "e0da400f-affd-43ef-b1d5-afc2eb6f2756",
                  "determination": "unknown",
                  "evidence": [
                      {
                          "created_datetime": "2021-04-27T12:19:27.721Z",
                          "defender_av_status": "unknown",
                          "device_dns_name": "tempDns",
                          "first_seen_datetime": "2020-09-12T07:28:32.432Z",
                          "health_status": "active",
                          "mde_device_id": "73e7e2de709dff64ef64b1d0c30e67fab63279db",
                          "odata_type": "#microsoft.graph.security.deviceEvidence",
                          "onboarding_status": "onboarded",
                          "os_build": "22424",
                          "os_platform": "Windows10",
                          "rbac_group": {
                              "id": "75",
                              "name": "UnassignedGroup"
                          },
                          "remediation_status": "none",
                          "risk_score": "medium",
                          "roles": [
                              "compromised"
                          ],
                          "tags": [
                              "Test Machine"
                          ],
                          "verdict": "unknown",
                          "version": "Other",
                          "vm_metadata": {
                              "cloud_provider": "azure",
                              "resource_id": "/subscriptions/8700d3a3-3bb7-4fbe-a090-488a1ad04161/resourceGroups/WdatpApi-EUS-STG/providers/Microsoft.Compute/virtualMachines/NirLaviTests",
                              "subscription_id": "8700d3a3-3bb7-4fbe-a090-488a1ad04161",
                              "vm_id": "ca1b0d41-5a3b-4d95-b48b-f220aed11d78"
                          }
                      }
                  ],
                  "first_activity_datetime": "2021-04-26T07:45:50.116Z",
                  "id": "da637551227677560813_-9614448132",
                  "incident_id": "28282",
                  "incident_web_url": {
                      "domain": "security.microsoft.com",
                      "original": "https://security.microsoft.com/incidents/28282?tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
                      "path": "/incidents/28282",
                      "query": "tid=b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
                      "scheme": "https"
                  },
                  "last_activity_datetime": "2021-05-02T07:56:58.222Z",
                  "last_update_datetime": "2021-05-02T14:19:01.326Z",
                  "mitre_techniques": [
                      "T1564.001"
                  ],
                  "provider_alert_id": "da637551227677560813_-961444813",
                  "recommended_actions": "Collect artifacts and determine scope\n�\tReview the machine timeline for suspicious activities that may have occurred before and after the time of the alert, and record additional related artifacts (files, IPs/URLs) \n�\tLook for the presence of relevant artifacts on other systems. Identify commonalities and differences between potentially compromised systems.\n�\tSubmit relevant files for deep analysis and review resulting detailed behavioral information.\n�\tSubmit undetected files to the MMPC malware portal\n\nInitiate containment & mitigation \n�\tContact the user to verify intent and initiate local remediation actions as needed.\n�\tUpdate AV signatures and run a full scan. The scan might reveal and remove previously-undetected malware components.\n�\tEnsure that the machine has the latest security updates. In particular, ensure that you have installed the latest software, web browser, and Operating System versions.\n�\tIf credential theft is suspected, reset all relevant users passwords.\n�\tBlock communication with relevant URLs or IPs at the organization�s perimeter.",
                  "service_source": "microsoftDefenderForEndpoint",
                  "severity": "low",
                  "status": "new",
                  "tenant_id": "b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
                  "title": "Suspicious execution of hidden file"
              },
              "assigned_to": "KaiC@contoso.onmicrosoft.com",
              "classification": "truePositive",
              "comments": [
                  {
                      "comment": "Demo incident",
                      "createdBy": "DavidS@contoso.onmicrosoft.com",
                      "createdTime": "2021-09-30T12:07:37.2756993Z"
                  }
              ],
              "created_datetime": "2021-08-13T08:43:35.553Z",
              "determination": "multiStagedAttack",
              "display_name": "Multi-stage incident involving Initial access & Command and control on multiple endpoints reported by multiple sources",
              "id": "29723951",
              "last_update_datetime": "2021-09-30T09:35:45.113Z",
              "odata_type": "#microsoft.graph.security.incident",
              "severity": "medium",
              "status": "active",
              "tags": [
                  "Demo"
              ],
              "tenant_id": "b3c1b5fc-828c-45fa-a1e1-10d74f6d6e9c",
              "web_url": {
                  "domain": "security.microsoft.com",
                  "original": "https://security.microsoft.com/incidents/2972395?tid=12f988bf-16f1-11af-11ab-1d7cd011db47",
                  "path": "/incidents/2972395",
                  "query": "tid=12f988bf-16f1-11af-11ab-1d7cd011db47",
                  "scheme": "https"
              }
          }
      },
      "message": "Multi-stage incident involving Initial access & Command and control on multiple endpoints reported by multiple sources",
      "related": {
          "hosts": [
              "tempDns"
          ],
          "user": [
              "KaiC",
              "KaiC@contoso.onmicrosoft.com",
              "DavidS@contoso.onmicrosoft.com"
          ]
      },
      "source": {
          "user": {
              "domain": "contoso.onmicrosoft.com",
              "email": "KaiC@contoso.onmicrosoft.com",
              "name": "KaiC"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "m365_defender-incident"
      ],
      "threat": {
          "tactic": {
              "name": [
                  "DefenseEvasion"
              ]
          },
          "technique": {
              "subtechnique": {
                  "id": [
                      "T1564.001"
                  ]
              }
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                                      | Description                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |----------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                                 | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | cloud.image.id                                                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | data_stream.dataset                                                        | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | data_stream.namespace                                                      | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.type                                                           | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | event.dataset                                                              | Event dataset.                                                                                                                                                                                                                                                                                                                                                                                          | constant_keyword |
  | event.module                                                               | Event module.                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | host.containerized                                                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.os.build                                                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                                                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | input.type                                                                 | Input type                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | log.offset                                                                 | Log offset                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | m365_defender.incident.alert.actor_display_name                            | The adversary or activity group that is associated with this alert.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.alert_web_url.domain                          |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.extension                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.fragment                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.full                            |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.original                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.password                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.path                            |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.port                            |                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.incident.alert.alert_web_url.query                           |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.scheme                          |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.alert_web_url.username                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.assigned_to                                   | Owner of the alert, or null if no owner is assigned.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.incident.alert.category                                      | The attack kill-chain category that the alert belongs to. Aligned with the MITRE ATT&CK framework.                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.classification                                | Specifies whether the alert represents a true threat. Possible values are: unknown, falsePositive, truePositive, benignPositive, unknownFutureValue.                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.incident.alert.comments                                      | Array of comments created by the Security Operations (SecOps) team during the alert management process.                                                                                                                                                                                                                                                                                                 | flattened        |
  | m365_defender.incident.alert.created_datetime                              | Time when Microsoft 365 Defender created the alert.                                                                                                                                                                                                                                                                                                                                                     | date             |
  | m365_defender.incident.alert.description                                   | String value describing each alert.                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.detection_source                              | Detection technology or sensor that identified the notable component or activity.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.detector_id                                   | The ID of the detector that triggered the alert.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.determination                                 | Specifies the result of the investigation, whether the alert represents a true attack and if so, the nature of the attack. Possible values are: unknown, apt, malware, securityPersonnel, securityTesting, unwantedSoftware, other, multiStagedAttack, compromisedUser, phishing, maliciousUserActivity, clean, insufficientData, confirmedUserActivity, lineOfBusinessApplication, unknownFutureValue. | keyword          |
  | m365_defender.incident.alert.evidence.antispam_direction                   | Direction of the email relative to your network. The possible values are: Inbound, Outbound or Intraorg.                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.incident.alert.evidence.app_id                               | Unique identifier of the application.                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.attachments_count                    | Number of attachments in the email.                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | m365_defender.incident.alert.evidence.azure_ad_device_id                   | A unique identifier assigned to a device by Azure Active Directory (Azure AD) when device is Azure AD-joined.                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.cluster_by                           | The clustering logic of the emails inside the cluster.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.cluster_by_value                     | The value utilized to cluster the similar emails.                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.evidence.created_datetime                     | The time the evidence was created and added to the alert.                                                                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.incident.alert.evidence.defender_av_status                   | State of the Defender AntiMalware engine. The possible values are: notReporting, disabled, notUpdated, updated, unknown, notSupported, unknownFutureValue.                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.delivery_action                      | Delivery action of the email. The possible values are: Delivered, DeliveredAsSpam, Junked, Blocked, or Replaced.                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.evidence.delivery_location                    | Location where the email was delivered. The possible values are: Inbox, External, JunkFolder, Quarantine, Failed, Dropped, DeletedFolder or Forwarded.                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.detection_status                     | The status of the detection.The possible values are: detected, blocked, prevented, unknownFutureValue.                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.device_dns_name                      | The fully qualified domain name (FQDN) for the device.                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.display_name                         | Name of the application.                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.incident.alert.evidence.email_count                          | Count of emails in the email cluster.                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.incident.alert.evidence.file_details.issuer                  | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.evidence.file_details.name                    | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.file_details.odata_type              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.file_details.path                    | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.file_details.publisher               | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.file_details.sha1                    | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.evidence.file_details.sha256                  | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.file_details.signer                  | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.file_details.size                    | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.incident.alert.evidence.first_seen_datetime                  | The date and time when the device was first seen.                                                                                                                                                                                                                                                                                                                                                       | date             |
  | m365_defender.incident.alert.evidence.health_status                        | The health state of the device.The possible values are: active, inactive, impairedCommunication, noSensorData, noSensorDataImpairedCommunication, unknown, unknownFutureValue.                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.image_file.issuer                    | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.evidence.image_file.name                      | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.image_file.odata_type                |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.image_file.path                      | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.image_file.publisher                 | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.image_file.sha1                      | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.evidence.image_file.sha256                    | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.image_file.signer                    | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.image_file.size                      | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.incident.alert.evidence.instance_id                          | Identifier of the instance of the Software as a Service (SaaS) application.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.evidence.instance_name                        | Name of the instance of the SaaS application.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.internet_message_id                  | Public-facing identifier for the email that is set by the sending email system.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.ip_address                           | The value of the IP Address, can be either in V4 address or V6 address format.                                                                                                                                                                                                                                                                                                                          | ip               |
  | m365_defender.incident.alert.evidence.language                             | Detected language of the email content.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.incident.alert.evidence.logged_on_users.account_name         | User account name of the logged-on user.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.incident.alert.evidence.logged_on_users.domain_name          | User account domain of the logged-on user.                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.logged_on_users.odata_type           |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.mde_device_id                        | A unique identifier assigned to a device by Microsoft Defender for Endpoint.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.network_message_id                   | Unique identifier for the email, generated by Microsoft 365.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.network_message_ids                  | Unique identifiers for the emails in the cluster, generated by Microsoft 365.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.object_id                            | The unique identifier of the application object in Azure AD.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.odata_type                           |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.onboarding_status                    | The status of the machine onboarding to Microsoft Defender for Endpoint.The possible values are: insufficientInfo, onboarded, canBeOnboarded, unsupported, unknownFutureValue.                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.os_build                             | The build version for the operating system the device is running.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.evidence.os_platform                          | The operating system platform the device is running.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.incident.alert.evidence.p1_sender.display_name               | The name of the sender.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.incident.alert.evidence.p1_sender.domain_name                | Sender domain.                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.p1_sender.email_address              | Sender email address.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.p1_sender.odata_type                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.p2_sender.display_name               | The name of the sender.                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.incident.alert.evidence.p2_sender.domain_name                | Sender domain.                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.p2_sender.email_address              | Sender email address.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.p2_sender.odata_type                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.creation_datetime     | Date and time when the parent of the process was created.                                                                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.incident.alert.evidence.parent_process.id                    | Process ID (PID) of the parent process that spawned the process.                                                                                                                                                                                                                                                                                                                                        | long             |
  | m365_defender.incident.alert.evidence.parent_process.image_file.issuer     | The certificate authority (CA) that issued the certificate.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.name       | The name of the file.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.odata_type |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.path       | The file path (location) of the file instance.                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.publisher  | The publisher of the file.                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.sha1       | The Sha1 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.sha256     | The Sha256 cryptographic hash of the file content.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.signer     | The signer of the signed file.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | m365_defender.incident.alert.evidence.parent_process.image_file.size       | The size of the file in bytes.                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.incident.alert.evidence.primary_address                      | The primary email address of the mailbox.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.incident.alert.evidence.process.command_line                 | Command line used to create the new process.                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.process.creation_datetime            | Date and time the process was created.                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | m365_defender.incident.alert.evidence.process.id                           | Process ID (PID) of the newly created process.                                                                                                                                                                                                                                                                                                                                                          | long             |
  | m365_defender.incident.alert.evidence.publisher                            | The name of the application publisher.                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.query                                | The query used to identify the email cluster.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.rbac_group.id                        | The ID of the role-based access control (RBAC) device group.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.rbac_group.name                      | The name of the RBAC device group.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.received_datetime                    | Date and time when the email was received.                                                                                                                                                                                                                                                                                                                                                              | date             |
  | m365_defender.incident.alert.evidence.recipient_email_address              | Email address of the recipient, or email address of the recipient after distribution list expansion.                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.incident.alert.evidence.registry_hive                        | Registry hive of the key that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.evidence.registry_key                         | Registry key that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.registry_value                       | Data of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.evidence.registry_value_name                  | Name of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.evidence.registry_value_type                  | Data type, such as binary or string, of the registry value that the recorded action was applied to.                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.evidence.remediation_status                   | Status of the remediation action taken. The possible values are: none, remediated, prevented, blocked, notFound, active, pendingApproval, declined, notRemediated, running, unknownFutureValue.                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.remediation_status_details           | Details about the remediation status.                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.risk_score                           | Risk score as evaluated by Microsoft Defender for Endpoint. The possible values are: none, informational, low, medium, high, unknownFutureValue.                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.incident.alert.evidence.roles                                | The role/s that an evidence entity represents in an alert, e.g., an IP address that is associated with an attacker will have the evidence role "Attacker".                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.incident.alert.evidence.saas_app_id                          | The identifier of the SaaS application.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.incident.alert.evidence.security_group_id                    | Unique identifier of the security group.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.incident.alert.evidence.sender_ip                            | IP address of the last detected mail server that relayed the message.                                                                                                                                                                                                                                                                                                                                   | ip               |
  | m365_defender.incident.alert.evidence.subject                              | Subject of the email.                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.incident.alert.evidence.tags                                 | Array of custom tags associated with an evidence instance, for example to denote a group of devices, high value assets, etc.                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.threat_detection_methods             | Collection of methods used to detect malware, phishing, or other threats found in the email.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.threats                              | Collection of detection names for malware or other threats found.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.evidence.type                                 |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.url                                  | The Unique Resource Locator (URL).                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.url_count                            | Number of embedded URLs in the email.                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | m365_defender.incident.alert.evidence.urls                                 | Collection of the URLs contained in this email.                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.urn                                  | Uniform resource name (URN) of the automated investigation where the cluster was identified.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.user_account.account_name            | The user account's displayed name.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.user_account.azure_ad_user_id        | The user object identifier in Azure AD.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.incident.alert.evidence.user_account.display_name            | The user display name in Azure AD.                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.user_account.domain_name             | The name of the Active Directory domain of which the user is a member.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.evidence.user_account.odata_type              |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.user_account.user_principal_name     | The user principal name of the account in Azure AD.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.evidence.user_account.user_sid                | The local security identifier of the user account.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.evidence.verdict                              | The decision reached by automated investigation. The possible values are: unknown, suspicious, malicious, noThreatsFound, unknownFutureValue.                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.version                              | The version of the operating system platform.                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | m365_defender.incident.alert.evidence.vm_metadata.cloud_provider           | The cloud provider hosting the virtual machine. The possible values are: unknown, azure, unknownFutureValue.                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.evidence.vm_metadata.odata_type               |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.evidence.vm_metadata.resource_id              | Unique identifier of the Azure resource.                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.incident.alert.evidence.vm_metadata.subscription_id          | Unique identifier of the Azure subscription the customer tenant belongs to.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.evidence.vm_metadata.vm_id                    | Unique identifier of the virtual machine instance.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.first_activity_datetime                       | The earliest activity associated with the alert.                                                                                                                                                                                                                                                                                                                                                        | date             |
  | m365_defender.incident.alert.id                                            | Unique identifier to represent the alert resource.                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.incident_id                                   | Unique identifier to represent the incident this alert resource is associated with.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.incident.alert.incident_web_url.domain                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.extension                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.fragment                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.full                         |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.original                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.password                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.path                         |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.port                         |                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.incident.alert.incident_web_url.query                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.scheme                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.incident_web_url.username                     |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.alert.last_activity_datetime                        | The oldest activity associated with the alert.                                                                                                                                                                                                                                                                                                                                                          | date             |
  | m365_defender.incident.alert.last_update_datetime                          | Time when the alert was last updated at Microsoft 365 Defender.                                                                                                                                                                                                                                                                                                                                         | date             |
  | m365_defender.incident.alert.mitre_techniques                              | The attack techniques, as aligned with the MITRE ATT&CK framework.                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.alert.provider_alert_id                             | The ID of the alert as it appears in the security provider product that generated the alert.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.recommended_actions                           | Recommended response and remediation actions to take in the event this alert was generated.                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | m365_defender.incident.alert.resolved_datetime                             | Time when the alert was resolved.                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | m365_defender.incident.alert.service_source                                | The service or product that created this alert. Possible values are: microsoftDefenderForEndpoint, microsoftDefenderForIdentity, microsoftCloudAppSecurity, microsoftDefenderForOffice365, microsoft365Defender, aadIdentityProtection, appGovernance, dataLossPrevention.                                                                                                                              | keyword          |
  | m365_defender.incident.alert.severity                                      | Indicates the possible impact on assets. The higher the severity the bigger the impact. Typically higher severity items require the most immediate attention. Possible values are: unknown, informational, low, medium, high, unknownFutureValue.                                                                                                                                                       | keyword          |
  | m365_defender.incident.alert.status                                        | The status of the alert. Possible values are: new, inProgress, resolved, unknownFutureValue.                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.alert.tenant_id                                     | The Azure Active Directory tenant the alert was created in.                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.alert.threat_display_name                           | The threat associated with this alert.                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.incident.alert.threat_family_name                            | Threat family associated with this alert.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.incident.alert.title                                         | Brief identifying string value describing the alert.                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | m365_defender.incident.assigned_to                                         | Owner of the incident, or null if no owner is assigned. Free editable text.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.incident.classification                                      | The specification for the incident. Possible values are: unknown, falsePositive, truePositive, informationalExpectedActivity, unknownFutureValue.                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.comments                                            | Array of comments created by the Security Operations (SecOps) team when the incident is managed.                                                                                                                                                                                                                                                                                                        | flattened        |
  | m365_defender.incident.created_datetime                                    | Time when the incident was first created.                                                                                                                                                                                                                                                                                                                                                               | date             |
  | m365_defender.incident.determination                                       | Specifies the determination of the incident. Possible values are: unknown, apt, malware, securityPersonnel, securityTesting, unwantedSoftware, other, multiStagedAttack, compromisedUser, phishing, maliciousUserActivity, clean, insufficientData, confirmedUserActivity, lineOfBusinessApplication, unknownFutureValue.                                                                               | keyword          |
  | m365_defender.incident.display_name                                        | The incident name.                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.id                                                  | Unique identifier to represent the incident.                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.incident.last_update_datetime                                | Time when the incident was last updated.                                                                                                                                                                                                                                                                                                                                                                | date             |
  | m365_defender.incident.odata_type                                          |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.redirect_incident_id                                | Only populated in case an incident is grouped together with another incident, as part of the logic that processes incidents. In such a case, the status property is redirected.                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.severity                                            | Indicates the possible impact on assets. The higher the severity, the bigger the impact. Typically higher severity items require the most immediate attention. Possible values are: unknown, informational, low, medium, high, unknownFutureValue.                                                                                                                                                      | keyword          |
  | m365_defender.incident.status                                              | The status of the incident. Possible values are: active, resolved, redirected, unknownFutureValue.                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.incident.tags                                                | Array of custom tags associated with an incident.                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.tenant_id                                           | The Azure Active Directory tenant in which the alert was created.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.incident.web_url.domain                                      |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.extension                                   |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.fragment                                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.full                                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.original                                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.password                                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.path                                        |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.port                                        |                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | m365_defender.incident.web_url.query                                       |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.scheme                                      |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | m365_defender.incident.web_url.username                                    |                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
</dropdown>


### vulnerability

This is the `vulnerability` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2026-01-05T12:06:57.268Z",
      "agent": {
          "ephemeral_id": "15548e80-a8ea-4a4c-baab-48929ef5392c",
          "id": "d54bb79c-84f4-4b99-abc8-fc8158cedafe",
          "name": "elastic-agent-64195",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "m365_defender.vulnerability",
          "namespace": "60777",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "d54bb79c-84f4-4b99-abc8-fc8158cedafe",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "vulnerability"
          ],
          "dataset": "m365_defender.vulnerability",
          "id": "1212121212121212121212_red_hat_kernel_0:5.14.0-427.42.1.el9_4_CVE-2022-49226",
          "ingested": "2026-01-05T12:06:58Z",
          "kind": "event",
          "original": "{\"CveBatchTitle\":\"Red_hat February 2025 Vulnerabilities\",\"CveBatchUrl\":\"https://security.access.redhat.com/data/oval/v2/RHEL9/rhel-9.8-eus.oval.xml.bz2\",\"CveId\":\"CVE-2022-49226\",\"CvssScore\":5.5,\"DeviceId\":\"1212121212121212121212\",\"DeviceName\":\"sample-host-1\",\"ExploitabilityLevel\":\"NoExploit\",\"FirstSeenTimestamp\":\"2025-10-06 10:43:58\",\"Id\":\"1212121212121212121212_red_hat_kernel_0:5.14.0-427.42.1.el9_4_CVE-2022-49226\",\"IsOnboarded\":true,\"LastSeenTimestamp\":\"2025-10-06 22:45:00\",\"OSArchitecture\":\"x64\",\"OSPlatform\":\"Linux\",\"OSVersion\":\"enterprise_linux_9.4\",\"RbacGroupId\":0,\"RbacGroupName\":\"Unassigned\",\"RecommendationReference\":\"va-_-red_hat-_-kernel\",\"RecommendedSecurityUpdate\":\"CVE-2022-49226_oval:com.redhat.rhsa:def:20249315\",\"RecommendedSecurityUpdateId\":\"RHSA-2024:9315\",\"RecommendedSecurityUpdateUrl\":\"https://access.redhat.com/errata/RHSA-2024:9315\",\"RegistryPaths\":[],\"SecurityUpdateAvailable\":true,\"SoftwareName\":\"kernel\",\"SoftwareVendor\":\"red_hat\",\"SoftwareVersion\":\"0:5.14.0-427.42.1.el9_4\",\"VulnerabilitySeverityLevel\":\"Medium\"}",
          "type": [
              "info"
          ]
      },
      "group": {
          "id": "0",
          "name": "Unassigned"
      },
      "host": {
          "architecture": "x64",
          "hostname": "sample-host-1",
          "id": "1212121212121212121212",
          "name": "sample-host-1",
          "os": {
              "name": "Linux enterprise_linux_9.4",
              "platform": "Linux",
              "type": "linux",
              "version": "enterprise_linux_9.4"
          }
      },
      "input": {
          "type": "cel"
      },
      "m365_defender": {
          "vulnerability": {
              "cve_batch_title": "Red_hat February 2025 Vulnerabilities",
              "cve_batch_url": "https://security.access.redhat.com/data/oval/v2/RHEL9/rhel-9.8-eus.oval.xml.bz2",
              "cve_id": "CVE-2022-49226",
              "cvss_score": 5.5,
              "device_id": "1212121212121212121212",
              "device_name": "sample-host-1",
              "exploitability_level": "NoExploit",
              "first_seen_timestamp": "2025-10-06T10:43:58.000Z",
              "id": "1212121212121212121212_red_hat_kernel_0:5.14.0-427.42.1.el9_4_CVE-2022-49226",
              "is_onboarded": true,
              "last_seen_timestamp": "2025-10-06T22:45:00.000Z",
              "os_architecture": "x64",
              "os_platform": "Linux",
              "os_version": "enterprise_linux_9.4",
              "rbac_group_id": "0",
              "rbac_group_name": "Unassigned",
              "recommendation_reference": "va-_-red_hat-_-kernel",
              "recommended_security_update": "CVE-2022-49226_oval:com.redhat.rhsa:def:20249315",
              "recommended_security_update_id": "RHSA-2024:9315",
              "security_update_available": true,
              "severity_level": "Medium",
              "software_name": "kernel",
              "software_vendor": "red_hat",
              "software_version": "0:5.14.0-427.42.1.el9_4"
          }
      },
      "message": "Red_hat February 2025 Vulnerabilities",
      "observer": {
          "product": "Microsoft 365 Defender",
          "vendor": "Microsoft"
      },
      "package": {
          "name": "kernel",
          "version": "0:5.14.0-427.42.1.el9_4"
      },
      "related": {
          "hosts": [
              "1212121212121212121212",
              "sample-host-1"
          ]
      },
      "resource": {
          "id": "1212121212121212121212",
          "name": "sample-host-1"
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "m365_defender-vulnerability"
      ],
      "vulnerability": {
          "classification": "CVSS",
          "cve": "CVE-2022-49226",
          "enumeration": "CVE",
          "id": "CVE-2022-49226",
          "reference": "https://www.cve.org/CVERecord?id=CVE-2022-49226",
          "scanner": {
              "vendor": "Microsoft"
          },
          "score": {
              "base": 5.5
          },
          "severity": "Medium",
          "title": "Vulnerability found in kernel 0:5.14.0-427.42.1.el9_4 - CVE-2022-49226"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.dataset                                              | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.                                                                                                                                                                                                               | constant_keyword |
  | event.module                                               | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.                                                                                                                                                                                                                                                                                              | constant_keyword |
  | input.type                                                 | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.device_id                                         | Device Id of the log file this event came from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | log.file.inode                                             | Inode number of the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | log.offset                                                 | Log offset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | m365_defender.vulnerability.cve_batch_title                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.vulnerability.cve_batch_url                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.vulnerability.cve_id                         | Unique identifier assigned to the security vulnerability under the Common Vulnerabilities and Exposures (CVE) system.                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | m365_defender.vulnerability.cvss_score                     | The CVSS score of the CVE.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | float            |
  | m365_defender.vulnerability.device_id                      | Unique identifier for the device in the service.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | m365_defender.vulnerability.device_name                    | Fully qualified domain name (FQDN) of the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.vulnerability.disk_paths                     | Disk evidence that the product is installed on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | m365_defender.vulnerability.exploitability_level           | The exploitability level of this vulnerability (NoExploit, ExploitIsPublic, ExploitIsVerified, ExploitIsInKit)                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.vulnerability.first_seen_timestamp           | First time this product CVE was seen on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | m365_defender.vulnerability.id                             | Unique identifier for the record.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | m365_defender.vulnerability.is_onboarded                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | m365_defender.vulnerability.last_seen_timestamp            | Last time the software was reported on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | date             |
  | m365_defender.vulnerability.os_architecture                | Architecture of the operating system running on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.vulnerability.os_platform                    | Platform of the operating system running on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | m365_defender.vulnerability.os_version                     | Version of the operating system running on the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | m365_defender.vulnerability.rbac_group_id                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | m365_defender.vulnerability.rbac_group_name                | The role-based access control (RBAC) group.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.vulnerability.recommendation_reference       | A reference to the recommendation ID related to this software.                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.vulnerability.recommended_security_update    | Name or description of the security update provided by the software vendor to address the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | m365_defender.vulnerability.recommended_security_update_id | Identifier of the applicable security updates or identifier for the corresponding guidance or knowledge base (KB) articles.                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | m365_defender.vulnerability.registry_paths                 | Registry evidence that the product is installed in the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.vulnerability.security_update_available      | Indicates whether a security update is available for the software.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | m365_defender.vulnerability.severity_level                 | Severity level assigned to the security vulnerability based on the CVSS score.                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | m365_defender.vulnerability.software_name                  | Name of the software product.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | m365_defender.vulnerability.software_vendor                | Name of the software vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | m365_defender.vulnerability.software_version               | Version number of the software product.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | observer.vendor                                            | Vendor name of the observer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | package.fixed_version                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | package.name                                               | Package name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | package.version                                            | Package version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.id                                                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | resource.name                                              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | vulnerability.cve                                          | The CVE id of the vulnerability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | vulnerability.published_date                               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | vulnerability.scanner.vendor                               | The name of the vulnerability scanner vendor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | vulnerability.title                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


### Inputs used

These inputs are used in this integration:
- [azure-eventhub](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-eventhub)
- [cel](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cel)
- [httpjson](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-httpjson)


### API usage

This integration dataset uses the following APIs:
- `Alerts`: [List alerts_v2](https://learn.microsoft.com/en-us/graph/api/security-list-alerts_v2?view=graph-rest-1.0&tabs=http) endpoint from [Microsoft Graph Security REST API v1.0](https://learn.microsoft.com/en-us/graph/api/resources/security-api-overview?view=graph-rest-1.0)
- `Events`: [Microsoft Defender XDR Streaming API](https://learn.microsoft.com/en-us/defender-xdr/streaming-api?view=o365-worldwide)
- `Incidents`: [List incidents](https://learn.microsoft.com/en-us/graph/api/security-list-incidents?view=graph-rest-1.0&tabs=http) endpoint from [Microsoft Graph Security REST API v1.0](https://learn.microsoft.com/en-us/graph/api/resources/security-api-overview?view=graph-rest-1.0)
- `Vulnerabilities`: [Get software vulnerabilities](https://learn.microsoft.com/en-us/defender-endpoint/api/get-assessment-software-vulnerabilities#2-export-software-vulnerabilities-assessment-via-files) endpoint from [Microsoft Defender for Endpoint API v1.0](https://learn.microsoft.com/en-us/defender-endpoint/api/exposed-apis-list)


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Microsoft Defender XDR Alert Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-alert-api.png)

  ![Microsoft Defender XDR (Incidents) Incidents Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-incident.png)

  ![Microsoft Defender XDR (Events) Alerts Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-alert-eventhub.png)

  ![Microsoft Defender XDR (Events) Device Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-device.png)

  ![Microsoft Defender XDR (Events) Email Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-email.png)

  ![Microsoft Defender XDR (Events) App & Identity Dashboard](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-app_and_identity.png)

  ![Microsoft Defender XDR Vulnerability](https://epr.elastic.co/package/m365_defender/5.6.0/img/m365_defender-vulnerability.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **5.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17276))Change default URL for the `vulnerability` data stream to `https://api.security.microsoft.com`.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17276))Improve documentation with correct links, updated input titles and descriptions for all data streams. Update UI text to reflect updated titles.                                                                                                                                   | 9.1.48.19.4            |
  | **5.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16676))Enhance ECS mappings across all datasets. Add navigation panel and refactor the dashboards.                                                                                                                                                                                                                                                                                                                                                                               | 9.1.48.19.4            |
  | **5.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16628))Add support for OAuth2 Endpoint Params option for alert and incident data streams.                                                                                                                                                                                                                                                                                                                                                                                        | 9.1.48.19.4            |
  | **5.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16615))Fix table rendering issue in documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.1.48.19.4            |
  | **5.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16152))Update documentation to reflect recent changes in vulnerability data stream including replacement of the List Vulnerabilities and List Machines API references with the SoftwareVulnerabilitiesExport API, using the modern integrations documentation layout.                                                                                                                                                                                                            | 9.1.48.19.4            |
  | **5.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16146))Add cloudsecurity_cdr sub category label                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.1.48.19.4            |
  | **5.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15728))Fix construction of `file.path` fields in the incident data stream to conform to ECS.                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.48.19.4            |
  | **5.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15749))Add support for OAuth2 Endpoint Params option to vulnerability data stream.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15749))Handle expired URLs in vulnerability data stream.                                                                                                                                                                                                                                                         | 9.1.48.19.4            |
  | **5.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15722))Update transform to filter out documents containing an error.message from vulnerability latest index                                                                                                                                                                                                                                                                                                                                                                          | 9.1.48.19.4            |
  | **5.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15603))Fetch vulnerability data using SoftwareVulnerabilitiesExport API endpoint.**Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/15603))The following fields are no longer available in the new implementation: "cloud.provider", "cloud.resource_id", "cloud.instance.id", "host.geo", "host.ip", "host.risk.calculated_level", "related.ip", "vulnerability.description", "vulnerability.published_date", "vulnerability.score.version". | 9.1.48.19.4            |
  | **4.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15415))Prevent updating fleet health status to degraded.                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.48.19.4            |
  | **4.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15151))Add `vulnerability_workflow` sub category labels.                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.1.28.19.2            |
  | **4.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15392))Ensure large `$skip` API parameter values are correctly formatted in `vulnerability` data stream.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15392))Supress expected empty template health updates.                                                                                                                                                                                                                                         | 9.1.28.19.2            |
  | **4.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15226))Extract `process.name` from `process.command_line` in alert, event, and incident data streams.                                                                                                                                                                                                                                                                                                                                                                                | 9.1.28.19.2            |
  | **4.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/14809))Add mapping changes and latest transform in `vulnerability` data stream for Cloud Detection and Response (CDR) vulnerability workflow.                                                                                                                                                                                                                                                                                                                                | 9.1.28.19.2            |
  | **3.14.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14857))Fix handling of empty string IP values.                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.18.0            |
  | **3.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14783))Fix agent handling of empty and error results in vulnerability data stream.                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **3.14.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14722))Enhanced error handling in the CEL program for API calls to prevent `no such key: product_batch_size` errors by ensuring proper propagation of the `product_batch_size` configuration during failures.                                                                                                                                                                                                                                                                        | 9.0.08.18.0            |
  | **3.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14448))Add `process.name` ECS mapping in alert, event, and incident data streams.                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **3.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14393))Use `terminate` processor instead of `fail` processor to handle agent errors.                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.0            |
  | **3.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14350))Rebrand integration to Microsoft Defender XDR to align with Microsoft's current branding.This is a superficial branding update only and does not affect existing functionalities.                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **3.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14137))Standardize user fields processing across integrations.                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **3.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **3.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14085))ECS mapping improvements.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **3.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13595))Add vulnerability data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.18.0            |
  | **3.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13931))Set `device.id` in all datasets and `application.name` in event dataset.                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **3.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13984))Add `process.entity_id` and `process.parent.entity_id` ECS mappings in all data streams.                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **3.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13955))Normalize `event.severity` values across EDR integrations.                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.18.0            |
  | **3.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13769))Set `cloud.instance.id` in event dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.18.0            |
  | **3.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 9.0.08.18.0            |
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13554))Improve `user.name` handling.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13452))Enable request trace log removal.                                                                                                                                                                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13335))Improve performance of event ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.18.0            |
  | **3.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13185))Fix `event.category` value for the AdvancedHunting-AlertInfo event.                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.18.0            |
  | **2.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13166))Add a toggle button for including unknown members in properties of evolvable enum types.                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.18.0            |
  | **2.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12891))Enable Agentless deployment.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.18.0            |
  | **2.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12888))Add email ECS fields to alert data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **2.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **2.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12593))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **2.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12546))Fix mapping of Defender InternetMessageId and NetworkMessageId values.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12546))Fix removal behavior for ECS-mapped `m365_defender.event.internet_message_id` field.                                                                                                                                                                                                                               | 8.13.0                 |
  | **2.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12449))Add ASN enrichment for IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12401))Make token endpoint configurable for Alert data stream.                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **2.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12214))Add support for `IdentityInfo` advanced hunting table.                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **2.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **2.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12112))Change connection_string to be a secret                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **2.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **2.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                 | 8.13.0                 |
  | **2.15.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12047))Fix string literals in painless scripts.                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.15.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11020))Add caseless fields to process events.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **2.15.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10953))Fix OS assignment for Windows devices.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10953))Set `host.os.type` to unix for all POSIX systems without a known platform.                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.14.7** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10947))Fix pipeline errors for DNS logs.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.13.0                 |
  | **2.14.6** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10810))Fix dashboard filters to look for correct event.severity values.                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.14.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10772))Fix mapping issue for DNS answers field.                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.14.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10798))Fix `host.mac` gsub processor to handle MAC addresses with `-` already present.                                                                                                                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **2.14.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10730))Fix sslconnectioninspected event `network.protocol` getting set to `dns`.                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.14.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10418))Fix `network.transport` and `network.protocol` processing.                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **2.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10280))Fix process executable containing duplicate process name.                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10179))Improve ECS mappings                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `host.ip` and `host.mac` fields conform to ECS field definition.                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9860))Improve detection rules support                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.12.0                 |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.12.0                 |
  | **2.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9983))Drop last page events in the alerts datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.12.0                 |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9812))Improve command line analyser.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **2.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9832))Resolved ignore_malformed issues with fields.                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9127))Set sensitive values as secret and fix incorrect mappings.                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.12.0                 |
  | **2.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9060))Handle invalid IP addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8950))Add support of Alert Data Stream.                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **2.6.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8492))Fix cursor value and query building for log data stream.                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8899))Add geoip processing to source and destination IP fields.                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8872))Fix `process.command_line` overwritten by `process.parent.command_line`.                                                                                                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8090))Remove renaming the original `message` field to `event.original`                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7919))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                                                                                                                                       | 8.7.1                  |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7707))Fix template snippet escaping and add event.kind for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7522))Major improvements in ECS field coverage and additional field mappings.                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **1.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7255))Fix fingerprint processor on `log` datastream to avoid document conflicts                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7119))Add support for newer Oauth Token Endpoint and fixes in some ECS mappings.                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7123))Update package-spec to 2.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6898))Convert dashboards to Lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.7.1                  |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6731))Added the mapping for user.name field into the incident data stream.                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **1.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6696))Fix event.query type to group                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6661))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6057))Add and lowercase host.name field                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/5744))Update event.kind to alert for Incident data stream and handle null value for AttackTechniques field in Event data stream.                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.6.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/5408))Update datastreams titles and ReadMe.                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4962))Add New Event Data Stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5164))Drop empty event sets in log data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.4.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4893))Update API version for incident data stream.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4893))Mark log data stream as deprecated because it's using the older defender APIs.                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.4.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4865))Bugfixes for when entities fields are empty.                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4611))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4435))Add New Incident Data Stream.                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3867))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.0.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3194))Update duplication handling to also support Redirect type alerts                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.0.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3194))Add duplication handling in ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3181))Fix mapping for comments field and add missing fields                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2854))First version                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
</dropdown>