﻿---
title: Lumos Integration
description: The Lumos integration uses Lumos' API to retrieve Activity Logs and ingest them into Elasticsearch. This allows you to search, observe, and visualize...
url: https://www.elastic.co/docs/reference/integrations/lumos
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Lumos Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4               |

The Lumos integration uses [Lumos' API](https://www.lumos.com/) to retrieve Activity Logs and ingest them into Elasticsearch. This allows you to search, observe, and visualize the Activity Logs through Elasticsearch.
The Elastic agent running this integration interacts with Lumos' infrastructure using their APIs to retrieve Activity Logs for a Lumos tenant.

## Configuration


### Enabling the integration in Elastic

1. In Kibana go to **Management > Integrations**
2. In the "Search for integrations" search bar type **Lumos**.
3. Click on "Lumos" integration from the search results.
4. Click on **Add Lumos** button to add Lumos integration.


### Configure Lumos Activity Logs data stream

1. In Lumos go to **Settings > API Tokens**
2. Click on "Add API Token", enter a name and description
3. Copy the key starting with `lsk_`
4. While adding Lumos integration in Elastic, paste your key into the `API Token` field


## Logs


### Activity Logs

Activity Logs summarize the history of changes and events occurring within Lumos.
<dropdown title="Exported fields">
  | Field                                        | Description                         | Type             |
  |----------------------------------------------|-------------------------------------|------------------|
  | @timestamp                                   | Event timestamp.                    | date             |
  | data_stream.dataset                          | Data stream dataset.                | constant_keyword |
  | data_stream.namespace                        | Data stream namespace.              | constant_keyword |
  | data_stream.type                             | Data stream type.                   | constant_keyword |
  | event.module                                 | Event module                        | constant_keyword |
  | input.type                                   | Input type                          | keyword          |
  | lumos.activity_logs.actor.actor_type         | The type of actor                   | keyword          |
  | lumos.activity_logs.actor.email              | The email of the actor              | keyword          |
  | lumos.activity_logs.actor.family_name        | The family name of the actor        | keyword          |
  | lumos.activity_logs.actor.given_name         | The given name of the actor         | keyword          |
  | lumos.activity_logs.event_began_at           | The time the event began            | keyword          |
  | lumos.activity_logs.event_type_user_friendly | The user friendly type of the event | keyword          |
  | lumos.activity_logs.targets.name             |                                     | keyword          |
  | lumos.activity_logs.targets.target_type      |                                     | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-10-07T10:29:39.283Z",
      "agent": {
          "ephemeral_id": "2899cf43-154c-43bf-8e38-6dd8fcdddeb8",
          "id": "ec7a2ba3-4ffe-4b9d-98cf-dce8eccd9455",
          "name": "elastic-agent-76548",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "lumos.activity_logs",
          "namespace": "18028",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "ec7a2ba3-4ffe-4b9d-98cf-dce8eccd9455",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "SOD_POLICY_DELETED",
          "agent_id_status": "verified",
          "created": "2025-10-07T10:29:39.283Z",
          "dataset": "lumos.activity_logs",
          "id": "630b90cedc35a8a5f43361534099bee51e032f42dd442085fc76ef094d228f543c78fbe59c132df992cf71a6b8496504e8ebbc6020fbae1f34206676985412e7",
          "ingested": "2025-10-07T10:29:42Z",
          "kind": "event",
          "outcome": "success",
          "type": [
              "info"
          ]
      },
      "host": {
          "architecture": "x86_64",
          "containerized": false,
          "hostname": "elastic-agent-76548",
          "ip": [
              "192.168.241.2",
              "192.168.240.4"
          ],
          "mac": [
              "12-2A-F7-F2-2C-D7",
              "DE-BF-74-CA-85-68"
          ],
          "name": "elastic-agent-76548",
          "os": {
              "kernel": "5.15.0-156-generic",
              "name": "Wolfi",
              "platform": "wolfi",
              "type": "linux",
              "version": "20230201"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "lumos": {
          "activity_logs": {
              "actor": {
                  "actor_type": "Lumos user",
                  "email": "wile.e.coyote@lumos.com",
                  "family_name": "Wile",
                  "given_name": "Coyote"
              },
              "event_began_at": "2024-03-12T16:09:14",
              "event_type_user_friendly": "A user deleted a SOD Policy",
              "targets": [
                  {
                      "name": "Untitled Rule",
                      "target_type": "SOD Policy"
                  }
              ]
          }
      },
      "message": "{\"actor\":{\"actor_type\":\"Lumos user\",\"email\":\"wile.e.coyote@lumos.com\",\"family_name\":\"Wile\",\"given_name\":\"Coyote\"},\"event_began_at\":\"2024-03-12T16:09:14\",\"event_hash\":\"630b90cedc35a8a5f43361534099bee51e032f42dd442085fc76ef094d228f543c78fbe59c132df992cf71a6b8496504e8ebbc6020fbae1f34206676985412e7\",\"event_metadata\":{},\"event_type\":\"SOD_POLICY_DELETED\",\"event_type_user_friendly\":\"A user deleted a SOD Policy\",\"outcome\":\"Succeeded\",\"targets\":[{\"name\":\"Untitled Rule\",\"target_type\":\"SOD Policy\"}]}"
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Lumos screenshot](https://epr.elastic.co/package/lumos/1.6.0/img/lumos-screenshot.png)

  ![Activity Log screenshot](https://epr.elastic.co/package/lumos/1.6.0/img/activity-log-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15584))Prevent updating fleet health status to degraded.                                                                                                   | 9.1.49.0.78.19.4       |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.4.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12071))Fix broken links in Security Service integrations packages.                                                                                             | 8.13.0                 |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10136))Fix sample event.                                                                                                                                       | 8.12.1                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `event.type` field conform to ECS field definition.                                                                                            | 8.12.1                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                 | 8.12.1                 |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9779))Release package as GA.                                                                                                                               | 8.12.1                 |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9276))Initial draft of the package                                                                                                                         |                        |
</dropdown>