﻿---
title: Kubernetes OpenTelemetry Assets
description: Kubernetes OpenTelemetry Assets must be used with OpenTelemetry data. With this package will be installed assets to monitor Kubernetes clusters. You need...
url: https://www.elastic.co/docs/reference/integrations/kubernetes_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Kubernetes OpenTelemetry Assets
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.4.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                          |

Kubernetes OpenTelemetry Assets must be used with OpenTelemetry data. With this package will be installed assets to monitor [Kubernetes clusters](https://kubernetes.io/).

## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

For step-by-step instructions on how to ingest opentelemetry data using the OpenTelemetry Operator, see the
[Elastic Distribution for OTel Collector](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) quickstart guide.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Kubernetes Overview Dashboard](https://epr.elastic.co/package/kubernetes_otel/1.4.0/img/kubernetes_overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                     | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16682))Add dataset filters to dashboard panels                            | 9.2.0                  |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15733))Add `discovery` field to support auto-install                      | 9.2.0                  |
  | **1.2.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15692))Update EDOT quick start url                                        | 9.2.08.18.0            |
  | **1.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15615))Add `opentelemetry` category                                       | 9.2.08.18.0            |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15454))Use k8seventsreceiver data for K8s Events visualisations           | 9.2.08.18.0            |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15020))Update the visualisation filters for ad-hoc fields                     | 9.0.08.18.0            |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12535))Add support for Kibana `9.0.0`                                     | 9.0.08.18.0            |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12268))Making package GA                                                  | 8.18.0                 |
  | **0.0.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11591))Adding events to overview dashboard                                |                        |
  | **0.0.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11451))Remove events from overview dashboard                              |                        |
  | **0.0.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11435))Update format_spec to target 3.3.0                                 |                        |
  | **0.0.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11407))Add a link to the onboarding flow, fix the package logo            |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11310))Change logo and description of the package, fix overview dashboard |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11137))Initial draft of the Kubernetes OpenTelemetry Assets package       |                        |
</dropdown>