﻿---
title: kube-state-metrics
description: Kube-state Metrics version should be aligned with the Kubernetes version of your cluster. Follow  relevant kubernetes/kube-state-metrics compatibility-matrix...
url: https://www.elastic.co/docs/reference/integrations/kubernetes/kube-state-metrics
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# kube-state-metrics
|                                                                            |                                                         |
|----------------------------------------------------------------------------|---------------------------------------------------------|
| **Version**                                                                | 1.84.1 ([View all](#changelog))                         |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                                                   |
| **Ingestion method(s)**                                                    | API, AWS CloudWatch, Azure Event Hub, File, GCP Pub/Sub |
| **Minimum Kibana version(s)**                                              | 9.3.09.2.49.1.10                                        |

Kube-state Metrics version should be aligned with the Kubernetes version of your cluster. Follow  relevant [kubernetes/kube-state-metrics compatibility-matrix](https://github.com/kubernetes/kube-state-metrics#compatibility-matrix) for more information.

## Metrics

If Leader Election is activated (default behaviour) only the `elastic agent` which holds the leadership lock
will retrieve metrics from the `kube_state_metrics`.
This is relevant in multi-node kubernetes cluster and prevents duplicate data.

### state_container

This is the `state_container` dataset of the Kubernetes package. It collects container related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "container": {
          "image": {
              "name": "k8s.gcr.io/coredns/coredns:v1.8.0"
          },
          "runtime": "containerd",
          "id": "696963fe4eeb8734a10e44e0ef8d582fe9861c13ef7c50d6fa5689733df7d302"
      },
      "kubernetes": {
          "container": {
              "memory": {
                  "request": {
                      "bytes": 73400320
                  },
                  "limit": {
                      "bytes": 178257920
                  }
              },
              "name": "coredns",
              "cpu": {
                  "request": {
                      "cores": 0.1
                  }
              },
              "id": "containerd://696963fe4eeb8734a10e44e0ef8d582fe9861c13ef7c50d6fa5689733df7d302",
              "status": {
                  "phase": "running",
                  "ready": true,
                  "restarts": 5
              }
          },
          "node": {
              "uid": "57ccd748-c877-4be9-9b0e-568e9f205025",
              "hostname": "kind-control-plane",
              "name": "kind-control-plane",
              "labels": {
                  "node_kubernetes_io/exclude-from-external-load-balancers": "",
                  "node-role_kubernetes_io/master": "",
                  "kubernetes_io/hostname": "kind-control-plane",
                  "node-role_kubernetes_io/control-plane": "",
                  "beta_kubernetes_io/os": "linux",
                  "kubernetes_io/arch": "amd64",
                  "kubernetes_io/os": "linux",
                  "beta_kubernetes_io/arch": "amd64"
              }
          },
          "pod": {
              "uid": "b5637989-65ec-4f86-a13e-b9bd02e9bac5",
              "ip": "10.244.0.5",
              "name": "coredns-558bd4d5db-8qp4d"
          },
          "namespace": "kube-system",
          "namespace_uid": "a4453575-518e-4a21-9909-34874f674177",
          "replicaset": {
              "name": "coredns-558bd4d5db"
          },
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "pod-template-hash": "558bd4d5db",
              "k8s-app": "kube-dns"
          },
          "deployment": {
              "name": "coredns"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "ephemeral_id": "22ed892c-43bd-408a-9121-65e2f5b6a56e",
          "type": "metricbeat",
          "version": "8.1.0"
      },
      "elastic_agent": {
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "version": "8.1.0",
          "snapshot": true
      },
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "@timestamp": "2021-12-20T10:02:04.923Z",
      "ecs": {
          "version": "8.0.0"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_container"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "metricset": {
          "period": 10000,
          "name": "state_container"
      },
      "event": {
          "duration": 1459222,
          "agent_id_status": "verified",
          "ingested": "2021-12-20T10:02:05Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_container"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |-------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                                              | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone                               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | container.runtime                                     | Runtime managing this container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | data_stream.dataset                                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*                              | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.container.cpu.limit.cores                  | Container CPU cores limit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | float            |      | gauge       |
  | kubernetes.container.cpu.request.cores                | Container CPU requested cores                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | float            |      | gauge       |
  | kubernetes.container.id                               | Container id                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | kubernetes.container.memory.limit.bytes               | Container memory limit in bytes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             | byte | gauge       |
  | kubernetes.container.memory.request.bytes             | Container requested memory in bytes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             | byte | gauge       |
  | kubernetes.container.name                             | Kubernetes container name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | kubernetes.container.status.last_terminated_exitcode  | The exit code for the last container in terminated state.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | integer          |      |             |
  | kubernetes.container.status.last_terminated_reason    | The last reason the container was in terminated state (Completed, ContainerCannotRun, Error or OOMKilled).                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.container.status.last_terminated_timestamp | Last terminated time (epoch) of the container                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | double           |      |             |
  | kubernetes.container.status.phase                     | Container phase (running, waiting, terminated)                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | kubernetes.container.status.ready                     | Container ready status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | boolean          |      |             |
  | kubernetes.container.status.reason                    | The reason the container is currently in waiting (ContainerCreating, CrashLoopBackoff, ErrImagePull, ImagePullBackoff) or terminated (Completed, ContainerCannotRun, Error, OOMKilled) state.                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | kubernetes.container.status.restarts                  | Container restarts count                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | integer          |      | counter     |
  | kubernetes.cronjob.name                               | Name of the CronJob to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | kubernetes.daemonset.name                             | Kubernetes daemonset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | kubernetes.deployment.name                            | Kubernetes deployment name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.job.name                                   | Name of the Job to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | kubernetes.labels.*                                   | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.namespace                                  | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.namespace_annotations.*                    | Kubernetes namespace annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | object           |      |             |
  | kubernetes.namespace_labels.*                         | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |      |             |
  | kubernetes.namespace_uid                              | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | kubernetes.node.annotations.*                         | Kubernetes node annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |      |             |
  | kubernetes.node.hostname                              | Kubernetes hostname as reported by the node’s kernel                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.node.labels.*                              | Kubernetes node labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.node.name                                  | Kubernetes node name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.node.uid                                   | Kubernetes node UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | kubernetes.pod.ip                                     | Kubernetes pod IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ip               |      |             |
  | kubernetes.pod.name                                   | Kubernetes pod name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | kubernetes.pod.uid                                    | Kubernetes pod UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | kubernetes.replicaset.name                            | Kubernetes replicaset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.statefulset.name                           | Kubernetes statefulset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | orchestrator.cluster.name                             | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url                              | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                                       | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                                          | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_cronjob

This is the `state_cronjob` dataset of the Kubernetes package. It collects cronjob related
metrics from `kube_state_metrics`.> Important Note: Please make sure that you install latest kube-state metrics version for this datataset to appear.
Eg. Kube-state-metrics v2.3.0 was not reporting cron_job metrics for Kubernetes v1.25.0
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "namespace": "default",
          "namespace_uid": "5f4a8989-32b3-4fc9-ba5b-9dece58436b8",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "default"
          },
          "cronjob": {
              "last_schedule": {
                  "sec": 1674053820
              },
              "created": {
                  "sec": 1674053817
              },
              "name": "hello",
              "active": {
                  "count": 0
              },
              "is_suspended": false,
              "next_schedule": {
                  "sec": 1674053880
              }
          },
          "labels": {
              "k8s-app": "myjob"
          }
      },
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "type": "metricbeat",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T14:57:16.597Z",
      "ecs": {
          "version": "8.0.0"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_cronjob"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "family": "debian",
              "type": "linux",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "52-A2-77-CF-D4-EC",
              "62-BC-CF-94-14-6C",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "BA-D7-49-95-5A-F5",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "EE-C8-E8-11-00-F5",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "metricset": {
          "period": 10000,
          "name": "state_cronjob"
      },
      "event": {
          "duration": 11786458,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T14:57:17Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_cronjob"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |--------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                           | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                             | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                     | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone              | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                       | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                    | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                  | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                   | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                     | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                       | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                         | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                         | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                 | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                     | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                       | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                  | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                     | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                          | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                    | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                   | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                          | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                        | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                              | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                              | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                             | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                            | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                        | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                     | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                       | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                       | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                         | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                    | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                     | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                      | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                            | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*             | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.cronjob.active.count      | Number of active pods for the cronjob                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |      | gauge       |
  | kubernetes.cronjob.concurrency       | Concurrency policy                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | kubernetes.cronjob.created.sec       | Epoch seconds since the cronjob was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | double           | s    | gauge       |
  | kubernetes.cronjob.deadline.sec      | Deadline seconds after schedule for considering failed                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             | s    | gauge       |
  | kubernetes.cronjob.is_suspended      | Whether the cronjob is suspended                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |      |             |
  | kubernetes.cronjob.last_schedule.sec | Epoch seconds for last cronjob run                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | double           | s    | gauge       |
  | kubernetes.cronjob.name              | Cronjob name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | kubernetes.cronjob.next_schedule.sec | Epoch seconds for next cronjob run                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | double           | s    | gauge       |
  | kubernetes.cronjob.schedule          | Cronjob schedule                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | kubernetes.labels.*                  | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.namespace                 | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.namespace_labels.*        | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |      |             |
  | kubernetes.namespace_uid             | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | orchestrator.cluster.name            | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url             | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                      | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                         | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_daemonset

This is the `state_daemonset` dataset of the Kubernetes package. It collects daemonset related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "kubernetes": {
          "namespace": "kube-system",
          "daemonset": {
              "replicas": {
                  "desired": 1,
                  "unavailable": 0,
                  "ready": 1,
                  "available": 1
              },
              "name": "kube-proxy"
          },
          "namespace_uid": "250a647d-3acc-4f7e-85b5-a51b6069959d",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "k8s-app": "kube-proxy"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "type": "metricbeat",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T14:52:46.935Z",
      "ecs": {
          "version": "8.0.0"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_daemonset"
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "type": "linux",
              "family": "debian",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "BA-D7-49-95-5A-F5",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "metricset": {
          "period": 10000,
          "name": "state_daemonset"
      },
      "event": {
          "duration": 182782,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T14:52:47Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_daemonset"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Metric Type |
  |-------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                                | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |             |
  | agent.id                                  | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | cloud.account.id                          | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.availability_zone                   | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | cloud.image.id                            | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.id                         | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.name                       | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.machine.type                        | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |             |
  | cloud.project.id                          | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.provider                            | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.region                              | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | container.id                              | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | container.image.name                      | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |             |
  | container.labels                          | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |             |
  | container.name                            | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | data_stream.dataset                       | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |             |
  | data_stream.namespace                     | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |             |
  | data_stream.type                          | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |             |
  | ecs.version                               | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |             |
  | host.architecture                         | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | host.containerized                        | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |             |
  | host.domain                               | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | host.hostname                             | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |             |
  | host.id                                   | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.ip                                   | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |             |
  | host.mac                                  | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |             |
  | host.name                                 | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.build                             | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.codename                          | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | host.os.family                            | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.kernel                            | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.os.name                              | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | host.os.name.text                         | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |             |
  | host.os.platform                          | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.version                           | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.type                                 | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.annotations.*                  | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |             |
  | kubernetes.daemonset.name                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | kubernetes.daemonset.replicas.available   | The number of available replicas per DaemonSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             | gauge       |
  | kubernetes.daemonset.replicas.desired     | The desired number of replicas per DaemonSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             | gauge       |
  | kubernetes.daemonset.replicas.ready       | The number of ready replicas per DaemonSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             | gauge       |
  | kubernetes.daemonset.replicas.unavailable | The number of unavailable replicas per DaemonSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             | gauge       |
  | kubernetes.labels.*                       | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |             |
  | kubernetes.namespace                      | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | kubernetes.namespace_labels.*             | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |             |
  | kubernetes.namespace_uid                  | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | orchestrator.cluster.name                 | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | orchestrator.cluster.url                  | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | service.address                           | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | service.type                              | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |             |
</dropdown>


### state_deployment

This is the `state_deployment` dataset of the Kubernetes package. It collects deployment related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "kubernetes": {
          "namespace": "kube-system",
          "namespace_uid": "250a647d-3acc-4f7e-85b5-a51b6069959d",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "k8s-app": "kube-dns"
          },
          "deployment": {
              "paused": false,
              "replicas": {
                  "desired": 2,
                  "unavailable": 0,
                  "available": 2,
                  "updated": 2
              },
              "name": "coredns"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "type": "metricbeat",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T14:50:47.075Z",
      "ecs": {
          "version": "8.0.0"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_deployment"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "family": "debian",
              "type": "linux",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "BA-D7-49-95-5A-F5",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "metricset": {
          "period": 10000,
          "name": "state_deployment"
      },
      "event": {
          "duration": 361259,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T14:50:47Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_deployment"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Metric Type |
  |--------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |             |
  | agent.id                                   | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | cloud.account.id                           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.availability_zone                    | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.id                          | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.name                        | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.machine.type                         | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |             |
  | cloud.project.id                           | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.provider                             | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.region                               | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | container.id                               | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | container.image.name                       | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |             |
  | container.labels                           | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |             |
  | container.name                             | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | data_stream.dataset                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |             |
  | data_stream.namespace                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |             |
  | data_stream.type                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |             |
  | ecs.version                                | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |             |
  | host.architecture                          | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | host.containerized                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |             |
  | host.domain                                | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | host.hostname                              | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |             |
  | host.id                                    | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.ip                                    | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |             |
  | host.mac                                   | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |             |
  | host.name                                  | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.build                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.codename                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | host.os.family                             | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.kernel                             | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.os.name                               | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | host.os.name.text                          | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |             |
  | host.os.platform                           | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.version                            | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.type                                  | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.annotations.*                   | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |             |
  | kubernetes.deployment.name                 | Kubernetes deployment name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | kubernetes.deployment.paused               | Kubernetes deployment paused status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | boolean          |             |
  | kubernetes.deployment.replicas.available   | Deployment available replicas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | integer          | gauge       |
  | kubernetes.deployment.replicas.desired     | Deployment number of desired replicas (spec)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | integer          | gauge       |
  | kubernetes.deployment.replicas.unavailable | Deployment unavailable replicas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          | gauge       |
  | kubernetes.deployment.replicas.updated     | Deployment updated replicas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | integer          | gauge       |
  | kubernetes.deployment.status.available     | Deployment Available Condition status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | kubernetes.deployment.status.progressing   | Deployment Progresing Condition status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | kubernetes.labels.*                        | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |             |
  | kubernetes.namespace                       | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | kubernetes.namespace_labels.*              | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |             |
  | kubernetes.namespace_uid                   | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | orchestrator.cluster.name                  | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | orchestrator.cluster.url                   | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | service.address                            | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | service.type                               | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |             |
</dropdown>


### state_job

This is the `state_job` dataset of the Kubernetes package. It collects job related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "kubernetes": {
          "namespace": "default",
          "job": {
              "owner": {
                  "kind": "CronJob",
                  "is_controller": "true",
                  "name": "hello"
              },
              "parallelism": {
                  "desired": 1
              },
              "name": "hello-27900898",
              "completions": {
                  "desired": 1
              },
              "pods": {
                  "active": 0,
                  "failed": 0,
                  "succeeded": 1
              },
              "time": {
                  "created": "2023-01-18T14:58:00.000Z",
                  "completed": "2023-01-18T14:58:04.000Z"
              },
              "status": {
                  "complete": "true"
              }
          },
          "namespace_uid": "5f4a8989-32b3-4fc9-ba5b-9dece58436b8",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "default"
          },
          "cronjob": {
              "name": "hello"
          },
          "labels": {
              "job-name": "hello-27900898",
              "controller-uid": "ae0e0759-f219-49c5-8845-43553448a045"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "type": "metricbeat",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T14:58:46.786Z",
      "ecs": {
          "version": "8.0.0"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_job"
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "family": "debian",
              "type": "linux",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "52-A2-77-CF-D4-EC",
              "62-BC-CF-94-14-6C",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "BA-D7-49-95-5A-F5",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "EE-C8-E8-11-00-F5",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "metricset": {
          "period": 10000,
          "name": "state_job"
      },
      "event": {
          "duration": 212263,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T14:58:46Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_job"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                              | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Metric Type |
  |------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                         | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |             |
  | agent.id                           | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | cloud.account.id                   | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.availability_zone            | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | cloud.image.id                     | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.id                  | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.name                | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.machine.type                 | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |             |
  | cloud.project.id                   | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.provider                     | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.region                       | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | container.id                       | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | container.image.name               | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |             |
  | container.labels                   | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |             |
  | container.name                     | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | data_stream.dataset                | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |             |
  | data_stream.namespace              | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |             |
  | data_stream.type                   | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |             |
  | ecs.version                        | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |             |
  | host.architecture                  | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | host.containerized                 | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |             |
  | host.domain                        | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | host.hostname                      | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |             |
  | host.id                            | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.ip                            | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |             |
  | host.mac                           | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |             |
  | host.name                          | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.build                      | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.codename                   | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | host.os.family                     | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.kernel                     | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.os.name                       | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | host.os.name.text                  | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |             |
  | host.os.platform                   | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.version                    | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.type                          | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.annotations.*           | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |             |
  | kubernetes.cronjob.name            | Name of the CronJob to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |             |
  | kubernetes.job.completions.desired | The configured completion count for the job (Spec)                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             | gauge       |
  | kubernetes.job.name                | Name of the Job to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | kubernetes.job.owner.is_controller | Owner is controller ("true", "false", or `"\<none\>"`)                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.job.owner.kind          | The kind of resource that owns this job (eg. "CronJob")                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |             |
  | kubernetes.job.owner.name          | The name of the resource that owns this job                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | kubernetes.job.parallelism.desired | The configured parallelism of the job (Spec)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             | gauge       |
  | kubernetes.job.pods.active         | Number of active pods                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             | gauge       |
  | kubernetes.job.pods.failed         | Number of failed pods                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             | gauge       |
  | kubernetes.job.pods.succeeded      | Number of successful pods                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             | gauge       |
  | kubernetes.job.status.complete     | Whether the job completed ("true", "false", or "unknown")                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | kubernetes.job.status.failed       | Whether the job failed ("true", "false", or "unknown")                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.job.time.completed      | The time at which the job completed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |             |
  | kubernetes.job.time.created        | The time at which the job was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |             |
  | kubernetes.labels.*                | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |             |
  | kubernetes.namespace               | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | kubernetes.namespace_labels.*      | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |             |
  | kubernetes.namespace_uid           | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | orchestrator.cluster.name          | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | orchestrator.cluster.url           | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | service.address                    | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | service.type                       | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |             |
</dropdown>


### state_namespace

This is the `state_namespace` dataset of the Kubernetes package. It collects node related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "namespace": "local-path-storage",
          "state_namespace": {
              "created": {
                  "sec": 1698661397
              },
              "status": {
                  "active": true,
                  "terminating": false
              }
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "9bbe4c49-2375-4d5d-b7ed-87eaec794094",
          "ephemeral_id": "fae4af00-5533-44c9-b2f1-bb5225bc2b36",
          "type": "metricbeat",
          "version": "8.11.0"
      },
      "@timestamp": "2023-10-30T10:31:06.062Z",
      "ecs": {
          "version": "8.0.0"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_namespace"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "elastic_agent": {
          "id": "9bbe4c49-2375-4d5d-b7ed-87eaec794094",
          "version": "8.11.0",
          "snapshot": true
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "6.3.13-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "type": "linux",
              "family": "debian",
              "version": "20.04.6 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "name": "kind-control-plane",
          "id": "138690b2aa0f48758176419fc2733566",
          "architecture": "x86_64"
      },
      "metricset": {
          "period": 10000,
          "name": "state_namespace"
      },
      "event": {
          "duration": 546253,
          "agent_id_status": "verified",
          "ingested": "2023-10-30T10:31:07Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_namespace"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |-----------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                                    | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                                      | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                              | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone                       | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                                | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                             | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                           | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                            | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                              | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                                | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                                  | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                                  | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                          | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                              | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                                | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                           | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                         | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                              | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                                   | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                             | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                            | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                                   | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                                 | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                                       | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                                       | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                                      | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                                     | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                                 | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                              | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                                | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                                | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                                  | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                             | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                              | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                               | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                                     | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*                      | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.labels.*                           | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.namespace                          | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.state_namespace.created.sec        | Epoch seconds since the namespace was created.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           | s    | gauge       |
  | kubernetes.state_namespace.status.active      | Whether the namespace is active (true or false).                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |      |             |
  | kubernetes.state_namespace.status.terminating | Whether the namespace is terminating (true or false).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |      |             |
  | orchestrator.cluster.name                     | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url                      | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                               | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                                  | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_node

This is the `state_node` dataset of the Kubernetes package. It collects node related
metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "labels": {
              "beta_kubernetes_io/arch": "amd64",
              "beta_kubernetes_io/os": "linux",
              "kubernetes_io/arch": "amd64",
              "kubernetes_io/hostname": "kind-control-plane",
              "kubernetes_io/os": "linux",
              "node-role_kubernetes_io/control-plane": "",
              "node_kubernetes_io/exclude-from-external-load-balancers": ""
          },
          "node": {
              "cpu": {
                  "allocatable": {
                      "cores": 16
                  },
                  "capacity": {
                      "cores": 16
                  }
              },
              "kubelet": {
                  "version": "v1.27.3"
              },
              "memory": {
                  "allocatable": {
                      "bytes": 8069844992
                  },
                  "capacity": {
                      "bytes": 8069844992
                  }
              },
              "name": "kind-control-plane",
              "pod": {
                  "allocatable": {
                      "total": 110
                  },
                  "capacity": {
                      "total": 110
                  }
              },
              "status": {
                  "disk_pressure": "false",
                  "memory_pressure": "false",
                  "pid_pressure": "false",
                  "ready": "true",
                  "unschedulable": false
              }
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |--------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                                   | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone                    | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                          | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                        | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                         | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                           | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                             | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                               | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                               | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                       | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                           | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                             | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                                | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                          | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                                | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                              | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                                    | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                                    | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                                   | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                                  | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                             | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                             | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                               | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                          | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                           | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                            | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                                  | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*                   | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.labels.*                        | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.node.cpu.allocatable.cores      | Node CPU allocatable cores                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | float            |      | gauge       |
  | kubernetes.node.cpu.capacity.cores         | Node CPU capacity cores                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |      | gauge       |
  | kubernetes.node.hostname                   | Kubernetes hostname as reported by the node’s kernel                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.node.kubelet.version            | Kubelet version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | kubernetes.node.memory.allocatable.bytes   | Node allocatable memory in bytes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             | byte | gauge       |
  | kubernetes.node.memory.capacity.bytes      | Node memory capacity in bytes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             | byte | gauge       |
  | kubernetes.node.name                       | Kubernetes node name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.node.pod.allocatable.total      | Node allocatable pods                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |      | gauge       |
  | kubernetes.node.pod.capacity.total         | Node pod capacity                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |      | gauge       |
  | kubernetes.node.status.disk_pressure       | Node DiskPressure status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | kubernetes.node.status.memory_pressure     | Node MemoryPressure status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | kubernetes.node.status.network_unavailable | Node NetworkUnavailable status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |      |             |
  | kubernetes.node.status.out_of_disk         | Node OutOfDisk status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | kubernetes.node.status.pid_pressure        | Node PIDPressure status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | kubernetes.node.status.ready               | Node ready status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.node.status.unschedulable       | Node unschedulable status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | boolean          |      |             |
  | orchestrator.cluster.name                  | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url                   | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                            | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                               | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_persistentvolume

This is the `state_persistentvolume` dataset of the Kubernetes package. It collects
PersistentVolume related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-06-25T12:43:54.412Z",
      "ecs": {
          "version": "1.5.0"
      },
      "event": {
          "module": "kubernetes",
          "duration": 12149615,
          "dataset": "kubernetes.state_persistentvolume"
      },
      "agent": {
          "version": "8.0.0",
          "ephemeral_id": "644323b5-5d6a-4dfb-92dd-35ca602db487",
          "id": "a6147a6e-6626-4a84-9907-f372f6c61eee",
          "name": "agent-ingest-management-clusterscope-674dbb75df-rp8cc",
          "type": "metricbeat"
      },
      "kubernetes": {
          "persistentvolume": {
              "capacity": {
                  "bytes": 10737418240
              },
              "phase": "Bound",
              "storage_class": "manual",
              "name": "task-pv-volume"
          },
          "labels": {
              "type": "local"
          }
      },
      "metricset": {
          "period": 10000,
          "name": "state_persistentvolume"
      },
      "service": {
          "address": "kube-state-metrics:8080",
          "type": "kubernetes"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |--------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                                   | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone                    | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                          | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                        | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                         | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                           | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                             | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                               | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                               | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                       | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                           | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                             | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                                | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                          | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                                | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                              | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                                    | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                                    | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                                   | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                                  | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                             | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                             | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                               | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                          | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                           | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                            | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                                  | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*                   | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.labels.*                        | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.persistentvolume.capacity.bytes | Volume capacity                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             | byte | gauge       |
  | kubernetes.persistentvolume.name           | Volume name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | kubernetes.persistentvolume.phase          | Volume phase according to kubernetes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.persistentvolume.storage_class  | Storage class for the volume                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | orchestrator.cluster.name                  | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url                   | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                            | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                               | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_persistentvolumeclaim

This is the `state_persistentvolumeclaim` dataset of the Kubernetes package. It collects
PersistentVolumeClaim related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "namespace": "default",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "default"
          },
          "namespace_uid": "b6c80381-f829-45a4-acef-e4e1c8e58f3e",
          "persistentvolumeclaim": {
              "access_mode": "ReadWriteOnce",
              "created": "2024-01-08T14:07:51.000Z",
              "name": "task-pv-claim",
              "phase": "Bound",
              "request_storage": {
                  "bytes": 1024
              },
              "storage_class": "generic",
              "volume_name": "task-pv-volume"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |--------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                                             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                                               | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                                       | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone                                | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                                         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                                      | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                                    | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                                     | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                                       | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                                         | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                                           | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                                           | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                                   | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                                       | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                                         | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                                    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                                  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                                       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                                            | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                                      | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                                     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                                            | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                                          | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                                                | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                                                | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                                               | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                                              | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                                          | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                                       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                                         | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                                         | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                                           | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                                      | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                                       | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                                        | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                                              | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*                               | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.labels.*                                    | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.namespace                                   | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.namespace_labels.*                          | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |      |             |
  | kubernetes.namespace_uid                               | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | kubernetes.persistentvolumeclaim.access_mode           | Access mode.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | kubernetes.persistentvolumeclaim.created               | PersistentVolumeClaim creation date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |      |             |
  | kubernetes.persistentvolumeclaim.name                  | PVC name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | kubernetes.persistentvolumeclaim.phase                 | PVC phase.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.persistentvolumeclaim.request_storage.bytes | Requested capacity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             | byte | gauge       |
  | kubernetes.persistentvolumeclaim.storage_class         | Storage class for the PVC.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | kubernetes.persistentvolumeclaim.volume_name           | Binded volume name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | orchestrator.cluster.name                              | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url                               | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                                        | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                                           | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_pod

This is the `state_pod` dataset of the Kubernetes package. It collects
Pod related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "node": {
              "uid": "57ccd748-c877-4be9-9b0e-568e9f205025",
              "hostname": "kind-control-plane",
              "name": "kind-control-plane",
              "labels": {
                  "node_kubernetes_io/exclude-from-external-load-balancers": "",
                  "node-role_kubernetes_io/master": "",
                  "kubernetes_io/hostname": "kind-control-plane",
                  "node-role_kubernetes_io/control-plane": "",
                  "beta_kubernetes_io/os": "linux",
                  "kubernetes_io/arch": "amd64",
                  "kubernetes_io/os": "linux",
                  "beta_kubernetes_io/arch": "amd64"
              }
          },
          "pod": {
              "uid": "d06d59c2-929f-4b13-bc7d-c2492200ce07",
              "host_ip": "172.20.0.2",
              "ip": "172.20.0.2",
              "name": "elastic-agent-h2mgj",
              "status": {
                  "phase": "running",
                  "ready": "true",
                  "scheduled": "true"
              }
          },
          "namespace": "kube-system",
          "daemonset": {
              "name": "elastic-agent"
          },
          "namespace_uid": "a4453575-518e-4a21-9909-34874f674177",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "app": "elastic-agent",
              "controller-revision-hash": "57c5d7c56f",
              "pod-template-generation": "3"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "type": "metricbeat",
          "ephemeral_id": "22ed892c-43bd-408a-9121-65e2f5b6a56e",
          "version": "8.1.0"
      },
      "elastic_agent": {
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "version": "8.1.0",
          "snapshot": true
      },
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "@timestamp": "2021-12-20T10:03:24.643Z",
      "ecs": {
          "version": "8.0.0"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_pod"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "metricset": {
          "period": 10000,
          "name": "state_pod"
      },
      "event": {
          "duration": 736951,
          "agent_id_status": "verified",
          "ingested": "2021-12-20T10:03:25Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_pod"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                              | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                         | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | agent.id                           | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.account.id                   | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone            | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                     | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                  | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                 | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                   | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                     | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                       | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                       | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name               | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                   | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                     | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | container.runtime                  | Runtime managing this container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | data_stream.dataset                | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace              | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                   | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | ecs.version                        | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |
  | host.architecture                  | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                 | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                        | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                      | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                            | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                            | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                           | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                          | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                      | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                   | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                     | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                     | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                       | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                  | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                   | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                    | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                          | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | kubernetes.annotations.*           | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |
  | kubernetes.cronjob.name            | Name of the CronJob to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | kubernetes.daemonset.name          | Kubernetes daemonset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | kubernetes.deployment.name         | Kubernetes deployment name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | kubernetes.job.name                | Name of the Job to which the Pod belongs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | kubernetes.labels.*                | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |
  | kubernetes.namespace               | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | kubernetes.namespace_annotations.* | Kubernetes namespace annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | object           |
  | kubernetes.namespace_labels.*      | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |
  | kubernetes.namespace_uid           | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | kubernetes.node.annotations.*      | Kubernetes node annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |
  | kubernetes.node.hostname           | Kubernetes hostname as reported by the node’s kernel                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | kubernetes.node.labels.*           | Kubernetes node labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |
  | kubernetes.node.name               | Kubernetes node name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | kubernetes.node.uid                | Kubernetes node UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | kubernetes.pod.host_ip             | Kubernetes pod host IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | ip               |
  | kubernetes.pod.ip                  | Kubernetes pod IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | ip               |
  | kubernetes.pod.name                | Kubernetes pod name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | kubernetes.pod.status.phase        | Kubernetes pod phase (Running, Pending...)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | kubernetes.pod.status.ready        | Kubernetes pod ready status (true, false or unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | kubernetes.pod.status.ready_time   | Readiness achieved time in unix timestamp for a pod                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | double           |
  | kubernetes.pod.status.reason       | The reason the pod is in its current state (Evicted, NodeAffinity, NodeLost, Shutdown or UnexpectedAdmissionError)                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | kubernetes.pod.status.scheduled    | Kubernetes pod scheduled status (true, false, unknown)                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | kubernetes.pod.uid                 | Kubernetes pod UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | kubernetes.replicaset.name         | Kubernetes replicaset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | kubernetes.statefulset.name        | Kubernetes statefulset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | orchestrator.cluster.name          | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | orchestrator.cluster.url           | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | service.address                    | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | service.type                       | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### state_replicaset

This is the `state_replicaset` dataset of the Kubernetes package. It collects
Replicaset related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "kubernetes": {
          "namespace": "kube-system",
          "replicaset": {
              "replicas": {
                  "desired": 1,
                  "ready": 1,
                  "labeled": 1,
                  "available": 1,
                  "observed": 1
              },
              "name": "kube-state-metrics-599d598bdf"
          },
          "namespace_uid": "250a647d-3acc-4f7e-85b5-a51b6069959d",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "deployment": {
              "name": "kube-state-metrics"
          },
          "labels": {
              "pod-template-hash": "599d598bdf",
              "app_kubernetes_io/version": "2.5.0",
              "app_kubernetes_io/name": "kube-state-metrics",
              "app_kubernetes_io/component": "exporter"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "type": "metricbeat",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T14:40:26.856Z",
      "ecs": {
          "version": "8.0.0"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_replicaset"
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "type": "linux",
              "family": "debian",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "BA-D7-49-95-5A-F5",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "metricset": {
          "period": 10000,
          "name": "state_replicaset"
      },
      "event": {
          "duration": 394846,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T14:40:27Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_replicaset"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Metric Type |
  |------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                               | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |             |
  | agent.id                                 | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | cloud.account.id                         | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.availability_zone                  | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | cloud.image.id                           | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.id                        | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.name                      | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.machine.type                       | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |             |
  | cloud.project.id                         | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.provider                           | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.region                             | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | container.id                             | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | container.image.name                     | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |             |
  | container.labels                         | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |             |
  | container.name                           | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | data_stream.dataset                      | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |             |
  | data_stream.namespace                    | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |             |
  | data_stream.type                         | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |             |
  | ecs.version                              | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |             |
  | host.architecture                        | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | host.containerized                       | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |             |
  | host.domain                              | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | host.hostname                            | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |             |
  | host.id                                  | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.ip                                  | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |             |
  | host.mac                                 | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |             |
  | host.name                                | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.build                            | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.codename                         | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | host.os.family                           | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.kernel                           | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.os.name                             | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | host.os.name.text                        | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |             |
  | host.os.platform                         | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.version                          | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.type                                | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.annotations.*                 | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |             |
  | kubernetes.deployment.name               | Kubernetes deployment name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | kubernetes.labels.*                      | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |             |
  | kubernetes.namespace                     | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | kubernetes.namespace_labels.*            | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |             |
  | kubernetes.namespace_uid                 | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | kubernetes.replicaset.name               | Kubernetes replicaset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | kubernetes.replicaset.replicas.available | The number of replicas per ReplicaSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             | gauge       |
  | kubernetes.replicaset.replicas.desired   | The number of replicas per ReplicaSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             | gauge       |
  | kubernetes.replicaset.replicas.labeled   | The number of fully labeled replicas per ReplicaSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             | gauge       |
  | kubernetes.replicaset.replicas.observed  | The generation observed by the ReplicaSet controller                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             | gauge       |
  | kubernetes.replicaset.replicas.ready     | The number of ready replicas per ReplicaSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             | gauge       |
  | orchestrator.cluster.name                | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | orchestrator.cluster.url                 | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | service.address                          | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | service.type                             | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |             |
</dropdown>


### state_resourcequota

This is the `state_resourcequota` dataset of the Kubernetes package. It collects ResourceQuota related metrics
from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-06-25T12:45:04.416Z",
      "metricset": {
          "name": "state_resourcequota",
          "period": 10000
      },
      "service": {
          "address": "kube-state-metrics:8080",
          "type": "kubernetes"
      },
      "event": {
          "dataset": "kubernetes.state_resourcequota",
          "module": "kubernetes",
          "duration": 6324269
      },
      "agent": {
          "id": "a6147a6e-6626-4a84-9907-f372f6c61eee",
          "name": "agent-ingest-management-clusterscope-674dbb75df-rp8cc",
          "type": "metricbeat",
          "version": "8.0.0",
          "ephemeral_id": "644323b5-5d6a-4dfb-92dd-35ca602db487"
      },
      "ecs": {
          "version": "1.5.0"
      },
      "kubernetes": {
          "namespace": "quota-object-example",
          "resourcequota": {
              "name": "object-quota-demo",
              "resource": "persistentvolumeclaims",
              "type": "hard",
              "quota": 1
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Unit | Metric Type |
  |--------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|------|-------------|
  | @timestamp                           | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |      |             |
  | agent.id                             | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | cloud.account.id                     | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.availability_zone              | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | cloud.image.id                       | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.id                    | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.instance.name                  | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.machine.type                   | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |      |             |
  | cloud.project.id                     | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | cloud.provider                       | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | cloud.region                         | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | container.id                         | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | container.image.name                 | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |      |             |
  | container.labels                     | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |      |             |
  | container.name                       | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |      |             |
  | data_stream.dataset                  | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |      |             |
  | data_stream.namespace                | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |      |             |
  | data_stream.type                     | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |      |             |
  | ecs.version                          | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |      |             |
  | host.architecture                    | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |      |             |
  | host.containerized                   | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |      |             |
  | host.domain                          | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | host.hostname                        | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |      |             |
  | host.id                              | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.ip                              | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |      |             |
  | host.mac                             | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |      |             |
  | host.name                            | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.build                        | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.codename                     | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | host.os.family                       | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |      |             |
  | host.os.kernel                       | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |      |             |
  | host.os.name                         | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |      |             |
  | host.os.name.text                    | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |      |             |
  | host.os.platform                     | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.os.version                      | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |      |             |
  | host.type                            | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |      |             |
  | kubernetes.annotations.*             | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |      |             |
  | kubernetes.labels.*                  | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |      |             |
  | kubernetes.namespace                 | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | kubernetes.resourcequota.created.sec | Epoch seconds since the ResourceQuota was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | double           | s    | gauge       |
  | kubernetes.resourcequota.name        | ResourceQuota name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | kubernetes.resourcequota.quota       | Quota informed (hard or used) for the resource                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | double           |      | gauge       |
  | kubernetes.resourcequota.resource    | Resource name the quota applies to                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |      |             |
  | kubernetes.resourcequota.type        | Quota information type, `hard` or `used`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | orchestrator.cluster.name            | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |      |             |
  | orchestrator.cluster.url             | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |      |             |
  | service.address                      | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |      |             |
  | service.type                         | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |      |             |
</dropdown>


### state_service

This is the `state_service` dataset of the Kubernetes package. It collects
Service related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "kubernetes": {
          "service": {
              "created": "2021-12-15T16:57:18.000Z",
              "name": "kube-dns",
              "type": "ClusterIP",
              "cluster_ip": "10.96.0.10"
          },
          "namespace": "kube-system",
          "namespace_uid": "a4453575-518e-4a21-9909-34874f674177",
          "selectors": {
              "k8s-app": "kube-dns"
          },
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "kubernetes_io_cluster_service": "true",
              "kubernetes_io_name": "CoreDNS",
              "k8s_app": "kube-dns",
              "k8s-app": "kube-dns",
              "kubernetes_io/cluster-service": "true",
              "kubernetes_io/name": "CoreDNS"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "type": "metricbeat",
          "ephemeral_id": "22ed892c-43bd-408a-9121-65e2f5b6a56e",
          "version": "8.1.0"
      },
      "elastic_agent": {
          "id": "de42127b-4db8-4471-824e-a7b14f478663",
          "version": "8.1.0",
          "snapshot": true
      },
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "@timestamp": "2021-12-20T10:04:34.632Z",
      "ecs": {
          "version": "8.0.0"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_service"
      },
      "metricset": {
          "period": 10000,
          "name": "state_service"
      },
      "event": {
          "duration": 187211,
          "agent_id_status": "verified",
          "ingested": "2021-12-20T10:04:35Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_service"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | agent.id                            | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.account.id                    | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone             | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                      | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                   | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                 | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                  | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                    | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                      | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                        | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                        | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                    | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                      | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                 | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace               | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                    | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | ecs.version                         | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |
  | host.architecture                   | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                  | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                         | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                       | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                             | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                             | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                            | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                           | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                       | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                    | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                      | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                      | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                        | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                   | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                    | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                     | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                           | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | kubernetes.annotations.*            | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |
  | kubernetes.labels.*                 | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |
  | kubernetes.namespace                | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | kubernetes.namespace_annotations.*  | Kubernetes namespace annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | object           |
  | kubernetes.namespace_labels.*       | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |
  | kubernetes.namespace_uid            | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | kubernetes.selectors.*              | Kubernetes Service selectors map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | object           |
  | kubernetes.service.cluster_ip       | Internal IP for the service.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | kubernetes.service.created          | Service creation date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | date             |
  | kubernetes.service.external_ip      | Service external IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | kubernetes.service.external_name    | Service external DNS name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | kubernetes.service.ingress_hostname | Ingress Hostname                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | kubernetes.service.ingress_ip       | Ingress IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | kubernetes.service.load_balancer_ip | Load Balancer service IP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | kubernetes.service.name             | Service name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | kubernetes.service.type             | Service type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | orchestrator.cluster.name           | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | orchestrator.cluster.url            | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | service.address                     | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | service.type                        | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### state_statefulset

This is the `state_statefulset` dataset of the Kubernetes package.
<dropdown title="Example">
  ```json
  {
      "orchestrator": {
          "cluster": {
              "name": "kind",
              "url": "kind-control-plane:6443"
          }
      },
      "kubernetes": {
          "statefulset": {
              "generation": {
                  "desired": 1,
                  "observed": 1
              },
              "replicas": {
                  "desired": 1,
                  "ready": 1,
                  "observed": 1
              },
              "created": 1671791408,
              "name": "prometheus-1-alertmanager"
          },
          "namespace": "kube-system",
          "namespace_uid": "250a647d-3acc-4f7e-85b5-a51b6069959d",
          "namespace_labels": {
              "kubernetes_io/metadata_name": "kube-system"
          },
          "labels": {
              "app_kubernetes_io/managed-by": "Helm",
              "helm_sh/chart": "alertmanager-0.22.2",
              "app_kubernetes_io/version": "v0.24.0",
              "app_kubernetes_io/name": "alertmanager",
              "app_kubernetes_io/instance": "prometheus-1"
          }
      },
      "agent": {
          "name": "kind-control-plane",
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "type": "metricbeat",
          "ephemeral_id": "b61db5f9-8e5a-4ec2-b73f-dd4ee1537110",
          "version": "8.6.0"
      },
      "@timestamp": "2023-01-18T15:00:26.890Z",
      "ecs": {
          "version": "8.0.0"
      },
      "data_stream": {
          "namespace": "default",
          "type": "metrics",
          "dataset": "kubernetes.state_statefulset"
      },
      "service": {
          "address": "http://kube-state-metrics:8080/metrics",
          "type": "kubernetes"
      },
      "host": {
          "hostname": "kind-control-plane",
          "os": {
              "kernel": "5.10.104-linuxkit",
              "codename": "focal",
              "name": "Ubuntu",
              "type": "linux",
              "family": "debian",
              "version": "20.04.5 LTS (Focal Fossa)",
              "platform": "ubuntu"
          },
          "containerized": false,
          "ip": [
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "172.18.0.2",
              "fc00:f853:ccd:e793::2",
              "fe80::42:acff:fe12:2",
              "10.244.0.1",
              "172.21.0.2",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1",
              "10.244.0.1"
          ],
          "name": "kind-control-plane",
          "id": "ee94d9f5b385448b805141d2b007ef9e",
          "mac": [
              "02-42-AC-12-00-02",
              "02-42-AC-15-00-02",
              "26-44-88-00-0A-01",
              "36-29-00-36-7F-53",
              "52-A2-77-CF-D4-EC",
              "62-BC-CF-94-14-6C",
              "8E-B9-C8-09-2D-B8",
              "92-BA-04-F3-2A-CC",
              "A2-55-7D-53-57-91",
              "A6-4F-D1-E2-1E-12",
              "B6-ED-00-D6-1B-B8",
              "CA-B9-E6-A7-52-0D",
              "D6-F9-71-43-6C-24",
              "DE-05-63-F9-0B-36",
              "EE-C8-E8-11-00-F5",
              "F6-52-0A-F0-63-83"
          ],
          "architecture": "x86_64"
      },
      "elastic_agent": {
          "id": "c446ee97-62f8-47db-ac88-ada92aa550a0",
          "version": "8.6.0",
          "snapshot": false
      },
      "metricset": {
          "period": 10000,
          "name": "state_statefulset"
      },
      "event": {
          "duration": 183204,
          "agent_id_status": "verified",
          "ingested": "2023-01-18T15:00:27Z",
          "module": "kubernetes",
          "dataset": "kubernetes.state_statefulset"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             | Metric Type |
  |--------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |             |
  | agent.id                                   | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | cloud.account.id                           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.availability_zone                    | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.id                          | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.instance.name                        | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.machine.type                         | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |             |
  | cloud.project.id                           | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | cloud.provider                             | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | cloud.region                               | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | container.id                               | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | container.image.name                       | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |             |
  | container.labels                           | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |             |
  | container.name                             | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |             |
  | data_stream.dataset                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |             |
  | data_stream.namespace                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |             |
  | data_stream.type                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |             |
  | ecs.version                                | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |             |
  | host.architecture                          | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |             |
  | host.containerized                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |             |
  | host.domain                                | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |             |
  | host.hostname                              | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |             |
  | host.id                                    | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.ip                                    | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |             |
  | host.mac                                   | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |             |
  | host.name                                  | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.build                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.codename                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | host.os.family                             | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |             |
  | host.os.kernel                             | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |             |
  | host.os.name                               | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | host.os.name.text                          | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |             |
  | host.os.platform                           | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.os.version                            | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |             |
  | host.type                                  | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |             |
  | kubernetes.annotations.*                   | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |             |
  | kubernetes.labels.*                        | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |             |
  | kubernetes.namespace                       | Kubernetes namespace                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | kubernetes.namespace_labels.*              | Kubernetes namespace labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |             |
  | kubernetes.namespace_uid                   | Kubernetes namespace UID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | kubernetes.statefulset.created             | The creation timestamp (epoch) for StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             | gauge       |
  | kubernetes.statefulset.generation.desired  | The desired generation per StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             | gauge       |
  | kubernetes.statefulset.generation.observed | The observed generation per StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             | gauge       |
  | kubernetes.statefulset.name                | Kubernetes statefulset name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |             |
  | kubernetes.statefulset.replicas.desired    | The number of desired replicas per StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             | gauge       |
  | kubernetes.statefulset.replicas.observed   | The number of observed replicas per StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             | gauge       |
  | kubernetes.statefulset.replicas.ready      | The number of ready replicas per StatefulSet                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | long             | gauge       |
  | orchestrator.cluster.name                  | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |             |
  | orchestrator.cluster.url                   | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |             |
  | service.address                            | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |             |
  | service.type                               | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |             |
</dropdown>


### state_storageclass

This is the `state_storageclass` dataset of the Kubernetes package. It collects
StorageClass related metrics from `kube_state_metrics`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-06-25T12:39:44.399Z",
      "agent": {
          "name": "agent-ingest-management-clusterscope-674dbb75df-rp8cc",
          "type": "metricbeat",
          "version": "8.0.0",
          "ephemeral_id": "644323b5-5d6a-4dfb-92dd-35ca602db487",
          "id": "a6147a6e-6626-4a84-9907-f372f6c61eee"
      },
      "kubernetes": {
          "storageclass": {
              "provisioner": "k8s.io/minikube-hostpath",
              "reclaim_policy": "Delete",
              "volume_binding_mode": "Immediate",
              "name": "standard",
              "created": "2020-06-10T09:02:27.000Z"
          },
          "labels": {
              "addonmanager_kubernetes_io_mode": "EnsureExists"
          }
      },
      "event": {
          "module": "kubernetes",
          "duration": 5713503,
          "dataset": "kubernetes.state_storageclass"
      },
      "metricset": {
          "name": "state_storageclass",
          "period": 10000
      },
      "service": {
          "address": "kube-state-metrics:8080",
          "type": "kubernetes"
      },
      "ecs": {
          "version": "1.5.0"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | agent.id                                    | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.account.id                            | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone                     | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                           | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                         | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                          | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                            | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                              | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                                | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                                | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                        | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                            | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                              | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | ecs.version                                 | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                | keyword          |
  | host.architecture                           | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                                 | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                               | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                                     | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                                     | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                                    | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                                   | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                              | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                              | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                                | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                           | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                            | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                             | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                                   | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | kubernetes.annotations.*                    | Kubernetes annotations map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | object           |
  | kubernetes.labels.*                         | Kubernetes labels map                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | object           |
  | kubernetes.storageclass.created             | Storage class creation date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | kubernetes.storageclass.name                | Storage class name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | kubernetes.storageclass.provisioner         | Volume provisioner for the storage class.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | kubernetes.storageclass.reclaim_policy      | Reclaim policy for dynamically created volumes                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | kubernetes.storageclass.volume_binding_mode | Mode for default provisioning and binding                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | orchestrator.cluster.name                   | Name of the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | orchestrator.cluster.url                    | URL of the API used to manage the cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | service.address                             | Address where data about this service was collected from. This should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | service.type                                | The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Metricbeat Kubernetes Overview](https://epr.elastic.co/package/kubernetes/1.84.1/img/metricbeat_kubernetes_overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version           | Details                                                                                                                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |-------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.84.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/17196))Add AWS authentication variables for CloudWatch input in audit_logs data stream and fix api_timeout variable name typo.                                                                                                                                                                    | 9.3.09.2.49.1.10       |
  | **1.84.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16680))Add kubernetes.container.status.last_terminated_exitcode field to the state_container data stream.                                                                                                                                                                                       | 9.3.09.2.49.1.10       |
  | **1.83.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16581))Update the container logs documentation on how to ingest rotated logs, including GZIP-compressed logs.                                                                                                                                                                                   | 9.0.08.15.0            |
  | **1.82.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16497))Fix field rename error in audit logs ingest pipeline.                                                                                                                                                                                                                                        | 9.0.08.15.0            |
  | **1.82.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15793))Allow to configure container_logs input id and update container logs documentation to include how to ingest rotated log files.                                                                                                                                                           | 9.0.08.15.0            |
  | **1.81.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15585))Fix processing of Azure AKS audit logs.                                                                                                                                                                                                                                                      | 9.0.08.15.0            |
  | **1.81.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14554))Support for collecting audit logs from cloud providers.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13008))Fixed typos in ssl node descriptions in manifest.yml files.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12756))Added description to ssl.certificate_authorities and ssl.verification_mode, including links to documentation.                                                                                                                                                                                | 9.0.08.15.0            |
  | **1.80.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12535))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                           | 9.0.08.15.0            |
  | **1.70.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12538))Update the container logs documentation                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12404))Fix kubernetes.pod.cpu.usage.nanocores unit                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12274))Make fingerprint configurable                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.69.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12227))Added datatype for audit log field annotations.pod-security_kubernetes_io/audit-violation                                                                                                                                                                                                | 8.15.0                 |
  | **1.68.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11243))Fix Overview dashboard Kibana id                                                                                                                                                                                                                                                             | 8.15.0                 |
  | **1.68.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11212))Use filestream fingerprint mode by default for container_logs datastream                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.67.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10593))Add both pod.{cpu,memory}.usage.node.pct and pod.{cpu,memory}.usage.limit.pct metrics to the Overview dashboard                                                                                                                                                                          | 8.15.0                 |
  | **1.66.4**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10893))Updating Cluster Overview Dashboard to use container.id as filter and replaced median functions from visualisations                                                                                                                                                                          | 8.15.0                 |
  | **1.66.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10713))Updating mapping of the field groups to keyword in kubernetes.audit_logs                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.66.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10548))Fixing missing processor block in kubernetes.audit_logs                                                                                                                                                                                                                                      | 8.15.0                 |
  | **1.66.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10535))Fixing Title in Volumes Dashboard                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.66.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10267))Adding Volume Usage per pod in Kubernetes Volume Dashboard                                                                                                                                                                                                                               | 8.15.0                 |
  | **1.65.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10503))Add last_terminated_timestamp metric to the kubernetes.state_container datastream                                                                                                                                                                                                        | 8.15.0                 |
  | **1.64.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10213))Move namespace filter to the group level configuration                                                                                                                                                                                                                                   | 8.15.0                 |
  | **1.63.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10421))Fix typo in kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.63.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10406))Add pod.status_reason and pod.status.ready_time fields to the state_pod datastream                                                                                                                                                                                                       | 8.15.0                 |
  | **1.62.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10396))Fix kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                         | 8.14.0                 |
  | **1.62.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10138))Add new mappings to the kubernetes.audit datastream                                                                                                                                                                                                                                      | 8.14.0                 |
  | **1.61.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9780))Remove percent unit for pod memory metrics                                                                                                                                                                                                                                                    | 8.14.0                 |
  | **1.61.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9736))Remove deprecated fields and add missing status.last_terminated_reason metric                                                                                                                                                                                                             | 8.14.0                 |
  | **1.60.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9685))Updating `Memory used vs total memory` and `Cores used vs total cores` visualisations in Cluster Overview Dashboard                                                                                                                                                                           | 8.14.0                 |
  | **1.59.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Add metadata fields to state_namespace data stream.                                                                                                                                                                                                                                       | 8.14.0                 |
  | **1.58.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Migrate to format_version v3.                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.57.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9036))Container logs preserve original content based on pod annotations.                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.56.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8835))Add new fields to API server, state_node and persistent volume claim data streams.                                                                                                                                                                                                        | 8.12.0                 |
  | **1.55.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8697))Modify the field definitions to reference ECS.                                                                                                                                                                                                                                            | 8.11.0                 |
  | **1.55.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Remove extra base fields from state data streams.                                                                                                                                                                                                                                         | 8.11.0                 |
  | **1.54.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7395))Expand condition support to remaining inputs                                                                                                                                                                                                                                              | 8.11.0                 |
  | **1.53.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8337))Update size of the metric visualizations                                                                                                                                                                                                                                                  | 8.11.0                 |
  | **1.52.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Add new data stream state_namespace.                                                                                                                                                                                                                                                      | 8.11.0                 |
  | **1.51.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8265))Migrate `Deployments` dashboard visualizations to lens.                                                                                                                                                                                                                                   | 8.10.2                 |
  | **1.50.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8263))Migrate `Cronjobs` dashboard visualizations to lens                                                                                                                                                                                                                                       | 8.10.2                 |
  | **1.49.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8266))Migrate `DaemonSets` dashboard visualizations to lens.                                                                                                                                                                                                                                    | 8.10.2                 |
  | **1.48.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8264))Migrate `StatefulSets` dashboard visualizations to lens.                                                                                                                                                                                                                                  | 8.10.2                 |
  | **1.47.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8262))Migrate `Jobs` dashboard visualizations to lens.                                                                                                                                                                                                                                          | 8.10.2                 |
  | **1.46.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8068))Adapt fields for changes in file system info                                                                                                                                                                                                                                              | 8.10.1                 |
  | **1.45.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7118))Reroute container logs based on pod annotations.                                                                                                                                                                                                                                          | 8.10.0                 |
  | **1.44.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6821))Introducing kubernetes.deployment.status.* metrics                                                                                                                                                                                                                                        | 8.10.0                 |
  | **1.43.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6933))Updating index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                | 8.8.0                  |
  | **1.43.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6603))Expand index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                  | 8.8.0                  |
  | **1.42.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for container_logs datastream                                                                                                                                                                                                               | 8.8.0                  |
  | **1.41.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6332))Enable time series data streams for the metrics datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html) | 8.8.0                  |
  | **1.40.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6310))Fix system tests for kubernetes integration for k8s v1.27.0                                                                                                                                                                                                                                   | 8.8.0                  |
  | **1.40.0-beta.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6292))Fix volume dashboard.                                                                                                                                                                                                                                                                         |                        |
  | **1.40.0-beta.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6221))Fix proxy and scheduler visualization with missing sort field.                                                                                                                                                                                                                                |                        |
  | **1.40.0-beta**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6159))Enable TSDS for metrics data_streams, except events for beta testing                                                                                                                                                                                                                      |                        |
  | **1.39.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6209))Remove container.name as a dimension.                                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.38.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6196))Switch max to last value on counter formulas and add missing sort field to proxy, controller manager and scheduler dashboard.                                                                                                                                                             | 8.6.1                  |
  | **1.38.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6171))Fix Pod dashboard and remove some visualisations from Api Server dashboard to support TSDB migration                                                                                                                                                                                      | 8.6.1                  |
  | **1.37.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5992))Update proxy, controller manager and scheduler dashboard to support TSDB.                                                                                                                                                                                                                 | 8.6.1                  |
  | **1.36.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6108))Add container.name dimension to container data stream                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.35.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5760))Add NetworkUnavailable condition to state node                                                                                                                                                                                                                                            | 8.6.1                  |
  | **1.34.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5464))Add support for TSDB on all metric data streams except the state ones                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.34.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5621))Add support for TSDB on all state metric data streams                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.33.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5555))Add `data_stream.dataset` setting and custom yaml input.                                                                                                                                                                                                                                  | 8.6.1                  |
  | **1.32.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5586))Added link to docs for condition filter                                                                                                                                                                                                                                                   | 8.6.1                  |
  | **1.32.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                    | 8.6.1                  |
  | **1.32.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5364))Add documentation for how to install alerts                                                                                                                                                                                                                                               | 8.6.1                  |
  | **1.31.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5161))Add system testing for state service datastream                                                                                                                                                                                                                                           | 8.6.1                  |
  | **1.31.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4948))Update controller manager, proxy and scheduler metrics and dashboards                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.31.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4972))Use datas_tream.dataset as pre filters for dashboards and remove tags                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.30.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5044))Add missing namespace_uid and namespace_labels fields                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.29.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4756))Fix function for memory node usage                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.29.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4714))Fix removed condition setting for container_logs                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.29.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4691))Remove "Control Plane" column from Node Information table                                                                                                                                                                                                                                     | 8.5.0                  |
  | **1.28.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4671))Fix Pod Memory usage panel title                                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.28.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4672))Delete statefulset, job and cronjob visualizations from Cluster Overview dashboard                                                                                                                                                                                                        | 8.5.0                  |
  | **1.28.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4646))Adding banner for Kube-state metrics                                                                                                                                                                                                                                                      | 8.5.0                  |
  | **1.27.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4544))Fix typo in cluster overview dashboard                                                                                                                                                                                                                                                    | 8.5.0                  |
  | **1.27.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))New cluster overview dashboard                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.26.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))Add `processors` configuration option for Kubernetes data_streams                                                                                                                                                                                                                         | 8.4.0                  |
  | **1.25.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4324))Add `condition` configuration option to container logs data stream                                                                                                                                                                                                                        | 8.4.0                  |
  | **1.24.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4203))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.23.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4144))Add missing dimension fields                                                                                                                                                                                                                                                              | 8.4.0                  |
  | **1.23.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4081))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.22.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4095))Fix overlapping fields in state_job data stream                                                                                                                                                                                                                                           | 8.4.0                  |
  | **1.22.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3825))Update apiserver and controllermanaged deprecated fields and dashboards                                                                                                                                                                                                                   | 8.4.0                  |
  | **1.21.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3672))add container ID and pod name as part of Kubernetes Cotainer Logs filestream input                                                                                                                                                                                                            | 8.3.0                  |
  | **1.21.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3139))improved the wording of the link to Kubernetes documentation                                                                                                                                                                                                                              | 8.3.0                  |
  | **1.21.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3115))Add new dashboards                                                                                                                                                                                                                                                                        | 8.3.0                  |
  | **1.20.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3414))Change fields type for audit_logs data_stream to use `requestObject` and `responseObject` fields of audit events. Disable dynamic mapping for audit_logs data_stream. Drop `kubernetes.audit.responseObject.metadata` and `kubernetes.audit.requestObject.metadata`                       | 8.2.0                  |
  | **1.19.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3029))Add documentation for volume field                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.19.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3054))Add missed ecs fields                                                                                                                                                                                                                                                                     | 8.2.0                  |
  | **1.18.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.18.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2876))Fix k8s overview dashboard                                                                                                                                                                                                                                                                | 8.2.0                  |
  | **1.17.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2827))Remove incorrectly tagged boolean dimension                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2702))Add missing metadata fields                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2694))Improve default ndjson parser configuration                                                                                                                                                                                                                                               |                        |
  | **1.17.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2675))Disable audit logs collection by default                                                                                                                                                                                                                                                  |                        |
  | **1.16.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2657))Documentation improvements                                                                                                                                                                                                                                                                |                        |
  | **1.15.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2613))Add ssl.certificate_authorities configuration                                                                                                                                                                                                                                             |                        |
  | **1.14.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2625))Add missing job.name and cronjob.name fields to state_container datastream                                                                                                                                                                                                                    |                        |
  | **1.14.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2612))Add missing job.name and cronjob.name fields to container related datastreams                                                                                                                                                                                                                 |                        |
  | **1.14.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2608))Add missing job.name and cronjob.name fields added by metadata generators                                                                                                                                                                                                                     |                        |
  | **1.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2567))Tune state_metrics settings                                                                                                                                                                                                                                                               |                        |
  | **1.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2491))Update to ECS 8.0                                                                                                                                                                                                                                                                         |                        |
  | **1.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2370))Expose add_recourse_metadata configuration option                                                                                                                                                                                                                                         |                        |
  | **1.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2469))Add memory.working_set.limit.pct for pod and container data streams                                                                                                                                                                                                                       |                        |
  | **1.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2377))Add leader election in state_job data stream                                                                                                                                                                                                                                              |                        |
  | **1.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2361))Add missing fields                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.8.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2288))Set kubernetes.volume.fs.used.pct to scaled_float                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2345))Support json logs parsing                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2317))Add new audit logs data stream in kubernetes integration                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2342))Add skip_older option for event datastream                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2209))Revert Kubernetes namespace field breaking change                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.4.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2076))Add dimension fields                                                                                                                                                                                                                                                                      |                        |
  | **1.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2151))Remove overriding of index pattern on the Kubernetes overview dashboard                                                                                                                                                                                                                   | 8.0.0                  |
  | **1.4.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2139))Use filestream input for container_logs data stream                                                                                                                                                                                                                                       |                        |
  | **1.3.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2041))Fix conditions of data_streams that are based on k8s labels & add condition in pipelines                                                                                                                                                                                                      |                        |
  | **1.3.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Set default host for proxy to localhost                                                                                                                                                                                                                                                   |                        |
  | **1.3.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Uniform with guidelines                                                                                                                                                                                                                                                                   |                        |
  | **1.3.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2033))Add container_logs ecs fields                                                                                                                                                                                                                                                             |                        |
  | **1.2.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2031))Update Kubernetes cluster_ip field type                                                                                                                                                                                                                                                       |                        |
  | **1.2.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1792))Update Kubernetes namespace field                                                                                                                                                                                                                                                         |                        |
  | **1.1.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1890))Update Kubernetes integration Readme                                                                                                                                                                                                                                                          |                        |
  | **1.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1696))Update to ECS 1.12.0                                                                                                                                                                                                                                                                      | 7.15.0                 |
  | **1.0.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1610))Release Kubernetes as GA                                                                                                                                                                                                                                                                  |                        |
  | **0.14.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1565))Update default host in kubernetes proxy data stream in kubernetes integration                                                                                                                                                                                                             |                        |
  | **0.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Add new container logs data stream in kubernetes integration                                                                                                                                                                                                                              |                        |
  | **0.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Leverage dynamic kubernetes provider for controller and scheduler datastream                                                                                                                                                                                                              |                        |
  | **0.12.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1459))Add missing field "kubernetes.daemonset.name" field for pod and container data streams                                                                                                                                                                                                        |                        |
  | **0.12.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1413))Add missing cluster filter for "orchestrator.cluster.name" field in [Metrics Kubernetes] Overview dashboard and Dashboard section in the integration overview page                                                                                                                            |                        |
  | **0.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1407))Update kubernetes package ecs fields with orchestrator.cluster.url and orchestrator.cluster.name                                                                                                                                                                                          |                        |
  | **0.11.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                         |                        |
  | **0.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1401))Update documentation to fit mdx spec                                                                                                                                                                                                                                                      |                        |
  | **0.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                            |                        |
  | **0.9.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1335))Add missing field "kubernetes.daemonset.name" field for state_pod and state_container                                                                                                                                                                                                         |                        |
  | **0.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Enhance kubernetes package with state_job data stream                                                                                                                                                                                                                                     |                        |
  | **0.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1321))Leverage leader election in kubernetes integration                                                                                                                                                                                                                                        |                        |
  | **0.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1289))Add _meta information to Kubernetes fields                                                                                                                                                                                                                                                |                        |
  | **0.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Introduce kubernetes package granularity using input_groups                                                                                                                                                                                                                               |                        |
  | **0.5.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1160))Add missing field "kubernetes.statefulset.replicas.ready"                                                                                                                                                                                                                                 |                        |
  | **0.5.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/998))Fix stack compatability                                                                                                                                                                                                                                                                        |                        |
  | **0.5.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/970))Fix references to env variables                                                                                                                                                                                                                                                                |                        |
  | **0.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/886))Add missing field "kubernetes.selectors.*" and extra https settings for controllermanager and scheduler datastreams                                                                                                                                                                        |                        |
  | **0.4.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing field "kubernetes.pod.ip"                                                                                                                                                                                                                                                      |                        |
  | **0.4.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                     |                        |
  | **0.4.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                     |                        |
  | **0.4.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/749))Change kibana.version constraint to be more conservative.                                                                                                                                                                                                                                      |                        |
  | **0.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/745))Add missing fields                                                                                                                                                                                                                                                                         |                        |
  | **0.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/70))initial release                                                                                                                                                                                                                                                                             |                        |
</dropdown>