﻿---
title: container-logs
description: container-logs integration collects and parses logs of Kubernetes containers. It requires access to the log files in each Kubernetes node where the container...
url: https://www.elastic.co/docs/reference/integrations/kubernetes/container-logs
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# container-logs
|                                                                            |                                                         |
|----------------------------------------------------------------------------|---------------------------------------------------------|
| **Version**                                                                | 1.84.1 ([View all](#changelog))                         |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                                                   |
| **Ingestion method(s)**                                                    | API, AWS CloudWatch, Azure Event Hub, File, GCP Pub/Sub |
| **Minimum Kibana version(s)**                                              | 9.3.09.2.49.1.10                                        |

container-logs integration collects and parses logs of Kubernetes containers.
It requires access to the log files in each Kubernetes node where the container logs are stored.
This defaults to `/var/log/containers/*${kubernetes.container.id}.log`.
By default, only [container parser](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-filestream.html#_parsers) is enabled. Additional log parsers can be added as an advanced options configuration.

## Ingesting Rotated Container Logs> 9.3.0 and later: GA, 9.2.0: Beta

The integration can monitor and ingest rotated Kubernetes container logs, including
on-the-fly decompression of GZIP archives. To enable this:

### 9.3 and later

- change the `ID` to `kubernetes-container-logs-${kubernetes.pod.uid}-${kubernetes.container.name}`
- add `compression: auto` under `Advanced options > Custom configurations`. Refer to
  [filestream documentation on reading GZIP files](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-filestream.html) for details.
- set the path to `/var/log/pods/${kubernetes.namespace}_${kubernetes.pod.name}_${kubernetes.pod.uid}/${kubernetes.container.name}/*.log*`. Refer to the official
  [Kubernetes documentation on log rotation](https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation) for details on the log rotation mechanism and file naming convention.


### 9.2.x

- change the `ID` to `kubernetes-container-logs-${kubernetes.pod.uid}-${kubernetes.container.name}`
- add `gzip_experimental: true` under `Advanced options > Custom configurations`. Refer to
  [filestream documentation on reading GZIP files](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-filestream.html) for details.
- set the path to `/var/log/pods/${kubernetes.namespace}_${kubernetes.pod.name}_${kubernetes.pod.uid}/${kubernetes.container.name}/*.log*`. Refer to the official
  [Kubernetes documentation on log rotation](https://kubernetes.io/docs/concepts/cluster-administration/logging/#log-rotation) for details on the log rotation mechanism and file naming convention.

<important>
  Data Duplication: When you change the path on an existing integration,
  the Elastic Agent reads all existing files in the new directory from the beginning.
  This action causes a one-time re-ingestion of the log files.After the initial scan, the Elastic Agent tracks files normally and will only
  ingest new log data.
</important>


## Rerouting and preserve original event based on pod annotations

You can customize the routing of container logs events and sending them to different datasets and namespaces,
as well as enable `preserve_original_event` based on using pods' annotations.
Customization can happen at:
- pod definition time, e.g., using a deployment.
- pod runtime, annotating pods using `kubectl`.


### Set at pod definition time

Here is an example of an Nginx deployment where we set both `elastic.co/dataset` and `elastic.co/namespace` annotations to route the container logs to specific datasets and namespace, respectively.
```yaml
# nginx-deployment.yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: nginx-deployment
spec:
  replicas: 1
  selector:
    matchLabels:
      app: nginx
  template:
    metadata:
      annotations:
        elastic.co/dataset: kubernetes.container_logs.nginx
        elastic.co/namespace: nginx
        elastic.co/preserve_original_event: "true"
      labels:
        app: nginx
        app.kubernetes.io/name: myservice
        app.kubernetes.io/version: v0.1.2
        app.kubernetes.io/instance: myservice-abcxzy
    spec:
      containers:
        - name: nginx-container
          image: nginx:latest
          ports:
            - containerPort: 80
```


### Set at runtime

Suppose you want to change the container logs routing and enable `preserve_original_event` on a running container.
In that case, you can annotate the pod using `kubectl`, and the integration will apply it immediately sending all the following documents to the new destination:
Here is an example where we route the container logs for a pod running the Elastic Agent to the `kubernetes.container_logs.agents` dataset:
```shell
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/dataset=kubernetes.container_logs.agents
```

Here's a similar example to change the namespace on a pod running Nginx:
```shell
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/namespace=nginx
```

Here is an example to enable `preserve_original_event` on a pod running Nginx:
```shell
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/preserve_original_event=true
```

You can restore the standard settings by removing the annotations:
```shell
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/dataset-
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/namespace-
kubectl annotate pods elastic-agent-managed-daemonset-6p22g elastic.co/preserve_original_event-
```


### Annotations Reference

Here are the annotations available to customize routing:

| Label                                | Description                                                                                    |
|--------------------------------------|------------------------------------------------------------------------------------------------|
| `elastic.co/dataset`                 | Defines the target data stream's dataset for this pod.                                         |
| `elastic.co/namespace`               | Defines the target data stream's namespace for this pod.                                       |
| `elastic.co/preserve_original_event` | Enables 'preserve_original_event' for this pod. Use string 'true' (case-insensitive) to enable |


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Metricbeat Kubernetes Overview](https://epr.elastic.co/package/kubernetes/1.84.1/img/metricbeat_kubernetes_overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version           | Details                                                                                                                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |-------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.84.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/17196))Add AWS authentication variables for CloudWatch input in audit_logs data stream and fix api_timeout variable name typo.                                                                                                                                                                    | 9.3.09.2.49.1.10       |
  | **1.84.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16680))Add kubernetes.container.status.last_terminated_exitcode field to the state_container data stream.                                                                                                                                                                                       | 9.3.09.2.49.1.10       |
  | **1.83.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16581))Update the container logs documentation on how to ingest rotated logs, including GZIP-compressed logs.                                                                                                                                                                                   | 9.0.08.15.0            |
  | **1.82.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16497))Fix field rename error in audit logs ingest pipeline.                                                                                                                                                                                                                                        | 9.0.08.15.0            |
  | **1.82.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15793))Allow to configure container_logs input id and update container logs documentation to include how to ingest rotated log files.                                                                                                                                                           | 9.0.08.15.0            |
  | **1.81.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15585))Fix processing of Azure AKS audit logs.                                                                                                                                                                                                                                                      | 9.0.08.15.0            |
  | **1.81.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14554))Support for collecting audit logs from cloud providers.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13008))Fixed typos in ssl node descriptions in manifest.yml files.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12756))Added description to ssl.certificate_authorities and ssl.verification_mode, including links to documentation.                                                                                                                                                                                | 9.0.08.15.0            |
  | **1.80.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12535))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                           | 9.0.08.15.0            |
  | **1.70.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12538))Update the container logs documentation                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12404))Fix kubernetes.pod.cpu.usage.nanocores unit                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12274))Make fingerprint configurable                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.69.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12227))Added datatype for audit log field annotations.pod-security_kubernetes_io/audit-violation                                                                                                                                                                                                | 8.15.0                 |
  | **1.68.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11243))Fix Overview dashboard Kibana id                                                                                                                                                                                                                                                             | 8.15.0                 |
  | **1.68.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11212))Use filestream fingerprint mode by default for container_logs datastream                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.67.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10593))Add both pod.{cpu,memory}.usage.node.pct and pod.{cpu,memory}.usage.limit.pct metrics to the Overview dashboard                                                                                                                                                                          | 8.15.0                 |
  | **1.66.4**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10893))Updating Cluster Overview Dashboard to use container.id as filter and replaced median functions from visualisations                                                                                                                                                                          | 8.15.0                 |
  | **1.66.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10713))Updating mapping of the field groups to keyword in kubernetes.audit_logs                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.66.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10548))Fixing missing processor block in kubernetes.audit_logs                                                                                                                                                                                                                                      | 8.15.0                 |
  | **1.66.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10535))Fixing Title in Volumes Dashboard                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.66.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10267))Adding Volume Usage per pod in Kubernetes Volume Dashboard                                                                                                                                                                                                                               | 8.15.0                 |
  | **1.65.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10503))Add last_terminated_timestamp metric to the kubernetes.state_container datastream                                                                                                                                                                                                        | 8.15.0                 |
  | **1.64.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10213))Move namespace filter to the group level configuration                                                                                                                                                                                                                                   | 8.15.0                 |
  | **1.63.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10421))Fix typo in kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.63.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10406))Add pod.status_reason and pod.status.ready_time fields to the state_pod datastream                                                                                                                                                                                                       | 8.15.0                 |
  | **1.62.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10396))Fix kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                         | 8.14.0                 |
  | **1.62.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10138))Add new mappings to the kubernetes.audit datastream                                                                                                                                                                                                                                      | 8.14.0                 |
  | **1.61.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9780))Remove percent unit for pod memory metrics                                                                                                                                                                                                                                                    | 8.14.0                 |
  | **1.61.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9736))Remove deprecated fields and add missing status.last_terminated_reason metric                                                                                                                                                                                                             | 8.14.0                 |
  | **1.60.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9685))Updating `Memory used vs total memory` and `Cores used vs total cores` visualisations in Cluster Overview Dashboard                                                                                                                                                                           | 8.14.0                 |
  | **1.59.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Add metadata fields to state_namespace data stream.                                                                                                                                                                                                                                       | 8.14.0                 |
  | **1.58.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Migrate to format_version v3.                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.57.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9036))Container logs preserve original content based on pod annotations.                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.56.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8835))Add new fields to API server, state_node and persistent volume claim data streams.                                                                                                                                                                                                        | 8.12.0                 |
  | **1.55.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8697))Modify the field definitions to reference ECS.                                                                                                                                                                                                                                            | 8.11.0                 |
  | **1.55.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Remove extra base fields from state data streams.                                                                                                                                                                                                                                         | 8.11.0                 |
  | **1.54.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7395))Expand condition support to remaining inputs                                                                                                                                                                                                                                              | 8.11.0                 |
  | **1.53.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8337))Update size of the metric visualizations                                                                                                                                                                                                                                                  | 8.11.0                 |
  | **1.52.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Add new data stream state_namespace.                                                                                                                                                                                                                                                      | 8.11.0                 |
  | **1.51.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8265))Migrate `Deployments` dashboard visualizations to lens.                                                                                                                                                                                                                                   | 8.10.2                 |
  | **1.50.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8263))Migrate `Cronjobs` dashboard visualizations to lens                                                                                                                                                                                                                                       | 8.10.2                 |
  | **1.49.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8266))Migrate `DaemonSets` dashboard visualizations to lens.                                                                                                                                                                                                                                    | 8.10.2                 |
  | **1.48.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8264))Migrate `StatefulSets` dashboard visualizations to lens.                                                                                                                                                                                                                                  | 8.10.2                 |
  | **1.47.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8262))Migrate `Jobs` dashboard visualizations to lens.                                                                                                                                                                                                                                          | 8.10.2                 |
  | **1.46.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8068))Adapt fields for changes in file system info                                                                                                                                                                                                                                              | 8.10.1                 |
  | **1.45.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7118))Reroute container logs based on pod annotations.                                                                                                                                                                                                                                          | 8.10.0                 |
  | **1.44.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6821))Introducing kubernetes.deployment.status.* metrics                                                                                                                                                                                                                                        | 8.10.0                 |
  | **1.43.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6933))Updating index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                | 8.8.0                  |
  | **1.43.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6603))Expand index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                  | 8.8.0                  |
  | **1.42.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for container_logs datastream                                                                                                                                                                                                               | 8.8.0                  |
  | **1.41.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6332))Enable time series data streams for the metrics datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html) | 8.8.0                  |
  | **1.40.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6310))Fix system tests for kubernetes integration for k8s v1.27.0                                                                                                                                                                                                                                   | 8.8.0                  |
  | **1.40.0-beta.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6292))Fix volume dashboard.                                                                                                                                                                                                                                                                         |                        |
  | **1.40.0-beta.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6221))Fix proxy and scheduler visualization with missing sort field.                                                                                                                                                                                                                                |                        |
  | **1.40.0-beta**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6159))Enable TSDS for metrics data_streams, except events for beta testing                                                                                                                                                                                                                      |                        |
  | **1.39.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6209))Remove container.name as a dimension.                                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.38.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6196))Switch max to last value on counter formulas and add missing sort field to proxy, controller manager and scheduler dashboard.                                                                                                                                                             | 8.6.1                  |
  | **1.38.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6171))Fix Pod dashboard and remove some visualisations from Api Server dashboard to support TSDB migration                                                                                                                                                                                      | 8.6.1                  |
  | **1.37.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5992))Update proxy, controller manager and scheduler dashboard to support TSDB.                                                                                                                                                                                                                 | 8.6.1                  |
  | **1.36.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6108))Add container.name dimension to container data stream                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.35.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5760))Add NetworkUnavailable condition to state node                                                                                                                                                                                                                                            | 8.6.1                  |
  | **1.34.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5464))Add support for TSDB on all metric data streams except the state ones                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.34.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5621))Add support for TSDB on all state metric data streams                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.33.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5555))Add `data_stream.dataset` setting and custom yaml input.                                                                                                                                                                                                                                  | 8.6.1                  |
  | **1.32.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5586))Added link to docs for condition filter                                                                                                                                                                                                                                                   | 8.6.1                  |
  | **1.32.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                    | 8.6.1                  |
  | **1.32.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5364))Add documentation for how to install alerts                                                                                                                                                                                                                                               | 8.6.1                  |
  | **1.31.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5161))Add system testing for state service datastream                                                                                                                                                                                                                                           | 8.6.1                  |
  | **1.31.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4948))Update controller manager, proxy and scheduler metrics and dashboards                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.31.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4972))Use datas_tream.dataset as pre filters for dashboards and remove tags                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.30.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5044))Add missing namespace_uid and namespace_labels fields                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.29.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4756))Fix function for memory node usage                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.29.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4714))Fix removed condition setting for container_logs                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.29.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4691))Remove "Control Plane" column from Node Information table                                                                                                                                                                                                                                     | 8.5.0                  |
  | **1.28.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4671))Fix Pod Memory usage panel title                                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.28.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4672))Delete statefulset, job and cronjob visualizations from Cluster Overview dashboard                                                                                                                                                                                                        | 8.5.0                  |
  | **1.28.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4646))Adding banner for Kube-state metrics                                                                                                                                                                                                                                                      | 8.5.0                  |
  | **1.27.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4544))Fix typo in cluster overview dashboard                                                                                                                                                                                                                                                    | 8.5.0                  |
  | **1.27.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))New cluster overview dashboard                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.26.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))Add `processors` configuration option for Kubernetes data_streams                                                                                                                                                                                                                         | 8.4.0                  |
  | **1.25.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4324))Add `condition` configuration option to container logs data stream                                                                                                                                                                                                                        | 8.4.0                  |
  | **1.24.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4203))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.23.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4144))Add missing dimension fields                                                                                                                                                                                                                                                              | 8.4.0                  |
  | **1.23.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4081))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.22.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4095))Fix overlapping fields in state_job data stream                                                                                                                                                                                                                                           | 8.4.0                  |
  | **1.22.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3825))Update apiserver and controllermanaged deprecated fields and dashboards                                                                                                                                                                                                                   | 8.4.0                  |
  | **1.21.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3672))add container ID and pod name as part of Kubernetes Cotainer Logs filestream input                                                                                                                                                                                                            | 8.3.0                  |
  | **1.21.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3139))improved the wording of the link to Kubernetes documentation                                                                                                                                                                                                                              | 8.3.0                  |
  | **1.21.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3115))Add new dashboards                                                                                                                                                                                                                                                                        | 8.3.0                  |
  | **1.20.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3414))Change fields type for audit_logs data_stream to use `requestObject` and `responseObject` fields of audit events. Disable dynamic mapping for audit_logs data_stream. Drop `kubernetes.audit.responseObject.metadata` and `kubernetes.audit.requestObject.metadata`                       | 8.2.0                  |
  | **1.19.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3029))Add documentation for volume field                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.19.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3054))Add missed ecs fields                                                                                                                                                                                                                                                                     | 8.2.0                  |
  | **1.18.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.18.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2876))Fix k8s overview dashboard                                                                                                                                                                                                                                                                | 8.2.0                  |
  | **1.17.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2827))Remove incorrectly tagged boolean dimension                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2702))Add missing metadata fields                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2694))Improve default ndjson parser configuration                                                                                                                                                                                                                                               |                        |
  | **1.17.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2675))Disable audit logs collection by default                                                                                                                                                                                                                                                  |                        |
  | **1.16.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2657))Documentation improvements                                                                                                                                                                                                                                                                |                        |
  | **1.15.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2613))Add ssl.certificate_authorities configuration                                                                                                                                                                                                                                             |                        |
  | **1.14.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2625))Add missing job.name and cronjob.name fields to state_container datastream                                                                                                                                                                                                                    |                        |
  | **1.14.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2612))Add missing job.name and cronjob.name fields to container related datastreams                                                                                                                                                                                                                 |                        |
  | **1.14.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2608))Add missing job.name and cronjob.name fields added by metadata generators                                                                                                                                                                                                                     |                        |
  | **1.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2567))Tune state_metrics settings                                                                                                                                                                                                                                                               |                        |
  | **1.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2491))Update to ECS 8.0                                                                                                                                                                                                                                                                         |                        |
  | **1.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2370))Expose add_recourse_metadata configuration option                                                                                                                                                                                                                                         |                        |
  | **1.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2469))Add memory.working_set.limit.pct for pod and container data streams                                                                                                                                                                                                                       |                        |
  | **1.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2377))Add leader election in state_job data stream                                                                                                                                                                                                                                              |                        |
  | **1.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2361))Add missing fields                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.8.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2288))Set kubernetes.volume.fs.used.pct to scaled_float                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2345))Support json logs parsing                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2317))Add new audit logs data stream in kubernetes integration                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2342))Add skip_older option for event datastream                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2209))Revert Kubernetes namespace field breaking change                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.4.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2076))Add dimension fields                                                                                                                                                                                                                                                                      |                        |
  | **1.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2151))Remove overriding of index pattern on the Kubernetes overview dashboard                                                                                                                                                                                                                   | 8.0.0                  |
  | **1.4.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2139))Use filestream input for container_logs data stream                                                                                                                                                                                                                                       |                        |
  | **1.3.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2041))Fix conditions of data_streams that are based on k8s labels & add condition in pipelines                                                                                                                                                                                                      |                        |
  | **1.3.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Set default host for proxy to localhost                                                                                                                                                                                                                                                   |                        |
  | **1.3.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Uniform with guidelines                                                                                                                                                                                                                                                                   |                        |
  | **1.3.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2033))Add container_logs ecs fields                                                                                                                                                                                                                                                             |                        |
  | **1.2.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2031))Update Kubernetes cluster_ip field type                                                                                                                                                                                                                                                       |                        |
  | **1.2.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1792))Update Kubernetes namespace field                                                                                                                                                                                                                                                         |                        |
  | **1.1.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1890))Update Kubernetes integration Readme                                                                                                                                                                                                                                                          |                        |
  | **1.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1696))Update to ECS 1.12.0                                                                                                                                                                                                                                                                      | 7.15.0                 |
  | **1.0.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1610))Release Kubernetes as GA                                                                                                                                                                                                                                                                  |                        |
  | **0.14.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1565))Update default host in kubernetes proxy data stream in kubernetes integration                                                                                                                                                                                                             |                        |
  | **0.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Add new container logs data stream in kubernetes integration                                                                                                                                                                                                                              |                        |
  | **0.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Leverage dynamic kubernetes provider for controller and scheduler datastream                                                                                                                                                                                                              |                        |
  | **0.12.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1459))Add missing field "kubernetes.daemonset.name" field for pod and container data streams                                                                                                                                                                                                        |                        |
  | **0.12.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1413))Add missing cluster filter for "orchestrator.cluster.name" field in [Metrics Kubernetes] Overview dashboard and Dashboard section in the integration overview page                                                                                                                            |                        |
  | **0.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1407))Update kubernetes package ecs fields with orchestrator.cluster.url and orchestrator.cluster.name                                                                                                                                                                                          |                        |
  | **0.11.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                         |                        |
  | **0.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1401))Update documentation to fit mdx spec                                                                                                                                                                                                                                                      |                        |
  | **0.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                            |                        |
  | **0.9.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1335))Add missing field "kubernetes.daemonset.name" field for state_pod and state_container                                                                                                                                                                                                         |                        |
  | **0.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Enhance kubernetes package with state_job data stream                                                                                                                                                                                                                                     |                        |
  | **0.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1321))Leverage leader election in kubernetes integration                                                                                                                                                                                                                                        |                        |
  | **0.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1289))Add _meta information to Kubernetes fields                                                                                                                                                                                                                                                |                        |
  | **0.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Introduce kubernetes package granularity using input_groups                                                                                                                                                                                                                               |                        |
  | **0.5.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1160))Add missing field "kubernetes.statefulset.replicas.ready"                                                                                                                                                                                                                                 |                        |
  | **0.5.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/998))Fix stack compatability                                                                                                                                                                                                                                                                        |                        |
  | **0.5.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/970))Fix references to env variables                                                                                                                                                                                                                                                                |                        |
  | **0.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/886))Add missing field "kubernetes.selectors.*" and extra https settings for controllermanager and scheduler datastreams                                                                                                                                                                        |                        |
  | **0.4.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing field "kubernetes.pod.ip"                                                                                                                                                                                                                                                      |                        |
  | **0.4.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                     |                        |
  | **0.4.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                     |                        |
  | **0.4.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/749))Change kibana.version constraint to be more conservative.                                                                                                                                                                                                                                      |                        |
  | **0.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/745))Add missing fields                                                                                                                                                                                                                                                                         |                        |
  | **0.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/70))initial release                                                                                                                                                                                                                                                                             |                        |
</dropdown>