﻿---
title: Kubernetes integration
description: This integration is used to collect logs and metrics from Kubernetes clusters. Time series index mode enabled for metrics data streams. As one of the...
url: https://www.elastic.co/docs/reference/integrations/kubernetes
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Kubernetes integration
|                                                                                                 |                                                         |
|-------------------------------------------------------------------------------------------------|---------------------------------------------------------|
| **Version**                                                                                     | 1.84.1 ([View all](#changelog))                         |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                   |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                 |
| **Ingestion method(s)**                                                                         | API, AWS CloudWatch, Azure Event Hub, File, GCP Pub/Sub |
| **Minimum Kibana version(s)**                                                                   | 9.3.09.2.49.1.10                                        |

This integration is used to collect logs and metrics from
[Kubernetes clusters](https://kubernetes.io/). Time series [index mode](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html) enabled for metrics data streams.

|                                                                                                                                                                                                                                                                         |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **This integration requires kube-state-metrics, which is not included with Kubernetes by default. For dashboards to properly populate, the [kube-state-metrics service must be deployed to your Kubernetes cluster](https://github.com/kubernetes/kube-state-metrics)** |

As one of the main pieces provided for Kubernetes monitoring, this integration is capable of fetching metrics from several components:
- [kubelet](https://kubernetes.io/docs/reference/command-line-tools-reference/kubelet/)
- [kube-state-metrics](https://github.com/kubernetes/kube-state-metrics)
- [apiserver](https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/)
- [controller-manager](https://kubernetes.io/docs/reference/command-line-tools-reference/kube-controller-manager/)
- [scheduler](https://kubernetes.io/docs/reference/command-line-tools-reference/kube-scheduler/)
- [proxy](https://kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/)

Some of the previous components are running on each of the Kubernetes nodes (like `kubelet` or `proxy`) while others provide
a single cluster-wide endpoint. This is important to determine the optimal configuration and running strategy
for the different datasets included in the integration.

### Kubernetes endpoints and metricsets

Kubernetes module is a bit complex as its internal datasets require access to a wide variety of endpoints.
This section highlights and introduces some groups of datasets with similar endpoint access needs.
For more details on the datasets see `configuration example` and the `datasets` sections below.

### node / system / pod / container / module / volume

The datasets `container`, `node`, `pod`, `system` and `volume` require access to the `kubelet endpoint` in each of
the Kubernetes nodes, hence it's recommended to include them as part
of an `Agent DaemonSet` or standalone Agents running on the hosts.
Depending on the version and configuration of Kubernetes nodes, `kubelet` might provide a read only http port (typically 10255),
which is used in some configuration examples. But in general, and lately, this endpoint requires SSL (`https`) access
(to port 10250 by default) and token based authentication.

#### state_* and event

State_* datasets are enabled by default.
All datasets with the `state_` prefix require `hosts` field pointing to `kube-state-metrics`
service within the cluster. As the service provides cluster-wide metrics, there's no need to fetch them per node,
hence the recommendation is to run these datasets as part of an `Agent Deployment` with one only replica.
Generally `kube-state-metrics` runs a `Deployment` and is accessible via a service called `kube-state-metrics` on
`kube-system` namespace, which will be the service to use in our configuration.

### apiserver

The apiserver dataset requires access to the Kubernetes API, which should be easily available in all Kubernetes
environments. Depending on the Kubernetes configuration, the API access might require SSL (`https`) and token
based authentication.

### proxy

The proxy dataset requires access to the proxy endpoint in each of Kubernetes nodes, hence it's recommended
to configure it as a part of an `Agent DaemonSet`.

### scheduler and controllermanager

These datasets require access to the Kubernetes `controller-manager` and `scheduler` endpoints. By default, these pods
run only on master nodes, and they are not exposed via a Service, but there are different strategies
available for its configuration:
- Create `Kubernetes Services` to make `kube-controller-manager` and `kube-scheduler` available and configure
  the datasets to point to these services as part of an `Agent Deployment`.
- Run these datasets as part an `Agent Daemonset` (with HostNetwork setting) with a `nodeSelector` to only run on Master nodes.

These datasets are not enabled by default.
<note>
  In some "As a Service" Kubernetes implementations, like `GKE`, the master nodes or even the pods running on
  the masters won't be visible. In these cases it won't be possible to use `scheduler` and `controllermanager` metricsets.
</note>


### container-logs

The container-logs dataset requires access to the log files in each Kubernetes node where the container logs are stored.
This defaults to `/var/log/containers/*${kubernetes.container.id}.log`, which is the active log file.
To also ingest rotated log files, refer to the
full [container logs documentation](https://www.elastic.co/docs/reference/integrations/kubernetes/container-logs#ingesting-rotated-container-logs).
It uses the [Filestream input](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-filestream.html)
and defines it's ID as: `id: kubernetes-container-logs-${kubernetes.pod.name}-${kubernetes.container.id}` by default. For every
container the Elastic-Agent will generate an instance of the Filestream input harvesting the `paths` defined in the
configuration. So make sure the paths are unique per container.
For more details about how those variables are resolved and the input
configuration rendered, refer to:
- [Elastic-Agent providers](https://www.elastic.co/guide/en/fleet/current/providers.html)
- [Kubernetes autodiscovery with Elastic Agent](https://www.elastic.co/guide/en/fleet/current/elastic-agent-kubernetes-autodiscovery.html)
- [Conditions based autodiscover](https://www.elastic.co/guide/en/fleet/current/conditions-based-autodiscover.html)


#### Routing

The container-logs data stream allows routing logs to a different *dataset* or *namespace* using pod annotations.
For example, suppose you are running Nginx on your Kubernetes cluster, and you want to drive the Nginx container logs into a dedicated dataset or namespace. By annotating the pod with `elastic.co/namespace: nginx`, the integration will send all the container logs to the `nginx` namespace.
To learn more about routing container-logs, see .

#### Preserve original event

The agent can be configured to set the tag `preserve_original_event` on container-logs using pod annotation.
For example, suppose you are routing your Nginx container logs into a dedicated dataset or namespace as described above to make use of the Nginx fleet integration. Enabling preserve_original_event on the Nginx integration will have no effect
since the logs were shipped via kubernetes integration and not Nginx. As well, you may not want to have all original events from all Nginx pods preserved as well.
By annotating the pod with `elastic.co/preserve_original_event: 'true'`, the integration will add the tag `preserve_original_event` as it would be done by the `nginx` integration otherwise.

### audit-logs

Audit-logs integration collects and parses Kubernetes audit logs.
Audit logs can be collected from managed Kubernetes services in cloud providers:
- Amazon EKS: Configure the aws-cloudwatch input to collect audit logs from a CloudWatch log group where EKS audit logs are published.
- Azure AKS: Use the azure-eventhub input to receive audit logs from an Event Hub configured to stream AKS diagnostic logs.
- Google GKE: Use the gcp-pubsub input to subscribe to a Pub/Sub topic that receives GKE audit logs via Log Router sinks.

To enable these, configure the corresponding input with access credentials and the appropriate log stream or topic.
To collect audit logs from local k8s deployments, it requires access to the log files on each Kubernetes node where the audit logs are stored.
This defaults to `/var/log/kubernetes/kube-apiserver-audit.log`.

## Compatibility

The Kubernetes package is tested with Kubernetes [1.29.x - 1.33.x] versions

## Dashboard

Kubernetes integration is shipped including default dashboards for `apiserver`, `controllermanager`, `overview`, `proxy` and `scheduler`.
If you are using HA for those components, be aware that when gathering data from all instances the dashboard will usually show the average of the metrics. For those scenarios filtering by hosts or service address is possible.
Cluster selector in `overview` dashboard helps in distinguishing and filtering metrics collected from multiple clusters. If you want to focus on a subset of the Kubernetes clusters for monitoring a specific scenario, this cluster selector could be a handy tool. Note that this selector gets populated from the `orchestrator.cluster.name` field that may not always be available. This field gets its value from sources like `kube_config`, `kubeadm-config` configMap, and Google Cloud's meta API for GKE. If the sources mentioned above don't provide this value, metricbeat will not report it. However, you can always use [processors](https://www.elastic.co/guide/en/beats/metricbeat/current/defining-processors.html) to set this field and utilize it in the `cluster overview` dashboard.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Metricbeat Kubernetes Overview](https://epr.elastic.co/package/kubernetes/1.84.1/img/metricbeat_kubernetes_overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version           | Details                                                                                                                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |-------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.84.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/17196))Add AWS authentication variables for CloudWatch input in audit_logs data stream and fix api_timeout variable name typo.                                                                                                                                                                    | 9.3.09.2.49.1.10       |
  | **1.84.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16680))Add kubernetes.container.status.last_terminated_exitcode field to the state_container data stream.                                                                                                                                                                                       | 9.3.09.2.49.1.10       |
  | **1.83.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16581))Update the container logs documentation on how to ingest rotated logs, including GZIP-compressed logs.                                                                                                                                                                                   | 9.0.08.15.0            |
  | **1.82.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16497))Fix field rename error in audit logs ingest pipeline.                                                                                                                                                                                                                                        | 9.0.08.15.0            |
  | **1.82.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15793))Allow to configure container_logs input id and update container logs documentation to include how to ingest rotated log files.                                                                                                                                                           | 9.0.08.15.0            |
  | **1.81.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15585))Fix processing of Azure AKS audit logs.                                                                                                                                                                                                                                                      | 9.0.08.15.0            |
  | **1.81.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14554))Support for collecting audit logs from cloud providers.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13008))Fixed typos in ssl node descriptions in manifest.yml files.                                                                                                                                                                                                                                  | 9.0.08.15.0            |
  | **1.80.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12756))Added description to ssl.certificate_authorities and ssl.verification_mode, including links to documentation.                                                                                                                                                                                | 9.0.08.15.0            |
  | **1.80.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12535))Add support for Kibana `9.0.0`                                                                                                                                                                                                                                                           | 9.0.08.15.0            |
  | **1.70.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12538))Update the container logs documentation                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12404))Fix kubernetes.pod.cpu.usage.nanocores unit                                                                                                                                                                                                                                                  | 8.15.0                 |
  | **1.70.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12274))Make fingerprint configurable                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.69.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12227))Added datatype for audit log field annotations.pod-security_kubernetes_io/audit-violation                                                                                                                                                                                                | 8.15.0                 |
  | **1.68.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11243))Fix Overview dashboard Kibana id                                                                                                                                                                                                                                                             | 8.15.0                 |
  | **1.68.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11212))Use filestream fingerprint mode by default for container_logs datastream                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.67.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10593))Add both pod.{cpu,memory}.usage.node.pct and pod.{cpu,memory}.usage.limit.pct metrics to the Overview dashboard                                                                                                                                                                          | 8.15.0                 |
  | **1.66.4**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10893))Updating Cluster Overview Dashboard to use container.id as filter and replaced median functions from visualisations                                                                                                                                                                          | 8.15.0                 |
  | **1.66.3**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10713))Updating mapping of the field groups to keyword in kubernetes.audit_logs                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.66.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10548))Fixing missing processor block in kubernetes.audit_logs                                                                                                                                                                                                                                      | 8.15.0                 |
  | **1.66.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10535))Fixing Title in Volumes Dashboard                                                                                                                                                                                                                                                            | 8.15.0                 |
  | **1.66.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10267))Adding Volume Usage per pod in Kubernetes Volume Dashboard                                                                                                                                                                                                                               | 8.15.0                 |
  | **1.65.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10503))Add last_terminated_timestamp metric to the kubernetes.state_container datastream                                                                                                                                                                                                        | 8.15.0                 |
  | **1.64.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10213))Move namespace filter to the group level configuration                                                                                                                                                                                                                                   | 8.15.0                 |
  | **1.63.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10421))Fix typo in kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                 | 8.15.0                 |
  | **1.63.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10406))Add pod.status_reason and pod.status.ready_time fields to the state_pod datastream                                                                                                                                                                                                       | 8.15.0                 |
  | **1.62.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10396))Fix kubernetes.audit ingest pipeline                                                                                                                                                                                                                                                         | 8.14.0                 |
  | **1.62.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10138))Add new mappings to the kubernetes.audit datastream                                                                                                                                                                                                                                      | 8.14.0                 |
  | **1.61.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9780))Remove percent unit for pod memory metrics                                                                                                                                                                                                                                                    | 8.14.0                 |
  | **1.61.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9736))Remove deprecated fields and add missing status.last_terminated_reason metric                                                                                                                                                                                                             | 8.14.0                 |
  | **1.60.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9685))Updating `Memory used vs total memory` and `Cores used vs total cores` visualisations in Cluster Overview Dashboard                                                                                                                                                                           | 8.14.0                 |
  | **1.59.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Add metadata fields to state_namespace data stream.                                                                                                                                                                                                                                       | 8.14.0                 |
  | **1.58.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9356))Migrate to format_version v3.                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.57.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9036))Container logs preserve original content based on pod annotations.                                                                                                                                                                                                                        | 8.12.0                 |
  | **1.56.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8835))Add new fields to API server, state_node and persistent volume claim data streams.                                                                                                                                                                                                        | 8.12.0                 |
  | **1.55.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8697))Modify the field definitions to reference ECS.                                                                                                                                                                                                                                            | 8.11.0                 |
  | **1.55.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Remove extra base fields from state data streams.                                                                                                                                                                                                                                         | 8.11.0                 |
  | **1.54.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7395))Expand condition support to remaining inputs                                                                                                                                                                                                                                              | 8.11.0                 |
  | **1.53.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8337))Update size of the metric visualizations                                                                                                                                                                                                                                                  | 8.11.0                 |
  | **1.52.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8329))Add new data stream state_namespace.                                                                                                                                                                                                                                                      | 8.11.0                 |
  | **1.51.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8265))Migrate `Deployments` dashboard visualizations to lens.                                                                                                                                                                                                                                   | 8.10.2                 |
  | **1.50.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8263))Migrate `Cronjobs` dashboard visualizations to lens                                                                                                                                                                                                                                       | 8.10.2                 |
  | **1.49.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8266))Migrate `DaemonSets` dashboard visualizations to lens.                                                                                                                                                                                                                                    | 8.10.2                 |
  | **1.48.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8264))Migrate `StatefulSets` dashboard visualizations to lens.                                                                                                                                                                                                                                  | 8.10.2                 |
  | **1.47.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8262))Migrate `Jobs` dashboard visualizations to lens.                                                                                                                                                                                                                                          | 8.10.2                 |
  | **1.46.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8068))Adapt fields for changes in file system info                                                                                                                                                                                                                                              | 8.10.1                 |
  | **1.45.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7118))Reroute container logs based on pod annotations.                                                                                                                                                                                                                                          | 8.10.0                 |
  | **1.44.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6821))Introducing kubernetes.deployment.status.* metrics                                                                                                                                                                                                                                        | 8.10.0                 |
  | **1.43.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6933))Updating index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                | 8.8.0                  |
  | **1.43.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6603))Expand index pattern for adHocDataviews for CCS use case                                                                                                                                                                                                                                  | 8.8.0                  |
  | **1.42.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6340))Add permissions to reroute events to logs-*-* for container_logs datastream                                                                                                                                                                                                               | 8.8.0                  |
  | **1.41.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6332))Enable time series data streams for the metrics datasets. This improves storage usage and query performance. For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html) | 8.8.0                  |
  | **1.40.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6310))Fix system tests for kubernetes integration for k8s v1.27.0                                                                                                                                                                                                                                   | 8.8.0                  |
  | **1.40.0-beta.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6292))Fix volume dashboard.                                                                                                                                                                                                                                                                         |                        |
  | **1.40.0-beta.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6221))Fix proxy and scheduler visualization with missing sort field.                                                                                                                                                                                                                                |                        |
  | **1.40.0-beta**   | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6159))Enable TSDS for metrics data_streams, except events for beta testing                                                                                                                                                                                                                      |                        |
  | **1.39.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6209))Remove container.name as a dimension.                                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.38.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6196))Switch max to last value on counter formulas and add missing sort field to proxy, controller manager and scheduler dashboard.                                                                                                                                                             | 8.6.1                  |
  | **1.38.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6171))Fix Pod dashboard and remove some visualisations from Api Server dashboard to support TSDB migration                                                                                                                                                                                      | 8.6.1                  |
  | **1.37.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5992))Update proxy, controller manager and scheduler dashboard to support TSDB.                                                                                                                                                                                                                 | 8.6.1                  |
  | **1.36.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6108))Add container.name dimension to container data stream                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.35.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5760))Add NetworkUnavailable condition to state node                                                                                                                                                                                                                                            | 8.6.1                  |
  | **1.34.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5464))Add support for TSDB on all metric data streams except the state ones                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.34.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5621))Add support for TSDB on all state metric data streams                                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.33.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5555))Add `data_stream.dataset` setting and custom yaml input.                                                                                                                                                                                                                                  | 8.6.1                  |
  | **1.32.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5586))Added link to docs for condition filter                                                                                                                                                                                                                                                   | 8.6.1                  |
  | **1.32.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                    | 8.6.1                  |
  | **1.32.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5364))Add documentation for how to install alerts                                                                                                                                                                                                                                               | 8.6.1                  |
  | **1.31.2**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5161))Add system testing for state service datastream                                                                                                                                                                                                                                           | 8.6.1                  |
  | **1.31.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4948))Update controller manager, proxy and scheduler metrics and dashboards                                                                                                                                                                                                                     | 8.6.1                  |
  | **1.31.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4972))Use datas_tream.dataset as pre filters for dashboards and remove tags                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.30.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5044))Add missing namespace_uid and namespace_labels fields                                                                                                                                                                                                                                     | 8.6.0                  |
  | **1.29.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4756))Fix function for memory node usage                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.29.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4714))Fix removed condition setting for container_logs                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.29.0**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4691))Remove "Control Plane" column from Node Information table                                                                                                                                                                                                                                     | 8.5.0                  |
  | **1.28.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4671))Fix Pod Memory usage panel title                                                                                                                                                                                                                                                              | 8.5.0                  |
  | **1.28.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4672))Delete statefulset, job and cronjob visualizations from Cluster Overview dashboard                                                                                                                                                                                                        | 8.5.0                  |
  | **1.28.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4646))Adding banner for Kube-state metrics                                                                                                                                                                                                                                                      | 8.5.0                  |
  | **1.27.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4544))Fix typo in cluster overview dashboard                                                                                                                                                                                                                                                    | 8.5.0                  |
  | **1.27.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))New cluster overview dashboard                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **1.26.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4363))Add `processors` configuration option for Kubernetes data_streams                                                                                                                                                                                                                         | 8.4.0                  |
  | **1.25.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4324))Add `condition` configuration option to container logs data stream                                                                                                                                                                                                                        | 8.4.0                  |
  | **1.24.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4203))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.23.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4144))Add missing dimension fields                                                                                                                                                                                                                                                              | 8.4.0                  |
  | **1.23.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4081))Add fields to audit logs data stream                                                                                                                                                                                                                                                      | 8.4.0                  |
  | **1.22.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4095))Fix overlapping fields in state_job data stream                                                                                                                                                                                                                                           | 8.4.0                  |
  | **1.22.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3825))Update apiserver and controllermanaged deprecated fields and dashboards                                                                                                                                                                                                                   | 8.4.0                  |
  | **1.21.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3672))add container ID and pod name as part of Kubernetes Cotainer Logs filestream input                                                                                                                                                                                                            | 8.3.0                  |
  | **1.21.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3139))improved the wording of the link to Kubernetes documentation                                                                                                                                                                                                                              | 8.3.0                  |
  | **1.21.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3115))Add new dashboards                                                                                                                                                                                                                                                                        | 8.3.0                  |
  | **1.20.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3414))Change fields type for audit_logs data_stream to use `requestObject` and `responseObject` fields of audit events. Disable dynamic mapping for audit_logs data_stream. Drop `kubernetes.audit.responseObject.metadata` and `kubernetes.audit.requestObject.metadata`                       | 8.2.0                  |
  | **1.19.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3029))Add documentation for volume field                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.19.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3054))Add missed ecs fields                                                                                                                                                                                                                                                                     | 8.2.0                  |
  | **1.18.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                        | 8.2.0                  |
  | **1.18.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2876))Fix k8s overview dashboard                                                                                                                                                                                                                                                                | 8.2.0                  |
  | **1.17.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2827))Remove incorrectly tagged boolean dimension                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2702))Add missing metadata fields                                                                                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.17.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2694))Improve default ndjson parser configuration                                                                                                                                                                                                                                               |                        |
  | **1.17.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2675))Disable audit logs collection by default                                                                                                                                                                                                                                                  |                        |
  | **1.16.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2657))Documentation improvements                                                                                                                                                                                                                                                                |                        |
  | **1.15.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2613))Add ssl.certificate_authorities configuration                                                                                                                                                                                                                                             |                        |
  | **1.14.3**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2625))Add missing job.name and cronjob.name fields to state_container datastream                                                                                                                                                                                                                    |                        |
  | **1.14.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2612))Add missing job.name and cronjob.name fields to container related datastreams                                                                                                                                                                                                                 |                        |
  | **1.14.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2608))Add missing job.name and cronjob.name fields added by metadata generators                                                                                                                                                                                                                     |                        |
  | **1.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2567))Tune state_metrics settings                                                                                                                                                                                                                                                               |                        |
  | **1.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2491))Update to ECS 8.0                                                                                                                                                                                                                                                                         |                        |
  | **1.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2370))Expose add_recourse_metadata configuration option                                                                                                                                                                                                                                         |                        |
  | **1.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2469))Add memory.working_set.limit.pct for pod and container data streams                                                                                                                                                                                                                       |                        |
  | **1.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2377))Add leader election in state_job data stream                                                                                                                                                                                                                                              |                        |
  | **1.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2361))Add missing fields                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.8.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2288))Set kubernetes.volume.fs.used.pct to scaled_float                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2345))Support json logs parsing                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2317))Add new audit logs data stream in kubernetes integration                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2342))Add skip_older option for event datastream                                                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2209))Revert Kubernetes namespace field breaking change                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.4.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2076))Add dimension fields                                                                                                                                                                                                                                                                      |                        |
  | **1.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2151))Remove overriding of index pattern on the Kubernetes overview dashboard                                                                                                                                                                                                                   | 8.0.0                  |
  | **1.4.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2139))Use filestream input for container_logs data stream                                                                                                                                                                                                                                       |                        |
  | **1.3.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2041))Fix conditions of data_streams that are based on k8s labels & add condition in pipelines                                                                                                                                                                                                      |                        |
  | **1.3.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Set default host for proxy to localhost                                                                                                                                                                                                                                                   |                        |
  | **1.3.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2057))Uniform with guidelines                                                                                                                                                                                                                                                                   |                        |
  | **1.3.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2033))Add container_logs ecs fields                                                                                                                                                                                                                                                             |                        |
  | **1.2.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2031))Update Kubernetes cluster_ip field type                                                                                                                                                                                                                                                       |                        |
  | **1.2.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1792))Update Kubernetes namespace field                                                                                                                                                                                                                                                         |                        |
  | **1.1.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1890))Update Kubernetes integration Readme                                                                                                                                                                                                                                                          |                        |
  | **1.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1696))Update to ECS 1.12.0                                                                                                                                                                                                                                                                      | 7.15.0                 |
  | **1.0.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1610))Release Kubernetes as GA                                                                                                                                                                                                                                                                  |                        |
  | **0.14.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1565))Update default host in kubernetes proxy data stream in kubernetes integration                                                                                                                                                                                                             |                        |
  | **0.14.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Add new container logs data stream in kubernetes integration                                                                                                                                                                                                                              |                        |
  | **0.13.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1324))Leverage dynamic kubernetes provider for controller and scheduler datastream                                                                                                                                                                                                              |                        |
  | **0.12.2**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1459))Add missing field "kubernetes.daemonset.name" field for pod and container data streams                                                                                                                                                                                                        |                        |
  | **0.12.1**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1413))Add missing cluster filter for "orchestrator.cluster.name" field in [Metrics Kubernetes] Overview dashboard and Dashboard section in the integration overview page                                                                                                                            |                        |
  | **0.12.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1407))Update kubernetes package ecs fields with orchestrator.cluster.url and orchestrator.cluster.name                                                                                                                                                                                          |                        |
  | **0.11.1**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                         |                        |
  | **0.11.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1401))Update documentation to fit mdx spec                                                                                                                                                                                                                                                      |                        |
  | **0.10.0**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                            |                        |
  | **0.9.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1335))Add missing field "kubernetes.daemonset.name" field for state_pod and state_container                                                                                                                                                                                                         |                        |
  | **0.9.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Enhance kubernetes package with state_job data stream                                                                                                                                                                                                                                     |                        |
  | **0.8.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1321))Leverage leader election in kubernetes integration                                                                                                                                                                                                                                        |                        |
  | **0.7.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1289))Add _meta information to Kubernetes fields                                                                                                                                                                                                                                                |                        |
  | **0.6.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1018))Introduce kubernetes package granularity using input_groups                                                                                                                                                                                                                               |                        |
  | **0.5.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1160))Add missing field "kubernetes.statefulset.replicas.ready"                                                                                                                                                                                                                                 |                        |
  | **0.5.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/998))Fix stack compatability                                                                                                                                                                                                                                                                        |                        |
  | **0.5.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/970))Fix references to env variables                                                                                                                                                                                                                                                                |                        |
  | **0.5.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/886))Add missing field "kubernetes.selectors.*" and extra https settings for controllermanager and scheduler datastreams                                                                                                                                                                        |                        |
  | **0.4.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/919))Add missing field "kubernetes.pod.ip"                                                                                                                                                                                                                                                      |                        |
  | **0.4.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/766))Updating package owner                                                                                                                                                                                                                                                                     |                        |
  | **0.4.3**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/754))Correct sample event file.                                                                                                                                                                                                                                                                     |                        |
  | **0.4.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/749))Change kibana.version constraint to be more conservative.                                                                                                                                                                                                                                      |                        |
  | **0.4.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/745))Add missing fields                                                                                                                                                                                                                                                                         |                        |
  | **0.1.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/70))initial release                                                                                                                                                                                                                                                                             |                        |
</dropdown>