﻿---
title: Kubelet Stats OpenTelemetry Input Package
description: The Kubelet Stats OpenTelemetry Input Package for Elastic enables collection of Kubernetes node, pod, container, and volume metrics from the Kubelet API...
url: https://www.elastic.co/docs/reference/integrations/kubeletstats_input_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Kubelet Stats OpenTelemetry Input Package
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The Kubelet Stats OpenTelemetry Input integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The Kubelet Stats OpenTelemetry Input Package for Elastic enables collection of Kubernetes node, pod, container, and volume metrics from the Kubelet API using the [kubeletstatsreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/kubeletstatsreceiver).

### How it works

This package configures the Kubelet Stats receiver in the EDOT (Elastic Distribution of OpenTelemetry) collector to scrape metrics from the Kubelet API. The Elastic Agent processes and enriches the data before sending it to Elasticsearch for indexing and analysis. Once the data arrives into Elasticsearch, its corresponding [Kubernetes OpenTelemetry Assets Package](https://www.elastic.co/docs/reference/integrations/kubernetes_otel) gets auto installed and the dashboards light up. Data from additional inputs such as the Kubernetes cluster, events and objects packages might be required for full dashboard functionality.

## Configuration

For the full list of settings exposed for the receiver and examples, refer to the [configuration](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/kubeletstatsreceiver#configuration) section.

## Reference


### Metrics Reference

For a complete list of all available metrics and their detailed descriptions, refer to the [Kubelet Stats Receiver documentation](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/kubeletstatsreceiver/documentation.md) in the upstream OpenTelemetry Collector repository.

## Troubleshooting


### Common Issues

**Connection refused errors:**
- Verify the Kubelet endpoint is accessible from the collector.
- Check that the correct port is being used (10250 for secure, 10255 for read-only).
- Ensure RBAC permissions are correctly configured.

**Certificate errors:**
- When using TLS auth, verify certificate paths are correct.
- Consider enabling `insecure_skip_verify` for testing (not recommended for production).
- Ensure the CA file matches the Kubelet's certificate.

**Empty metrics:**
- Verify `metric_groups` includes the desired metric types.
- Check Kubelet logs for any errors.
- Ensure the node name is correctly configured if using node utilization metrics.


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                 | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17159))Initial version of the package |                        |
</dropdown>