﻿---
title: Keycloak Integration
description: The Keycloak integration collects events from the Keycloak log files. To enable logging of all Keycloak events like logins, user creation/updates/deletions...
url: https://www.elastic.co/docs/reference/integrations/keycloak
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Keycloak Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.31.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | File                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

The Keycloak integration collects events from the [Keycloak](https://www.keycloak.org/server/logging) log files.
To enable logging of all Keycloak events like logins, user creation/updates/deletions.... add the below
```
    <logger category="org.keycloak.events">
        <level name="DEBUG"/>
    </logger>
```

to your configuration XML file (ie standalone.xml) under the path below
```
<server>
    <profile>
        <subsystem xmlns="urn:jboss:domain:logging:8.0">
            ....
        </subsystem>
    </profile>
</server>
```

Note:
- Keycloak log files could contain multiline logs. In order to process them, the [multiline configuration](https://www.elastic.co/guide/en/beats/filebeat/current/multiline-examples.html) should be added to the parsers section when deploying the integration.


## Logs


### log

<dropdown title="Exported fields">
  | Field                                 | Description                                                                               | Type             |
  |---------------------------------------|-------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Event timestamp.                                                                          | date             |
  | cloud.image.id                        | Image ID for the cloud instance.                                                          | keyword          |
  | data_stream.dataset                   | Data stream dataset name.                                                                 | constant_keyword |
  | data_stream.namespace                 | Data stream namespace.                                                                    | constant_keyword |
  | data_stream.type                      | Data stream type.                                                                         | constant_keyword |
  | event.dataset                         | Event dataset                                                                             | constant_keyword |
  | event.module                          | Event module                                                                              | constant_keyword |
  | host.containerized                    | If the host is a container.                                                               | boolean          |
  | host.os.build                         | OS build information.                                                                     | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                      | keyword          |
  | input.type                            | Type of Filebeat input.                                                                   | keyword          |
  | keycloak.admin.operation              | Keycloak admin operation; Add, Update, Delete                                             | keyword          |
  | keycloak.admin.resource.path          | Path to affected resource                                                                 | keyword          |
  | keycloak.admin.resource.type          | Type of keycloak resource being acted upon; Group, User, Client, Scope...                 | keyword          |
  | keycloak.client.id                    | ID of the Keycloak client                                                                 | keyword          |
  | keycloak.event_type                   | Keycloak event type; Login or Admin                                                       | keyword          |
  | keycloak.impersonator                 |                                                                                           | keyword          |
  | keycloak.impersonator_realm           |                                                                                           | keyword          |
  | keycloak.login.auth_method            | Keycloak authentication method (SAML or OpenID Connect)                                   | keyword          |
  | keycloak.login.auth_session_parent_id | Parent session ID                                                                         | keyword          |
  | keycloak.login.auth_session_tab_id    | Session Tab ID                                                                            | keyword          |
  | keycloak.login.auth_type              | OpenID Connect authentication type (code, implicit...)                                    | keyword          |
  | keycloak.login.code_id                | OpenID Connect Code ID                                                                    | keyword          |
  | keycloak.login.redirect_uri           | Keycloak redirect URL                                                                     | keyword          |
  | keycloak.login.type                   | Event Type                                                                                | keyword          |
  | keycloak.realm.id                     | Keycloak Realm ID                                                                         | keyword          |
  | keycloak.session.id                   |                                                                                           | keyword          |
  | log.file.device_id                    | ID of the device containing the filesystem where the file resides.                        | keyword          |
  | log.file.fingerprint                  | The sha256 fingerprint identity of the file when fingerprinting is enabled.               | keyword          |
  | log.file.idxhi                        | The high-order part of a unique identifier that is associated with a file. (Windows-only) | keyword          |
  | log.file.idxlo                        | The low-order part of a unique identifier that is associated with a file. (Windows-only)  | keyword          |
  | log.file.inode                        | Inode number of the log file.                                                             | keyword          |
  | log.file.vol                          | The serial number of the volume that contains a file. (Windows-only)                      | keyword          |
  | log.flags                             | Flags for the log file.                                                                   | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                      | long             |
  | url.scheme                            |                                                                                           |                  |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-10-22T21:01:42.667+05:00",
      "agent": {
          "ephemeral_id": "9f6c0477-ed78-4030-8b72-4c0794d50c25",
          "id": "3df05e3b-922c-4316-a0fa-fb72d095657d",
          "name": "elastic-agent-22472",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "keycloak.log",
          "namespace": "68860",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "3df05e3b-922c-4316-a0fa-fb72d095657d",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "dataset": "keycloak.log",
          "ingested": "2025-05-28T08:34:57Z",
          "original": "2021-10-22 21:01:42,667 INFO  [org.jboss.resteasy.resteasy_jaxrs.i18n] (ServerService Thread Pool -- 64) RESTEASY002220: Adding singleton resource org.keycloak.services.resources.admin.AdminRoot from Application class org.keycloak.services.resources.KeycloakApplication",
          "timezone": "+05:00"
      },
      "host": {
          "architecture": "x86_64",
          "containerized": true,
          "hostname": "elastic-agent-22472",
          "id": "8259e024976a406e8a54cdbffeb84fec",
          "ip": [
              "192.168.255.2",
              "192.168.252.6"
          ],
          "mac": [
              "02-42-C0-A8-FC-06",
              "02-42-C0-A8-FF-02"
          ],
          "name": "elastic-agent-22472",
          "os": {
              "codename": "focal",
              "family": "debian",
              "kernel": "3.10.0-1160.92.1.el7.x86_64",
              "name": "Ubuntu",
              "platform": "ubuntu",
              "type": "linux",
              "version": "20.04.6 LTS (Focal Fossa)"
          }
      },
      "input": {
          "type": "filestream"
      },
      "log": {
          "file": {
              "device_id": "64768",
              "inode": "19004628",
              "path": "/tmp/service_logs/test-log.log"
          },
          "level": "INFO",
          "logger": "org.jboss.resteasy.resteasy_jaxrs.i18n",
          "offset": 658
      },
      "message": "RESTEASY002220: Adding singleton resource org.keycloak.services.resources.admin.AdminRoot from Application class org.keycloak.services.resources.KeycloakApplication",
      "process": {
          "thread": {
              "name": "ServerService Thread Pool -- 64"
          }
      },
      "tags": [
          "preserve_original_event",
          "keycloak-log"
      ]
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Keycloak Overview Dashboard Screenshot](https://epr.elastic.co/package/keycloak/1.31.0/img/keycloak-overview-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.31.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16685))Add support for `impersonator`, `impersonator_realm` and `session.id` fields.                                                                       | 9.0.08.13.0            |
  | **1.30.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14388))Add support for ECS-format events from Keycloak.                                                                                                    | 9.0.08.13.0            |
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14191))Allow ISO8601 datetime format.                                                                                                                      | 9.0.08.13.0            |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14027))Set the ECS field `event.outcome` based on the value of `keycloak.login.type`.                                                                      | 9.0.08.13.0            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13717))Add dashboard.                                                                                                                                      | 9.0.08.13.0            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                             | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11213))Make condition configurable to control when to apply the log data stream.                                                                           | 8.13.0                 |
  | **1.22.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10751))Fix missing value in pipeline condition.                                                                                                                | 8.13.0                 |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10563))Enhanced kv processor to trim escape sequences properly.                                                                                                | 8.13.0                 |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10549))Fixed parser config default value and updated GROK pattern to account for multiline logs.                                                               | 8.13.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9402))Update manifest format version to v3.0.3.                                                                                                            | 8.0.07.16.0            |
  | **1.20.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.0.07.16.0            |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8857))Make parsers configurable for Keycloak logs.                                                                                                         | 8.0.07.16.0            |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                       | 8.0.07.16.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                               | 8.0.07.16.0            |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8014))Adapt fields for changes in file system info                                                                                                         | 8.0.07.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                          | 8.0.07.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7928))Update package to ECS 8.10.0 and align ECS categorization fields.                                                                                    | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7110))Update package to ECS 8.9.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7120))Update package-spec to 2.9.0.                                                                                                                        | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6617))Ensure event.kind is correctly set for pipeline errors.                                                                                              | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6327))Update package to ECS 8.8.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.7.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                               | 8.0.07.16.0            |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5051))Ensure numeric timezones are correctly interpreted.                                                                                                      | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                   | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3867))Update package to ECS 8.4.0                                                                                                                          | 8.0.07.16.0            |
  | **1.4.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3708))Fix typo in 'Timezone Offset' description.                                                                                                               | 8.0.07.16.0            |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                   | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3136))Add link to keycloak documentation                                                                                                                   | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update to ECS 8.2                                                                                                                                    | 8.0.07.16.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                   | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2419))Update to ECS 8.0                                                                                                                                    | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2273))Add 8.0.0 version constraint                                                                                                                         | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1913))initial release                                                                                                                                      | 7.16.0                 |
</dropdown>