﻿---
title: Custom Kafka Log integration
description: The custom Kafka log integration is used to read from topics in a Kafka cluster. To configure this integration, specify a list of one or more hosts in...
url: https://www.elastic.co/docs/reference/integrations/kafka_log
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Custom Kafka Log integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.9.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | Kafka                          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

The custom Kafka log integration is used to read from topics in a Kafka cluster.
To configure this integration, specify a list of one or more hosts in the cluster to bootstrap the connection with, a list of topics to track, and a group_id for the connection.

## Compatibility

This Integration works with all Kafka versions in between 0.11 and 2.8.0. Older versions might work as well, but are not supported.

## Ingest Pipelines

Custom ingest pipelines may be added by adding the name to the pipeline configuration option, creating custom ingest pipelines can be done either through the API or the *Ingest Node Pipeline UI* (use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) to search for "ingest pipelines").
**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                       | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.9.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/16516))Updated the version field description to clarify default protocol versions.                                                                                                                                                                              | 9.0.08.13.0            |
  | **1.9.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15647))Add SASL mechanism configuration.                                                                                                                                                                                                                    | 9.0.08.13.0            |
  | **1.8.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12727))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                             | 9.0.08.13.0            |
  | **1.8.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12468))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                      | 9.0.08.13.0            |
  | **1.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10162))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                   | 8.13.0                 |
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9321))Enable secrets for sensitive fields. For more details, refer [https://www.elastic.co/guide/en/fleet/current/agent-policy.html#agent-policy-secret-values](https://www.elastic.co/guide/en/fleet/current/agent-policy.html#agent-policy-secret-values) | 8.12.0                 |
  | **1.5.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9279))Disable secrets for older stack versions due to errors.                                                                                                                                                                                                   | 8.0.07.16.0            |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9009))Enable 'secret' for the sensitive fields, supported from 8.12.                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8171))Update the package format_version to 3.0.0.                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6840))Add permissions to reroute events to logs-*-* for generic datastream                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6298))Rename ownership from obs-service-integrations to obs-infraobs-integrations                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                | 8.0.07.16.0            |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5057))Update ECS version to 8.5.1                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2741))Initial Release                                                                                                                                                                                                                                       | 8.0.07.16.0            |
</dropdown>