﻿---
title: Jolokia input
description: The Jolokia input package collects metrics from Jolokia agents running on a target JMX server or dedicated proxy server. The metrics are collected by...
url: https://www.elastic.co/docs/reference/integrations/jolokia
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Jolokia input
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.0.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.17.0                    |

The Jolokia input package collects metrics from [Jolokia agents](https://jolokia.org/agent.html) running on a target JMX server or dedicated proxy server.
The metrics are collected by communicating with a Jolokia HTTP/REST endpoint that exposes the JMX metrics over HTTP/REST/JSON.
You can use this input for any service that collects metrics through Jolokia endpoint. Optionally, you can provide custom mappings and custom ingest pipelines through the Kibana UI to get the tailored data.

## Compatibility

The Jolokia module is tested with Jolokia 2.2.9.

## Configuration


### Hosts

To collect metrics from a Jolokia endpoint, configure the hosts setting to point to your Jolokia agent.
For example:
`http://host_address:jolokia_port`

### Period

Defines the interval at which metrics are fetched.
For example, every `1s`, `1m`, `1h`.

### Path

Specifies the endpoint path of the Jolokia service, including any optional query parameters.
- Default: `/jolokia`
- Example with query parameters:: `/jolokia/?ignoreErrors=true&canonicalNaming=false`


### HTTP Method

Specifies the HTTP method used to communicate with the Jolokia endpoint.
- Supported values: `GET`, `POST`


### Authentication and SSL Configuration

To securely communicate with HTTPS-enabled Jolokia endpoints, you can configure `SSL settings` to meet the necessary requirements. For example:
```yaml
ssl.verification_mode: full
ssl.certificate_authorities:
  - /etc/ssl/certs/ca.crt
ssl.certificate: /etc/ssl/certs/client.crt
ssl.key: /etc/ssl/private/client.key
ssl.key_passphrase: your_key_passphrase
ssl.ca_trusted_fingerprint: "AB:CD:EF:..."
bearer_token_file: /path/to/token.txt
username: your_username
password: your_password
```

- `username / password` used for Basic authentication (if required by Jolokia).


### JMX Mappings and attributes

The Jolokia input package can collect metrics from various JMX MBeans by configuring the `mbean` parameter. You can specify which MBeans and attributes to collect as shown in the example below.
```
- mbean: 'java.lang:type=Runtime'
  attributes:
    - attr: Uptime
      field: uptime
- mbean: 'java.lang:type=Memory'
  attributes:
    - attr: HeapMemoryUsage
      field: memory.heap_usage
    - attr: NonHeapMemoryUsage
      field: memory.non_heap_usage
```


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14842))Make Jolokia Input GA                                                                                                                                                              | 9.0.08.17.0            |
  | **0.8.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14852))fix `Readme` file.                                                                                                                                                                     |                        |
  | **0.8.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14792))Update `Readme` file.                                                                                                                                                              |                        |
  | **0.7.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14712))Update `metrics_path` to `path`.                                                                                                                                                       |                        |
  | **0.7.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13010))Added description to ssl nodes to package level manifest.yml file to including links to documentation.                                                                                 |                        |
  | **0.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12468))Add support for Kibana `9.0.0`.                                                                                                                                                    |                        |
  | **0.6.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                              |                        |
  | **0.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12089))Added HTTP Options and http_method parameter (default to GET).                                                                                                                     |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10162))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. |                        |
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10068))Add processors option.                                                                                                                                                             |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8171))Update the package format_version to 3.0.0.                                                                                                                                         |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6451))Update the Kibana Version to 8.8.0                                                                                                                                                  |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6298))Rename ownership from obs-service-integrations to obs-infraobs-integrations                                                                                                         |                        |
  | **0.0.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5937))Added build manifest to indicate the ECS reference.                                                                                                                                     |                        |
  | **0.0.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                              |                        |
  | **0.0.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4660))Update the Jolokia metrics path                                                                                                                                                         |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4638))Update the Jolokia logo                                                                                                                                                             |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4543))Initial draft of the Jolokia Input                                                                                                                                                  |                        |
</dropdown>