﻿---
title: Imperva Cloud WAF
description: Imperva Cloud WAF is a cloud-based application delivery service that includes web security, DDoS protection, CDN, and load balancing. This integration...
url: https://www.elastic.co/docs/reference/integrations/imperva_cloud_waf
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Imperva Cloud WAF
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.13.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | API, AWS S3                     |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.16.5                     |

Imperva Cloud WAF is a cloud-based application delivery service that includes web security, DDoS protection, CDN, and load balancing.

## Data streams

This integration supports ingestion of events from Imperva Cloud WAF, via AWS S3 input or via [Imperva API](https://docs.imperva.com/bundle/cloud-application-security/page/settings/log-integration.htm).
**Event** is used to retrieve access and security events. See more details in the documentation [here](https://docs.imperva.com/bundle/cloud-application-security/page/more/log-file-structure.htm).

## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

## Setup


### Setup Amazon S3 Connection (Push Mode)

1. Login to your [Imperva Cloud WAF console](https://authentication-management.service.imperva.com/login).
2. On the sidebar, click Logs > Log Setup.
3. Connection. Select **Amazon S3**.
4. Next, fill in your credentials:

   Your S3 Access key, Secret key, and Path, where path is the location of the folder where you want to store the logs. Enter the path in the following format: <Amazon S3 bucket name>/<log folder>. For example: MyBucket/MyIncapsulaLogFolder.
5. Click Test connection to perform a full testing cycle in which a test file will be transferred to your designated folder. The test file does not contain real data, and will be removed by Incapsula when the transfer is complete.
6. Configure the additional options:
   - Format. Select the format for the log files: CEF
- Compress logs. By default, log files are compressed. Set the option to not compress files.


### Obtain API URL, API Key and API ID (Pull Mode)

1. Login to your [Imperva Cloud WAF console](https://authentication-management.service.imperva.com/login).
2. On the sidebar, click Logs > Log Setup.
3. Connection. Select **Imperva API**.
4. From this window copy and keep API Key handy, this will be required for further Integration configuration.
5. Copy **API ID** and **Log Server URI**.
6. Configure the additional options:
   - Format. Select the format for the log files: CEF
- Compress logs. By default, log files are compressed. Set the option to not compress files.


### Enable the integration in Elastic

1. In Kibana go to **Management** > **Integrations**.
2. In the search bar, type **Imperva Cloud WAF**.
3. Select the **Imperva Cloud WAF** integration and add it.
4. While adding the integration, if you want to collect logs via AWS S3, keep **Collect Imperva Cloud WAF logs via AWS S3 or AWS SQS** toggle on and then configure following parameters:
   - access key id
- secret access key
- bucket arn
- collect logs via S3 Bucket toggled on
   or if you want to collect logs via AWS SQS, keep **Collect Imperva Cloud WAF logs via AWS S3 or AWS SQS** toggle on and then configure following parameters:
   - access key id
- secret access key
- queue url
- collect logs via S3 Bucket toggled off
   or if you want to collect logs via API, keep **Collect Imperva Cloud WAF logs via API** toggle on and and then configure following parameters:
   - API ID
- API Key
- URL
5. Save the integration.

<note>
  There are other input combination options available for AWS S3 input, please check [here](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-aws-s3.html).
</note>


## Logs Reference


### Event

This is the `Event` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-08-26T09:17:33.442Z",
      "agent": {
          "ephemeral_id": "c2af9640-ea28-4ab7-b766-c5391d82b759",
          "id": "f8329c43-eb4d-4aab-a20e-a39db67260a4",
          "name": "elastic-agent-34907",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "imperva_cloud_waf.event",
          "namespace": "44486",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "f8329c43-eb4d-4aab-a20e-a39db67260a4",
          "snapshot": false,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "web"
          ],
          "code": "1",
          "dataset": "imperva_cloud_waf.event",
          "end": "2019-08-20T11:31:10.892Z",
          "ingested": "2025-08-26T09:17:36Z",
          "kind": "event",
          "original": "CEF:0|Incapsula|SIEMintegration|1|1|Normal|0| sourceServiceName=site123.abcd.info siteid=1509732 suid=50005477 requestClientApplication=Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0 deviceFacility=mia ccode=IL tag=www.elvis.com cicode=Rehovot cs7=31.8969 cs7Label=latitude cs8=34.8186 cs8Label=longitude Customer=CEFcustomer123 siteTag=my-site-tag start=1453290121336 request=site123.abcd.info/main.css ref=www.incapsula.com/lama requestmethod=GET cn1=200 app=HTTP deviceExternalID=33411452762204224 in=54 xff=44.44.44.44 cpt=443 src=12.12.12.12 ver=TLSv1.2 ECDHE-RSA-AES128-GCM-SHA256 end=1566300670892 additionalReqHeaders=[{\"Accept\":\"*/*\"},{\"x-v\":\"1\"},{\"x-fapi-interaction-id\":\"10.10.10.10\"}] additionalResHeaders=[{\"Content-Type\":\"text/html; charset\\=UTF-8\"}]",
          "severity": 0,
          "start": "2016-01-20T11:42:01.336Z",
          "type": [
              "info"
          ]
      },
      "http": {
          "request": {
              "method": "GET"
          },
          "response": {
              "status_code": 200
          }
      },
      "imperva_cloud_waf": {
          "event": {
              "device": {
                  "event_class_id": "1",
                  "product": "SIEMintegration",
                  "vendor": "Incapsula",
                  "version": "1"
              },
              "extensions": {
                  "additional": {
                      "req_headers": [
                          {
                              "Accept": "*/*"
                          },
                          {
                              "x-v": "1"
                          },
                          {
                              "x-fapi-interaction-id": "10.10.10.10"
                          }
                      ],
                      "res_headers": [
                          {
                              "Content-Type": "text/html; charset=UTF-8"
                          }
                      ]
                  },
                  "application_protocol": "HTTP",
                  "bytes_in": 54,
                  "ccode": "IL",
                  "cicode": "Rehovot",
                  "cpt": 443,
                  "cs7": 31.8969,
                  "cs7Label": "latitude",
                  "cs8": 34.8186,
                  "cs8Label": "longitude",
                  "customer": "CEFcustomer123",
                  "device": {
                      "custom_number1": 200,
                      "externalId": "33411452762204224",
                      "facility": "mia"
                  },
                  "end_time": "2019-08-20T11:31:10.892Z",
                  "ref": "www.incapsula.com/lama",
                  "request": {
                      "client_application": "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0",
                      "method": "GET",
                      "url": "site123.abcd.info/main.css"
                  },
                  "site": {
                      "id": "1509732",
                      "tag": "my-site-tag"
                  },
                  "source": {
                      "address": "12.12.12.12",
                      "service_name": "site123.abcd.info",
                      "user_id": "50005477"
                  },
                  "start_time": "2016-01-20T11:42:01.336Z",
                  "tag": "www.elvis.com",
                  "ver": "TLSv1.2 ECDHE-RSA-AES128-GCM-SHA256",
                  "xff": [
                      "44.44.44.44"
                  ]
              },
              "name": "Normal",
              "severity": 0,
              "version": "0"
          }
      },
      "input": {
          "type": "cel"
      },
      "message": "Normal",
      "network": {
          "application": "http",
          "forwarded_ip": [
              "44.44.44.44"
          ]
      },
      "observer": {
          "product": "SIEMintegration",
          "vendor": "Incapsula",
          "version": "1"
      },
      "related": {
          "ip": [
              "12.12.12.12",
              "44.44.44.44"
          ],
          "user": [
              "50005477"
          ]
      },
      "source": {
          "bytes": 54,
          "geo": {
              "country_iso_code": "IL",
              "location": {
                  "lat": 31.8969,
                  "lon": 34.8186
              }
          },
          "ip": "12.12.12.12",
          "port": 443,
          "service": {
              "name": "site123.abcd.info"
          },
          "user": {
              "id": "50005477"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "imperva_cloud_waf-event"
      ],
      "tls": {
          "cipher": "ECDHE-RSA-AES128-GCM-SHA256",
          "version": "1.2"
      },
      "url": {
          "domain": "site123.abcd.info",
          "extension": "css",
          "original": "http://site123.abcd.info/main.css",
          "path": "/main.css",
          "scheme": "http"
      },
      "user_agent": {
          "device": {
              "name": "Other"
          },
          "name": "Firefox",
          "original": "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0",
          "os": {
              "full": "Windows 7",
              "name": "Windows",
              "version": "7"
          },
          "version": "40.0"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                          | Description                                                                                                                     | Type             |
  |----------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                     | Event timestamp.                                                                                                                | date             |
  | aws.s3.bucket.arn                                              | The AWS S3 bucket ARN.                                                                                                          | keyword          |
  | aws.s3.bucket.name                                             | The AWS S3 bucket name.                                                                                                         | keyword          |
  | aws.s3.object.key                                              | The AWS S3 Object key.                                                                                                          | keyword          |
  | data_stream.dataset                                            | Data stream dataset.                                                                                                            | constant_keyword |
  | data_stream.namespace                                          | Data stream namespace.                                                                                                          | constant_keyword |
  | data_stream.type                                               | Data stream type.                                                                                                               | constant_keyword |
  | destination.process.name                                       |                                                                                                                                 | keyword          |
  | event.dataset                                                  | Event dataset.                                                                                                                  | constant_keyword |
  | event.module                                                   | Event module.                                                                                                                   | constant_keyword |
  | imperva_cloud_waf.event.device.event_class_id                  | Signature Id.                                                                                                                   | keyword          |
  | imperva_cloud_waf.event.device.product                         | The product or service that is generating the logs.                                                                             | keyword          |
  | imperva_cloud_waf.event.device.vendor                          | The vendor that is generating the logs.                                                                                         | keyword          |
  | imperva_cloud_waf.event.device.version                         | An integer that identifies the version of the log format.                                                                       | keyword          |
  | imperva_cloud_waf.event.extensions.action                      | The method in which Imperva processed the request.                                                                              | keyword          |
  | imperva_cloud_waf.event.extensions.additional.req_headers      | Request headers in JSON format, with each field represented as a name-value pair.                                               | object           |
  | imperva_cloud_waf.event.extensions.additional.res_headers      | Response headers in JSON format, with each field represented as a name-value pair.                                              | object           |
  | imperva_cloud_waf.event.extensions.application_protocol        | The request protocol.                                                                                                           | keyword          |
  | imperva_cloud_waf.event.extensions.bytes_in                    | The content length.                                                                                                             | long             |
  | imperva_cloud_waf.event.extensions.ccode                       | The country code of the site visitor.                                                                                           | keyword          |
  | imperva_cloud_waf.event.extensions.cicode                      | The city code of the site visitor.                                                                                              | keyword          |
  | imperva_cloud_waf.event.extensions.cpt                         | The client port used to communicate the request.                                                                                | long             |
  | imperva_cloud_waf.event.extensions.cs10                        | JSON describing all actions that were applied to a specific request.                                                            | object           |
  | imperva_cloud_waf.event.extensions.cs10Label                   |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.cs11                        | Additional information on the violation that triggered the rule, in JSON format.                                                | object           |
  | imperva_cloud_waf.event.extensions.cs11Label                   |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.cs7                         | The latitude of the event.                                                                                                      | double           |
  | imperva_cloud_waf.event.extensions.cs7Label                    |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.cs8                         | The longitude of the event.                                                                                                     | double           |
  | imperva_cloud_waf.event.extensions.cs8Label                    |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.cs9                         | The threat rule name that this request triggered.                                                                               | keyword          |
  | imperva_cloud_waf.event.extensions.cs9Label                    |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.customer                    | The account name of the site owner.                                                                                             | keyword          |
  | imperva_cloud_waf.event.extensions.destination_process_name    | The browser type.                                                                                                               | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_number1       | The HTTP response code returned to the client.                                                                                  | long             |
  | imperva_cloud_waf.event.extensions.device.custom_string1       | Whether or not the client application supports Captcha.                                                                         | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string1_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string2       | Whether or not the client application supports JavaScript.                                                                      | boolean          |
  | imperva_cloud_waf.event.extensions.device.custom_string2_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string3       | Whether or not the client application supports cookies.                                                                         | boolean          |
  | imperva_cloud_waf.event.extensions.device.custom_string3_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string4       | The ID of the visitor.                                                                                                          | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string4_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string5       | For internal use.                                                                                                               | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string5_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string6       | The client application software.                                                                                                | keyword          |
  | imperva_cloud_waf.event.extensions.device.custom_string6_label |                                                                                                                                 | keyword          |
  | imperva_cloud_waf.event.extensions.device.externalId           | A unique identifier of the request that can be used to correlate with reports and data from the Imperva Cloud Security Console. | keyword          |
  | imperva_cloud_waf.event.extensions.device.facility             | The Imperva PoP that handled the request.                                                                                       | keyword          |
  | imperva_cloud_waf.event.extensions.end_time                    | The end time of the response to the request, in UTC. In UNIX epoch time format.                                                 | date             |
  | imperva_cloud_waf.event.extensions.file.permission             | Imperva attack id.                                                                                                              | keyword          |
  | imperva_cloud_waf.event.extensions.file.type                   | The type of attack.                                                                                                             | keyword          |
  | imperva_cloud_waf.event.extensions.file_id                     | The unique identification.                                                                                                      | keyword          |
  | imperva_cloud_waf.event.extensions.postbody                    | The post body data of the request.                                                                                              | keyword          |
  | imperva_cloud_waf.event.extensions.qstr                        | The query string of the request.                                                                                                | keyword          |
  | imperva_cloud_waf.event.extensions.ref                         | The URL of the previous page that the client visited.                                                                           | keyword          |
  | imperva_cloud_waf.event.extensions.request.client_application  | The UserAgent header value.                                                                                                     | keyword          |
  | imperva_cloud_waf.event.extensions.request.method              | The request method.                                                                                                             | keyword          |
  | imperva_cloud_waf.event.extensions.request.url                 | The URL of the request.                                                                                                         | keyword          |
  | imperva_cloud_waf.event.extensions.sip                         | The IP address of the server.                                                                                                   | ip               |
  | imperva_cloud_waf.event.extensions.site.id                     | The numeric identifier of the site.                                                                                             | keyword          |
  | imperva_cloud_waf.event.extensions.site.tag                    | Site level reference ID.                                                                                                        | keyword          |
  | imperva_cloud_waf.event.extensions.source.address              | The client IP that made the request.                                                                                            | ip               |
  | imperva_cloud_waf.event.extensions.source.port                 | The port of the server.                                                                                                         | long             |
  | imperva_cloud_waf.event.extensions.source.service_name         | The name of the site.                                                                                                           | keyword          |
  | imperva_cloud_waf.event.extensions.source.user_id              | The numeric identifier of the account of the site owner.                                                                        | keyword          |
  | imperva_cloud_waf.event.extensions.start_time                  | The time in which this visit started, in UTC. In UNIX epoch time format.                                                        | date             |
  | imperva_cloud_waf.event.extensions.tag                         | Account level reference ID.                                                                                                     | keyword          |
  | imperva_cloud_waf.event.extensions.ver                         | The TLS version and encryption algorithms used in the request.                                                                  | keyword          |
  | imperva_cloud_waf.event.extensions.xff                         | The X-Forwarded-For request header.                                                                                             | ip               |
  | imperva_cloud_waf.event.name                                   | The rule type that was triggered.                                                                                               | keyword          |
  | imperva_cloud_waf.event.severity                               | Imperva internal rule ID number.                                                                                                | long             |
  | imperva_cloud_waf.event.version                                | An integer that identifies the version of the log format.                                                                       | keyword          |
  | input.type                                                     | Type of filebeat input.                                                                                                         | keyword          |
  | log.offset                                                     | Log offset.                                                                                                                     | long             |
  | source.service.name                                            |                                                                                                                                 | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Imperva Cloud WAF Dashboard](https://epr.elastic.co/package/imperva_cloud_waf/1.13.1/img/imperva-cwaf-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                  | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15602))Downgrade the `format_version` to the minimum version that supports all the necessary features for the package.                                                                                                                     | 9.0.08.16.5            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14393))Use `terminate` processor instead of `fail` processor to handle agent errors.                                                                                                                                                   | 9.0.08.16.5            |
  | **1.12.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14298))Fix handling of API requests when the cursor state cannot be found in the log file index returned by Imperva.                                                                                                                       | 9.0.08.16.5            |
  | **1.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14220))Fix ingest pipeline to handle whitespace in request URL.                                                                                                                                                                            | 9.0.08.16.5            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13573))Remove redundant installation instructions.                                                                                                                                                                                     | 9.0.08.16.5            |
  | **1.11.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                         | 9.0.08.16.5            |
  | **1.11.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13350))Fix handling of SQS worker count configuration.                                                                                                                                                                                     | 9.0.08.16.5            |
  | **1.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13244))Handle multiple IPs in `extensions.xff`.                                                                                                                                                                                            | 9.0.08.16.5            |
  | **1.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13161))Fix type issue in CEL program.                                                                                                                                                                                                      | 9.0.08.16.5            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13152))Prevent stale compressed data wedging log collection.                                                                                                                                                                           | 9.0.08.16.5            |
  | **1.10.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13148))Clarify documentation regarding Imperva file compression configuration.                                                                                                                                                             | 9.0.08.16.5            |
  | **1.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13066))Re-add trailing slash in second stage log file collection in API input.                                                                                                                                                             | 9.0.08.16.5            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13035))Enable request trace log removal.                                                                                                                                                                                               | 9.0.08.16.5            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12645))Add support to configure start_timestamp and ignore_older configurations for AWS S3 backed inputs.                                                                                                                              | 9.0.08.16.5            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                      | 9.0.08.16.2            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12894))Prevent absence of trailing slash in base URL from causing data collection failure.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12894))Improve error reporting in collection failure case. | 8.16.2                 |
  | **1.6.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12779))Fix error message formatting syntax in agent configuration.                                                                                                                                                                         | 8.16.2                 |
  | **1.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                        | 8.16.2                 |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12648))Improve error reporting for API requests.                                                                                                                                                                                       | 8.16.2                 |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12497))Tolerate no separator in log files.                                                                                                                                                                                                 | 8.16.2                 |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12154))Add support for Access Point ARN when collecting logs via the AWS S3 Bucket.                                                                                                                                                    | 8.16.2                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                                                              | 8.13.0                 |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                         | 8.13.0                 |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                       | 8.13.0                 |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10182))Remove reference to a Kibana version from the README.                                                                                                                                                                               | 8.13.0                 |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                      | 8.13.0                 |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9779))Release package as GA.                                                                                                                                                                                                           | 8.13.0                 |
  | **0.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9778))Use modern ecs@mappings.                                                                                                                                                                                                         |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9238))Set sensitive values as secret, upgrade to package spec 3.0.3.                                                                                                                                                                   |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9210))Added Attack Map, Events Over Time, Unique IP and domain visualizations.                                                                                                                                                         |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8999))Initial release.                                                                                                                                                                                                                 |                        |
</dropdown>