﻿---
title: Imperva device log integration
description: This integration is for Imperva device logs. It includes the datasets for receiving logs over syslog or read from a file: securesphere dataset: supports...
url: https://www.elastic.co/docs/reference/integrations/imperva
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Imperva device log integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.9.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | File, Network Protocol         |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                    |

This integration is for Imperva device logs. It includes the
datasets for receiving logs over syslog or read from a file:
- `securesphere` dataset: supports Imperva SecureSphere logs.


## Data streams

The Imperva integration collects one type of data: securesphere.
**Securesphere** consists of alerts, violations, and system events. See more details about [alerts, violations, and events](https://docs.imperva.com/bundle/v14.7-web-application-firewall-user-guide/page/1024.htm)

## Requirements

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
The minimum **kibana.version** required is **8.10.1**.

## Setup


### Collect data from Imperva

1. The gateway and management server (MX) should have the relevant connectivity for sending logs using the Syslog server.
2. To send all security violations from the gateway to Elastic:

- Create a custom action set:
  - From a 'security violation–all', type and add the gateway security system log > gateway log security event to system log (syslog) using the CEF standard.
- Configure the relevant name and parameters for the action set.
- Assign a followed action to a security - > policy rule.

1. To send all security alerts (aggregated violations) from the gateway to Elastic:

- Create a custom action set:
  - From an 'any event type', type and add the server system log > log security event to system log (syslog) using the CEF standard.
- Configure the relevant name and parameters for the action set.
- Assign a followed action to a security - > policy rule.

1. To send all system events from the gateway to Elastic:

- Create a custom action set:
  - From an 'any event type', type and add the server system log > log system event to system log (syslog) using the CEF standard.
- Configure the relevant name and parameters for the action set.
- Create system events policy.
- Assign a followed action to a system event policy.

For more information on working with action sets and followed actions, check the Imperva [documentation](https://docs.imperva.com/bundle/v15.0-waf-management-server-manager-user-guide/page/Working_with_Action_Sets_and_Followed_Actions.htm).

### Enable the integration in Elastic

1. In Kibana navigate to **Management** > **Integrations**.
2. In the search bar, type **Imperva**.
3. Select the **Imperva** integration and add it.
4. Enable the data collection mode from the following: Filestream, TCP, or UDP.
5. Add all the required configuration parameters, such as paths for the filestream or listen address and listen port for the TCP and UDP.
6. Save the integration.


## Logs Reference


### SecureSphere

This is the `Securesphere` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-10-05T18:33:02.000Z",
      "agent": {
          "ephemeral_id": "94608df6-6778-4ec4-99dc-d0cd37d583d8",
          "id": "0412638f-dd94-4c0e-b349-e99a0886d9f0",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.10.1"
      },
      "data_stream": {
          "dataset": "imperva.securesphere",
          "namespace": "ep",
          "type": "logs"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "0412638f-dd94-4c0e-b349-e99a0886d9f0",
          "snapshot": false,
          "version": "8.10.1"
      },
      "event": {
          "agent_id_status": "verified",
          "code": "User logged in",
          "dataset": "imperva.securesphere",
          "ingested": "2023-12-01T09:10:18Z",
          "kind": "event",
          "original": "<14>CEF:0|Imperva Inc.|SecureSphere|15.1.0|User logged in|User admin logged in from 81.2.69.142.|High|suser=admin rt=Oct 05 2023 18:33:02 cat=SystemEvent",
          "severity": 7
      },
      "imperva": {
          "securesphere": {
              "device": {
                  "event": {
                      "category": "SystemEvent",
                      "class_id": "User logged in"
                  },
                  "product": "SecureSphere",
                  "receipt_time": "2023-10-05T18:33:02.000Z",
                  "vendor": "Imperva Inc.",
                  "version": "15.1.0"
              },
              "name": "User admin logged in from 81.2.69.142.",
              "severity": "High",
              "source": {
                  "user_name": "admin"
              },
              "version": "0"
          }
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "192.168.249.7:48857"
          }
      },
      "message": "User admin logged in from 81.2.69.142.",
      "observer": {
          "product": "SecureSphere",
          "vendor": "Imperva Inc.",
          "version": "15.1.0"
      },
      "related": {
          "user": [
              "admin"
          ]
      },
      "source": {
          "user": {
              "name": "admin"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "imperva.securesphere"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                             | Description                                                                               | Type             |
  |---------------------------------------------------|-------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                        | Event timestamp.                                                                          | date             |
  | data_stream.dataset                               | Data stream dataset.                                                                      | constant_keyword |
  | data_stream.namespace                             | Data stream namespace.                                                                    | constant_keyword |
  | data_stream.type                                  | Data stream type.                                                                         | constant_keyword |
  | event.dataset                                     | Event dataset.                                                                            | constant_keyword |
  | event.module                                      | Event module.                                                                             | constant_keyword |
  | imperva.securesphere.destination.address          |                                                                                           | ip               |
  | imperva.securesphere.destination.port             |                                                                                           | long             |
  | imperva.securesphere.destination.user_name        |                                                                                           | keyword          |
  | imperva.securesphere.device.action                |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string1.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string1.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string10.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string10.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string11.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string11.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string12.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string12.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string13.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string13.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string14.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string14.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string15.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string15.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string16.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string16.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string17.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string17.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string18.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string18.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string19.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string19.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string2.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string2.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string20.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string20.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string21.label |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string21.value |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string3.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string3.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string4.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string4.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string5.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string5.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string6.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string6.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string7.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string7.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string8.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string8.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string9.label  |                                                                                           | keyword          |
  | imperva.securesphere.device.custom_string9.value  |                                                                                           | keyword          |
  | imperva.securesphere.device.event.category        |                                                                                           | keyword          |
  | imperva.securesphere.device.event.class_id        |                                                                                           | keyword          |
  | imperva.securesphere.device.product               |                                                                                           | keyword          |
  | imperva.securesphere.device.receipt_time          |                                                                                           | date             |
  | imperva.securesphere.device.vendor                |                                                                                           | keyword          |
  | imperva.securesphere.device.version               |                                                                                           | keyword          |
  | imperva.securesphere.name                         |                                                                                           | keyword          |
  | imperva.securesphere.severity                     |                                                                                           | keyword          |
  | imperva.securesphere.source.address               |                                                                                           | ip               |
  | imperva.securesphere.source.port                  |                                                                                           | long             |
  | imperva.securesphere.source.user_name             |                                                                                           | keyword          |
  | imperva.securesphere.transport_protocol           |                                                                                           | keyword          |
  | imperva.securesphere.version                      |                                                                                           | keyword          |
  | input.type                                        | Type of filebeat input.                                                                   | keyword          |
  | log.file.device_id                                | ID of the device containing the filesystem where the file resides.                        | keyword          |
  | log.file.fingerprint                              | The sha256 fingerprint identity of the file when fingerprinting is enabled.               | keyword          |
  | log.file.idxhi                                    | The high-order part of a unique identifier that is associated with a file. (Windows-only) | keyword          |
  | log.file.idxlo                                    | The low-order part of a unique identifier that is associated with a file. (Windows-only)  | keyword          |
  | log.file.inode                                    | Inode number of the log file.                                                             | keyword          |
  | log.file.vol                                      | The serial number of the volume that contains a file. (Windows-only)                      | keyword          |
  | log.offset                                        | Log offset.                                                                               | long             |
  | log.source.address                                | Source address from which the log event was read / sent from.                             | keyword          |
  | tags                                              | User defined tags.                                                                        | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Imperva Securesphere Dashboard Screenshot](https://epr.elastic.co/package/imperva/1.9.0/img/imperva-securesphere-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                             | Minimum Kibana version |
  |------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15805))Preserve event.original on pipeline error.                                                                 | 9.0.08.11.0            |
  | **1.8.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15560))Generate processor tags and normalize error handler.                                                       | 9.0.08.11.0            |
  | **1.8.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15397))Fixed H1s for SEO purpose.                                                                                 | 9.0.08.11.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14938))Removed markdown links from dashboards.                                                                    | 9.0.08.11.0            |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                            | 9.0.08.11.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14376))Remove duplicated installation instructions from the documentation.                                        | 9.0.08.11.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13521))Allow @custom pipeline access to event.original without setting preserve_original_event.                   | 9.0.08.11.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                 | 9.0.08.10.1            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                   | 8.10.1                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12618))Add support for additional custom string fields.                                                           | 8.10.1                 |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12571))ECS version updated to 8.17.0.                                                                             | 8.10.1                 |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12349))Add configuration for custom filestream options. Ensure filestream fingerprint is disabled in system test. | 8.10.1                 |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                               | 8.10.1                 |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                              | 8.10.1                 |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8833))Release package as GA.                                                                                      | 8.10.1                 |
  | **0.20.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                      |                        |
  | **0.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/8469))Adapt fields for changes in file system info.                                                                 |                        |
  | **0.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                              |                        |
  | **0.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8237))Replace RSA2ELK with Syslog integration.                                                                    |                        |
  | **0.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                              |                        |
  | **0.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                |                        |
  | **0.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6616))Ensure event.kind is correctly set for pipeline errors.                                                     |                        |
  | **0.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                |                        |
  | **0.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                       |                        |
  | **0.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                |                        |
  | **0.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                |                        |
  | **0.11.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4802))Update docs to match field definitions.                                                                         |                        |
  | **0.11.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4610))Remove duplicate fields.                                                                                        |                        |
  | **0.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                |                        |
  | **0.10.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                          |                        |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3866))Update package to ECS 8.4.0                                                                                 |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                |                        |
  | **0.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update to ECS 8.2.0                                                                                         |                        |
  | **0.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2586))Update to ECS 8.0.0                                                                                         |                        |
  | **0.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                              |                        |
  | **0.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2274))Add 8.0.0 version constraint                                                                                |                        |
  | **0.5.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2103))Uniform with guidelines                                                                                     |                        |
  | **0.5.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1968))Update Title and Description.                                                                               |                        |
  | **0.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1882))Fixed a bug that prevents the package from working in 7.16.                                                     |                        |
  | **0.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1823))Fix logic that checks for the 'forwarded' tag                                                                   |                        |
  | **0.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1663))Update to ECS 1.12.0                                                                                        |                        |
  | **0.4.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1541))Requires version 7.14.1 of the stack                                                                            |                        |
  | **0.4.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1482))Convert to generated ECS fields                                                                             |                        |
  | **0.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1389))update to ECS 1.11.0                                                                                        |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                              |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1264))Set "event.module" and "event.dataset"                                                                      |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1055))update to ECS 1.10.0 and adding event.original options                                                      |                        |
  | **0.1.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/850))update to ECS 1.9.0                                                                                          |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/package-storage/pull/181))initial release                                                                                           |                        |
</dropdown>