﻿---
title: IIS OpenTelemetry Input Package
description: The IIS OpenTelemetry Input Package for Elastic enables collection of telemetry data from Internet Information Services (IIS) web servers through OpenTelemetry...
url: https://www.elastic.co/docs/reference/integrations/iis_otel_input
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# IIS OpenTelemetry Input Package
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The IIS OpenTelemetry Input Package integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The IIS OpenTelemetry Input Package for Elastic enables collection of telemetry data from Internet Information Services (IIS) web servers through OpenTelemetry protocols using the [iisreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/iisreceiver#iis-receiver).

### How it works

This package receives telemetry data from IIS servers by configuring the IIS receiver in the Input Package, which then gets applied to the iisreceiver present in the EDOT collector, which then forwards the data to Elastic Agent. The Elastic Agent processes and enriches the data before sending it to Elasticsearch for indexing and analysis. Once the data arrives into Elasticsearch, its corresponding [IIS OpenTelemetry Assets Package](https://www.elastic.co/docs/reference/integrations/iis_otel) gets auto installed and the dashboards light up.

## Metrics reference

For a complete list of all available metrics and their detailed descriptions, refer to the [IIS Receiver documentation](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/iisreceiver/documentation.md) in the upstream OpenTelemetry Collector repository.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                               | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17099))Initial draft of the package |                        |
</dropdown>