﻿---
title: IIS metrics for OpenTelemetry Collector
description: The IIS metrics from IIS OpenTelemetry receiver allow you to monitor Internet Information Services (IIS) for Windows® Server, a flexible, secure and manageable...
url: https://www.elastic.co/docs/reference/integrations/iis_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# IIS metrics for OpenTelemetry Collector
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.2.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The IIS OpenTelemetry assets integration v0.2.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

The IIS metrics from IIS OpenTelemetry receiver allow you to monitor [Internet Information Services (IIS) for Windows® Server](https://www.iis.net), a flexible, secure and manageable Web server for hosting anything on the Web. From media streaming to web applications, IIS's scalable and open architecture is ready to handle the most demanding tasks.
The IIS OpenTelemetry assets provide a visual representation of IIS metrics collected via OpenTelemetry ([IIS receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/iisreceiver)).

## Compatibility

The IIS OpenTelemetry assets have been tested with [OpenTelemetry IIS receiver v0.130.0](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/v0.130.0/receiver/iisreceiver/README.md) and Windows 10 Pro N.

## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

1. Install and configure the upstream OpenTelemetry Collector to export metrics to ElasticSearch, as shown in the following example:

```yaml
receivers:
  iis:
    collection_interval: 10s
    initial_delay: 1s
exporters:
  debug:
    verbosity: detailed
  elasticsearch/otel:
    endpoints: https://elasticsearch:9200
    user: <userid>
    password: <pwd>
    mapping:
      mode: otel
    metrics_dynamic_index:
      enabled: true
service:
  pipelines:
    metrics:
      exporters: [debug, elasticsearch/otel]
      receivers: [iis]
```

Use this configuration to run the collector.

## Metrics reference


### IIS metrics

Refer to [the documentation of the OpenTelemetry's IIS receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/iisreceiver/documentation.md).

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![IIS OTEL Metrics screenshot](https://epr.elastic.co/package/iis_otel/0.2.0/img/iis_otel_1.png)

  ![IIS OTEL Metrics screenshot (continued)](https://epr.elastic.co/package/iis_otel/0.2.0/img/iis_otel_2.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                               | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15664))Add `discovery` field to support auto-install                |                        |
  | **0.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15475))Add `opentelemetry` category                                 |                        |
  | **0.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15081))Remove mentions of "Content Pack" and EDOT Collector from README |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14918))First release of the IIS OpenTelemetry content package       |                        |
</dropdown>