﻿---
title: HTTP Check Integration for Elastic
description: The HTTP Check integration for Elastic performs HTTP checks using the HTTP check receiver of the OTel Collector. This integration can be used to monitor...
url: https://www.elastic.co/docs/reference/integrations/httpcheck_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# HTTP Check Integration for Elastic
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                                                          |

<admonition title="The Simple HTTP Check integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>


## Overview

The HTTP Check integration for Elastic performs HTTP checks using the [HTTP check
receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/httpcheckreceiver/README.md) of the OTel Collector.
This integration can be used to monitor the availability of HTTP endpoints.

### How it works

This integration performs periodic HTTP checks to the configured endpoints.
Apart from the endpoints, it is also possible to select the HTTP method and
headers to use in the requests.

## What data does this integration collect?

This integration collects metrics with information about the
availability of the HTTP endpoints, and the status codes returned by requests.
Key metrics are stored under the metrics object, and they include:

| Metric Name        | Description                                                                                                                      | Type  |
|--------------------|----------------------------------------------------------------------------------------------------------------------------------|-------|
| httpcheck.status   | For each status class (1xx, 2xx, 3xx, 4xx or 5xx), it is set to 1 if the check returned an status of this class, to 0 otherwise. | Gauge |
| httpcheck.duration | Total duration of the request in milliseconds.                                                                                   | Gauge |

Documents for these metrics include attributes that follow [Semantic Conventions
for HTTP data](https://opentelemetry.io/docs/specs/semconv/http/).

### Supported use cases

This integration can be used to monitor the availability of HTTP endpoints. In a
more general sense, it can be used to perform requests to specific endpoints.

## How do I deploy this integration?


### Agent-based deployment

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.
Elastic Agent is required to have network connectivity with the monitored
endpoints.

### Onboard / configure

This integration needs to be configured with the list of endpoints to monitor,
and the HTTP method and headers that should be used on the requests.
With each policy you can monitor multiple endpoints that require the same method
and headers. For example you can use a single policy to monitor multiple
endpoints if you only need to check its availability with the `GET` method.
In cases where different headers or methods are required, multiple policies must
be created, one for each combination of configurations.

### Validation

Once configured, you can find documents with information about the status code
of the requests done to the configured endpoints.

## Troubleshooting

For help with Elastic ingest tools, check [Common problems](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).

## Scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### Inputs used

This package uses the [HTTP Check Receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/receiver/httpcheckreceiver/README.md) of the OTel collector.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                 | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15785))Initial version of the package |                        |
</dropdown>