﻿---
title: Custom HTTP Endpoint Log integration
description: The custom HTTP Endpoint Log integration initializes a listening HTTP server that collects incoming HTTP POST requests containing a JSON body. The body...
url: https://www.elastic.co/docs/reference/integrations/http_endpoint
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Custom HTTP Endpoint Log integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.15.0                    |

The custom HTTP Endpoint Log integration initializes a listening HTTP server that collects incoming HTTP POST requests containing a JSON body. The body must be either an object or an array of objects. Any other data types will result in an HTTP 400 (Bad Request) response. For arrays, one document is created for each object in the array.
These are the possible response codes from the server.

| HTTP Response Code | Name                   | Reason                                                             |
|--------------------|------------------------|--------------------------------------------------------------------|
| 200                | OK                     | Returned on success.                                               |
| 400                | Bad Request            | Returned if JSON body decoding fails.                              |
| 401                | Unauthorized           | Returned when basic auth, secret header, or HMAC validation fails. |
| 405                | Method Not Allowed     | Returned if methods other than POST are used.                      |
| 406                | Not Acceptable         | Returned if the POST request does not contain a body.              |
| 415                | Unsupported Media Type | Returned if the Content-Type is not application/json.              |
| 500                | Internal Server Error  | Returned if an I/O error occurs reading the request.               |

Custom ingest pipelines may be added by adding the name to the pipeline configuration option, creating custom ingest pipelines can be done either through the API or the *Ingest Node Pipeline UI* (use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) to search for "ingest pipelines").

## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                               | 9.0.08.15.0            |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12942))Note support for base64-encoded HMAC headers.                                                                                                                                                                                                                                            | 8.15.0                 |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12943))Improve HMAC configuration documentation.                                                                                                                                                                                                                                                    | 8.14.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12016))Make CEL program configuration available.                                                                                                                                                                                                                                                | 8.14.0                 |
  | **2.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10289))Pass `preserve_original_event` state to input.                                                                                                                                                                                                                                               | 8.14.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                | 8.14.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9909))Provide request tracing support.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9843))Added test for end-to-end ACK behaviour.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9935))Clarify supported HMAC header format. | 8.12.0                 |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9732))Converted package to input type.                                                                                                                                                                                                                                                          | 8.12.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9311))Allow user selection of HTTP method.                                                                                                                                                                                                                                                      | 8.12.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9127))Set sensitive values as secret.                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                 | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                      | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6548))Fix handling of include header config.                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6297))Update package-spec version to 2.7.0.                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                    | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4485))Added infrastructure category.                                                                                                                                                                                                                                                            | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3866))Update package to ECS 8.4.0                                                                                                                                                                                                                                                               | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                              | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update ECS to 8.2                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2727))Update readme                                                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2724))Initial Release                                                                                                                                                                                                                                                                           |                        |
</dropdown>