﻿---
title: Google Cloud
description: Collect logs and metrics from various Google Cloud products. Google Cloud is a suite of cloud computing services including computing, data storage, data...
url: https://www.elastic.co/docs/reference/integrations/google-cloud-intro
products:
  - Elastic integrations
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Google Cloud
Collect logs and metrics from various Google Cloud products. Google Cloud is a suite of cloud computing services including computing, data storage, data analytics, and machine learning.
- [Custom GCS Input](https://www.elastic.co/docs/reference/integrations/google_cloud_storage)
- [GCP](https://www.elastic.co/docs/reference/integrations/gcp)
- [GCP Audit logs](https://www.elastic.co/docs/reference/integrations/gcp/audit)
- [GCP Audit logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/gcp_audit_otel)
- [GCP Billing metrics](https://www.elastic.co/docs/reference/integrations/gcp/billing)
- [GCP Cloud Run metrics](https://www.elastic.co/docs/reference/integrations/gcp/cloudrun)
- [GCP CloudSQL metrics](https://www.elastic.co/docs/reference/integrations/gcp/cloudsql)
- [GCP Compute metrics](https://www.elastic.co/docs/reference/integrations/gcp/compute)
- [GCP Dataproc metrics](https://www.elastic.co/docs/reference/integrations/gcp/dataproc)
- [GCP DNS logs](https://www.elastic.co/docs/reference/integrations/gcp/dns)
- [GCP Firestore metrics](https://www.elastic.co/docs/reference/integrations/gcp/firestore)
- [GCP Firewall logs](https://www.elastic.co/docs/reference/integrations/gcp/firewall)
- [GCP GKE metrics](https://www.elastic.co/docs/reference/integrations/gcp/gke)
- [GCP Load Balancing metrics](https://www.elastic.co/docs/reference/integrations/gcp/loadbalancing)
- [GCP Metrics Input](https://www.elastic.co/docs/reference/integrations/gcp_metrics)
- [GCP PubSub logs (custom)](https://www.elastic.co/docs/reference/integrations/gcp_pubsub)
- [GCP PubSub metrics](https://www.elastic.co/docs/reference/integrations/gcp/pubsub)
- [GCP Redis metrics](https://www.elastic.co/docs/reference/integrations/gcp/redis)
- [GCP Security Command Center](https://www.elastic.co/docs/reference/integrations/google_scc)
- [GCP Storage metrics](https://www.elastic.co/docs/reference/integrations/gcp/storage)
- [GCP VPC Flow logs](https://www.elastic.co/docs/reference/integrations/gcp/vpcflow)
- [GCP VPC Flow logs OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/gcp_vpcflow_otel)
- [GCP Vertex AI](https://www.elastic.co/docs/reference/integrations/gcp_vertexai)