﻿---
title: GCP VPC Flow Logs OpenTelemetry Assets
description: This package contains Kibana assets for monitoring GCP Virtual Private Cloud (VPC) Flow Logs. ECF is the simplest way to configure GCP log collection...
url: https://www.elastic.co/docs/reference/integrations/gcp_vpcflow_otel
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# GCP VPC Flow Logs OpenTelemetry Assets
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.1.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.1                                                          |

<admonition title="The GCP VPC Flow Logs OpenTelemetry Assets integration v0.1.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

This package contains Kibana assets for monitoring [GCP Virtual Private Cloud (VPC) Flow Logs](https://docs.cloud.google.com/vpc/docs/flow-logs).

## Supported data sources


### EDOT Cloud Forwarder (ECF) for GCP

ECF is the simplest way to configure GCP log collection. For the setup instructions, check the [ECF documentation](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder/gcp).

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Dashboard screenshot](https://epr.elastic.co/package/gcp_vpcflow_otel/0.1.0/img/dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                      | Minimum Kibana version |
  |-----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16439))Initial draft of the GCP VPC Flow Logs OpenTelemetry Assets Package |                        |
</dropdown>