﻿---
title: GCP Custom Metrics
description: The GCP Custom Metrics input package can collect custom metrics for any GCP service. A list of metrics and services that are available, can be found in...
url: https://www.elastic.co/docs/reference/integrations/gcp_metrics
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# GCP Custom Metrics
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.3.1 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.15.0                                                    |

<admonition title="The GCP Metrics Input integration v0.3.1 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

The GCP Custom Metrics input package can collect custom metrics for any GCP service.
A list of metrics and services that are available, can be found in the [GCP Cloud Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp) official documentation.
The `metrics` configuration should be configured as the `metrics` fields of the [GCP `metrics` metricset](https://www.elastic.co/guide/en/beats/metricbeat/current/metricbeat-metricset-gcp-metrics.html)
This package does not contain any ingest pipeline, so no pre-ingest data processing is applied out of the box. Custom ingest pipelines can be added through the Kibana UI, to get the data in the desired format.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.3.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14765))Fixed GCP project ID handling to prevent numeric parsing issues by enforcing string type casting in YAML configuration templates. |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12660))Add support for Kibana `9.0.0`                                                                                                |                        |
  | **0.2.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                         |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10665))Set kibana restriction to 8.15.0, where was reduced scope of the ecs_geo_point                                                |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8041))Update the package format_version to 3.0.0.                                                                                    |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6212))Add base fields mappings                                                                                                       |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4436))Initial draft of the package                                                                                                   |                        |
</dropdown>