﻿---
title: Load Balancing
description: The loadbalancing_logs dataset collects logs of the requests sent to and handled by GCP Load Balancers. ECS Field Reference Please refer to the following...
url: https://www.elastic.co/docs/reference/integrations/gcp/loadbalancing
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Load Balancing
|                                                                            |                                 |
|----------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                | 2.47.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                           |
| **Ingestion method(s)**                                                    | API, GCP Pub/Sub                |
| **Minimum Kibana version(s)**                                              | 9.0.08.13.0                     |


## Logs

The `loadbalancing_logs` dataset collects logs of the requests sent to and handled by GCP Load Balancers.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-06-08T23:41:30.078Z",
      "agent": {
          "ephemeral_id": "f4dde373-2ff7-464b-afdb-da94763f219b",
          "id": "5d3eee86-91a9-4afa-af92-c6b79bd866c0",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.6.0"
      },
      "cloud": {
          "project": {
              "id": "PROJECT_ID"
          },
          "region": "global"
      },
      "data_stream": {
          "dataset": "gcp.loadbalancing_logs",
          "namespace": "ep",
          "type": "logs"
      },
      "destination": {
          "address": "81.2.69.193",
          "ip": "81.2.69.193",
          "nat": {
              "ip": "10.5.3.1",
              "port": 9090
          },
          "port": 8080
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5d3eee86-91a9-4afa-af92-c6b79bd866c0",
          "snapshot": true,
          "version": "8.6.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "created": "2020-06-08T23:41:30.588Z",
          "dataset": "gcp.loadbalancing_logs",
          "id": "1oek5rg3l3fxj7",
          "ingested": "2023-01-13T15:02:22Z",
          "kind": "event",
          "type": [
              "info"
          ]
      },
      "gcp": {
          "load_balancer": {
              "backend_service_name": "",
              "cache_hit": true,
              "cache_id": "SFO-fbae48ad",
              "cache_lookup": true,
              "forwarding_rule_name": "FORWARDING_RULE_NAME",
              "status_details": "response_from_cache",
              "target_proxy_name": "TARGET_PROXY_NAME",
              "url_map_name": "URL_MAP_NAME"
          }
      },
      "http": {
          "request": {
              "bytes": 577,
              "method": "GET",
              "referrer": "https://developer.mozilla.org/en-US/docs/Web/JavaScript"
          },
          "response": {
              "bytes": 157,
              "status_code": 304
          },
          "version": "2.0"
      },
      "input": {
          "type": "gcp-pubsub"
      },
      "log": {
          "level": "INFO",
          "logger": "projects/PROJECT_ID/logs/requests"
      },
      "network": {
          "protocol": "http"
      },
      "related": {
          "ip": [
              "89.160.20.156",
              "81.2.69.193",
              "10.5.3.1"
          ]
      },
      "source": {
          "address": "89.160.20.156",
          "as": {
              "number": 29518,
              "organization": {
                  "name": "Bredband2 AB"
              }
          },
          "geo": {
              "city_name": "Linköping",
              "continent_name": "Europe",
              "country_iso_code": "SE",
              "country_name": "Sweden",
              "location": {
                  "lat": 58.4167,
                  "lon": 15.6167
              },
              "region_iso_code": "SE-E",
              "region_name": "Östergötland County"
          },
          "ip": "89.160.20.156",
          "port": 9989
      },
      "tags": [
          "forwarded",
          "gcp-loadbalancing_logs"
      ],
      "url": {
          "domain": "81.2.69.193",
          "extension": "jpg",
          "original": "http://81.2.69.193:8080/static/us/three-cats.jpg",
          "path": "/static/us/three-cats.jpg",
          "port": 8080,
          "scheme": "http"
      },
      "user_agent": {
          "device": {
              "name": "Mac"
          },
          "name": "Chrome",
          "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36",
          "os": {
              "full": "Mac OS X 10.14.6",
              "name": "Mac OS X",
              "version": "10.14.6"
          },
          "version": "83.0.4103.61"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                  | Description                                                                                                                                                                                                                                                                                                                                             | Type             |
  |----------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                             | Event timestamp.                                                                                                                                                                                                                                                                                                                                        | date             |
  | cloud.image.id                         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                        | keyword          |
  | data_stream.dataset                    | Data stream dataset.                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | data_stream.namespace                  | Data stream namespace.                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | data_stream.type                       | Data stream type.                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | event.dataset                          | Event dataset                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.module                           | Event module                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | gcp.load_balancer.backend_service_name | The backend service to which the load balancer is sending traffic                                                                                                                                                                                                                                                                                       | keyword          |
  | gcp.load_balancer.cache_hit            | Whether or not an entity was served from cache (with or without validation).                                                                                                                                                                                                                                                                            | boolean          |
  | gcp.load_balancer.cache_id             | Indicates the location and cache instance that the cache response was served from. For example, a cache response served from a cache in Amsterdam would have a cacheId value of AMS-85e2bd4b, where AMS is the IATA code, and 85e2bd4b is an opaque identifier of the cache instance  (because some Cloud CDN locations have multiple discrete caches). | keyword          |
  | gcp.load_balancer.cache_lookup         | Whether or not a cache lookup was attempted.                                                                                                                                                                                                                                                                                                            | boolean          |
  | gcp.load_balancer.forwarding_rule_name | The name of the forwarding rule                                                                                                                                                                                                                                                                                                                         | keyword          |
  | gcp.load_balancer.status_details       | Explains why the load balancer returned the HTTP status that it did. See  for specific messages.                                                                                                                                                                                                                                                        | keyword          |
  | gcp.load_balancer.target_proxy_name    | The target proxy name                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | gcp.load_balancer.url_map_name         | The URL map name                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.containerized                     | If the host is a container.                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.os.build                          | OS build information.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | input.type                             | Input type                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | log.offset                             | Log offset                                                                                                                                                                                                                                                                                                                                              | long             |
</dropdown>


## Metrics

The `loadbalancing_metrics` dataset fetches HTTPS, HTTP, and Layer 3 metrics from [Load Balancing](https://cloud.google.com/load-balancing/) in Google Cloud Platform. It contains all metrics exported from the [GCP Load Balancing Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-loadbalancing).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2017-10-12T08:05:34.853Z",
      "cloud": {
          "account": {
              "id": "elastic-observability"
          },
          "provider": "gcp",
          "region": "us-central1",
          "availability_zone": "us-central1-a"
      },
      "event": {
          "dataset": "gcp.loadbalancing_metrics",
          "duration": 115000,
          "module": "gcp"
      },
      "gcp": {
          "labels": {
              "metrics": {
                  "client_network": "ocp-be-c5kjr-network",
                  "client_subnetwork": "ocp-be-c5kjr-worker-subnet",
                  "client_zone": "us-central1-a"
              },
              "resource": {
                  "backend_name": "ocp-be-c5kjr-master-us-central1-a",
                  "backend_scope": "us-central1-a",
                  "backend_scope_type": "ZONE",
                  "backend_subnetwork_name": "ocp-be-c5kjr-master-subnet",
                  "backend_target_name": "ocp-be-c5kjr-api-internal",
                  "backend_target_type": "BACKEND_SERVICE",
                  "backend_type": "INSTANCE_GROUP",
                  "forwarding_rule_name": "ocp-be-c5kjr-api-internal",
                  "load_balancer_name": "ocp-be-c5kjr-api-internal",
                  "network_name": "ocp-be-c5kjr-network",
                  "region": "us-central1"
              }
          },
          "loadbalancing_metrics": {
              "l3": {
                  "internal": {
                      "egress_packets": {
                          "count": 100
                      },
                      "egress": {
                          "bytes": 1247589
                      }
                  }
              }
          }
      },
      "metricset": {
          "name": "loadbalancing",
          "period": 10000
      },
      "service": {
          "type": "gcp"
      }
  }
  ```
</dropdown>

**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                                     | Description                                                                                                                                                                                            | Type             | Metric Type |
  |---------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|-------------|
  | @timestamp                                                                | Event timestamp.                                                                                                                                                                                       | date             |             |
  | agent.id                                                                  | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.                                                                                                             | keyword          |             |
  | cloud.account.id                                                          | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                     | keyword          |             |
  | cloud.image.id                                                            | Image ID for the cloud instance.                                                                                                                                                                       | keyword          |             |
  | data_stream.dataset                                                       | Data stream dataset.                                                                                                                                                                                   | constant_keyword |             |
  | data_stream.namespace                                                     | Data stream namespace.                                                                                                                                                                                 | constant_keyword |             |
  | data_stream.type                                                          | Data stream type.                                                                                                                                                                                      | constant_keyword |             |
  | event.dataset                                                             | Event dataset                                                                                                                                                                                          | constant_keyword |             |
  | event.module                                                              | Event module                                                                                                                                                                                           | constant_keyword |             |
  | gcp.labels.metadata.*                                                     |                                                                                                                                                                                                        | object           |             |
  | gcp.labels.metrics.*                                                      |                                                                                                                                                                                                        | object           |             |
  | gcp.labels.resource.*                                                     |                                                                                                                                                                                                        | object           |             |
  | gcp.labels.system.*                                                       |                                                                                                                                                                                                        | object           |             |
  | gcp.labels.user.*                                                         |                                                                                                                                                                                                        | object           |             |
  | gcp.labels_fingerprint                                                    | Hashed value of the labels field.                                                                                                                                                                      | keyword          |             |
  | gcp.loadbalancing_metrics.https.backend_latencies.value                   | A distribution of the latency calculated from when the request was sent by the proxy to the backend until the proxy received from the backend the last byte of response.                               | object           |             |
  | gcp.loadbalancing_metrics.https.backend_request.bytes                     | Delta of the number of bytes sent as requests from HTTP/S load balancer to backends.                                                                                                                   | long             | gauge       |
  | gcp.loadbalancing_metrics.https.backend_request.count                     | Delta of the number of requests served by backends of HTTP/S load balancer.                                                                                                                            | long             | gauge       |
  | gcp.loadbalancing_metrics.https.backend_response.bytes                    | Delta of the number of bytes sent as responses from backends (or cache) to external HTTP(S) load balancer.                                                                                             | long             | gauge       |
  | gcp.loadbalancing_metrics.https.external.regional.backend_latencies.value | A distribution of the latency calculated from when the request was sent by the proxy to the backend until the proxy received from the backend the last byte of response.                               | object           |             |
  | gcp.loadbalancing_metrics.https.external.regional.total_latencies.value   | A distribution of the latency calculated from when the request was received by the proxy until the proxy got ACK from client on last response byte.                                                    | object           |             |
  | gcp.loadbalancing_metrics.https.frontend_tcp_rtt.value                    | A distribution of the RTT measured for each connection between client and proxy.                                                                                                                       | object           |             |
  | gcp.loadbalancing_metrics.https.internal.backend_latencies.value          | A distribution of the latency calculated from when the request was sent by the internal HTTP/S load balancer proxy to the backend until the proxy received from the backend the last byte of response. | object           |             |
  | gcp.loadbalancing_metrics.https.internal.total_latencies.value            | A distribution of the latency calculated from when the request was received by the internal HTTP/S load balancer proxy until the proxy got ACK from client on last response byte.                      | object           |             |
  | gcp.loadbalancing_metrics.https.request.bytes                             | Delta of the number of bytes sent as requests from clients to HTTP/S load balancer.                                                                                                                    | long             | gauge       |
  | gcp.loadbalancing_metrics.https.request.count                             | Delta of the number of requests served by HTTP/S load balancer.                                                                                                                                        | long             | gauge       |
  | gcp.loadbalancing_metrics.https.response.bytes                            | Delta of the number of bytes sent as responses from HTTP/S load balancer to clients.                                                                                                                   | long             | gauge       |
  | gcp.loadbalancing_metrics.https.total_latencies.value                     | A distribution of the latency calculated from when the request was received by the external HTTP/S load balancer proxy until the proxy got ACK from client on last response byte.                      | object           |             |
  | gcp.loadbalancing_metrics.l3.external.egress.bytes                        | Delta of the number of bytes sent from external TCP/UDP network load balancer backend to client of the flow. For TCP flows it's counting bytes on application stream only.                             | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.external.egress_packets.count                | Delta of the number of packets sent from external TCP/UDP network load balancer backend to client of the flow.                                                                                         | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.external.ingress.bytes                       | Delta of the number of bytes sent from client to external TCP/UDP network load balancer backend. For TCP flows it's counting bytes on application stream only.                                         | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.external.ingress_packets.count               | Delta of the number of packets sent from client to external TCP/UDP network load balancer backend.                                                                                                     | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.external.rtt_latencies.value                 | A distribution of the round trip time latency, measured over TCP connections for the external network load balancer.                                                                                   | object           |             |
  | gcp.loadbalancing_metrics.l3.internal.egress.bytes                        | Delta of the number of bytes sent from ILB backend to client (for TCP flows it's counting bytes on application stream only).                                                                           | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.internal.egress_packets.count                | Delta of the number of packets sent from ILB backend to client of the flow.                                                                                                                            | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.internal.ingress.bytes                       | Delta of the number of bytes sent from client to ILB backend (for TCP flows it's counting bytes on application stream only).                                                                           | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.internal.ingress_packets.count               | Delta of the number of packets sent from client to ILB backend.                                                                                                                                        | long             | gauge       |
  | gcp.loadbalancing_metrics.l3.internal.rtt_latencies.value                 | A distribution of RTT measured over TCP connections for internal TCP/UDP load balancer flows.                                                                                                          | object           |             |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.closed_connections.value          | Delta of the number of connections that were terminated over TCP/SSL proxy.                                                                                                                            | long             | gauge       |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.egress.bytes                      | Delta of the number of bytes sent from VM to client using proxy.                                                                                                                                       | long             | gauge       |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.frontend_tcp_rtt.value            | A distribution of the smoothed RTT (in ms) measured by the proxy's TCP stack, each minute application layer bytes pass from proxy to client.                                                           | object           |             |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.ingress.bytes                     | Delta of the number of bytes sent from client to VM using proxy.                                                                                                                                       | long             | gauge       |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.new_connections.value             | Delta of the number of connections that were created over TCP/SSL proxy.                                                                                                                               | long             | gauge       |
  | gcp.loadbalancing_metrics.tcp_ssl_proxy.open_connections.value            | Current number of outstanding connections through the TCP/SSL proxy.                                                                                                                                   | long             | gauge       |
  | gcp.metrics.*.*.*.*                                                       | Metrics that returned from Google Cloud API query.                                                                                                                                                     | object           |             |
  | host.containerized                                                        | If the host is a container.                                                                                                                                                                            | boolean          |             |
  | host.os.build                                                             | OS build information.                                                                                                                                                                                  | keyword          |             |
  | host.os.codename                                                          | OS codename, if any.                                                                                                                                                                                   | keyword          |             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![filebeat gcp audit](https://epr.elastic.co/package/gcp/2.47.1/img/filebeat-gcp-audit.png)

  ![GCP Billing Metrics Dashboard](https://epr.elastic.co/package/gcp/2.47.1/img/gcp-billing.png)

  ![GCP Compute Metrics Dashboard](https://epr.elastic.co/package/gcp/2.47.1/img/gcp-compute.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version            | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Minimum Kibana version |
  |--------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.47.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16898))Fix gke network metrics fields and dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **2.47.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15828))Enhance GCP billing data stream with additional fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **2.46.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15930))Add type-specific entity fields to data stream.This enables better entity classification while maintaining backward compatibility with existing `actor.entity.id` and `target.entity.id` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.13.0            |
  | **2.45.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15279))Prefer set with copy_from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **2.44.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15619))Add support for parsing sensitive action notifications event in the audit dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.13.0            |
  | **2.43.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14745))Add tags and processors to GCP Billing, Cloudrun, CloudSQL, Dataproc, GKE, Loadbalancing, Pubsub and Redis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.13.0            |
  | **2.42.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14765))Fixed GCP project ID handling to prevent numeric parsing issues by enforcing string type casting in YAML configuration templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **2.42.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13777))Remove redundant audit violation field renames.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.13.0            |
  | **2.42.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13521))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.13.0            |
  | **2.41.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13633))Preserve original value of resource name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.13.0            |
  | **2.41.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12251))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.13.0            |
  | **2.40.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **2.40.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11983))Add `actor.entity.id` and `target.entity.id` fields to audit logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.39.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11762))Add `related.entity` field to audit logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.38.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10886))Add `policy_violation_info`, `metadata` and `related` fields to audit logs.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10886))Update GCP audit log dashboard to use correct `email` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.37.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11016))Fix definition of subfields of nested objects                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.37.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9931))Improve GCP Billing documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.37.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10701))Retain `authenticationInfo.serviceAccountKeyName` data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.36.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10398))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **2.35.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10225))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.34.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10159))Fix Redis metric type for 'persistence.rdb.bgsave_in_progress'. Metric type should be boolean instead of long.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **2.34.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9508))Add tags and processors to GCP Compute, Firestore, PostgreSQL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                 |
  | **2.33.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9252))Add tags and processors to GCP Storage                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **2.33.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8404))Update Legacy metric visualization to new metric in GCP Billing overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.33.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8662))Enable time series data for metrics data streams. This dramatically reduces storage for metrics and is expected to progressively improve query [performance](https://www.elastic.co/blog/70-percent-storage-savings-for-metrics-with-elastic-observability). For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.32.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8314))Add dimensions mappings and the metrics_fingerprint field across all metrics data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.32.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8343))Add new billing data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.31.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8447))Fix pipeline error parsing DNS logs with empty rdata field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **2.31.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8096))Add Cloud Run docs and fix policy template name to allow adding Cloud Run logs to the policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.31.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8299))Allow users to retain otherwised discarded fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **2.30.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mappings of group fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.30.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7957))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7957))Upgrade package spec to 3.0.0.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7957))Fix orphan dashboard references.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7957))Add missing dashboard filters.                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.29.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7934))Add null checks and ignore_missing checks to the rename processor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.29.0**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7367))Remove GCP CloudSQL deprecated, alpha or beta metrics and fix field types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.28.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7569))Set metric type for GKE, Load Balancing, PubSub, Redis and Storage data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.28.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7458))Migrate GCP Load Balancing HTTPS Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.28.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7560))Set metric type for Cloud Run, Compute, Dataproc and Firestore data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.28.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7459))Migrate GCP Load Balancing TCP SSL Proxy Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.28.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7556))Set metric type for CloudSQL data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **2.28.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7461))Migrate GCP Load Balancing L3 Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **2.27.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7368))Add GCP CloudSQL MySQL, SQL Server and PostgreSQL dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.26.0**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7287))Fix GCP loadbalancing_metrics fields prefix.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.25.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7308))Fix check on gcp.audit.authorization_info[].granted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.25.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7249))Migrate GCP Billing input control to new control panel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **2.24.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4126))Add GCP CloudSQL MySQL, Postgres, SQLServer data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.23.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7014))Convert security dashboards to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.22.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Change ownership in manifest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                  |
  | **2.22.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                  |
  | **2.21.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.20.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6128))Fix invalid TSDS metric type for persistence.rdb.bgsave_in_progress field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                  |
  | **2.20.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.19.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5038))Migrate compute dashboard to lens and add datastream filter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.19.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5097))Add Cloud Run metrics datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.6.0                  |
  | **2.18.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5630))Support `subscription_num_goroutines` and `subscription_max_outstanding_messages` for GCP PubSub input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **2.17.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5597))Fix IP Convert processor in Audit ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.6.0                  |
  | **2.17.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **2.17.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add Audit Log Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add GKE Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add PubSub Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add Storage Overview dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                  |
  | **2.16.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5231))Add logic to handle scalar request.policy values on audit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.5.0                  |
  | **2.16.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5032))Replace missing input control panel with new-style control.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.5.0                  |
  | **2.16.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **2.15.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4729))Update documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.5.0                  |
  | **2.15.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4639))Add GCP Compute pipeline test.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.5.0                  |
  | **2.15.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4197))Remove support for Kibana 7.17.x**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4197))Support multiple regions for metrics data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.5.0                  |
  | **2.14.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.3.0                  |
  | **2.13.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4214))Migrate dashboard by values                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.0                  |
  | **2.12.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4397))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.12.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4325))Add GCP Redis                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.3.07.17.6            |
  | **2.11.12**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4357))Add GKE ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.11.11**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4371))Fix type of dns.answers.ttl.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.10**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4344))Add ingest pipeline for dataproc.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4350))Add GCP loadbalancing ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4349))Add GCP PubSub ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4348))Add GCP Storage ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4347))Add GCP Firestore ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4343))Add GCP Compute ingest pipeline                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.11.10-beta.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4344))Add ingest pipeline for dataproc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **2.11.10-beta.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4350))Add GCP loadbalancing ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **2.11.10-beta.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4349))Add GCP PubSub ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **2.11.10-beta.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4348))Add GCP Storage ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **2.11.10-beta.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4347))Add GCP Firestore ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **2.11.10-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4343))Add GCP Compute ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **2.11.9**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4355))Fix GKE kubernetes.io indentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.3.07.17.6            |
  | **2.11.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4339))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4270))Move Dataproc lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4269))Move LoadBalancing lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.3.07.17.6            |
  | **2.11.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4268))Move Storage lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.11.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4267))Move PubSub lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.07.17.6            |
  | **2.11.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3797))Move GKE lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.3.07.17.6            |
  | **2.11.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3798))Move Firestore lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.3.07.17.6            |
  | **2.11.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.3.07.17.6            |
  | **2.11.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3797))Move Compute lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.10.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3788))Add GCP PubSub Data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.3.07.17.6            |
  | **2.9.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3789))Add GCP Dataproc Data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.3.07.17.6            |
  | **2.8.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4098))Add GCP GKE Data Stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.7.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3785))Add GCP Storage Data Stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.6.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3493))Add Load Balancing logs datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.3.07.17.6            |
  | **2.5.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2308))Add GCP Load Balancing Metricset**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Fix credentials_json escaping in loadbalancing_metrics**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Update loadbalancing_metrics default period to 60s**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Fix event.dataset for loadbalancing_metrics**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4004))Add loadbalancing_metrics distribution fields                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.4.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3865))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2340))Add additional parsing for DNS Public Zone Query Logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.07.17.6            |
  | **2.2.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3821))Fix Billing policy template title and default period for gcp.compute                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3609))Remove fields duplicated in ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.07.17.6            |
  | **2.1.0**          | **Enhancement**restore compatibility with 7.17 release track                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.0.0**          | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/2707))Move configurations to support metrics. This change is breaking, as it movessome configuration from the top level variables to data stream variables.This change involves `project_id`, `credentials_file` and `credentials_json`variables that are moved from input level configuration to package levelconfiguration (as those variables are reused across all inputs/data streams).Users with GCP integration enabled will need to input values for thesevariables again when upgrading the policies to this version.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2141))Add GCP Billing Data Stream**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2301))Add GCP Compute Data Stream**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2704))Add GCP Firestore Data stream | 8.3.0                  |
  | **1.10.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.17.0            |
  | **1.9.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3583))Fix GCP auditlog parsing issue on response status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.17.0            |
  | **1.9.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3103))Update readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.17.0            |
  | **1.9.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3390))Preserve request and response in flattened fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.17.0            |
  | **1.8.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3274))Add missing `cloud.provider` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.17.0            |
  | **1.7.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3280))Add dashboards for firewall and vpc flow logs.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3280))Add missing mappings for several `event.*` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **1.6.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3206))Clarify the GCP privileges required by the Pub/Sub input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.3            |
  | **1.6.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update to ECS 8.2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.5.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.3            |
  | **1.5.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2842))Improve Google Cloud Platform docs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.3            |
  | **1.4.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2747))Remove emtpy values, names with only dots, and invalid client IPs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.3            |
  | **1.4.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2712))Fix quoting of the credentials_json value in policy templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.3            |
  | **1.4.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2624))Add gcp.dns integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **1.3.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2470))Add Ingest Pipeline script to map IANA Protocol Numbers                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0            |
  | **1.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2406))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.15.0            |
  | **1.2.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.15.0            |
  | **1.2.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2251))Add 8.0.0 version constraint                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.15.0            |
  | **1.1.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1965))Update Title and Description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 7.15.0                 |
  | **1.1.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1818))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **1.1.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1661))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 7.15.0                 |
  | **1.0.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1568))Move from experimental to GA**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1717))remove experimental from data_sets                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.3.3**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1478))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1385))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.3.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1240))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.1.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1045))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.0.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/846))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/459))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
</dropdown>