﻿---
title: Audit
description: The audit dataset collects audit logs of administrative activities and accesses within your Google Cloud resources. ECS Field Reference Please refer to...
url: https://www.elastic.co/docs/reference/integrations/gcp/audit
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Audit
|                                                                            |                                 |
|----------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                | 2.47.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions) | Basic                           |
| **Ingestion method(s)**                                                    | API, GCP Pub/Sub                |
| **Minimum Kibana version(s)**                                              | 9.0.08.13.0                     |


## Logs

The `audit` dataset collects audit logs of administrative activities and accesses within your Google Cloud resources.
**ECS Field Reference**
Please refer to the following [document](https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html) for detailed information on ECS fields.
<dropdown title="Exported fields">
  | Field                                                         | Description                                                                                                                                                                                                                                                                                                                                        | Type             |
  |---------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                    | Event timestamp.                                                                                                                                                                                                                                                                                                                                   | date             |
  | actor.entity.id                                               | [Deprecated] This field is maintained for backward compatibility. Use type-specific fields instead: user.entity.id for user accounts, service.entity.id for service accounts and GCP services, host.entity.id for compute instances, or entity.id for other types.                                                                                 | keyword          |
  | cloud.image.id                                                | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                   | keyword          |
  | data_stream.dataset                                           | Data stream dataset.                                                                                                                                                                                                                                                                                                                               | constant_keyword |
  | data_stream.namespace                                         | Data stream namespace.                                                                                                                                                                                                                                                                                                                             | constant_keyword |
  | data_stream.type                                              | Data stream type.                                                                                                                                                                                                                                                                                                                                  | constant_keyword |
  | entity.id                                                     | Generic entity identifier for principals that don't fit into specific categories (user, service, host). Used as a fallback for unknown or miscellaneous entity types like GitHub repo references.                                                                                                                                                  | keyword          |
  | entity.target.id                                              | Generic entity identifier for targets that don't fit into specific categories. Used for projects, zones, and other miscellaneous GCP resources.                                                                                                                                                                                                    | keyword          |
  | event.dataset                                                 | Event dataset                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | event.module                                                  | Event module                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | gcp.audit.access.caller_ip_geo.region_code                    |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.access.method_name                                  |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.access.principal_email                              |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.access.principal_subject                            |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.access.service_name                                 |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.access.user_agent                                   |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.action_time                                         |                                                                                                                                                                                                                                                                                                                                                    | date             |
  | gcp.audit.action_type                                         |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.affected_resources                                  |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.authentication_info.authority_selector              | The authority selector specified by the requestor, if any. It is not guaranteed  that the principal was allowed to use this authority.                                                                                                                                                                                                             | keyword          |
  | gcp.audit.authentication_info.principal_email                 | The email address of the authenticated user making the request.                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.authentication_info.principal_subject               | String representation of identity of requesting party. Populated for both first and third party identities. Only present for APIs that support third-party identities.                                                                                                                                                                             | keyword          |
  | gcp.audit.authentication_info.service_account_delegation_info | Identity delegation history of an authenticated service account that makes the request. It contains information on the real authorities that try to access GCP resources by delegating on a service account. When multiple authorities present, they are guaranteed to be sorted based on the original ordering of the identity delegation events. | flattened        |
  | gcp.audit.authentication_info.service_account_key_name        | The service account key that was used to request the OAuth 2.0 access token. This field identifies the service account key by its full resource name.                                                                                                                                                                                              | keyword          |
  | gcp.audit.authentication_info.third_party_principal           | The third party identification (if any) of the authenticated user making the request. When the JSON object represented here has a proto equivalent, the proto name will be indicated in the @type property.                                                                                                                                        | flattened        |
  | gcp.audit.authorization_info                                  | Authorization information for the operation.                                                                                                                                                                                                                                                                                                       | nested           |
  | gcp.audit.authorization_info.granted                          | Whether or not authorization for resource and permission was granted.                                                                                                                                                                                                                                                                              | boolean          |
  | gcp.audit.authorization_info.permission                       | The required IAM permission.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | gcp.audit.authorization_info.resource                         | The resource being accessed, as a REST-style string.                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.audit.authorization_info.resource_attributes.name         | The name of the resource.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | gcp.audit.authorization_info.resource_attributes.service      | The name of the service.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | gcp.audit.authorization_info.resource_attributes.type         | The type of the resource.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | gcp.audit.flattened                                           | Contains the full audit document as sent by GCP.                                                                                                                                                                                                                                                                                                   | flattened        |
  | gcp.audit.labels                                              | A map of key, value pairs that provides additional information about the log entry. The labels can be user-defined or system-defined.                                                                                                                                                                                                              | flattened        |
  | gcp.audit.learn_more_uri                                      |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.logentry_operation.first                            | Optional. Set this to True if this is the first log entry in the operation.                                                                                                                                                                                                                                                                        | boolean          |
  | gcp.audit.logentry_operation.id                               | Optional. An arbitrary operation identifier. Log entries with the same identifier are assumed to be part of the same operation.                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.logentry_operation.last                             | Optional. Set this to True if this is the last log entry in the operation.                                                                                                                                                                                                                                                                         | boolean          |
  | gcp.audit.logentry_operation.producer                         | Optional. An arbitrary producer identifier. The combination of id and producer must be globally unique.                                                                                                                                                                                                                                            | keyword          |
  | gcp.audit.metadata                                            | Service-specific data about the request, response, and other information associated with the current audited event.                                                                                                                                                                                                                                | flattened        |
  | gcp.audit.method_name                                         | The name of the service method or operation. For API calls, this  should be the name of the API method.  For example, 'google.datastore.v1.Datastore.RunQuery'.                                                                                                                                                                                    | keyword          |
  | gcp.audit.num_response_items                                  | The number of items returned from a List or Query API method, if applicable.                                                                                                                                                                                                                                                                       | long             |
  | gcp.audit.policy_violation_info.payload                       | Resource payload that is currently in scope and is subjected to orgpolicy conditions.                                                                                                                                                                                                                                                              | flattened        |
  | gcp.audit.policy_violation_info.resource_tags                 | Tags referenced on the resource at the time of evaluation.                                                                                                                                                                                                                                                                                         | flattened        |
  | gcp.audit.policy_violation_info.resource_type                 | Resource type that the orgpolicy is checked against.                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.audit.policy_violation_info.violations.checkedValue       | Value that is being checked for the policy.                                                                                                                                                                                                                                                                                                        | keyword          |
  | gcp.audit.policy_violation_info.violations.constraint         | Constraint name.                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | gcp.audit.policy_violation_info.violations.errorMessage       | Error message that policy is indicating.                                                                                                                                                                                                                                                                                                           | keyword          |
  | gcp.audit.policy_violation_info.violations.policyType         | Indicates the type of the policy.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | gcp.audit.receive_timestamp                                   |                                                                                                                                                                                                                                                                                                                                                    | date             |
  | gcp.audit.request                                             |                                                                                                                                                                                                                                                                                                                                                    | flattened        |
  | gcp.audit.request_metadata.caller_ip                          | The IP address of the caller.                                                                                                                                                                                                                                                                                                                      | ip               |
  | gcp.audit.request_metadata.caller_supplied_user_agent         | The user agent of the caller. This information is not authenticated and  should be treated accordingly.                                                                                                                                                                                                                                            | keyword          |
  | gcp.audit.request_metadata.raw.caller_ip                      | The raw IP address of the caller.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | gcp.audit.resource.labels.resource_container                  |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.resource.type                                       |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.resource_location.current_locations                 | Current locations of the resource.                                                                                                                                                                                                                                                                                                                 | keyword          |
  | gcp.audit.resource_name                                       | The resource or collection that is the target of the operation.  The name is a scheme-less URI, not including the API service name.  For example, 'shelves/SHELF_ID/books'.                                                                                                                                                                        | keyword          |
  | gcp.audit.response                                            |                                                                                                                                                                                                                                                                                                                                                    | flattened        |
  | gcp.audit.service_name                                        | The name of the API service performing the operation.  For example, datastore.googleapis.com.                                                                                                                                                                                                                                                      | keyword          |
  | gcp.audit.source_log_ids.insert_id                            |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.source_log_ids.log_time                             |                                                                                                                                                                                                                                                                                                                                                    | date             |
  | gcp.audit.source_log_ids.query_uri                            |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.source_log_ids.resource_container                   |                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.audit.status.code                                         | The status code, which should be an enum value of google.rpc.Code.                                                                                                                                                                                                                                                                                 | integer          |
  | gcp.audit.status.details                                      | A list of messages that carry the error details.                                                                                                                                                                                                                                                                                                   | flattened        |
  | gcp.audit.status.message                                      | A developer-facing error message, which should be in English. Any user-facing  error message should be localized and sent in the google.rpc.Status.details  field, or localized by the client.                                                                                                                                                     | keyword          |
  | gcp.audit.type                                                | Type property.                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | gcp.destination.instance.project_id                           | ID of the project containing the VM.                                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.destination.instance.region                               | Region of the VM.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | gcp.destination.instance.zone                                 | Zone of the VM.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.destination.vpc.project_id                                | ID of the project containing the VM.                                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.destination.vpc.subnetwork_name                           | Subnetwork on which the VM is operating.                                                                                                                                                                                                                                                                                                           | keyword          |
  | gcp.destination.vpc.vpc_name                                  | VPC on which the VM is operating.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | gcp.source.instance.project_id                                | ID of the project containing the VM.                                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.source.instance.region                                    | Region of the VM.                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | gcp.source.instance.zone                                      | Zone of the VM.                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | gcp.source.vpc.project_id                                     | ID of the project containing the VM.                                                                                                                                                                                                                                                                                                               | keyword          |
  | gcp.source.vpc.subnetwork_name                                | Subnetwork on which the VM is operating.                                                                                                                                                                                                                                                                                                           | keyword          |
  | gcp.source.vpc.vpc_name                                       | VPC on which the VM is operating.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.containerized                                            | If the host is a container.                                                                                                                                                                                                                                                                                                                        | boolean          |
  | host.entity.id                                                | Unique identifier for Compute Engine instances acting as principals in GCP audit events. Contains instance resource paths.                                                                                                                                                                                                                         | keyword          |
  | host.os.build                                                 | OS build information.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.os.codename                                              | OS codename, if any.                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.target.entity.id                                         | Unique identifier for compute resources targeted by GCP audit events. Includes Compute Engine instance IDs and resource paths.                                                                                                                                                                                                                     | keyword          |
  | input.type                                                    | Input type                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.offset                                                    | Log offset                                                                                                                                                                                                                                                                                                                                         | long             |
  | related.entity                                                | A collection of all entity identifiers associated with the document. If the document  contains multiple entities, identifiers for each will be included. Example identifiers include (but not limited to) cloud resource IDs, email addresses, and hostnames.                                                                                      | keyword          |
  | service.entity.id                                             | Unique identifier for service accounts and GCP services acting as principals. Contains serviceAccount: prefixed values, *.iam.gserviceaccount.com addresses, and *.googleapis.com services.                                                                                                                                                        | keyword          |
  | service.target.entity.id                                      | Unique identifier for GCP service resources targeted by audit events. Includes Cloud Storage buckets, Cloud Functions, BigQuery datasets, Compute Engine resources, networking components, and other GCP services.                                                                                                                                 | keyword          |
  | target.entity.id                                              | [Deprecated] This field is maintained for backward compatibility. Use type-specific fields instead: user.target.entity.id for IAM principals, service.target.entity.id for GCP service resources, host.target.entity.id for compute instances, or entity.target.id for other types.                                                                | keyword          |
  | user.entity.id                                                | Unique identifier for user accounts acting as principals in GCP audit events. Contains email addresses and user: prefixed identifiers.                                                                                                                                                                                                             | keyword          |
  | user.target.entity.id                                         | Unique identifier for IAM principals targeted by GCP audit events. Includes service accounts, users, and groups.                                                                                                                                                                                                                                   | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-12-19T00:44:25.051Z",
      "actor": {
          "entity": {
              "id": [
                  "xxx@xxx.xxx"
              ]
          }
      },
      "agent": {
          "ephemeral_id": "c12ff10d-c028-4d1b-80b1-a8151b80a275",
          "id": "5bce43a4-737b-4c53-9db0-a4bff79e32d1",
          "name": "elastic-agent-10901",
          "type": "filebeat",
          "version": "8.18.7"
      },
      "client": {
          "user": {
              "email": "xxx@xxx.xxx"
          }
      },
      "cloud": {
          "availability_zone": "global",
          "project": {
              "id": "elastic-beats"
          },
          "provider": "gcp"
      },
      "data_stream": {
          "dataset": "gcp.audit",
          "namespace": "84187",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5bce43a4-737b-4c53-9db0-a4bff79e32d1",
          "snapshot": false,
          "version": "8.18.7"
      },
      "event": {
          "action": "beta.compute.instances.aggregatedList",
          "agent_id_status": "verified",
          "category": [
              "network",
              "configuration"
          ],
          "created": "2025-10-09T12:32:26.254Z",
          "dataset": "gcp.audit",
          "id": "yonau2dg2zi",
          "ingested": "2025-10-09T12:32:29Z",
          "kind": "event",
          "outcome": "success",
          "provider": "data_access",
          "type": [
              "access",
              "allowed"
          ]
      },
      "gcp": {
          "audit": {
              "authorization_info": [
                  {
                      "granted": true,
                      "permission": "compute.instances.list",
                      "resource_attributes": {
                          "name": "projects/elastic-beats",
                          "service": "resourcemanager",
                          "type": "resourcemanager.projects"
                      }
                  }
              ],
              "num_response_items": 61,
              "receive_timestamp": "2019-12-19T00:44:25.262Z",
              "request": {
                  "@type": "type.googleapis.com/compute.instances.aggregatedList"
              },
              "resource": {
                  "type": "api"
              },
              "resource_location": {
                  "current_locations": [
                      "global"
                  ]
              },
              "resource_name": "projects/elastic-beats/global/instances",
              "response": {
                  "@type": "core.k8s.io/v1.Status",
                  "apiVersion": "v1",
                  "details": {
                      "group": "batch",
                      "kind": "jobs",
                      "name": "gsuite-exporter-1589294700",
                      "uid": "2beff34a-945f-11ea-bacf-42010a80007f"
                  },
                  "kind": "Status",
                  "status_value": "Success"
              },
              "type": "type.googleapis.com/google.cloud.audit.AuditLog"
          }
      },
      "input": {
          "type": "gcp-pubsub"
      },
      "log": {
          "level": "INFO",
          "logger": "projects/elastic-beats/logs/cloudaudit.googleapis.com%2Fdata_access"
      },
      "related": {
          "entity": [
              "projects/elastic-beats/global/instances",
              "xxx@xxx.xxx"
          ],
          "ip": [
              "192.168.1.1"
          ],
          "user": [
              "xxx@xxx.xxx"
          ]
      },
      "service": {
          "name": "compute.googleapis.com"
      },
      "source": {
          "ip": "192.168.1.1"
      },
      "tags": [
          "forwarded",
          "gcp-audit"
      ],
      "target": {
          "entity": {
              "id": [
                  "projects/elastic-beats/global/instances"
              ]
          }
      },
      "user_agent": {
          "device": {
              "name": "Mac"
          },
          "name": "Firefox",
          "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:71.0) Gecko/20100101 Firefox/71.0,gzip(gfe),gzip(gfe)",
          "os": {
              "full": "Mac OS X 10.15",
              "name": "Mac OS X",
              "version": "10.15"
          },
          "version": "71.0"
      }
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![filebeat gcp audit](https://epr.elastic.co/package/gcp/2.47.1/img/filebeat-gcp-audit.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version            | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Minimum Kibana version |
  |--------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.47.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16898))Fix gke network metrics fields and dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **2.47.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15828))Enhance GCP billing data stream with additional fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **2.46.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15930))Add type-specific entity fields to data stream.This enables better entity classification while maintaining backward compatibility with existing `actor.entity.id` and `target.entity.id` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 9.0.08.13.0            |
  | **2.45.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15279))Prefer set with copy_from.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 9.0.08.13.0            |
  | **2.44.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15619))Add support for parsing sensitive action notifications event in the audit dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 9.0.08.13.0            |
  | **2.43.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14745))Add tags and processors to GCP Billing, Cloudrun, CloudSQL, Dataproc, GKE, Loadbalancing, Pubsub and Redis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.13.0            |
  | **2.42.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14765))Fixed GCP project ID handling to prevent numeric parsing issues by enforcing string type casting in YAML configuration templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 9.0.08.13.0            |
  | **2.42.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13777))Remove redundant audit violation field renames.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 9.0.08.13.0            |
  | **2.42.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13521))Allow @custom pipeline access to event.original without setting preserve_original_event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 9.0.08.13.0            |
  | **2.41.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13633))Preserve original value of resource name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 9.0.08.13.0            |
  | **2.41.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12251))Add support for Kibana `9.0.0`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.13.0            |
  | **2.40.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **2.40.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11983))Add `actor.entity.id` and `target.entity.id` fields to audit logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.39.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11762))Add `related.entity` field to audit logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.38.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10886))Add `policy_violation_info`, `metadata` and `related` fields to audit logs.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10886))Update GCP audit log dashboard to use correct `email` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.37.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11016))Fix definition of subfields of nested objects                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.37.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9931))Improve GCP Billing documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **2.37.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10701))Retain `authenticationInfo.serviceAccountKeyName` data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.36.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10398))Add global dataset filter for dashboards to improve performance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **2.35.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10225))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.34.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10159))Fix Redis metric type for 'persistence.rdb.bgsave_in_progress'. Metric type should be boolean instead of long.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **2.34.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9508))Add tags and processors to GCP Compute, Firestore, PostgreSQL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.12.0                 |
  | **2.33.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9252))Add tags and processors to GCP Storage                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.12.0                 |
  | **2.33.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8404))Update Legacy metric visualization to new metric in GCP Billing overview dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.33.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8662))Enable time series data for metrics data streams. This dramatically reduces storage for metrics and is expected to progressively improve query [performance](https://www.elastic.co/blog/70-percent-storage-savings-for-metrics-with-elastic-observability). For more details, see [https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html](https://www.elastic.co/guide/en/elasticsearch/reference/current/tsds.html).                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.32.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8314))Add dimensions mappings and the metrics_fingerprint field across all metrics data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.32.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8343))Add new billing data stream fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.12.0                 |
  | **2.31.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8447))Fix pipeline error parsing DNS logs with empty rdata field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **2.31.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8096))Add Cloud Run docs and fix policy template name to allow adding Cloud Run logs to the policy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.31.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8299))Allow users to retain otherwised discarded fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.7.1                  |
  | **2.30.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8115))Fix mappings of group fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.30.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7957))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7957))Upgrade package spec to 3.0.0.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7957))Fix orphan dashboard references.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7957))Add missing dashboard filters.                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.29.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7934))Add null checks and ignore_missing checks to the rename processor                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.29.0**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7367))Remove GCP CloudSQL deprecated, alpha or beta metrics and fix field types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **2.28.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7569))Set metric type for GKE, Load Balancing, PubSub, Redis and Storage data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.28.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7458))Migrate GCP Load Balancing HTTPS Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.28.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7560))Set metric type for Cloud Run, Compute, Dataproc and Firestore data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.7.1                  |
  | **2.28.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7459))Migrate GCP Load Balancing TCP SSL Proxy Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.28.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7556))Set metric type for CloudSQL data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.7.1                  |
  | **2.28.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7461))Migrate GCP Load Balancing L3 Overview dashboard to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **2.27.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7368))Add GCP CloudSQL MySQL, SQL Server and PostgreSQL dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **2.26.0**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7287))Fix GCP loadbalancing_metrics fields prefix.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.25.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7308))Fix check on gcp.audit.authorization_info[].granted.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **2.25.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7249))Migrate GCP Billing input control to new control panel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **2.24.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4126))Add GCP CloudSQL MySQL, Postgres, SQLServer data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.7.1                  |
  | **2.23.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7014))Convert security dashboards to lens.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **2.22.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Change ownership in manifest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                  |
  | **2.22.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.6.0                  |
  | **2.21.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.20.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6128))Fix invalid TSDS metric type for persistence.rdb.bgsave_in_progress field                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.6.0                  |
  | **2.20.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.19.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5038))Migrate compute dashboard to lens and add datastream filter.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.6.0                  |
  | **2.19.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5097))Add Cloud Run metrics datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.6.0                  |
  | **2.18.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5630))Support `subscription_num_goroutines` and `subscription_max_outstanding_messages` for GCP PubSub input                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **2.17.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5597))Fix IP Convert processor in Audit ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.6.0                  |
  | **2.17.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.6.0                  |
  | **2.17.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add Audit Log Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add GKE Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add PubSub Overview dashboard**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5025))Add Storage Overview dashboard                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.6.0                  |
  | **2.16.2**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5231))Add logic to handle scalar request.policy values on audit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.5.0                  |
  | **2.16.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5032))Replace missing input control panel with new-style control.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.5.0                  |
  | **2.16.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.5.0                  |
  | **2.15.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4729))Update documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.5.0                  |
  | **2.15.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4639))Add GCP Compute pipeline test.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.5.0                  |
  | **2.15.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4197))Remove support for Kibana 7.17.x**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4197))Support multiple regions for metrics data streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.5.0                  |
  | **2.14.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.3.0                  |
  | **2.13.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4214))Migrate dashboard by values                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.0                  |
  | **2.12.1**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4397))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.12.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4325))Add GCP Redis                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.3.07.17.6            |
  | **2.11.12**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4357))Add GKE ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.11.11**        | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4371))Fix type of dns.answers.ttl.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.10**        | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4344))Add ingest pipeline for dataproc.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4350))Add GCP loadbalancing ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4349))Add GCP PubSub ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4348))Add GCP Storage ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4347))Add GCP Firestore ingest pipeline**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4343))Add GCP Compute ingest pipeline                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.11.10-beta.6** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4344))Add ingest pipeline for dataproc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **2.11.10-beta.5** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4350))Add GCP loadbalancing ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                        |
  | **2.11.10-beta.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4349))Add GCP PubSub ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **2.11.10-beta.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4348))Add GCP Storage ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **2.11.10-beta.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4347))Add GCP Firestore ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **2.11.10-beta.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4343))Add GCP Compute ingest pipeline                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **2.11.9**         | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4355))Fix GKE kubernetes.io indentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.3.07.17.6            |
  | **2.11.8**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4339))Remove duplicate fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.7**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4270))Move Dataproc lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.3.07.17.6            |
  | **2.11.6**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4269))Move LoadBalancing lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.3.07.17.6            |
  | **2.11.5**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4268))Move Storage lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.11.4**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4267))Move PubSub lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.07.17.6            |
  | **2.11.3**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3797))Move GKE lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.3.07.17.6            |
  | **2.11.2**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3798))Move Firestore lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.3.07.17.6            |
  | **2.11.1**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.3.07.17.6            |
  | **2.11.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3797))Move Compute lightweight module config into integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.10.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3788))Add GCP PubSub Data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.3.07.17.6            |
  | **2.9.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3789))Add GCP Dataproc Data stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.3.07.17.6            |
  | **2.8.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4098))Add GCP GKE Data Stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.3.07.17.6            |
  | **2.7.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3785))Add GCP Storage Data Stream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.6.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3493))Add Load Balancing logs datastream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.3.07.17.6            |
  | **2.5.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2308))Add GCP Load Balancing Metricset**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Fix credentials_json escaping in loadbalancing_metrics**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Update loadbalancing_metrics default period to 60s**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3986))Fix event.dataset for loadbalancing_metrics**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4004))Add loadbalancing_metrics distribution fields                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.4.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3865))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.3.07.17.6            |
  | **2.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2340))Add additional parsing for DNS Public Zone Query Logs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.3.07.17.6            |
  | **2.2.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3821))Fix Billing policy template title and default period for gcp.compute                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3609))Remove fields duplicated in ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.3.07.17.6            |
  | **2.1.0**          | **Enhancement**restore compatibility with 7.17 release track                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.3.07.17.6            |
  | **2.0.0**          | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/2707))Move configurations to support metrics. This change is breaking, as it movessome configuration from the top level variables to data stream variables.This change involves `project_id`, `credentials_file` and `credentials_json`variables that are moved from input level configuration to package levelconfiguration (as those variables are reused across all inputs/data streams).Users with GCP integration enabled will need to input values for thesevariables again when upgrading the policies to this version.**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2141))Add GCP Billing Data Stream**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2301))Add GCP Compute Data Stream**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2704))Add GCP Firestore Data stream | 8.3.0                  |
  | **1.10.0**         | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.17.0            |
  | **1.9.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3583))Fix GCP auditlog parsing issue on response status                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.17.0            |
  | **1.9.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3103))Update readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.07.17.0            |
  | **1.9.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3390))Preserve request and response in flattened fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.17.0            |
  | **1.8.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3274))Add missing `cloud.provider` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.17.0            |
  | **1.7.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3280))Add dashboards for firewall and vpc flow logs.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3280))Add missing mappings for several `event.*` fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **1.6.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3206))Clarify the GCP privileges required by the Pub/Sub input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.07.16.3            |
  | **1.6.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update to ECS 8.2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **1.5.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.0.07.16.3            |
  | **1.5.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2842))Improve Google Cloud Platform docs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.16.3            |
  | **1.4.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2747))Remove emtpy values, names with only dots, and invalid client IPs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.16.3            |
  | **1.4.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2712))Fix quoting of the credentials_json value in policy templates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.07.16.3            |
  | **1.4.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2624))Add gcp.dns integration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                        |
  | **1.3.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2470))Add Ingest Pipeline script to map IANA Protocol Numbers                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.0.07.15.0            |
  | **1.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2406))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | 8.0.07.15.0            |
  | **1.2.2**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.07.15.0            |
  | **1.2.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2251))Add 8.0.0 version constraint                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | 8.0.07.15.0            |
  | **1.1.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1965))Update Title and Description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 7.15.0                 |
  | **1.1.1**          | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1818))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **1.1.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1661))Update to ECS 1.12.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 7.15.0                 |
  | **1.0.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1568))Move from experimental to GA**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1717))remove experimental from data_sets                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.3.3**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1478))Convert to generated ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |                        |
  | **0.3.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1385))update to ECS 1.11.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                        |
  | **0.3.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |                        |
  | **0.3.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
  | **0.2.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1240))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.1.0**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1045))update to ECS 1.10.0 and adding event.original options                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **0.0.2**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/846))update to ECS 1.9.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.0.1**          | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/459))initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                        |
</dropdown>