﻿---
title: Fortinet FortiMail
description: The Fortinet FortiMail integration allows users to monitor History, System, Mail, Antispam, Antivirus, and Encryption events. FortiMail delivers advanced...
url: https://www.elastic.co/docs/reference/integrations/fortinet_fortimail
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Fortinet FortiMail
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 2.18.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.11.0                     |


## Overview

The [Fortinet FortiMail](https://www.fortinet.com/products/email-security) integration allows users to monitor History, System, Mail, Antispam, Antivirus, and Encryption events. FortiMail delivers advanced multi-layered protection against the full spectrum of email-borne threats. Powered by FortiGuard Labs threat intelligence and integrated into the Fortinet Security Fabric, FortiMail helps your organization prevent, detect, and respond to email-based threats including spam, phishing, malware, zero-day threats, impersonation, and Business Email Compromise (BEC) attacks.
Use the Fortinet FortiMail integration to collect and parse data from the Syslog. Then visualize that data in Kibana.

## Data streams

The Fortinet FortiMail integration collects one type of data stream: log.
**Log** helps users to keep a record of email activity and traffic including system-related events, such as system restarts and HA activity, virus detections, spam filtering results, POP3, SMTP, IMAP, and webmail events. See more details [About FortiMail logging](https://docs.fortinet.com/document/fortimail/7.2.2/administration-guide/435158/about-fortimail-logging)
This integration targets the six types of events as mentioned below:
- **History** records all email traffic going through the FortiMail unit.
- **System** records system management activities, including changes to the system configuration as well as administrator and user login and logouts.
- **Mail** records mail activities.
- **Antispam** records spam detection events.
- **Antivirus** records virus intrusion events.
- **Encryption** records detection of IBE-related events.


## Requirements

Elasticsearch is needed to store and search data, and Kibana is needed for visualizing and managing it. You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your hardware.
This module has been tested against **Fortinet FortiMail version 7.2.2**.
<note>
  The User must have to **Enable CSV format** option.
</note>


## Setup


### To collect data from Fortinet FortiMail Syslog server, follow the below steps:

- [Configure Syslog server](https://docs.fortinet.com/document/fortimail/7.2.2/administration-guide/332364/configuring-logging#logging_2063907032_1949484)

![Fortinet FortiMail Syslog Server](https://www.elastic.co/docs/reference/integrations/images/fortinet_fortimail/fortinet-fortimail-configure-syslog-server.png)

## Logs Reference


### Log

This is the `Log` dataset.

#### Example

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2013-02-25T07:01:34.000Z",
      "agent": {
          "ephemeral_id": "6e27a1ae-39ab-4632-8e9b-d6d0b7a1e56b",
          "id": "4a5f8370-e38c-43b1-9dc9-b2c1e0788c6d",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.10.2"
      },
      "data_stream": {
          "dataset": "fortinet_fortimail.log",
          "namespace": "ep",
          "type": "logs"
      },
      "destination": {
          "ip": "81.2.69.194"
      },
      "ecs": {
          "version": "8.17.0"
      },
      "elastic_agent": {
          "id": "4a5f8370-e38c-43b1-9dc9-b2c1e0788c6d",
          "snapshot": false,
          "version": "8.10.2"
      },
      "email": {
          "direction": "unknown",
          "from": {
              "address": [
                  "aaa@example.com"
              ]
          },
          "subject": "Test12345",
          "to": {
              "address": [
                  "user1@example.com"
              ]
          },
          "x_mailer": "proxy"
      },
      "event": {
          "agent_id_status": "verified",
          "code": "0200025843",
          "dataset": "fortinet_fortimail.log",
          "ingested": "2023-10-03T09:51:39Z",
          "kind": "event",
          "original": "<187>date=2013-02-25,time=07:01:34,device_id=FE100C3909600504,log_id=0200025843,type=statistics,pri=information,session_id=\"r1PF1YTh025836-r1PF1YTh025836\",client_name=\"user\",dst_ip=\"81.2.69.194\",endpoint=\"\",from=\"aaa@example.com\",to=\"user1@example.com\",polid=\"0:1:0\",domain=\"example.com\",subject=\"Test12345\",mailer=\"proxy\",resolved=\"FAIL\",direction=\"unknown\",virus=\"\",disposition=\"Delay\",classifier=\"Session Limits\",message_length=\"199986\"",
          "outcome": "failure"
      },
      "fortinet_fortimail": {
          "log": {
              "classifier": "Session Limits",
              "client": {
                  "name": "user"
              },
              "date": "2013-02-25",
              "destination_ip": "81.2.69.194",
              "device_id": "FE100C3909600504",
              "direction": "unknown",
              "disposition": "Delay",
              "domain": "example.com",
              "from": "aaa@example.com",
              "id": "0200025843",
              "mailer": "proxy",
              "message_length": 199986,
              "policy_id": "0:1:0",
              "priority": "information",
              "priority_number": 187,
              "resolved": "FAIL",
              "session_id": "r1PF1YTh025836-r1PF1YTh025836",
              "subject": "Test12345",
              "time": "07:01:34",
              "to": "user1@example.com",
              "type": "statistics"
          }
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "level": "information",
          "source": {
              "address": "192.168.144.4:54368"
          },
          "syslog": {
              "facility": {
                  "code": 22
              },
              "priority": 187,
              "severity": {
                  "code": 6
              }
          }
      },
      "observer": {
          "product": "FortiMail",
          "serial_number": "FE100C3909600504",
          "type": "firewall",
          "vendor": "Fortinet"
      },
      "related": {
          "ip": [
              "81.2.69.194"
          ],
          "user": [
              "user",
              "aaa@example.com",
              "user1@example.com"
          ]
      },
      "server": {
          "domain": "example.com",
          "registered_domain": "example.com",
          "top_level_domain": "com"
      },
      "source": {
          "user": {
              "name": "user"
          }
      },
      "tags": [
          "preserve_original_event",
          "preserve_duplicate_custom_fields",
          "forwarded",
          "fortinet_fortimail-log"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                  | Description                                                                               | Type             |
  |----------------------------------------|-------------------------------------------------------------------------------------------|------------------|
  | @timestamp                             | Event timestamp.                                                                          | date             |
  | data_stream.dataset                    | Data stream dataset.                                                                      | constant_keyword |
  | data_stream.namespace                  | Data stream namespace.                                                                    | constant_keyword |
  | data_stream.type                       | Data stream type.                                                                         | constant_keyword |
  | event.dataset                          | Event dataset.                                                                            | constant_keyword |
  | event.module                           | Event module.                                                                             | constant_keyword |
  | fortinet_fortimail.log.action          |                                                                                           | keyword          |
  | fortinet_fortimail.log.classifier      |                                                                                           | keyword          |
  | fortinet_fortimail.log.client.cc       |                                                                                           | keyword          |
  | fortinet_fortimail.log.client.ip       |                                                                                           | ip               |
  | fortinet_fortimail.log.client.name     |                                                                                           | keyword          |
  | fortinet_fortimail.log.date            |                                                                                           | keyword          |
  | fortinet_fortimail.log.destination_ip  |                                                                                           | ip               |
  | fortinet_fortimail.log.detail          |                                                                                           | keyword          |
  | fortinet_fortimail.log.device_id       |                                                                                           | keyword          |
  | fortinet_fortimail.log.direction       |                                                                                           | keyword          |
  | fortinet_fortimail.log.disposition     |                                                                                           | keyword          |
  | fortinet_fortimail.log.domain          |                                                                                           | keyword          |
  | fortinet_fortimail.log.endpoint        |                                                                                           | keyword          |
  | fortinet_fortimail.log.from            |                                                                                           | keyword          |
  | fortinet_fortimail.log.hfrom           |                                                                                           | keyword          |
  | fortinet_fortimail.log.id              |                                                                                           | keyword          |
  | fortinet_fortimail.log.ip              |                                                                                           | ip               |
  | fortinet_fortimail.log.mailer          |                                                                                           | keyword          |
  | fortinet_fortimail.log.message         |                                                                                           | keyword          |
  | fortinet_fortimail.log.message_id      |                                                                                           | keyword          |
  | fortinet_fortimail.log.message_length  |                                                                                           | long             |
  | fortinet_fortimail.log.module          |                                                                                           | keyword          |
  | fortinet_fortimail.log.network         |                                                                                           | keyword          |
  | fortinet_fortimail.log.notif_delay     |                                                                                           | keyword          |
  | fortinet_fortimail.log.policy_id       |                                                                                           | keyword          |
  | fortinet_fortimail.log.port            |                                                                                           | long             |
  | fortinet_fortimail.log.priority        |                                                                                           | keyword          |
  | fortinet_fortimail.log.priority_number |                                                                                           | long             |
  | fortinet_fortimail.log.read_status     |                                                                                           | keyword          |
  | fortinet_fortimail.log.reason          |                                                                                           | keyword          |
  | fortinet_fortimail.log.recv_time       |                                                                                           | keyword          |
  | fortinet_fortimail.log.resolved        |                                                                                           | keyword          |
  | fortinet_fortimail.log.scan_time       |                                                                                           | double           |
  | fortinet_fortimail.log.sent_from       |                                                                                           | keyword          |
  | fortinet_fortimail.log.session_id      |                                                                                           | keyword          |
  | fortinet_fortimail.log.source.folder   |                                                                                           | keyword          |
  | fortinet_fortimail.log.source.ip       |                                                                                           | ip               |
  | fortinet_fortimail.log.source.type     |                                                                                           | keyword          |
  | fortinet_fortimail.log.status          |                                                                                           | keyword          |
  | fortinet_fortimail.log.sub_module      |                                                                                           | keyword          |
  | fortinet_fortimail.log.sub_type        |                                                                                           | keyword          |
  | fortinet_fortimail.log.subject         |                                                                                           | keyword          |
  | fortinet_fortimail.log.time            |                                                                                           | keyword          |
  | fortinet_fortimail.log.to              |                                                                                           | keyword          |
  | fortinet_fortimail.log.type            |                                                                                           | keyword          |
  | fortinet_fortimail.log.ui              |                                                                                           | keyword          |
  | fortinet_fortimail.log.ui_ip           |                                                                                           | ip               |
  | fortinet_fortimail.log.url             |                                                                                           | keyword          |
  | fortinet_fortimail.log.user            |                                                                                           | keyword          |
  | fortinet_fortimail.log.virus           |                                                                                           | keyword          |
  | fortinet_fortimail.log.xfer_time       |                                                                                           | double           |
  | input.type                             | Type of Filebeat input.                                                                   | keyword          |
  | log.file.device_id                     | ID of the device containing the filesystem where the file resides.                        | keyword          |
  | log.file.fingerprint                   | The sha256 fingerprint identity of the file when fingerprinting is enabled.               | keyword          |
  | log.file.idxhi                         | The high-order part of a unique identifier that is associated with a file. (Windows-only) | keyword          |
  | log.file.idxlo                         | The low-order part of a unique identifier that is associated with a file. (Windows-only)  | keyword          |
  | log.file.inode                         | Inode number of the log file.                                                             | keyword          |
  | log.file.vol                           | The serial number of the volume that contains a file. (Windows-only)                      | keyword          |
  | log.offset                             | Log offset.                                                                               | long             |
  | log.source.address                     | Source address from which the log event was read / sent from.                             | keyword          |
  | tags                                   | User defined tags.                                                                        | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Fortinet FortiMail Antispam, Antivirus & Encryption Dashboard Screenshot](https://epr.elastic.co/package/fortinet_fortimail/2.18.0/img/fortinet-fortimail-antispam-antivirus-encryption-dashboard.png)

  ![Fortinet FortiMail Email Dashboard Screenshot](https://epr.elastic.co/package/fortinet_fortimail/2.18.0/img/fortinet-fortimail-email-dashboard.png)

  ![Fortinet FortiMail History Dashboard Screenshot](https://epr.elastic.co/package/fortinet_fortimail/2.18.0/img/fortinet-fortimail-history-dashboard.png)

  ![Fortinet FortiMail System Dashboard Screenshot](https://epr.elastic.co/package/fortinet_fortimail/2.18.0/img/fortinet-fortimail-system-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/17257))Map url field.                                                                                                                                                           | 9.0.08.11.0            |
  | **2.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17024))Remove duplicate security-solution-default tag references                                                                                                                    | 9.0.08.11.0            |
  | **2.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15803))Preserve event.original on pipeline error.                                                                                                                               | 9.0.08.11.0            |
  | **2.16.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15541))Generate processor tags and normalize error handler.                                                                                                                     | 9.0.08.11.0            |
  | **2.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14938))Replace navigation with links panels. Updated support for kibana version to 8.11.0 and above.                                                                            | 9.0.08.11.0            |
  | **2.15.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14753))Changed owners.                                                                                                                                                          | 9.0.08.3.0             |
  | **2.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13042))Support stack version 9.0.                                                                                                                                               | 9.0.08.3.0             |
  | **2.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12753))Updated SSL description to be uniform and to include links to documentation.                                                                                                 | 8.3.0                  |
  | **2.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12571))ECS version updated to 8.17.0.                                                                                                                                           | 8.3.0                  |
  | **2.13.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11606))Tolerate existing event.timezone value.                                                                                                                                      | 8.3.0                  |
  | **2.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9235))Update package spec to 3.0.3.                                                                                                                                             | 8.3.0                  |
  | **2.12.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.3.0                  |
  | **2.12.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                                                    | 8.3.0                  |
  | **2.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8434))ECS version updated to 8.11.0.                                                                                                                                            | 8.3.0                  |
  | **2.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.3.0                  |
  | **2.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8014))Adapt fields for changes in file system info                                                                                                                              | 8.3.0                  |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                                            | 8.3.0                  |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.3.0                  |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.3.0                  |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7191))Handle block rule addition and removal.                                                                                                                                   | 8.3.0                  |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                                              | 8.3.0                  |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.3.0                  |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                              | 8.3.0                  |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                                     | 8.3.0                  |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.3.0                  |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5437))Replace RSA2ELK with Syslog integration.                                                                                                                                  | 8.3.0                  |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.14.1            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.14.1            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.14.1            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/4327))Remove duplicate field.                                                                                                                                                     | 8.0.07.14.1            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                        | 8.0.07.14.1            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3819))Update Ingest Pipeline with observer Fields                                                                                                                               | 8.0.07.14.1            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3266))Initial version of Fortinet FortiMail as separate package                                                                                                                 | 8.0.07.14.1            |
</dropdown>