﻿---
title: ForgeRock Identity Platform
description: ForgeRock is a modern identity platform which helps organizations radically simplify identity and access management (IAM) and identity governance and...
url: https://www.elastic.co/docs/reference/integrations/forgerock
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# ForgeRock Identity Platform
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.22.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

ForgeRock is a modern identity platform which helps organizations radically simplify identity and access management (IAM) and identity governance and administration (IGA). The ForgeRock integration collects audit logs from the [API](https://backstage.forgerock.com/knowledge/kb/article/a37739488).

### Configuration

Authorization parameters for the ForgeRock Identity Cloud API (`API Key ID`, and `API Key Secret`) can be created [in the Identity Cloud admin UI](https://backstage.forgerock.com/docs/idcloud/latest/developer-docs/authenticate-to-rest-api-with-api-key-and-secret.html#get_an_api_key_and_secret).

## Logs


### AM_Access events

This is the `forgerock.am_access` dataset. These logs capture all incoming Identity Cloud access calls as audit events. This includes who, what, when, and the output for every access request. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#am-access).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-05T20:55:43.188Z",
      "agent": {
          "ephemeral_id": "912582e9-ce0a-4e33-bd0d-b446b246d5cb",
          "id": "e5f7134f-516b-4b77-a0e8-a558bda68feb",
          "name": "elastic-agent-93058",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "client": {
          "ip": "1.128.0.0"
      },
      "data_stream": {
          "dataset": "forgerock.am_access",
          "namespace": "96005",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e5f7134f-516b-4b77-a0e8-a558bda68feb",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "AM-ACCESS-ATTEMPT",
          "agent_id_status": "verified",
          "created": "2025-10-06T12:40:16.272Z",
          "dataset": "forgerock.am_access",
          "id": "45463f84-ff1b-499f-aa84-8d4bd93150de-437950",
          "ingested": "2025-10-06T12:40:17Z",
          "type": [
              "access"
          ]
      },
      "forgerock": {
          "eventName": "AM-ACCESS-ATTEMPT",
          "http": {
              "request": {
                  "headers": {
                      "accept": [
                          "application/json, text/plain, */*"
                      ],
                      "accept-api-version": [
                          "protocol=1.0,resource=1.1"
                      ],
                      "host": [
                          "openam-chico-poc.forgeblocks.com"
                      ],
                      "user-agent": [
                          "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36"
                      ],
                      "x-forwarded-for": [
                          "50.159.194.107, 34.149.144.150, 10.168.0.13"
                      ],
                      "x-forwarded-proto": [
                          "https"
                      ]
                  },
                  "secure": true
              }
          },
          "level": "INFO",
          "realm": "/",
          "request": {
              "operation": "READ",
              "protocol": "CREST"
          },
          "source": "audit",
          "topic": "access"
      },
      "http": {
          "request": {
              "Path": "https://openam-chico-poc.forgeblocks.com/am/json/serverinfo/*",
              "method": "GET"
          }
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "server": {
          "ip": "10.68.17.12"
      },
      "service": {
          "name": "Server Info"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-am-access"
      ],
      "transaction": {
          "id": "1665003343053-7492ffada57c074a1475-43264/0"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                        | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                               | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace                             | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                                  | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.eventName                               | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.http.request.headers.*                  | The headers of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | object           |
  | forgerock.http.request.headers.accept             | The accept parameter for the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | forgerock.http.request.headers.accept-api-version | The accept-api-version header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | forgerock.http.request.headers.content-type       | The content-type header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.http.request.headers.host               | The host header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | forgerock.http.request.headers.origin             | The origin header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.http.request.headers.user-agent         | The user-agent header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | forgerock.http.request.headers.x-forwarded-for    | The x-forwarded-for header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forgerock.http.request.headers.x-forwarded-proto  | The x-forwaded-proto header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | forgerock.http.request.headers.x-requested-with   | The x-requested with header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | forgerock.http.request.queryParameters.*          | The query parameter string of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | object           |
  | forgerock.http.request.secure                     | A flag describing whether or not the HTTP request was secure.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | forgerock.level                                   | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.objectId                                | Specifies the identifier of an object that has been created, updated, or deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.realm                                   | The realm where the operation occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.request.detail.*                        | Details around the response status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | object           |
  | forgerock.request.detail.action                   | Details around the request action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | forgerock.request.detail.grant_type               | The request's grant type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | forgerock.request.detail.scope                    | The request's scope.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | forgerock.request.detail.token_type_hint          | The request's token type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | forgerock.request.operation                       | The request operation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.request.protocol                        | The protocol associated with the request; REST or PLL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.response.detail.*                       | Details around the response status.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | object           |
  | forgerock.response.detail.active                  | A flag for whether or not the response was active.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | forgerock.response.detail.client_id               | The responses's client id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | forgerock.response.detail.revision                | The responses's revision.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | forgerock.response.detail.scope                   | The responses's scope.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.response.detail.token_type              | The responses's token type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.response.detail.username                | The responses's username.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | forgerock.response.elapsedTime                    | Time to execute event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | forgerock.response.elapsedTimeUnits               | Units for response time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.response.status                         | Status indicator, usually SUCCESS/SUCCESSFUL or FAIL/FAILED.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.roles                                   | IDM roles associated with the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.source                                  | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic                                   | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.trackingIds                             | Specifies a unique random string generated as an alias for each AM session ID and OAuth 2.0 token.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | http.request.Path                                 | The path of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | input.type                                        | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### AM_Activity events

This is the `forgerock.am_activity` dataset. These logs capture state changes to objects that have been created, updated, or deleted by Identity Cloud end users. This includes session, user profile, and device profile changes. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#am-activity).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-05T20:55:59.966Z",
      "agent": {
          "ephemeral_id": "300977b2-2103-4f5c-8398-cb7491c52ce3",
          "id": "a77ca8ac-13ef-47c3-84e4-ec42fde7af3f",
          "name": "elastic-agent-41379",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.am_activity",
          "namespace": "61561",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "a77ca8ac-13ef-47c3-84e4-ec42fde7af3f",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "AM-SESSION-CREATED",
          "agent_id_status": "verified",
          "created": "2025-10-06T12:41:04.474Z",
          "dataset": "forgerock.am_activity",
          "id": "45463f84-ff1b-499f-aa84-8d4bd93150de-438366",
          "ingested": "2025-10-06T12:41:07Z",
          "reason": "CREATE"
      },
      "forgerock": {
          "level": "INFO",
          "objectId": "45463f84-ff1b-499f-aa84-8d4bd93150de-438033",
          "realm": "/",
          "source": "audit",
          "topic": "activity",
          "trackingIds": [
              "45463f84-ff1b-499f-aa84-8d4bd93150de-438033"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "service": {
          "name": "Session"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-am-activity"
      ],
      "transaction": {
          "id": "5ff83988-8f23-4108-9359-42658fcfc4d1-request-3/0"
      },
      "user": {
          "effective": {
              "id": "id=d7cd65bf-743c-4753-a78f-a20daae7e3bf,ou=user,ou=am-config"
          },
          "id": "id=d7cd65bf-743c-4753-a78f-a20daae7e3bf,ou=user,ou=am-config"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp              | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset     | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace   | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type        | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.after.*       | Specifies the JSON representation of the object after the activity.                                                                                                                                                                                                                                                                                                                                                                                                                                                          | object           |
  | forgerock.before.*      | Specifies the JSON representation of the object prior to the activity.                                                                                                                                                                                                                                                                                                                                                                                                                                                       | object           |
  | forgerock.changedFields | Specifies the fields that were changed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.eventName     | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level         | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.objectId      | Specifies the identifier of an object that has been created, updated, or deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.realm         | The realm where the operation occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.source        | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic         | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.trackingIds   | Specifies a unique random string generated as an alias for each AM session ID and OAuth 2.0 token.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type              | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### AM_Authentication events

This is the `forgerock.am_authentication` dataset. These logs capture when and how a user is authenticated and related audit events. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#am-authentication).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-05T18:21:48.253Z",
      "agent": {
          "ephemeral_id": "ad09d001-2dbe-4840-af47-f2818fa57098",
          "id": "1fbc06be-5d4e-4db9-99c9-f1320758f1d8",
          "name": "elastic-agent-75467",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.am_authentication",
          "namespace": "58576",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "1fbc06be-5d4e-4db9-99c9-f1320758f1d8",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "AM-LOGIN-COMPLETED",
          "agent_id_status": "verified",
          "category": [
              "authentication"
          ],
          "created": "2025-10-06T12:42:03.795Z",
          "dataset": "forgerock.am_authentication",
          "id": "45463f84-ff1b-499f-aa84-8d4bd93150de-256208",
          "ingested": "2025-10-06T12:42:06Z",
          "outcome": "success"
      },
      "forgerock": {
          "entries": [
              {
                  "info": {
                      "authIndex": "module_instance",
                      "authIndexValue": "Application",
                      "authLevel": "0",
                      "ipAddress": "1.128.0.0"
                  },
                  "moduleId": "Application"
              }
          ],
          "eventName": "AM-LOGIN-COMPLETED",
          "level": "INFO",
          "principal": [
              "autoid-resource-server"
          ],
          "realm": "/",
          "source": "audit",
          "topic": "authentication",
          "trackingIds": [
              "45463f84-ff1b-499f-aa84-8d4bd93150de-256204"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "service": {
          "name": "Authentication"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-am-authentication"
      ],
      "transaction": {
          "id": "1664994108247-9f138d8fc9f59d23164c-26466/0"
      },
      "user": {
          "id": "id=autoid-resource-server,ou=agent,ou=am-config"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.entries     | The JSON representation of the details of an authentication module, chain, tree, or node.                                                                                                                                                                                                                                                                                                                                                                                                                                    | flattened        |
  | forgerock.eventName   | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level       | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.principal   | The array of accounts used to authenticate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.realm       | The realm where the operation occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.source      | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic       | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.trackingIds | Specifies a unique random string generated as an alias for each AM session ID and OAuth 2.0 token.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type            | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### AM_Config events

This is the `forgerock.am_config` dataset. These logs capture access management configuration changes for Identity Cloud with a timestamp and by whom. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#am-config).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-09-20T14:40:10.664Z",
      "agent": {
          "ephemeral_id": "78438062-5e65-437e-8b89-308d70efdb88",
          "id": "d36dcc8f-d86c-4c48-9832-fd9828a9dfe7",
          "name": "elastic-agent-89631",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.am_config",
          "namespace": "15954",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "d36dcc8f-d86c-4c48-9832-fd9828a9dfe7",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "action": "AM-CONFIG-CHANGE",
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-10-06T12:42:52.973Z",
          "dataset": "forgerock.am_config",
          "id": "4e8550cd-71d6-4a08-b5b0-bb63bcbbc960-20605",
          "ingested": "2025-10-06T12:42:55Z"
      },
      "forgerock": {
          "level": "INFO",
          "objectId": "ou=test,ou=agentgroup,ou=OrganizationConfig,ou=1.0,ou=AgentService,ou=services,o=alpha,ou=services,ou=am-config",
          "operation": "CREATE",
          "realm": "/alpha",
          "source": "audit",
          "topic": "config",
          "trackingIds": [
              "4e8550cd-71d6-4a08-b5b0-bb63bcbbc960-5563"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-am-config"
      ],
      "transaction": {
          "id": "1663684810619-c42f8145dec437c43428-2465/0"
      },
      "user": {
          "effective": {
              "id": "id=dsameuser,ou=user,ou=am-config"
          },
          "id": "id=d7cd65bf-743c-4753-a78f-a20daae7e3bf,ou=user,ou=am-config"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp              | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset     | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace   | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type        | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.changedFields | Specifies the fields that were changed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.eventName     | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level         | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.objectId      | Specifies the identifier of an object that has been created, updated, or deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.operation     | The state change operation invoked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | forgerock.realm         | The realm where the operation occurred.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.source        | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic         | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.trackingIds   | Specifies a unique random string generated as an alias for each AM session ID and OAuth 2.0 token.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type              | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### AM_Core events

This is the `forgerock.am_core` dataset. These logs capture access management debug logs for Identity Cloud. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#am-core).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-12-05T19:29:20.845Z",
      "agent": {
          "ephemeral_id": "013fcb42-a6c3-47de-8afb-94a1f9014635",
          "id": "7efa0d65-4e58-4fb3-a1ed-0d89d045c77a",
          "name": "elastic-agent-19283",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.am_core",
          "namespace": "89252",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7efa0d65-4e58-4fb3-a1ed-0d89d045c77a",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-06T12:43:43.162Z",
          "dataset": "forgerock.am_core",
          "ingested": "2025-10-06T12:43:46Z",
          "reason": "Connection attempt failed: availableConnections=0, maxPoolSize=10"
      },
      "forgerock": {
          "context": "default"
      },
      "input": {
          "type": "httpjson"
      },
      "log": {
          "level": "DEBUG",
          "logger": "org.forgerock.opendj.ldap.CachedConnectionPool"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "process": {
          "name": "LDAP SDK Default Scheduler"
      },
      "tags": [
          "forwarded",
          "forgerock-debug",
          "forgerock-am-core"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.context     | The context of the debug event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type            | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_access events

This is the `forgerock.idm_access` dataset. These logs capture messages for the identity management REST endpoints and the invocation of scheduled tasks. This is the who, what, and output for every identity management access request in Identity Cloud. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-access).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-11-01T15:04:50.110Z",
      "agent": {
          "ephemeral_id": "4a50402b-fc44-4850-93ea-ef0cf4c922ba",
          "id": "229bc928-46fc-40e6-9d5c-687a54978dfd",
          "name": "elastic-agent-86850",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "client": {
          "ip": "216.160.83.56",
          "port": 56278
      },
      "data_stream": {
          "dataset": "forgerock.idm_access",
          "namespace": "92556",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "229bc928-46fc-40e6-9d5c-687a54978dfd",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-06T12:44:33.069Z",
          "dataset": "forgerock.idm_access",
          "duration": 2000000,
          "id": "a9a32d9e-7029-45e6-b581-eafb5d502273-49025",
          "ingested": "2025-10-06T12:44:36Z",
          "outcome": "success",
          "type": [
              "access"
          ]
      },
      "forgerock": {
          "eventName": "access",
          "http": {
              "request": {
                  "headers": {
                      "host": [
                          "idm"
                      ]
                  },
                  "secure": false
              }
          },
          "level": "INFO",
          "request": {
              "operation": "READ",
              "protocol": "CREST"
          },
          "response": {
              "elapsedTime": 2,
              "elapsedTimeUnits": "MILLISECONDS",
              "status": "SUCCESSFUL"
          },
          "roles": [
              "internal/role/openidm-reg"
          ],
          "source": "audit",
          "topic": "access"
      },
      "http": {
          "request": {
              "Path": "http://idm/openidm/info/ping",
              "method": "GET"
          },
          "response": {
              "status_code": 200
          }
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "server": {
          "ip": "81.2.69.142"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-idm-access"
      ],
      "transaction": {
          "id": "a9a32d9e-7029-45e6-b581-eafb5d502273-49021"
      },
      "user": {
          "id": "anonymous"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                 | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace               | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                    | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.eventName                 | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.http.request.headers.host | The host header of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | forgerock.http.request.secure       | A flag describing whether or not the HTTP request was secure.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | forgerock.level                     | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.request.operation         | The request operation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.request.protocol          | The protocol associated with the request; REST or PLL.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.response.elapsedTime      | Time to execute event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | forgerock.response.elapsedTimeUnits | Units for response time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.response.status           | Status indicator, usually SUCCESS/SUCCESSFUL or FAIL/FAILED.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.roles                     | IDM roles associated with the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | forgerock.source                    | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic                     | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | http.request.Path                   | The path of the HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | input.type                          | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_activity events

This is the `forgerock.idm_activity` dataset. These logs capture operations on internal (managed) and external (system) objects in Identity Cloud. idm-activity logs the changes to identity content, such as adding or updating users, changing passwords, etc. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-activity).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-11-01T18:02:39.882Z",
      "agent": {
          "ephemeral_id": "e5134748-2f93-46d7-832e-a0345a05dd7a",
          "id": "8cdbc0fe-d88c-4a81-bc16-8f7dafdb3681",
          "name": "elastic-agent-30475",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.idm_activity",
          "namespace": "97694",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8cdbc0fe-d88c-4a81-bc16-8f7dafdb3681",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-06T12:45:23.278Z",
          "dataset": "forgerock.idm_activity",
          "id": "a9a32d9e-7029-45e6-b581-eafb5d502273-268906",
          "ingested": "2025-10-06T12:45:26Z",
          "outcome": "success"
      },
      "forgerock": {
          "eventName": "relationship_created",
          "level": "INFO",
          "message": "Relationship originating from managed/alpha_organization/e6df3df4-c798-4187-ba06-db8e6ae3db88 via the relationship field parent and referencing managed/alpha_organization/c4de605d-9d1b-439e-9ea8-9aba47e01008  was created.",
          "objectId": "managed/alpha_organization/e6df3df4-c798-4187-ba06-db8e6ae3db88/parent/bb20cd10-e6ad-48fd-8ef1-e8d4c3f7859f",
          "operation": "CREATE",
          "passwordChanged": false,
          "revision": "00000000478fd92b",
          "source": "audit",
          "topic": "activity"
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-idm-activity"
      ],
      "transaction": {
          "id": "1667325742545-ee41d6454a6b4a815b69-24798/0"
      },
      "user": {
          "effective": {
              "id": "9120c7db-d7e6-4b51-b805-07bbee7a4bb9"
          },
          "id": "9120c7db-d7e6-4b51-b805-07bbee7a4bb9"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                     | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset       | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace     | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type          | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.eventName       | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level           | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.message         | Human readable text about the action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | forgerock.objectId        | Specifies the identifier of an object that has been created, updated, or deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.operation       | The state change operation invoked.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | forgerock.passwordChanged | Boolean specifying whether changes were made to the password.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | forgerock.revision        | Specifies the object revision number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | forgerock.source          | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic           | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | input.type                | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_authentication events

This is the `forgerock.idm_authentication` dataset. These logs capture the results when you authenticate to an /openidm endpoint to complete certain actions on an object. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-authentication).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-05T18:21:48.253Z",
      "agent": {
          "ephemeral_id": "43621d03-c360-4aaf-8c54-29f1b2c9c14e",
          "id": "d45d8d44-75ed-4fc4-8cd7-7e9546178b5f",
          "name": "elastic-agent-35658",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.idm_authentication",
          "namespace": "74191",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "d45d8d44-75ed-4fc4-8cd7-7e9546178b5f",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "authentication"
          ],
          "created": "2025-10-06T12:46:13.049Z",
          "dataset": "forgerock.idm_authentication",
          "id": "45463f84-ff1b-499f-aa84-8d4bd93150de-256208",
          "ingested": "2025-10-06T12:46:16Z",
          "outcome": "success"
      },
      "forgerock": {
          "entries": [
              {
                  "info": {
                      "authIndex": "module_instance",
                      "authIndexValue": "Application",
                      "authLevel": "0",
                      "ipAddress": "1.128.0.0"
                  },
                  "moduleId": "Application"
              }
          ],
          "eventName": "authentication",
          "level": "INFO",
          "method": "MANAGED_USER",
          "principal": [
              "openidm-admin"
          ],
          "result": "SUCCESSFUL",
          "topic": "authentication",
          "trackingIds": [
              "45463f84-ff1b-499f-aa84-8d4bd93150de-256204"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-idm-authentication"
      ],
      "transaction": {
          "id": "1664994108247-9f138d8fc9f59d23164c-26466/0"
      },
      "user": {
          "id": "id=user"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.entries     | The JSON representation of the details of an authentication module, chain, tree, or node.                                                                                                                                                                                                                                                                                                                                                                                                                                    | flattened        |
  | forgerock.eventName   | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level       | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.method      | The authentication method, such as `JWT` or `MANAGED_USER`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.principal   | The array of accounts used to authenticate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.result      | Status indicator, usually SUCCESS/SUCCESSFUL or FAIL/FAILED.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.topic       | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.trackingIds | Specifies a unique random string generated as an alias for each AM session ID and OAuth 2.0 token.                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type            | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_config events

This is the `forgerock.idm_config` dataset. These logs capture configuration changes to Identity Cloud with a timestamp and by whom. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-config).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-19T16:12:12.549Z",
      "agent": {
          "ephemeral_id": "c2abb4f1-08de-4c4b-b783-22cadd5e81fb",
          "id": "e591b5b6-3b50-4c61-ac46-5c93370cda0b",
          "name": "elastic-agent-85889",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.idm_config",
          "namespace": "96403",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "e591b5b6-3b50-4c61-ac46-5c93370cda0b",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "configuration"
          ],
          "created": "2025-10-06T12:47:03.339Z",
          "dataset": "forgerock.idm_config",
          "id": "5e787c05-c32f-40d3-9e77-666376f6738f-134332",
          "ingested": "2025-10-06T12:47:06Z"
      },
      "forgerock": {
          "changedFields": [
              "/mappings"
          ],
          "eventName": "CONFIG",
          "level": "INFO",
          "objectId": "sync",
          "source": "audit",
          "topic": "config"
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-idm-config"
      ],
      "transaction": {
          "id": "1666195908296-b802a87436c00618a43e-13149/0"
      },
      "user": {
          "effective": {
              "id": "d7cd65bf-743c-4753-a78f-a20daae7e3bf"
          },
          "id": "d7cd65bf-743c-4753-a78f-a20daae7e3bf"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp              | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset     | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace   | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type        | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.changedFields | Specifies the fields that were changed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | forgerock.eventName     | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level         | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.objectId      | Specifies the identifier of an object that has been created, updated, or deleted.                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.source        | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.topic         | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | input.type              | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_core events

This is the `forgerock.idm_core` dataset. These logs capture identity management debug logs for Identity Cloud. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-core).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-12-05T20:01:34.448Z",
      "agent": {
          "ephemeral_id": "be0af615-72c8-4765-af00-f48265926a95",
          "id": "49e76a53-246c-4949-aec1-a76a75a7943f",
          "name": "elastic-agent-40983",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.idm_core",
          "namespace": "15088",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "49e76a53-246c-4949-aec1-a76a75a7943f",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-06T12:47:53.258Z",
          "dataset": "forgerock.idm_core",
          "ingested": "2025-10-06T12:47:56Z",
          "reason": "Dec 05, 2022 8:01:34 PM org.forgerock.openidm.internal.InternalObjectSet readInstance"
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-debug",
          "forgerock-idm-core"
      ]
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |----------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.idm_core.message |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forgerock.idm_core.name    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forgerock.idm_core.target  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forgerock.idm_core.type    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                 | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


### IDM_sync events

This is the `forgerock.idm_sync` dataset. These logs capture any changes made to an object resulting in automatic sync (live sync and implicit sync) to occur when you have a repository mapped to Identity Cloud. More information about [these logs](https://backstage.forgerock.com/knowledge/kb/article/a37739488#idm-sync).
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-10-19T16:09:17.900Z",
      "agent": {
          "ephemeral_id": "87a05e07-8bc1-4a59-b294-755ca4f09ab5",
          "id": "92635cef-b931-43d6-89aa-42a3566922f7",
          "name": "elastic-agent-79875",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "forgerock.idm_sync",
          "namespace": "45841",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "92635cef-b931-43d6-89aa-42a3566922f7",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "created": "2025-10-06T12:52:05.339Z",
          "dataset": "forgerock.idm_sync",
          "id": "5e787c05-c32f-40d3-9e77-666376f6738f-130280",
          "ingested": "2025-10-06T12:52:08Z",
          "outcome": "success"
      },
      "forgerock": {
          "action": "ASYNC",
          "eventName": "sync",
          "level": "INFO",
          "linkQualifier": "default",
          "mapping": "managedalpha_user_managedMarketinglist",
          "situation": "SOURCE_IGNORED",
          "source": "audit",
          "sourceObjectId": "managed/alpha_user/9d88b635-9b7a-48d3-9a57-1978b99a5f41",
          "topic": "sync"
      },
      "input": {
          "type": "httpjson"
      },
      "observer": {
          "vendor": "ForgeRock Identity Platform"
      },
      "tags": [
          "forwarded",
          "forgerock-audit",
          "forgerock-idm-sync"
      ],
      "transaction": {
          "id": "1666195747447-56a35455016b7da218a6-11991/0"
      },
      "user": {
          "id": "d7cd65bf-743c-4753-a78f-a20daae7e3bf"
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |--------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp               | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset      | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace    | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type         | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forgerock.action         | The synchronization action, depicted as a Common REST action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | forgerock.eventName      | The name of the audit event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | forgerock.level          | The log level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.linkQualifier  | ForgeRock's link qualifier applied to the action.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | forgerock.mapping        | Name of the mapping used for the synchronization operation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.situation      | The synchronization situation as documented                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | forgerock.source         | The source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | forgerock.sourceObjectId | Object ID on the source system.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forgerock.targetObjectId | Object ID on the target system                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | forgerock.topic          | The topic of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | input.type               | Input type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![ForgeRock Dashboard](https://epr.elastic.co/package/forgerock/1.22.0/img/forgerock-dashboard.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15584))Prevent updating fleet health status to degraded.                                                                                                                        | 9.1.49.0.78.19.4       |
  | **1.21.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14484))Add `forgerock.*` filter to dashboard panels.                                                                                                                                | 9.0.08.13.0            |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13959))Map the duration `forgerock.response.elapsedTime` as a long not a date.                                                                                                      | 9.0.08.13.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                         | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **1.18.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11409))Fix handling of `endTime` query parameter.                                                                                                                                   | 8.13.0                 |
  | **1.18.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                         | 8.13.0                 |
  | **1.18.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11219))Fix handling of idm_core object payloads.                                                                                                                                    | 8.13.0                 |
  | **1.18.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11240))Fix handling of query time ranges.                                                                                                                                           | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **1.17.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10136))Fix sample event.                                                                                                                                                            | 8.12.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10120))Make `event.type` and `event.category` fields conform to ECS field definition.                                                                                           | 8.12.0                 |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                      | 8.12.0                 |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9127))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.14.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8056))Use dynamic mappings for object fields.                                                                                                                                   | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7601))Update package-spec to 2.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6542))Fix IDM Activity revision field type.                                                                                                                                         | 8.7.1                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.17.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4416))Initial draft of the package                                                                                                                                              | 8.0.07.17.0            |
</dropdown>