﻿---
title: Forcepoint Web Security
description: This integration allows you to ingest log and event data from Forcepoint Web Security. The Forcepoint Web Security integration collects one type of data...
url: https://www.elastic.co/docs/reference/integrations/forcepoint_web
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Forcepoint Web Security
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.13.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | File                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

This integration allows you to ingest log and event data from Forcepoint Web Security.
<note>
  At present it is limited to ingestion of files exported using the offical Forcepoint Log Export SIEM tool, refer to [this page](https://www.websense.com/content/support/library/web/hosted/admin_guide/siem_script.aspx)
</note>


## Data streams

The Forcepoint Web Security integration collects one type of data stream: logs.

## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

Start by reading [this page](https://www.websense.com/content/support/library/web/hosted/admin_guide/siem_integration_explain.aspx).
While it is possible to use AWS S3 as BYO storage that Forcepoint Web Security can export logs to, at this point the integration does not support connection to an S3 bucket directly.
Configuration of storage type is [described here](https://www.websense.com/content/support/library/web/hosted/admin_guide/siem_storage.aspx).
A Perl script is provided by Forcepoint to "pull" logs from "Forcepoint" storage and is [described here](https://www.websense.com/content/support/library/web/hosted/admin_guide/siem_script.aspx).
A containerised version of the Forcepoint Log Export SIEM tool is available via this [GitHub repository](https://github.com/colin-stubbs/docker-forcepoint-log_export_siem).
The format of the gzip compressed CSV files that Forcepoint Web Security spits out is configurable, ensure you read and understand [this page](https://www.websense.com/content/support/library/web/hosted/siem_guide/siem_format.aspx).
The default format assumed by this integration is:
```
"%{date}","%{time}","%{user}","%{workstation}","%{category}","%{action}","%{risk_class}","%{policy_name}","%{url}","%{connection_ip}","%{destination_ip}","%{source_ip}","%{threat_type}","%{threat_name}","%{user_agent_string}","%{http_status_code}","%{http_request_method}"
```

The field names (encapsulated in %{}) used in this format will wind up under the `forcepoint_web` field object.
If you choose to export additional fields you may need to expand or change this entirely if you order things differently. It can be customised as part of each integration policy instance. Ensure you escape the double quotes (") in the string as per the default string.
At present those fields are currently mapped as follows,

| Field (under forcepoint_web) | Fields (ECS where possible)                   |
|------------------------------|-----------------------------------------------|
| date + time                  | @timestamp                                    |
| user                         | user.id, user.name, user.domain, related.user |
| workstation                  | host.name, related.hosts                      |
| category                     | -                                             |
| action                       | event.action (lowercase)                      |
| risk_class                   | -                                             |
| policy_name                  | rule.name                                     |
| url                          | url.*                                         |
| connection_ip                | source.nat.ip, related.ip                     |
| destination_ip               | destination.ip, related.ip                    |
| source_ip                    | source.ip, related.ip                         |
| threat_type                  | -                                             |
| threat_name                  | -                                             |
| user_agent_string            | user_agent.*                                  |
| http_status_code             | http.response.status_code                     |
| http_request_method          | http.request.method                           |


## Compatibility

This integration has been tested against Forcepoint Web Security using the Log Export SIEM tool version v2.0.1
Versions above this are expected to work but have not been tested.

## Debugging

If the "Preserve original event" is enabled, this will add the tag `preserve_original_event` to the event. `event.original` will be set with the *original* message contents, which is pre-KV and pre-syslog parsing.
If the "preserve_log" tag is added to an integration input, the `log` object and all fields under it will be preserved.

## Logs reference


### forcepoint_web.logs

The `forcepoint_web.logs` data stream provides events from Forcepoint Web Security.

#### Example

An example event for `forcepoint_web.logs` looks as following:
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-01-13T00:30:45.891Z",
      "agent": {
          "ephemeral_id": "07b2ae81-8fca-461c-aba7-9331c2aabc5e",
          "id": "8cc7367b-4069-4535-8545-a477b8c273af",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.5.1"
      },
      "data_stream": {
          "dataset": "forcepoint_web.logs",
          "namespace": "ep",
          "type": "logs"
      },
      "destination": {
          "ip": "3.24.198.68"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8cc7367b-4069-4535-8545-a477b8c273af",
          "snapshot": false,
          "version": "8.5.1"
      },
      "event": {
          "action": "allowed",
          "agent_id_status": "verified",
          "category": [
              "web"
          ],
          "dataset": "forcepoint_web.logs",
          "ingested": "2023-01-13T00:30:46Z",
          "kind": "event",
          "type": [
              "info"
          ]
      },
      "forcepoint_web": {
          "action": "Allowed",
          "category": [
              "Reference Materials",
              "Trusted Server Downloads"
          ],
          "connection_ip": "202.4.188.96",
          "date": "16/12/2022",
          "destination_ip": "3.24.198.68",
          "http_request_method": "Connect",
          "http_status_code": "200",
          "policy_name": "Org Internal Server Policy",
          "risk_class": [
              "Business Usage",
              "None"
          ],
          "time": "07:05:25",
          "timestamp": "2022-12-16T07:05:25.000Z",
          "user": "anonymous",
          "user_agent_string": "Java/11.0.6"
      },
      "http": {
          "request": {
              "method": "CONNECT"
          },
          "response": {
              "status_code": 200
          }
      },
      "input": {
          "type": "log"
      },
      "message": "\"16/12/2022\",\"07:05:25\",\"anonymous\",\"Not available\",\"Reference Materials,Trusted Server Downloads\",\"Allowed\",\"Business Usage,None\",\"Org Internal Server Policy\",\"aom-au.nearmap.com:443/\",\"202.4.188.96\",\"3.24.198.68\",\"Not available\",\"None\",\"None\",\"Java/11.0.6\",\"200\",\"Connect\"",
      "related": {
          "ip": [
              "3.24.198.68",
              "202.4.188.96"
          ],
          "user": [
              "anonymous"
          ]
      },
      "rule": {
          "name": "Org Internal Server Policy"
      },
      "source": {
          "nat": {
              "ip": "202.4.188.96"
          }
      },
      "tags": [
          "forwarded"
      ],
      "url": {
          "domain": "aom-au.nearmap.com",
          "original": "https://aom-au.nearmap.com:443/",
          "path": "/",
          "port": 443,
          "registered_domain": "nearmap.com",
          "scheme": "https",
          "subdomain": "aom-au",
          "top_level_domain": "com"
      },
      "user": {
          "id": "anonymous",
          "name": "anonymous"
      },
      "user_agent": {
          "device": {
              "name": "Spider"
          },
          "name": "Java",
          "original": "Java/11.0.6",
          "version": "0.6."
      }
  }
  ```
</dropdown>

The following fields may be used by the package:
<dropdown title="Exported fields">
  | Field                              | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                         | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                            | date             |
  | data_stream.dataset                | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters | constant_keyword |
  | data_stream.namespace              | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                | constant_keyword |
  | data_stream.type                   | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | forcepoint_web.action              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.category            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.connection_ip       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.date                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.destination_ip      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.http_request_method |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.http_status_code    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.policy_name         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.risk_class          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.source_ip           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.time                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.timestamp           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | date             |
  | forcepoint_web.user                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.user_agent_string   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | forcepoint_web.workstation         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Sample screenshot](https://epr.elastic.co/package/forcepoint_web/1.13.0/img/sample-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12503))Allow the usage of deprecated log input and support for stack 9.0                                                                                   | 8.13.0                 |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                             | 8.13.0                 |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9238))Upgrade to package spec 3.0.3.                                                                                                                       | 8.5.1                  |
  | **1.7.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.5.1                  |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                               | 8.5.1                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.5.1                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                               | 8.5.1                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                          | 8.5.1                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                       | 8.5.1                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Added 'owner.type: elastic' to package manifest.                            | 8.5.1                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.5.1                  |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7807))Remove version attribute from ingest node pipelines.                                                                                                     | 8.5.1                  |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                         | 8.5.1                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6800))Release Forcepoint Web Security as GA.                                                                                                               | 8.5.1                  |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                              |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                         |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6151))Update package-spec version to 2.7.0.                                                                                                                |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         |                        |
  | **0.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4992))Initial draft of the package                                                                                                                         |                        |
</dropdown>