﻿---
title: Fleet Server integration
description: Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents. It’s launched as part of an Elastic Agent on a host intended...
url: https://www.elastic.co/docs/reference/integrations/fleet_server
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Fleet Server integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.12.0                    |

Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents. It’s launched as part of an Elastic Agent on a host intended to act as a server. One Fleet Server process can support many Elastic Agent connections. It is responsible for updating agent policies, collecting status information, and coordinating actions across Elastic Agents.
To add this integration to an Elastic Agent, just add it to an agent policy. The Elastic Agents enrolled into that policy must run with additional credentials such as a service token. Learn how to add a Fleet Server our [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).

## Compatibility

Fleet Server is compatible with the Elastic Stack and Elastic Agents version 7.13 or higher. The version of Elastic Agents running Fleet Server must be greater than or equal to the version of the Elastic Agents that enroll in them.

## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                              | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.6.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12460))Support for stack 9.0                                                           | 9.0.08.12.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8605))Added new output health data stream                                          | 8.12.0                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8145))Added new metrics data streams                                               | 8.12.0                 |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6555))Fix agent template to avoid server:null that caused an invalid policy            | 8.8.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5896))Remove host and port                                                         | 8.8.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2531))Added max agents field, deprecated max connections                           | 8.0.07.16.0            |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2026))Uniform with guidelines                                                      | 8.0.07.16.0            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2133))Update compatibility to be compatible with 8.0                               | 8.0.07.16.0            |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1533))Add Fleet Icon                                                               | 7.14.0                 |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1431))Make integration GA.                                                         | 7.14.0                 |
  | **0.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                               |                        |
  | **0.9.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1008))Updating the README.                                                         |                        |
  | **0.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1008))Move fleet_server package to beta release.                                   |                        |
  | **0.2.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/988))Fix max_connection config which was not working becase limits prefix was missing. |                        |
  | **0.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/959))Add yaml block for configuration                                              |                        |
  | **0.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/894))Remove fleet indices mappings that are supported by ES system indices plugin  |                        |
  | **0.2.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/788))Add missing template for agent and max_connections variable                       |                        |
  | **0.1.7**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/788))increment package version and manifest link to 7.13                           |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/544))initial release                                                               |                        |
</dropdown>