﻿---
title: FireEye Integration
description: This integration periodically fetches logs from FireEye Network Security devices. The FireEye nx integration has been developed against FireEye Network...
url: https://www.elastic.co/docs/reference/integrations/fireeye
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# FireEye Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.27.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Community                       |
| **Ingestion method(s)**                                                                         | File, Network Protocol          |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

This integration periodically fetches logs from [FireEye Network Security](https://www.fireeye.com/products/network-security.html) devices.

## Compatibility

The FireEye `nx` integration has been developed against FireEye Network Security 9.0.0.916432 but is expected to work with other versions.

## Logs


### NX

The `nx` integration ingests network security logs from FireEye NX through TCP/UDP and file.
<dropdown title="Exported fields">
  | Field                        | Description                                                                    | Type             |
  |------------------------------|--------------------------------------------------------------------------------|------------------|
  | @timestamp                   | Event timestamp.                                                               | date             |
  | cloud.image.id               | Image ID for the cloud instance.                                               | keyword          |
  | data_stream.dataset          | Data stream dataset.                                                           | constant_keyword |
  | data_stream.namespace        | Data stream namespace.                                                         | constant_keyword |
  | data_stream.type             | Data stream type.                                                              | constant_keyword |
  | event.dataset                | Event dataset                                                                  | constant_keyword |
  | event.module                 | Event module                                                                   | constant_keyword |
  | fireeye.nx.device_oml        | Device OML (Object Management Layer) identifier.                               | long             |
  | fireeye.nx.deviceid          | Device ID of the event.                                                        | keyword          |
  | fireeye.nx.fileinfo.filename | File name.                                                                     | keyword          |
  | fireeye.nx.fileinfo.magic    | Fileinfo magic.                                                                | keyword          |
  | fireeye.nx.fileinfo.md5      | File hash.                                                                     | keyword          |
  | fireeye.nx.fileinfo.size     | File size.                                                                     | long             |
  | fireeye.nx.fileinfo.state    | File state.                                                                    | keyword          |
  | fireeye.nx.fileinfo.stored   | File stored or not.                                                            | boolean          |
  | fireeye.nx.flow.age          | Flow age.                                                                      | long             |
  | fireeye.nx.flow.alerted      | Flow alerted or not.                                                           | boolean          |
  | fireeye.nx.flow.endtime      | Flow endtime.                                                                  | date             |
  | fireeye.nx.flow.reason       | Flow reason.                                                                   | keyword          |
  | fireeye.nx.flow.starttime    | Flow start time.                                                               | date             |
  | fireeye.nx.flow.state        | Flow state.                                                                    | keyword          |
  | fireeye.nx.flow_id           | Flow ID of the event.                                                          | long             |
  | fireeye.nx.hostname          | Hostname of the event.                                                         | keyword          |
  | fireeye.nx.tcp.ack           | TCP acknowledgement.                                                           | boolean          |
  | fireeye.nx.tcp.psh           | TCP PSH.                                                                       | boolean          |
  | fireeye.nx.tcp.state         | TCP connectin state.                                                           | keyword          |
  | fireeye.nx.tcp.syn           | TCP SYN.                                                                       | boolean          |
  | fireeye.nx.tcp.tcp_flags     | TCP flags.                                                                     | keyword          |
  | fireeye.nx.tcp.tcp_flags_tc  | TCP flags.                                                                     | keyword          |
  | fireeye.nx.tcp.tcp_flags_ts  | TCP flags.                                                                     | keyword          |
  | host.containerized           | If the host is a container.                                                    | boolean          |
  | host.os.build                | OS build information.                                                          | keyword          |
  | host.os.codename             | OS codename, if any.                                                           | keyword          |
  | input.type                   | Input type                                                                     | keyword          |
  | log.offset                   | Log offset                                                                     | long             |
  | log.source.address           | Logs Source Raw address.                                                       | keyword          |
  | tls.client.ciphersuites      | TLS cipher suites by client.                                                   | long             |
  | tls.client.fingerprint       | TLS fingerprint.                                                               | keyword          |
  | tls.client.ja3_string        | A hash that identifies clients based on how they perform an SSL/TLS handshake. | keyword          |
  | tls.client.tls_exts          | TLS extensions set by client.                                                  | long             |
  | tls.public_keylength         | TLS public key length.                                                         | long             |
  | tls.server.ciphersuite       | TLS cipher suites by server.                                                   | long             |
  | tls.server.ja3s_string       | A hash that identifies servers based on how they perform an SSL/TLS handshake. | keyword          |
  | tls.server.tls_exts          | TLS extensions set by server.                                                  | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-09-22T08:34:44.991Z",
      "agent": {
          "ephemeral_id": "29a00621-9074-4b14-bcbb-db252f6203c3",
          "id": "7740d13f-75db-41df-89ee-b1cb3b873df4",
          "name": "elastic-agent-93841",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "fireeye.nx",
          "namespace": "68601",
          "type": "logs"
      },
      "destination": {
          "address": "ff02:0000:0000:0000:0000:0000:0000:0001",
          "bytes": 0,
          "ip": "ff02:0000:0000:0000:0000:0000:0000:0001",
          "packets": 0,
          "port": 10001
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "7740d13f-75db-41df-89ee-b1cb3b873df4",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network"
          ],
          "dataset": "fireeye.nx",
          "ingested": "2025-07-23T06:50:57Z",
          "kind": "event",
          "reason": "timeout",
          "timezone": "+00:00",
          "type": [
              "info"
          ]
      },
      "fireeye": {
          "nx": {
              "flow": {
                  "age": 0,
                  "alerted": false,
                  "endtime": "2020-09-22T08:34:12.761348+0000",
                  "reason": "timeout",
                  "starttime": "2020-09-22T08:34:12.761326+0000",
                  "state": "new"
              },
              "flow_id": 721570461162990
          }
      },
      "input": {
          "type": "udp"
      },
      "log": {
          "source": {
              "address": "192.168.245.3:36580"
          }
      },
      "network": {
          "community_id": "1:McNAQcsUcKZYOHHZYm0sD8JiBLc=",
          "iana_number": "17",
          "protocol": "failed",
          "transport": "udp"
      },
      "observer": {
          "hostname": "fireeye-7e0de1",
          "ip": [
              "192.168.1.99"
          ],
          "product": "NX",
          "vendor": "Fireeye"
      },
      "related": {
          "ip": [
              "192.168.1.99",
              "fe80:0000:0000:0000:feec:daff:fe31:b706",
              "ff02:0000:0000:0000:0000:0000:0000:0001"
          ]
      },
      "source": {
          "address": "fe80:0000:0000:0000:feec:daff:fe31:b706",
          "bytes": 1680,
          "ip": "fe80:0000:0000:0000:feec:daff:fe31:b706",
          "packets": 8,
          "port": 45944
      },
      "tags": [
          "fireeye-nx",
          "forwarded"
      ]
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![FireEye Network Security dashboard screenshot](https://epr.elastic.co/package/fireeye/1.27.0/img/fireeye-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                      | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14550))Add support for `event.kind`, `destination.domain`, `file.hash.md5`, `file.path`, `observer.hostname` and `observer.ip` ECS fields.                 | 9.0.08.13.0            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13713))Add Overview Dashboard.                                                                                                                             | 9.0.08.13.0            |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                          | 9.0.08.13.0            |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                           | 8.13.0                 |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                    | 8.13.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9402))Update manifest format version to v3.0.3.                                                                                                            | 8.0.07.16.0            |
  | **1.21.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                       | 8.0.07.16.0            |
  | **1.21.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8635))Fix exclude_files pattern.                                                                                                                               | 8.0.07.16.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8433))ECS version updated to 8.11.0.                                                                                                                       | 8.0.07.16.0            |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                               | 8.0.07.16.0            |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'community' owner type.                                                                                                                          | 8.0.07.16.0            |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8025))Update the package format_version to 3.0.0.                                                                                                          | 8.0.07.16.0            |
  | **1.17.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7969))Correct invalid ECS field usages at root-level.                                                                                                          | 8.0.07.16.0            |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7918))ECS version updated to 8.10.0.                                                                                                                       | 8.0.07.16.0            |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. | 8.0.07.16.0            |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7109))Update package to ECS 8.9.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6614))Ensure event.kind is correctly set for pipeline errors.                                                                                              | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6590))Update package to pkg-spec 2.7.0.                                                                                                                    | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6326))Update package to ECS 8.8.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.9.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                               | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4863))Add `udp_options` to the UDP input.                                                                                                                  | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.6.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4407))Remove duplicate fields.                                                                                                                                 | 8.0.07.16.0            |
  | **1.6.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                   | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3865))Update package to ECS 8.4.0                                                                                                                          | 8.0.07.16.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                   | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                         | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3440))Add JA3/JA3S to `related.hash`                                                                                                                       | 8.0.07.16.0            |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3331))Move invalid field value in sample event file                                                                                                            | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2779))Update to ECS 8.2                                                                                                                                    | 8.0.07.16.0            |
  | **1.2.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3099))Move invalid field values                                                                                                                                |                        |
  | **1.2.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3092))Fix typo in config template for ignoring host enrichment                                                                                                 |                        |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                   | 8.0.07.16.0            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2892))Fix field mappings for `dns.id` and `network.iana_number`                                                                                            |                        |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2404))Update to ECS 8.0                                                                                                                                    | 8.0.07.16.0            |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                       | 8.0.07.16.0            |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                           |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2225))Add 8.0.0 version constraint                                                                                                                         | 8.0.07.16.0            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1887))Initial draft of the package                                                                                                                         | 7.16.0                 |
</dropdown>