﻿---
title: Custom Logs (Filestream) Package
description: In future releases it's expected to have an automated way to migrate the state. However, this is not possible at the moment. The current best option for...
url: https://www.elastic.co/docs/reference/integrations/filestream
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Custom Logs (Filestream) Package
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.3.2 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.2.0                          |

<warning>
  Migrating from the "Custom Logs (Deprecated)" to "Custom Logs
  (Filestream)" will cause files to be re-ingested because the state is not migrated.
</warning>

<important>
  The Filestream integration will only start ingesting files
  **when they are 1024 bytes in size or larger**. This can be adjusted by
  setting "Fingerprint length", however it will influence how files are
  identified. Refer to the
  [fingerprint](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream#filebeat-input-filestream-file-identity-fingerprint)
  documentation for more details.
</important>

In future releases it's expected to have an automated way to migrate the state. However, this is not possible at the moment.
The current best option for minimizing the data duplication while migrating to "Custom Logs (Filestream)" is to use the 'Ignore Older' or 'Exclude Files' options.
The `filestream` custom input is used to read lines from active log files. It is the
new, improved alternative to the `log` input. It comes with various improvements
to the existing input:
1. Checking of `close_*` options happens out of band. Thus, if an output is blocked,
   Elastic Agent can close the reader and avoid keeping too many files open.
2. The order of `parsers` is configurable. So it is possible to parse JSON lines and then
   aggregate the contents into a multiline event.
3. Some position updates and metadata changes no longer depend on the publishing pipeline.
   If the pipeline is blocked some changes are still applied to the registry.
4. Only the most recent updates are serialized to the registry. In contrast, the `log` input
   has to serialize the complete registry on each ACK from the outputs. This makes the registry updates
   much quicker with this input.
5. The input ensures that only offsets updates are written to the registry append only log.
   The `log` writes the complete file state.
6. Stale entries can be removed from the registry, even if there is no active input.
7. The fingerprint file identity is used by default.

More information can be found on the [Filestream documentation page](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-input-filestream.html)
As Filestream configures a new input, configuring it to collect data
from a file that was previously collected by Custom Logs integration
will result in duplicate data. You may wish to configure
`ignore_older` or temporarily set `ignore_inactive: since_first_start`
to limit the amount of duplicate data collected.
If the Custom Logs integration is removed and the Custom Filestream
Logs is added in the same policy change, there risk of data being
missed between the last entry ingested by the Custom Logs and the
first one ingested by the Custom Filestream Logs.

## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                      | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.3.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16648))Include on "Decompress GZIP files" description it's GA on 9.3.0.                    | 9.2.0                  |
  | **2.3.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16647))Adjust GZIP decompression docs                                                      | 9.2.0                  |
  | **2.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16565))Promote GZIP decompression to GA                                                    | 9.2.0                  |
  | **2.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13576))Add support for removing files after ingestion                                      | 9.2.0                  |
  | **2.1.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15962))Ignore "Ingest Pipeline" when "Use Logs Stream" is set                                  | 9.2.0                  |
  | **2.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15901))Improve documentation for the "Use the logs data stream" option.                    | 9.2.0                  |
  | **2.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15047))Allow filestream to be configured to ingest GZIP files                              | 9.2.0                  |
  | **2.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15653))Remove hard-coded dataset field                                                         | 9.2.0                  |
  | **2.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12878))Migrate to input package type                                                       |                        |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14846))Add logs stream support                                                             | 9.2.0                  |
  | **1.2.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14351))Add the native file identity                                                            | 9.0.08.15.0            |
  | **1.1.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14210))Fix file identity options not getting applied correctly                                 | 9.0.08.15.0            |
  | **1.1.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14209))Add warning about only ingesting files >= 1024 bytes                                | 9.0.08.15.0            |
  | **1.1.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13679))Correct the readme                                                                  | 9.0.08.15.0            |
  | **1.1.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13670))Add warning about migration from "Custom Logs (Legacy)" to"Custom Logs (Filestream" | 9.0.08.15.0            |
  | **1.1.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13666))Rename the package                                                                  | 9.0.08.15.0            |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12880))Add support for defining Conditions                                                 | 9.0.08.15.0            |
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12861))Resolving conflicts with past integration versions.                                     | 9.0.08.15.0            |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12845))Make it GA                                                                          |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12837))Make it available in 9.0                                                            |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11332))Initial Release                                                                     |                        |
</dropdown>